<?php

/** WP_TTAR class use for all types report
 *   use EXCEL & PDF formate
 *   
 */

class WPTTARReporting {

// Constructor
    protected $wpttarMainClass;
    public $WpttarProjectsTable = 'wpttar_projects';
    public $WpttarAttachmentsTable = 'wpttar_attachments';
    public $WpttarTeamsTable = 'wpttar_teams';
    public $WpttarProjectsLogTable = 'wpttar_projects_log';
    protected $projectsTable, $teamsTable, $projectsLogTable;

    public function __construct($wpttarMainClass) {
        $this->WPTTARObjectStart();
        $this->wpttarMainClass = $wpttarMainClass;
        $this->projectsTable = $this->wpttarMainClass->WpttarProjectsTable;
        $this->teamsTable = $this->wpttarMainClass->WpttarTeamsTable;
        $this->projectsLogTable = $this->wpttarMainClass->WpttarProjectsLogTable;
    }

    public function WPTTARGetProjectReportDatas($wpttarFromDate, $wpttarToDate) {
        global $wpdb;
        
        $wpttarDateStart = '';
        if ($wpttarFromDate != '') {
            $wpttarDateStart = date('Y-m-d', strtotime($wpttarFromDate));
        }
        $wpttarDateEnd = '';
        if ($wpttarToDate != '') {
            $wpttarDateEnd = date('Y-m-d', strtotime($wpttarToDate));
        }

        $datebetween = '';
        if (($wpttarDateStart != '') && ($wpttarDateEnd != '')) {
            $datebetween = "WHERE  `dateTime` BETWEEN '".esc_sql($wpttarDateStart)."' AND '".esc_sql($wpttarDateEnd)."'";
        }
        $datas['wpttar-projects-reports'] = $wpdb->get_results("SELECT * FROM  $this->projectsTable $datebetween");
        $datas['wpttar-num-row'] = $wpdb->num_rows;
        return $datas;
    }
    
    public function WPTTARObjectStart() {
        @ob_end_clean();
        if (ob_get_level() == 0) {
            ob_start();
        }
    }

    public function WPTTARGetProjectReportExcel($wpttarFromDate, $wpttarToDate, $wpttarReportType, $developerId) {
        global $wpdb;
        $wpttarProjectReportsData = $this->WPTTARGetProjectReportDatas($wpttarFromDate, $wpttarToDate);
        $i = 1;
        ob_clean();
        $filename = 'projectReports-' . date('dmYHis');
        $numcolumn = $wpttarProjectReportsData['wpttar-num-row'];
        header('Content-Disposition: attachment; filename=' . $filename . '.xls');
        header('Cache-Control: no-cache, no-store, must-revalidate, post-check=0, pre-check=0');
        header('Pragma: no-cache');
        header('Content-Type: application/x-msexcel; charset=windows-1251; format=attachment;');
        ?>
        <table>
            <tr>
                <th><?php _e('Serial No', 'wpttar'); ?></th>
                <th><?php _e('Project Name', 'wpttar'); ?></th>
                <th><?php _e('Start Date', 'wpttar'); ?></th>
                <th><?php _e('End Date', 'wpttar'); ?></th>
                <th><?php _e('Total Time', 'wpttar'); ?></th>            
            </tr>
            <?php
            if ($wpttarReportType == 'Wpttar-developer-excel-reports') {
                foreach ($wpttarProjectReportsData['wpttar-projects-reports'] as $data) {
                     $wpttarProjectID = esc_sql($data->id);
                                $wpttarProjectDates = $this->wpttarMainClass->WPTTARGetResultsByOrderByFieldName($this->projectsLogTable,'projectID',$wpttarProjectID,'updateDate','ASC','getRow');
                                $wpttarProjectHours = $this->wpttarMainClass->WPTTARGetResultsByMultipleFields($this->projectsLogTable,'projectID','developerID',$wpttarProjectID,$developerId,'getResults');
                                $getTotalHour = $this->wpttarMainClass->WPTTARGetProjectTime($wpttarProjectHours, 'totalHours');
                    ?>
                    <tr>
                        <td><?php echo esc_html($i); ?></td>
                        <td><?php echo esc_html($data->projectName); ?></td>
                        <td><?php
                            if (isset($wpttarProjectDates->updateDate)) : echo esc_html(date('d M Y', strtotime($wpttarProjectDates->updateDate)));
                            endif;
                            ?></td>
                        <td> <?php
                            if (isset($data->projectStatus) && ($data->projectStatus == 'Open' || $data->projectStatus == 'Reopen' )) {
                                _e('In Progress', 'wpttar');
                            } else {
                                echo esc_html(date('d M Y', strtotime($data->lastUpdate)));
                            }
                            ?></td>
                        <td><?php
                            if (isset($getTotalHour['hour'])) : echo esc_html($getTotalHour['hour'].' ');
                            endif;
                            ?>
                            <?php
                            if (isset($getTotalHour['minutes'])) : echo esc_html($getTotalHour['minutes']);
                            endif;
                            ?></td>
                    </tr>
                    <?php
                    $i++;
                }
            }else {
                foreach ($wpttarProjectReportsData['wpttar-projects-reports'] as $data) {
                    $wpttarProjectID = esc_sql($data->id);
                    $wpttarProjectDates = $this->wpttarMainClass->WPTTARGetResultsByOrderByFieldName($this->projectsLogTable,'projectID',$wpttarProjectID,'updateDate','ASC','getRow');
                    $wpttarProjectHours = $this->wpttarMainClass->WPTTARGetResultsByID($wpttarProjectID,$this->projectsLogTable,'projectID');
                    $wpttarProjectEndDate = $this->wpttarMainClass->WPTTARGetTableDataByID($wpttarProjectID, $this->projectsTable, 'id');
                    $getTotalHour = $this->wpttarMainClass->WPTTARGetProjectTime($wpttarProjectHours, 'totalHours');
                    ?>
                    <tr>
                        <td><?php echo esc_html($i); ?></td>
                        <td><?php echo esc_html($data->projectName); ?></td>
                        <td><?php
                            if (isset($wpttarProjectDates->updateDate)) : echo esc_html(date('d M Y', strtotime($wpttarProjectDates->updateDate)));
                            endif;
                            ?></td>
                        <td> <?php
                            if (isset($wpttarProjectEndDate->projectStatus) && ($wpttarProjectEndDate->projectStatus == 'Open' || $wpttarProjectEndDate->projectStatus == 'Reopen' )) {
                                _e('In Progress', 'wpttar');
                            } else {
                                echo esc_html(date('d M Y', strtotime($wpttarProjectEndDate->lastUpdate)));
                            }
                            ?></td>
                        <td><?php
                            if (isset($getTotalHour['hour'])) : echo esc_html($getTotalHour['hour'].' ');
                            endif;
                            ?>
                            <?php
                            if (isset($getTotalHour['minutes'])) : echo  esc_html($getTotalHour['minutes']);
                            endif;
                            ?></td>
                    </tr>
                    <?php
                    $i++;
                }
            }
            ?>
        </table><?php
        exit;
    }

    public function WPTTARGetProjectReportPdf($wpttarFromDate, $wpttarToDate, $wpttarReportType, $developerId) {
        global $wpdb;
        $i = 1;
        $wpttarProjectReportsData = $this->WPTTARGetProjectReportDatas($wpttarFromDate, $wpttarToDate);
        ?>
        <html><head>
                <style>
                    body {
                        font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; font-size: 62.5%; color: #585858; padding: 22px 10px; padding-bottom: 55px;
                    }
                    #keywords {
                        margin: 0 auto; font-size: 1.2em; margin-bottom: 15px; width: 100%; margin-top: 75px;
                    }
                    #keywords thead tr th {
                        border: 1px solid #ddd; padding: 12px 30px; padding-left: 42px;
                    }
                    #keywords thead tr th span { padding-right: 20px; }
                    #keywords tbody tr td {
                        text-align: center; padding: 15px 10px; border: 1px solid #ddd;
                    }
                    .logo { display: inline-block; float: left; }
                    .main-header { text-align: center; font-size: 25px; margin-top: 50px; text-decoration: underline; color: #546E7A; text-transform: capitalize; font-weight: 400; margin-right: 10%; letter-spacing: 0.5px; }
                    .bottom-line { border-bottom: 2px solid #ddd; width: 97%; padding-top: 50px; position: absolute; }
                </style>
            </head>
            <body>
                <div class="main-header"><?php _e('Project Summary', 'wpttar'); ?> - <?php echo esc_html(date('d M Y')); ?></div>
                <table id="keywords" cellspacing="0" cellpadding="0">
                    <thead>
                        <tr>
                            <th><span><?php _e('Serial No', 'wpttar'); ?></span></th>
                            <th><span><?php _e('Project Name', 'wpttar'); ?></span></th>
                            <th><span><?php _e('Start Date', 'wpttar'); ?></span></th>
                            <th><span><?php _e('End Date', 'wpttar'); ?></span></th>
                            <th><span><?php _e('Total Time', 'wpttar'); ?></span></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if ($wpttarReportType == 'Wpttar-developer-pdf-reports') {
                            foreach ($wpttarProjectReportsData['wpttar-projects-reports'] as $data) {
                                $wpttarProjectID = esc_sql($data->id);
                                $wpttarProjectDates = $this->wpttarMainClass->WPTTARGetResultsByOrderByFieldName($this->projectsLogTable,'projectID',$wpttarProjectID,'updateDate','ASC','getRow');
                                $wpttarProjectHours = $this->wpttarMainClass->WPTTARGetResultsByMultipleFields($this->projectsLogTable,'projectID','developerID',$wpttarProjectID,$developerId,'getResults');
                                $getTotalHour = $this->wpttarMainClass->WPTTARGetProjectTime($wpttarProjectHours, 'totalHours');
                                ?>
                                <tr>
                                    <td><?php echo esc_html($i); ?></td>
                                    <td><?php echo esc_html($data->projectName); ?></td>
                                    <td><?php
                                        if (isset($wpttarProjectDates->updateDate)) : echo esc_html(date('d M Y', strtotime($wpttarProjectDates->updateDate)));
                                        endif;
                                        ?></td>
                                    <td> <?php
                                        if (isset($data->projectStatus) && ($data->projectStatus == 'Open' || $data->projectStatus == 'Reopen' )) {
                                            _e('In Progress', 'wpttar');
                                        } else {
                                            echo esc_html(date('d M Y', strtotime($data->lastUpdate)));
                                        }
                                        ?></td>
                                    <td><?php
                                        if (isset($getTotalHour['hour'])) : echo esc_html($getTotalHour['hour'].' ');
                                        endif;
                                        ?>
                                        <?php
                                        if (isset($getTotalHour['minutes'])) : echo esc_html($getTotalHour['minutes']);
                                        endif;
                                        ?></td>
                                </tr>
                                <?php
                                $i++;
                            }
                        }else {
                            foreach ($wpttarProjectReportsData['wpttar-projects-reports'] as $data) {
                                $wpttarProjectID = esc_sql($data->id);
                                $wpttarProjectDates = $this->wpttarMainClass->WPTTARGetResultsByOrderByFieldName($this->projectsLogTable,'projectID',$wpttarProjectID,'updateDate','ASC','getRow');
                                $wpttarProjectHours = $this->wpttarMainClass->WPTTARGetResultsByID($wpttarProjectID,$this->projectsLogTable,'projectID');
                                $wpttarProjectEndDate = $this->wpttarMainClass->WPTTARGetTableDataByID($wpttarProjectID, $this->projectsTable, 'id');
                                $getTotalHour = $this->wpttarMainClass->WPTTARGetProjectTime($wpttarProjectHours, 'totalHours');
                                ?>
                                <tr>
                                    <td><?php echo esc_html($i); ?></td>
                                    <td><?php echo esc_html($data->projectName); ?></td>
                                    <td><?php
                                        if (isset($wpttarProjectDates->updateDate)) : echo esc_html(date('d M Y', strtotime($wpttarProjectDates->updateDate)));
                                        endif;
                                        ?></td>
                                    <td> <?php
                                        if (isset($wpttarProjectEndDate->projectStatus) && ($wpttarProjectEndDate->projectStatus == 'Open' || $wpttarProjectEndDate->projectStatus == 'Reopen' )) {
                                            _e('In Progress', 'wpttar');
                                        } else {
                                            echo esc_html(date('d M Y', strtotime($wpttarProjectEndDate->lastUpdate)));
                                        }
                                        ?></td>
                                    <td><?php
                                        if (isset($getTotalHour['hour'])) : echo esc_html($getTotalHour['hour'].' ');
                                        endif;
                                        ?>
                                        <?php
                                        if (isset($getTotalHour['minutes'])) : echo  esc_html($getTotalHour['minutes']);
                                        endif;
                                        ?></td>
                                </tr>
                                <?php
                                $i++;
                            }
                        }
                        ?> </table>
            </body></html>
        <?php
        return  ob_get_contents(); ob_clean(); 
        
    }
    
  
}
?>