<?php
global $wpdb, $current_user;
$wpttarUserRole = $this->WPTTARGetCurrentUserCall();

if (isset($_REQUEST['projectID']) && !empty($_REQUEST['projectID'])) {
    $projectId = $_REQUEST['projectID'];
} else {
    $projectId = '';
}

if (isset($_REQUEST['developerID']) && !empty($_REQUEST['developerID'])) {
    $developerID = $_REQUEST['developerID'];
} else {
    $developerID = $current_user->ID;
}
$wpttarProjectLogs = $this->WPTTARGetResultsByMultipleFields($this->WpttarProjectsLogTable, 'projectID', 'developerID', $projectId, $developerID, 'getResults');
$WpttarEmployeeFirstName = get_user_meta($developerID, 'first_name', true);
$WpttarEmployeeLastName = get_user_meta($developerID, 'last_name', true);
$wpttarProjectResults = $this->WPTTARGetTableDataByID($projectId, $this->WpttarProjectsTable, 'id');

$wpttarTimeZoneSettings = $this->WPTTARGetSettings('wpttarTimeZoneSettingsInfo');
if(isset($wpttarTimeZoneSettings['wpttar-time-format']) && $wpttarTimeZoneSettings['wpttar-time-format'] =='12 Hour'){
    $timeFormat = 'h : i  A';
}else{
    $timeFormat = 'H : i : s';
}
?>
<!-- BEGIN PAGE HEADER-->
<!-- END PAGE HEADER-->
<!-- BEGIN PAGE CONTENT-->
<div class="preloader">  <span class="preloader-custom-gif"></span></div>
<input type="hidden" id="current-role-member" value="<?php echo esc_attr($wpttarUserRole); ?>">
<div style="padding-left: 0px; padding-right:20px; padding-top:0px;" class="col-md-12">
    <h3 class="page-title"><?php if (isset($wpttarProjectResults->projectName)) : echo esc_html($wpttarProjectResults->projectName);
                                    endif; _e(' Logs', 'wpttar'); ?></h3>
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li><a href="?page=wpttar-projects"><i class="fa fa-home"></i><?php _e('Home', 'wpttar'); ?><i class="fa fa-angle-right"></i></a></li>
            <li><a href="?page=wpttar-developer-projects-details&developerID=<?php
            if (isset($developerID)) : echo esc_attr($developerID);
            endif;
            ?>"><?php _e('Developer Projects', 'wpttar'); ?><i class="fa fa-angle-right"></i></a></li>
            <li><?php if (isset($wpttarProjectResults->projectName)) : echo esc_html($wpttarProjectResults->projectName);
                                    endif; _e(' Logs', 'wpttar'); ?></li>        
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <a class="btn green " href="?page=wpttar-developer-projects-details&developerID=<?php
            if (isset($developerID)) : echo esc_attr($developerID);
            endif;
            ?>" ><i class="fa fa-arrow-left"></i><?php _e('Back', 'wpttar'); ?> </a>
            <div class="portlet box blue calendar">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-list"></i>
                        <?php
                        if (isset($WpttarEmployeeFirstName)) : echo esc_html($WpttarEmployeeFirstName . ' ');
                        endif;
                        if (isset($WpttarEmployeeLastName)) : echo esc_html($WpttarEmployeeLastName);
                        endif;
                        ?>
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="wpttarDataTable">
                        <thead>
                            <tr>
                                <th><?php _e('S.No', 'wpttar'); ?></th>
                                <th><?php _e('Date', 'wpttar'); ?></th>
                                <th><?php _e('Start To End Time', 'wpttar'); ?></th>
                                <th><?php _e('Total Time', 'wpttar'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $i = 1;
                            if (!empty($wpttarProjectLogs)) {

                                foreach ($wpttarProjectLogs as $wpttarProjectLog) {
                                    $WorkTime = explode(':', $wpttarProjectLog->workedHour);
                                    if (isset($WorkTime[0]) && $WorkTime[0] != '00') {
                                        if (!empty($WorkTime[0])) {
                                            $workTimeHours = $WorkTime[0] . ' Hour';
                                        }
                                    } else {
                                        $workTimeHours = '';
                                    }
                                    if (isset($WorkTime[1]) && $WorkTime[1] != '00') {
                                        if (!empty($WorkTime[1])) {
                                            $workTimeMinutes = $WorkTime[1] . ' Minute';
                                        }
                                    } else {
                                        $workTimeMinutes = '';
                                    }
                                    ?>
                                    <tr id="row">
                                        <td><?php echo esc_html($i); ?></td>
                                       
                                        <td><?php
                                    if (isset($wpttarProjectLog->updateDate)) : echo esc_html(date('d M Y', strtotime($wpttarProjectLog->updateDate)));
                                    endif;
                                    ?>
                                    </td>
                                        
                                    <td><?php
                                    if (isset($wpttarProjectLog->startTime)) : echo esc_html(date($timeFormat, strtotime($wpttarProjectLog->startTime))); 
                                    endif;
                                    ?>&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;
                                    <?php
                                    if (isset($wpttarProjectLog->endTime)) : echo esc_html(date($timeFormat, strtotime($wpttarProjectLog->endTime)));
                                    endif;
                                    ?></td>
                                        <td><?php
                                    if (isset($workTimeHours)) : echo esc_html($workTimeHours);
                                    endif;
                                    ?>&nbsp;
                                            <?php
                                            if (isset($workTimeMinutes)) : echo esc_html($workTimeMinutes);
                                            endif;
                                            ?></td>
                                    </tr>
                                    <?php
                                    $i++;
                                }
                            }
                            ?>
                        </tbody>
                    </table>                   
                </div>
            </div>
        </div>
    </div>
</div><div id="project-model" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="alert alert-success display-hide" id="WPTTARCustomDelete_success"><i class='fa fa-check-square' aria-hidden='true'></i>
                <button class="close" data-close="alert"></button>
            </div>
            <div class="alert alert-danger display-hide" id="WPTTARCustomDelete_error">
                <button class="close" data-close="alert"></button>
            </div>
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"><?php _e('Projects Report', 'wpttar'); ?></h4>
            </div>
            <div class="modal-body" id="info"><?php _e('Please select date range.', 'wpttar'); ?></div>
            <div class="modal-footer">

                <button type="button" data-dismiss="modal" aria-hidden="true" class="btn default"><i class="fa fa-times"></i><?php _e('Cancel', 'wpttar'); ?></button>
            </div>
        </div>
    </div>
</div>
<!-- END PAGE CONTENT-->
<div class="user-timer-load-in-div"></div>