<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://presstigers.com/
 * @since             2.4.3
 * @package           Sjb_Job_Expirator
 *
 * @wordpress-plugin
 * Plugin Name:       SJB Job Expirator
 * Plugin URI:        https://wordpress.org/plugins/simple-job-board/
 * Description:       This plugin allows you to add the expiration date to a job & unpublished it after its expiry period.
 * Version:           1.0.0
 * Author:            PressTigers
 * Author URI:        http://presstigers.com/
 * License:           GPL-3.0+
 * License URI:       http://www.gnu.org/licenses/gpl-3.0.txt
 * Text Domain:       sjb-job-expirator
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Show admin notice & deactivate plugin if Simple Job Board plugin is not installed or activated.
 *  
 * @since    2.2.0
 */
if (!function_exists('sjbje_has_parent_plugin')) {

    /**
     * Check for parent plugin.
     */
    function sjbje_has_parent_plugin() {
        if (is_admin() && (!file_exists(WP_PLUGIN_DIR . '/simple-job-board/simple-job-board.php') && current_user_can('activate_plugins') )) {
            add_action('admin_notices', create_function(null, 'echo \'<div class="error"><p>\' . sprintf( __( \'Activation failed: Simple Job Board must be installed to use the <strong>SJB Job Expirator</strong> Plugin. %sInstall Simple Job Board now.\', \'sjb-job-expirator\' ), \'<a href="\' . admin_url(\'plugin-install.php?tab=plugin-information&plugin=simple-job-board&TB_iframe=true&width=600&height=550\')  . \'" class="thickbox" title="Simple Job Board">\' ) . \'</a></p></div>\';'));

            deactivate_plugins(plugin_basename(__FILE__));
            if (isset($_GET['activate'])) {
                unset($_GET['activate']);
            }
        } elseif (is_plugin_inactive('simple-job-board/simple-job-board.php') && current_user_can('activate_plugins')) {
            add_action('admin_notices', create_function(null, 'echo \'<div class="error"><p>\' . __( \'Activation failed: Simple Job Board must be activated to use the <strong>SJB Job Expirator</strong> Plugin.\', \'SJB Job Expirator\' ), \'</p></div>\';'));

            deactivate_plugins(plugin_basename(__FILE__));
            if (isset($_GET['activate'])) {
                unset($_GET['activate']);
            }
        }
    }

}

// Action -> Check for parent plugin.
add_action('admin_init', 'sjbje_has_parent_plugin');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-sjb-job-expirator-activator.php
 */
function activate_sjb_job_expirator() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-sjb-job-expirator-activator.php';
	Sjb_Job_Expirator_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-sjb-job-expirator-deactivator.php
 */
function deactivate_sjb_job_expirator() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-sjb-job-expirator-deactivator.php';
	Sjb_Job_Expirator_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_sjb_job_expirator' );
register_deactivation_hook( __FILE__, 'deactivate_sjb_job_expirator' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-sjb-job-expirator.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_sjb_job_expirator() {

	$plugin = new Sjb_Job_Expirator();
	$plugin->run();

}
run_sjb_job_expirator();
