<?php
namespace BooklyStaffCabinet\Frontend\Modules\StaffDetails;

use Bookly\Lib as BooklyLib;

/**
 * Class Ajax
 * @package BooklyStaffCabinet\Frontend\Modules\StaffDetails
 */
class Ajax extends BooklyLib\Base\Ajax
{
    /** @var BooklyLib\Entities\Staff */
    protected static $staff;

    /**
     * @inheritDoc
     */
    protected static function permissions()
    {
        return array(
            'getDetails' => 'staff',
        );
    }

    public static function getDetails()
    {
        $attributes = self::parameter( 'attributes' );
        $hide  = isset ( $attributes['hide'] ) ? explode( ',', $attributes['hide'] ) : array();
        $html  = self::renderTemplate( 'details', array( 'staff' => self::$staff, 'hide' => $hide ), false );
        wp_send_json_success( compact( 'html' ) );
    }

    /**
     * @inheritDoc
     */
    protected static function hasAccess( $action )
    {
        if ( parent::hasAccess( $action ) ) {
            self::$staff = BooklyLib\Entities\Staff::query()->where( 'wp_user_id', get_current_user_id() )->findOne();

            return self::$staff->isLoaded();
        }

        return false;
    }
}