<?php
namespace BooklyRecurringAppointments\Lib\Notifications\Assets\Item\ProxyProviders;

use Bookly\Lib\DataHolders\Booking\Series;
use Bookly\Lib\Notifications\Assets\Item\Codes;
use Bookly\Lib\Notifications\Assets\Item\Proxy;
use Bookly\Lib\Utils;

/**
 * Class Shared
 * @package BooklyRecurringAppointments\Lib\Notifications\Assets\Item\ProxyProviders
 */
abstract class Shared extends Proxy\Shared
{
    /**
     * @inheritdoc
     */
    public static function prepareCodes( Codes $codes )
    {
        /** @var Series $item */
        $item = $codes->getItem();
        if ( $item->isSeries() ) {
            $schedule = array();
            foreach ( $item->getItems() as $co ) {
                $event = clone $co;
                $show  = $codes->isForCustomer();
                if ( ! $show ) {
                    foreach ( $event->getItems() as $simple ) {
                        if ( $simple->getStaff()->getId() == $codes->staff->getId() ) {
                            $event = $simple;
                            $show  = true;
                            $codes->prepareForItem( $event, 'staff', $codes->staff );
                            break;
                        }
                    }
                }
                if( $show ) {
                    $schedule[] = array(
                        'start'      => $codes->tz( $event->getAppointment()->getStartDate() ),
                        'end'        => $codes->tz( $event->getAppointment()->getEndDate() ),
                        'token'      => $event->getCA()->getToken(),
                        'duration'   => $event->getService()->getDuration(),
                        'start_info' => $event->getService()->getStartTimeInfo(),
                    );
                }
            }
            $codes->schedule     = $schedule;
            $codes->series_token = $item->getSeries()->getToken();
        }
    }

    /**
     * @inheritdoc
     */
    public static function prepareReplaceCodes( array $replace_codes, Codes $codes, $format )
    {
        if ( is_array( $codes->schedule ) ) {
            $schedule = $schedule_c = '';
            $position = 1;
            foreach ( $codes->schedule as $appointment ) {
                $date       = Utils\DateTime::formatDate( $appointment['start'] );
                $time       = $appointment['duration'] < DAY_IN_SECONDS ? Utils\DateTime::formatTime( $appointment['start'] ) : $appointment['start_info'];
                $cancel_url = admin_url( 'admin-ajax.php?action=bookly_cancel_appointment&token=' . $appointment['token'] );
                if ( $format == 'html' ) {
                    $schedule_c .= sprintf( '<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>', $position, $date, $time, $cancel_url );
                    $schedule   .= sprintf( '<tr><td>%s</td><td>%s</td><td>%s</td></tr>', $position, $date, $time );
                } else {
                    $schedule_c .= sprintf( '%s. %s %s %s %s', $position, $date, __( 'at', 'bookly' ), $time, $cancel_url ) . PHP_EOL;
                    $schedule   .= sprintf( '%s. %s %s %s', $position, $date, __( 'at', 'bookly' ), $time ) . PHP_EOL;
                }
                $position ++;
            }
            if ( $format == 'html' ) {
                $replace_codes['{appointment_schedule}']   = '<table>' . $schedule . '</table>';
                $replace_codes['{appointment_schedule_c}'] = '<table>' . $schedule_c . '</table>';
            } else {
                $replace_codes['{appointment_schedule}']   = $schedule;
                $replace_codes['{appointment_schedule_c}'] = $schedule_c ;
            }
            $replace_codes['{recurring_count}'] = count( $codes->schedule );
            $replace_codes['{approve_appointment_schedule_url}'] = admin_url(
                'admin-ajax.php?action=bookly_recurring_appointments_approve_schedule&token=' .
                urlencode( Utils\Common::xorEncrypt( $codes->series_token, 'approve' ) )
            );
        } else {
            $replace_codes['{appointment_schedule}']             = '';
            $replace_codes['{appointment_schedule_c}']           = '';
            $replace_codes['{recurring_count}']                  = '';
            $replace_codes['{approve_appointment_schedule_url}'] = '';
        }

        return $replace_codes;
    }
}