<?php
namespace BooklyRecurringAppointments\Backend\Modules\Services\ProxyProviders;

use Bookly\Backend\Modules\Services\Proxy;

/**
 * Class Local
 * @package BooklyRecurringAppointments\Backend\Modules\Services\ProxyProviders
 */
class Local extends Proxy\RecurringAppointments
{
    /**
     * @inheritdoc
     */
    public static function renderSubForm( array $service )
    {
        $frequencies = array( 'daily', 'weekly', 'biweekly', 'monthly' );
        $recurrence_frequencies = explode( ',', $service['recurrence_frequencies'] );

        self::renderTemplate( 'recurring', compact( 'service', 'recurrence_frequencies', 'frequencies' ) );
    }
}