<?php

/**************************************
WIDGET: sport_animated_number
***************************************/

	add_action('widgets_init', 'register_widget_sport_animated_number' );
	function register_widget_sport_animated_number () {
		register_widget('sport_animated_number');	
	}

	class sport_animated_number extends WP_Widget {

		/**************************************
		1. INIT
		***************************************/
		function __construct () {

				$widget_ops = array(
					'classname' => 'sport_animated_number', 								
					'description' => __('Display an animated number', "loc_sport_widgets_plugin")	 				
				);
				$control_ops = array(
					'width' => 300, 
					'height' => 350, 
					'id_base' => 'sport_animated_number' 														
				);

				$this->WP_Widget('sport_animated_number', __('Sport: Animated Number', "loc_sport_widgets_plugin"), $widget_ops, $control_ops );	
		}

		/**************************************
		2. UPDATE
		***************************************/
		function update($new_instance, $old_instance) {
			return $new_instance;	 
		}

		/**************************************
		3. FORM
		***************************************/
		function form($instance) {

			//default for checkboxes
			if (empty($instance)) {
				$defaults_checkboxes = array(
					// 'fb_faces' => 'checked'
				);	
			}

			//defaults
			$defaults = array( 
				'number' 				=> "100",
				'postfix' 				=> "",
				'text' 					=> 'Nullam quis risus eget urna mollis ornare vel eu leo. Etiam porta sem malesuada magna.',
				'animation_speed' 		=> 3000,
				'use_seperator' 		=> 'checked',
				'show_text' 			=> 'checked',
			);

			//merge default
			if (!empty($defaults_checkboxes)) $defaults = array_merge($defaults, $defaults_checkboxes);

			$instance = wp_parse_args($instance, $defaults);
			extract($instance);
			?>

				<p>
					<label for="<?php echo $this->get_field_id('number'); ?> "><?php _e("Number", "loc_sport_widgets_plugin"); ?>: </label><br>
					<input type='text' id='<?php echo $this->get_field_id('number'); ?>' name='<?php echo $this->get_field_name('number'); ?>' value="<?php if(isset($number)) echo htmlspecialchars($number); ?>">
				</p>

				<p>
					<label for="<?php echo $this->get_field_id('prefix'); ?> "><?php _e("Prefix", "loc_sport_widgets_plugin"); ?>: </label><br>
					<input type='text' id='<?php echo $this->get_field_id('prefix'); ?>' name='<?php echo $this->get_field_name('prefix'); ?>' value="<?php if(isset($prefix)) echo htmlspecialchars($prefix); ?>">
				</p>

				<p>
					<label for="<?php echo $this->get_field_id('postfix'); ?> "><?php _e("Postfix", "loc_sport_widgets_plugin"); ?>: </label><br>
					<input type='text' id='<?php echo $this->get_field_id('postfix'); ?>' name='<?php echo $this->get_field_name('postfix'); ?>' value="<?php if(isset($postfix)) echo htmlspecialchars($postfix); ?>">
				</p>

				<p>
					<label for='<?php echo $this->get_field_id('text'); ?>'><?php _e("Text", "loc_sport_widgets_plugin"); ?></label><br>
					<textarea class='widefat' id='<?php echo $this->get_field_id('text'); ?>' name='<?php echo $this->get_field_name('text'); ?>' rows='5'><?php if (isset($text)) echo esc_attr($text); ?></textarea>
				</P>

				<p>
					<label for='<?php echo $this->get_field_id('animation_speed'); ?>'><?php _e("Animation Speed", "loc_sport_widgets_plugin"); ?>	: </label><br>
					<input 
						style='width: 80px;'
						type='number' 
						min='0'
						max='100000'
						step='100'
						id='<?php echo $this->get_field_id('animation_speed'); ?>' 
						name='<?php echo $this->get_field_name('animation_speed'); ?>' 
						value='<?php if (isset($animation_speed)) echo esc_attr($animation_speed); ?>'
					>
				</p>

				<p>
					<input type="hidden" name="<?php echo $this->get_field_name( 'use_seperator' ); ?>" value="unchecked" />
					<input class="checkbox" type="checkbox" id="<?php echo $this->get_field_id( 'use_seperator' ); ?>" name="<?php echo $this->get_field_name( 'use_seperator' ); ?>" value="checked" <?php checked($use_seperator == "checked"); ?>/> 
					<label for="<?php echo $this->get_field_id( 'use_seperator' ); ?>"><?php _e("Comma seperator", "loc_sport_widgets_plugin"); ?></label>
				</p>

				<p>
					<input type="hidden" name="<?php echo $this->get_field_name( 'show_text' ); ?>" value="unchecked" />
					<input class="checkbox" type="checkbox" id="<?php echo $this->get_field_id( 'show_text' ); ?>" name="<?php echo $this->get_field_name( 'show_text' ); ?>" value="checked" <?php checked($show_text == "checked"); ?>/> 
					<label for="<?php echo $this->get_field_id( 'show_text' ); ?>"><?php _e("Show text", "loc_sport_widgets_plugin"); ?></label>
				</p>

			<?php
		}

		/**************************************
		4. DISPLAY
		***************************************/
		function widget($args, $instance) {
			extract($args);								
			extract($instance);							

            // WPML
            if (function_exists('icl_translate')) { $number = icl_translate('loc_sport_widgets_plugin', "$widget_id-widget[number]", $number); }
            if (function_exists('icl_translate')) { $postfix = icl_translate('loc_sport_widgets_plugin', "$widget_id-widget[postfix]", $postfix); }
            if (function_exists('icl_translate')) { $text = icl_translate('loc_sport_widgets_plugin', "$widget_id-widget[text]", $text); }

			?>

			<?php echo $before_widget; ?>

			<?php echo $before_title . $after_title; ?>

			<div class="canon_animated_number" data-number="<?php echo $number; ?>" data-seperator="<?php echo $use_seperator; ?>" data-animation_speed="<?php echo $animation_speed; ?>">

				<h1 class="super"><?php if (!empty($prefix)) { echo $prefix; } ?> <span class="canon_animated_number_wrapper">0</span> <?php if (!empty($postfix)) { echo $postfix; } ?></h1>

				<?php if ($show_text == 'checked') { printf('<p>%s</p>', esc_attr($text)); } ?>

			</div>

			<?php echo $after_widget; ?>


			<?php
		}

	} //END CLASS



