<?php
/**
 * Template Name: Page Builder
 */
use Arkfield\Misc\Service;

$page_builder_utils = Service::page_builder_utils();

get_header();
?>

	<!-- Main Area -->
	<main id="site-main" class="site-main site-main--page-builder" role="main">

		<?php if ( have_posts() ) :

			while ( have_posts() ) :
				the_post();

				$page_builder_sections = $page_builder_utils->get_page_builder_sections( get_the_ID() );

				if ( ! empty( $page_builder_sections ) ) :
					foreach ( $page_builder_sections as $index => $section ) :
						$section['index'] = $index;
						$page_builder_utils->get_page_builder_partial( $section );
					endforeach;
				else : ?>
					<section class="main__content">
						<?php the_content(); ?>
					</section>
					<?php
				endif;
			endwhile;
		endif;
		?>

	</main>

<?php
get_footer();
