<?php
use Arkfield\Misc\Service;

$page_builder_section = \Zend_Registry::get( 'page_builder_section' );

$projects      = Service::project_dal()->get_projects( $page_builder_section['nb_projects'] );
$project_utils = Service::project_utils();
$project_dal   = Service::project_dal();

if ( ! empty( $projects ) ): ?>
	<article class="page-builder page-builder--fullscreen">
		<div class="article__content">
			<div class="pikartslider pikartslider--fullscreen">
				<?php
				/* @var WP_Post $project */
				foreach ( $projects as $project_index => $project ) :
				$project_meta = $project_dal->get_project_meta( $project->ID );
				$meta_title   = isset ( $project_meta['title'] ) ? $project_meta['title'] : '';
				$title        = $project_utils->get_project_title( get_the_title( $project ), $meta_title ); ?>
				<a href="<?php echo esc_url( get_permalink( $project ) ); ?>">
					<?php echo $project_utils->get_project_featured_image_html(
						$project->ID, $title, $project_meta, 'full', array( 'class' => 'rsImg' ) );
					endforeach; ?>
				</a>
			</div>
		</div>
	</article>
<?php endif;