<?php
namespace Arkfield\Setup;

use Arkfield\Admin\MCE_Manager;
use Arkfield\Admin\Post\Post_Setup;
use Arkfield\Admin\ThemeCustomizer\Theme_Options_Manager;
use Arkfield\Misc\Pixcodes;
use Arkfield\Misc\Plugins_Register;
use Arkfield\PageBuilder\Page_Builder_Manager;
use Arkfield\Project\Project_Register;
use Arkfield\Site\Blog\Blog_Manager;
use Arkfield\Site\Site_Customizer;
use Arkfield\WooCommerce\Woo_Commerce_Setup;


if ( ! class_exists( __NAMESPACE__ . '\Bootstrap' ) ) {
	/**
	 * Class Bootstrap
	 * @package Arkfield\Setup
	 */
	class Bootstrap {
		/**
		 * @var Theme_Setup
		 */
		protected $theme_setup;

		/**
		 * @var Project_Register
		 */
		protected $project_register;

		/**
		 * @var Theme_Options_Manager
		 */
		protected $theme_options_manager;

		/**
		 * @var Plugins_Register
		 */
		protected $plugins_register;

		/**
		 * @var Page_Builder_Manager
		 */
		protected $page_builder_manager;

		/**
		 * @var MCE_Manager
		 */
		protected $mce_manager;

		/**
		 * @var Pixcodes
		 */
		protected $pixcodes;

		/**
		 * @var Site_Customizer
		 */
		protected $site_customizer;

		/**
		 * @var Blog_Manager
		 */
		protected $blog_manager;

		/**
		 * @var Woo_Commerce_Setup
		 */
		protected $woo_commerce_setup;

		/**
		 * @var Post_Setup
		 */
		protected $post_setup;


		public function run() {
			$this->theme_setup->run();
			$this->project_register->setup();
			$this->theme_options_manager->run();
			$this->plugins_register->register();
			$this->page_builder_manager->setup();
			$this->mce_manager->setup_buttons();
			$this->pixcodes->setup();
			$this->site_customizer->customize();
			$this->blog_manager->setup();
			$this->woo_commerce_setup->run();
			$this->post_setup->run();
		}

		/**
		 * @param Theme_Setup $theme_setup
		 */
		public function set_theme_setup( Theme_Setup $theme_setup ) {
			$this->theme_setup = $theme_setup;
		}

		/**
		 * @param Project_Register $project_register
		 */
		public function set_project_register( Project_Register $project_register ) {
			$this->project_register = $project_register;
		}

		/**
		 * @param Theme_Options_Manager $theme_options_manager
		 */
		public function set_theme_options_manager( Theme_Options_Manager $theme_options_manager ) {
			$this->theme_options_manager = $theme_options_manager;
		}

		/**
		 * @param Plugins_Register $plugins_register
		 */
		public function set_plugins_register( Plugins_Register $plugins_register ) {
			$this->plugins_register = $plugins_register;
		}

		/**
		 * @param Page_Builder_Manager $page_builder_manager
		 */
		public function set_page_builder_manager( Page_Builder_Manager $page_builder_manager ) {
			$this->page_builder_manager = $page_builder_manager;
		}

		/**
		 * @param MCE_Manager $mce_manager
		 */
		public function set_mce_manager( MCE_Manager $mce_manager ) {
			$this->mce_manager = $mce_manager;
		}

		/**
		 * @param Pixcodes $pixcodes
		 */
		public function set_pixcodes( Pixcodes $pixcodes ) {
			$this->pixcodes = $pixcodes;
		}

		/**
		 * @param Site_Customizer $site_customizer
		 */
		public function set_site_customizer( Site_Customizer $site_customizer ) {
			$this->site_customizer = $site_customizer;
		}

		/**
		 * @param Blog_Manager $blog_manager
		 */
		public function set_blog_manager( Blog_Manager $blog_manager ) {
			$this->blog_manager = $blog_manager;
		}

		/**
		 * @param Woo_Commerce_Setup $woo_commerce_setup
		 */
		public function set_woo_commerce_setup( Woo_Commerce_Setup $woo_commerce_setup ) {
			$this->woo_commerce_setup = $woo_commerce_setup;
		}

		/**
		 * @param Post_Setup $post_setup
		 */
		public function set_post_setup( Post_Setup $post_setup ) {
			$this->post_setup = $post_setup;
		}
	}
}