<?php
namespace Arkfield\Project;

if ( ! class_exists( __NAMESPACE__ . '\Project_Config' ) ) {
	/**
	 * Class Project_Config
	 * @package Arkfield\Project
	 */
	class Project_Config {
		const PROJECT_SLUG = 'pikart-project';
		const PROJECT_CATEGORY_SLUG = 'pikart-project-category';
		const PROJECT_DB_PREFIX = 'pikart_project_';

		/**
		 * @return array
		 */
		public function get_project_config() {
			return array(
				'label'               => esc_html__( 'projects', 'arkfield' ),
				'description'         => esc_html__( 'Portfolio projects', 'arkfield' ),
				'supports'            => array( 'title', 'editor', 'thumbnail', 'comments' ),
				'taxonomies'          => array( self::PROJECT_CATEGORY_SLUG ),
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
				'show_in_menu'        => true,
				'show_in_nav_menus'   => true,
				'show_in_admin_bar'   => true,
				'menu_position'       => 5,
				'menu_icon'           => 'dashicons-portfolio',
				'can_export'          => true,
				'has_archive'         => true,
				'exclude_from_search' => false,
				'publicly_queryable'  => true,
				'capability_type'     => 'post',
				'rewrite'             => array(
					'slug'       => 'project',
					'with_front' => true,
				),
				'labels'              => array(
					'name'               => esc_html_x( 'Projects', 'Post Type General Name', 'arkfield' ),
					'singular_name'      => esc_html_x( 'Project', 'Post Type Singular Name', 'arkfield' ),
					'menu_name'          => esc_html__( 'Projects', 'arkfield' ),
					'parent_item_colon'  => esc_html__( 'Parent Project:', 'arkfield' ),
					'all_items'          => esc_html__( 'All Projects', 'arkfield' ),
					'view_item'          => esc_html__( 'View Project', 'arkfield' ),
					'add_new_item'       => esc_html__( 'Add New Project', 'arkfield' ),
					'new_item'           => esc_html__( 'New Project', 'arkfield' ),
					'add_new'            => esc_html__( 'Add New', 'arkfield' ),
					'edit_item'          => esc_html__( 'Edit Project', 'arkfield' ),
					'update_item'        => esc_html__( 'Update Project', 'arkfield' ),
					'search_items'       => esc_html__( 'Search Project', 'arkfield' ),
					'not_found'          => esc_html__( 'No projects found', 'arkfield' ),
					'not_found_in_trash' => esc_html__( 'No projects found in Trash', 'arkfield' ),
				),
			);
		}

		/**
		 * @return array
		 */
		public function get_project_taxonomies_config() {
			return array(
				'hierarchical'      => true,
				'public'            => true,
				'show_ui'           => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud'     => true,
				'rewrite'           => array(
					'slug'         => 'project-category',
					'with_front'   => true,
					'hierarchical' => false,
				),
				'labels'            => array(
					'name'                       => esc_html_x( 'Project Categories', 'Taxonomy General Name', 'arkfield' ),
					'singular_name'              => esc_html_x( 'Project Category', 'Taxonomy Singular Name', 'arkfield' ),
					'menu_name'                  => esc_html__( 'Project Categories', 'arkfield' ),
					'all_items'                  => esc_html__( 'All Categories', 'arkfield' ),
					'parent_item'                => esc_html__( 'Parent Category', 'arkfield' ),
					'parent_item_colon'          => esc_html__( 'Parent Category:', 'arkfield' ),
					'new_item_name'              => esc_html__( 'New Category', 'arkfield' ),
					'add_new_item'               => esc_html__( 'Add New Category', 'arkfield' ),
					'edit_item'                  => esc_html__( 'Edit Category', 'arkfield' ),
					'view_item'                  => esc_html__( 'View Category', 'arkfield' ),
					'update_item'                => esc_html__( 'Update Category', 'arkfield' ),
					'separate_items_with_commas' => esc_html__( 'Separate Categories with commas', 'arkfield' ),
					'search_items'               => esc_html__( 'Search Categories', 'arkfield' ),
					'add_or_remove_items'        => esc_html__( 'Add or remove Categories', 'arkfield' ),
					'popular_items'              => esc_html__( 'Popular Categories', 'arkfield' ),
					'choose_from_most_used'      => esc_html__( 'Choose from the most used categories', 'arkfield' ),
					'not_found'                  => esc_html__( 'Not categories found', 'arkfield' ),
				),
			);
		}

		/**
		 * @return array
		 */
		public function get_meta_boxes_config() {
			return array(
				'header_slider' => array(
					'label'  => esc_html__( 'Header Slider', 'arkfield' ),
					'nonce'  => array(
						'action' => self::PROJECT_DB_PREFIX . 'header_slider',
						'name'   => self::PROJECT_DB_PREFIX . 'header_slider_nonce'
					),
					'fields' => array(
						array(
							'id'    => self::PROJECT_DB_PREFIX . 'gallery',
							'type'  => 'gallery',
							'label' => esc_html__( 'Gallery', 'arkfield' ),
						),
						array(
							'id'          => self::PROJECT_DB_PREFIX . 'title',
							'type'        => 'text',
							'label'       => esc_html__( 'Title', 'arkfield' ),
							'description' => esc_html__( 'Insert your title here. In case you will not mention it, it will be automatically considered the project title', 'arkfield' ),
						),
						array(
							'id'    => self::PROJECT_DB_PREFIX . 'subtitle',
							'type'  => 'text',
							'label' => esc_html__( 'Subtitle', 'arkfield' ),
						)
					)
				)
			);
		}

		/**
		 * @return array
		 */
		public function get_classic_projects_animation_delay_config() {
			return array( 700, 850, 1000 );
		}

		/**
		 * @return array
		 */
		public function get_full_grid_projects_animation_delay_config() {
			return array( 700, 850, 1000, 1050 );
		}

		/**
		 * @return string
		 */
		public function get_project_no_feature_image_url_pattern() {
			return ARKFIELD_THEME_IMAGES_URI . '/projects/no-featured-image-%s.png';
		}
	}
}