<?php
namespace Arkfield\PageBuilder;

if ( ! class_exists( __NAMESPACE__ . '\Page_Builder_Config' ) ) {
	/**
	 * Class Page_Builder_Config
	 * @package Arkfield\PageBuilder
	 */
	class Page_Builder_Config {
		const PAGE_BUILDER_SECTIONS_META_KEY = 'page_builder_sections';

		/**
		 * @return array
		 */
		public function get_meta_boxes_page_section_config() {
			$fields = apply_filters( 'arkfield' . '_page_builder_section_fields', array(
				array(
					'id'          => 'content_type',
					'type'        => 'dropdown',
					'label'       => esc_html__( 'Content type', 'arkfield' ),
					'description' => esc_html__( 'Choose what would you like to insert in this section', 'arkfield' ),
					'options'     => array(
						'default'     => esc_html__( 'Default', 'arkfield' ),
						'projects'    => esc_html__( 'Projects', 'arkfield' ),
						'posts'       => esc_html__( 'Posts', 'arkfield' ),
						'contact_map' => esc_html__( 'Contact Map', 'arkfield' ),
					),
					'attributes'  => array(
						'class' => 'page-builder-section-content-type'
					)
				),
				array(
					'id'          => 'projects_display',
					'type'        => 'dropdown',
					'label'       => esc_html__( 'Display', 'arkfield' ),
					'description' => esc_html__( 'Select the way the projects will be displayed. The last 2 options, Classic and Multiple, have PortfolioFilter feature.', 'arkfield' ),
					'options'     => array(
						'fullgrid'          => esc_html__( 'Fullgrid', 'arkfield' ),
						'fullscreen_slider' => esc_html__( 'Fullscreen Slider', 'arkfield' ),
						'classic'           => esc_html__( 'Classic', 'arkfield' ),
						'multiple'          => esc_html__( 'Multiple', 'arkfield' ),
					),
					'attributes'  => array(
						'class' => 'page-builder-section-projects-display'
					)
				),
				array(
					'id'          => 'gmap_latitude',
					'type'        => 'number',
					'label'       => esc_html__( 'Google Maps latitude', 'arkfield' ),
					'description' => esc_html__( 'Paste here the latitude from Google Maps.', 'arkfield' ),
					'attributes'  => array(
						'min'  => - 90,
						'max'  => 90,
						'step' => 'any'
					)
				),
				array(
					'id'          => 'gmap_longitude',
					'type'        => 'number',
					'label'       => esc_html__( 'Google Maps longitude', 'arkfield' ),
					'description' => esc_html__( 'Paste here the longitude from Google Maps.', 'arkfield' ),
					'attributes'  => array(
						'min'  => - 180,
						'max'  => 180,
						'step' => 'any'
					)
				),
				array(
					'id'          => 'nb_projects',
					'type'        => 'number',
					'label'       => esc_html__( 'Number of projects', 'arkfield' ),
					'description' => esc_html__( 'Select the number of projects to display.', 'arkfield' ),
					'default'     => 12,
					'attributes'  => array(
						'min' => 1
					)
				),
				array(
					'id'          => 'nb_posts',
					'type'        => 'number',
					'label'       => esc_html__( 'Number of posts', 'arkfield' ),
					'description' => esc_html__( 'Select the number of posts to display.', 'arkfield' ),
					'default'     => 9,
					'attributes'  => array(
						'min' => 1
					)
				),
				array(
					'id'          => 'projects_speed',
					'type'        => 'checkbox',
					'label'       => esc_html__( 'Projects speed', 'arkfield' ),
					'description' => esc_html__( 'Check if you want the projects to move during scrolling', 'arkfield' ),
					'default'     => 'on',
				),
				array(
					'id'          => 'posts_speed',
					'type'        => 'checkbox',
					'label'       => esc_html__( 'Posts speed', 'arkfield' ),
					'description' => esc_html__( 'Check if you want the posts to move during scrolling', 'arkfield' ),
					'default'     => 'on',
				),
				array(
					'id'              => 'content',
					'type'            => 'wp_editor',
					'label'           => esc_html__( 'Content', 'arkfield' ),
					'description'     => esc_html__( 'Use images or shortcodes to further organize your content.', 'arkfield' ),
					'editor_settings' => array(
						'editor_class'  => 'meta-box-custom-wp-editor',
						'editor_height' => 380
					)
				),
				array(
					'id'         => 'remove_section',
					'type'       => 'button',
					'label'      => esc_html__( 'Delete', 'arkfield' ),
					'title'      => esc_html__( 'Remove section', 'arkfield' ),
					'persist'    => false,
					'attributes' => array(
						'href'  => '#',
						'class' => 'remove-page-meta-box-custom-button',
					)
				)
			) );

			return array(
				'label'  => esc_html__( 'Section', 'arkfield' ),
				'nonce'  => array(
					'action' => 'page_builder_section',
					'name'   => 'page_builder_section_nonce'
				),
				'fields' => $fields
			);
		}

		/**
		 * @return string
		 */
		public function get_add_section_label() {
			return esc_html__( 'Add section', 'arkfield' );
		}

		/**
		 * specifies which content type points to which field
		 * @return array
		 */
		public function get_partials_config() {
			return array( 'projects' => 'projects_display' );
		}
	}
}