<?php
namespace Arkfield\Misc;

if ( ! class_exists( __NAMESPACE__ . '\\Pixcodes' ) ) {
	// workaround to be able to use is_plugin_active
	require_once ABSPATH . 'wp-admin/includes/plugin.php';

	/**
	 * Class Pixcodes
	 * @package Arkfield\Misc
	 */
	class Pixcodes {
		const PIXCODES_PLUGIN = 'pixcodes/pixcodes.php';
		const PIXCODES_OPTION = 'wpgrade_shortcodes_list';
		const PIXCODES_FILTER_PATTERN = 'pixcodes_filter_params_for_%s';

		protected static $pixcodes = array(
			'Columns',
			'Heading',
			'Quote',
			'Button',
			'Icon',
			'Separator',
			'Slider',
			'Progress Bar',
			'Team Member',
		);

		public function setup() {
			if ( ! \is_admin() || ! \is_plugin_active( self::PIXCODES_PLUGIN ) ) {
				return;
			}

			\add_action( 'admin_head', $this->init_shortcode_list() );

			$this->register_shortcode_filters();
		}

		protected function register_shortcode_filters() {
			foreach ( static::$pixcodes as $pixcode ) {
				$pixcode       = strtolower( $pixcode );
				$filter_name   = sprintf( self::PIXCODES_FILTER_PATTERN, $pixcode );
				$filter_method = sprintf( 'configure_%s', str_replace( ' ', '_', $pixcode ) );

				if ( method_exists( $this, $filter_method ) ) {
					\add_filter( $filter_name, $this->$filter_method() );
				}
			}
		}

		/**
		 * @return \Closure
		 */
		protected function init_shortcode_list() {
			$pixcodes = static::$pixcodes;

			return function () use ( $pixcodes ) {
				$pixcode_names = array_map( function ( $pixcode ) {
					return str_replace( ' ', '', $pixcode );
				}, $pixcodes );

				\update_option( Pixcodes::PIXCODES_OPTION, $pixcode_names );
			};
		}

		/**
		 * @return \Closure
		 */
		protected function configure_columns() {
			return function ( array $params ) {
				unset( $params['bg_color'] );
				unset( $params['full_width'] );
				unset( $params['inner'] );
				unset( $params['inner_info'] );
				unset( $params['class'] );

				return $params;
			};
		}

		/**
		 * @return \Closure
		 */
		protected function configure_heading() {
			return function () {
				return array(
					'title'    => array(
						'type'        => 'text',
						'name'        => 'Title',
						'admin_class' => 'span7 push1'
					),
					'subtitle' => array(
						'type'        => 'text',
						'name'        => 'Subtitle',
						'admin_class' => 'span7 push1'
					),
				);
			};
		}

		/**
		 * @return \Closure
		 */
		protected function configure_quote() {
			return function ( array $params ) {
				unset( $params['author_title'] );

				return $params;
			};
		}

		/**
		 * @return \Closure
		 */
		protected function configure_button() {
			return function ( array $params ) {
				$params['newtab']['name'] = esc_html_x( 'Open in a new tab', 'Button shortcode', 'arkfield' );
				$params['newtab']['admin_class'] .= ' new-tab';

				return $params;
			};
		}

		/**
		 * @return \Closure
		 */
		protected function configure_separator() {
			return function ( array $params ) {
				unset( $params['align'] );
				unset( $params['size'] );
				unset( $params['weight'] );
				unset( $params['color'] );

				return $params;
			};
		}

		/**
		 * @return \Closure
		 */
		protected function configure_slider() {
			return function ( array $params ) {
				unset( $params['navigation_style']['options']['both'] );

				return $params;
			};
		}

		/**
		 * @return \Closure
		 */
		protected function configure_progress_bar() {
			return function ( array $params ) {
				unset( $params['markers'] );
				$params['title']['admin_class']    = 'span7 push1';
				$params['progress']['admin_class'] = 'span2 push2';
				$params[0]['admin_class']          = 'span10 push1';

				return $params;
			};
		}

		/**
		 * @return \Closure
		 */
		protected function configure_team_member() {
			return function ( array $params ) {
				unset( $params['content'] );

				return $params;
			};
		}
	}
}
