<?php
namespace Arkfield\Misc;

if ( ! class_exists( __NAMESPACE__ . '\\Back_Compat' ) ) {
	/**
	 * This class is used for backwards compatibility for wp old versions starting from 4.0
	 *
	 * Class Back_Compat
	 * @package Arkfield\Misc
	 */
	class Back_Compat {

		public function build_theme_title() {
			// build the title only for wp version < 4.1, because since 4.1 it's already in the core
			if ( version_compare( $GLOBALS['wp_version'], '4.0', '>=' ) ) {
				return;
			}

			\add_filter( 'wp_title', function ( $title, $sep ) {
				$page  = $GLOBALS['page'];
				$paged = $GLOBALS['paged'];

				if ( \is_feed() ) {
					return $title;
				}

				$titleData = array( \get_bloginfo( 'name', 'display' ) );

				// Add the site description for the home/front page.
				$site_description = \get_bloginfo( 'description', 'display' );
				if ( $site_description && ( \is_home() || \is_front_page() ) ) {
					$titleData[] = $site_description;
				}

				// Add a page number if necessary.
				if ( ( $paged >= 2 || $page >= 2 ) && ! \is_404() ) {
					$titleData[] = sprintf(  esc_html__( 'Page %s', 'arkfield' ), max( $paged, $page ) );
				}

				return $title . implode( $sep, $titleData );
			}, 10, 2 );
		}

		/**
		 * Retrieve the archive title based on the queried object.
		 *
		 * Used for backwards compatibility since it's only available in WP 4.1
		 *
		 * @return string Archive title.
		 */
		public function get_the_archive_title() {
			$title = '';
			if ( \is_category() ) {
				$title = sprintf(  esc_html__( 'Category: %s', 'arkfield' ), \single_cat_title( '', false ) );
			} elseif ( \is_tag() ) {
				$title = sprintf(  esc_html__( 'Tag: %s', 'arkfield' ), \single_tag_title( '', false ) );
			} elseif ( \is_author() ) {
				$title = sprintf(  esc_html__( 'Author: %s', 'arkfield' ),
					'<span class="vcard">' . \get_the_author() . '</span>' );
			} elseif ( \is_year() ) {
				$title = sprintf(  esc_html__( 'Year: %s', 'arkfield' ),
					\get_the_date( esc_html_x( 'Y', 'yearly archives date format', 'arkfield' ) ) );
			} elseif ( \is_month() ) {
				$title = sprintf(  esc_html__( 'Month: %s', 'arkfield' ),
					\get_the_date( esc_html_x( 'F Y', 'monthly archives date format', 'arkfield' ) ) );
			} elseif ( \is_day() ) {
				$title = sprintf(  esc_html__( 'Day: %s', 'arkfield' ),
					\get_the_date( esc_html_x( 'F j, Y', 'daily archives date format', 'arkfield' ) ) );
			} elseif ( \is_tax( 'post_format' ) ) {
				if ( \is_tax( 'post_format', 'post-format-aside' ) ) {
					$title = esc_html_x( 'Asides', 'post format archive title', 'arkfield' );
				} elseif ( \is_tax( 'post_format', 'post-format-gallery' ) ) {
					$title = esc_html_x( 'Galleries', 'post format archive title', 'arkfield' );
				} elseif ( \is_tax( 'post_format', 'post-format-image' ) ) {
					$title = esc_html_x( 'Images', 'post format archive title', 'arkfield' );
				} elseif ( \is_tax( 'post_format', 'post-format-video' ) ) {
					$title = esc_html_x( 'Videos', 'post format archive title', 'arkfield' );
				} elseif ( \is_tax( 'post_format', 'post-format-quote' ) ) {
					$title = esc_html_x( 'Quotes', 'post format archive title', 'arkfield' );
				} elseif ( \is_tax( 'post_format', 'post-format-link' ) ) {
					$title = esc_html_x( 'Links', 'post format archive title', 'arkfield' );
				} elseif ( \is_tax( 'post_format', 'post-format-status' ) ) {
					$title = esc_html_x( 'Statuses', 'post format archive title', 'arkfield' );
				} elseif ( \is_tax( 'post_format', 'post-format-audio' ) ) {
					$title = esc_html_x( 'Audio', 'post format archive title', 'arkfield' );
				} elseif ( \is_tax( 'post_format', 'post-format-chat' ) ) {
					$title = esc_html_x( 'Chats', 'post format archive title', 'arkfield' );
				}
			} elseif ( \is_post_type_archive() ) {
				$title = sprintf(  esc_html__( 'Archives: %s', 'arkfield' ), post_type_archive_title( '', false ) );
			} elseif ( \is_tax() ) {
				$tax = \get_taxonomy( \get_queried_object()->taxonomy );
				/* translators: 1: Taxonomy singular name, 2: Current taxonomy term */
				$title = sprintf(  esc_html__( '%1$s: %2$s', 'arkfield' ), $tax->labels->singular_name,
					\single_term_title( '', false ) );
			} else {
				$title =  esc_html__( 'Archives', 'arkfield' );
			}

			return \apply_filters( 'get_the_archive_title', $title );
		}

		/**
		 * Retrieve category, tag, or term description.
		 *
		 * Used for backwards compatibility since it's only available in WP 4.1
		 *
		 * @return string Archive description.
		 */
		public function get_the_archive_description() {
			/**
			 * Filter the archive description.
			 *
			 * @see term_description()
			 *
			 * @param string $description Archive description to be displayed.
			 */
			return \apply_filters( 'get_the_archive_description', term_description() );
		}

		/**
		 * Return a paginated navigation to next/previous set of posts,
		 * when applicable.
		 *
		 * Used for backwards compatibility since it's only available in WP 4.1
		 *
		 * @param array $args               {
		 *                                  Optional. Default pagination arguments, {@see paginate_links()}.
		 *
		 * @type string $screen_reader_text Screen reader text for navigation element.
		 *                                      Default 'Posts navigation'.
		 * }
		 * @return string Markup for pagination links.
		 */
		public function get_the_posts_pagination( $args = array() ) {
			$navigation = '';

			// Don't print empty markup if there's only one page.
			if ( $GLOBALS['wp_query']->max_num_pages > 1 ) {
				$args = \wp_parse_args( $args, array(
					'mid_size'           => 1,
					'prev_text'          => esc_html_x( 'Previous', 'previous post', 'arkfield' ),
					'next_text'          => esc_html_x( 'Next', 'next post', 'arkfield' ),
					'screen_reader_text' =>  esc_html__( 'Posts navigation', 'arkfield' ),
				) );

				// Make sure we get a string back. Plain is the next best thing.
				if ( isset( $args['type'] ) && 'array' === $args['type'] ) {
					$args['type'] = 'plain';
				}

				// Set up paginated links.
				$links = \paginate_links( $args );

				if ( $links ) {
					$navigation = $this->_navigation_markup( $links, 'pagination', $args['screen_reader_text'] );
				}
			}

			return $navigation;
		}


		/**
		 * Wraps passed links in navigational markup.
		 *
		 * Used for backwards compatibility since it's only available in WP 4.1
		 * @access private
		 *
		 * @param string $links              Navigational links.
		 * @param string $class              Optional. Custom class for nav element. Default: 'posts-navigation'.
		 * @param string $screen_reader_text Optional. Screen reader text for nav element. Default: 'Posts navigation'.
		 *
		 * @return string Navigation template tag.
		 */
		protected function _navigation_markup( $links, $class = 'posts-navigation', $screen_reader_text = '' ) {
			if ( empty( $screen_reader_text ) ) {
				$screen_reader_text =  esc_html__( 'Posts navigation', 'arkfield' );
			}

			$template = '
				<nav class="navigation %1$s" role="navigation">
					<h2 class="screen-reader-text">%2$s</h2>
					<div class="nav-links">%3$s</div>
				</nav>';

			return sprintf( $template, sanitize_html_class( $class ), esc_html( $screen_reader_text ), $links );
		}
	}
}