<?php
namespace Arkfield\Admin\ThemeCustomizer;

if ( ! class_exists( __NAMESPACE__ . '\\Theme_Options_Css_Filter' ) ) {
	/**
	 * Class Theme_Options_Css_Filter
	 * @package Arkfield\Admin\ThemeCustomizer
	 */
	class Theme_Options_Css_Filter {
		/**
		 * @param string $value
		 *
		 * @return string
		 */
		public function size_unit_em( $value ) {
			return $value . 'em';
		}

		/**
		 * @param string $value
		 *
		 * @return string
		 */
		public function size_unit_px( $value ) {
			return $value . 'px';
		}

		/**
		 * @param string $value
		 *
		 * @return string
		 */
		public function reverse_percentage( $value ) {
			return ( 100 / $value ) . '%';
		}

		/**
		 * @param $value
		 *
		 * @return mixed
		 */
		public function font_family( $value ) {
			$fontData = explode( ':', $value );

			return "'" . str_replace( '+', ' ', $fontData[0] ) . "', " . Theme_Options_Config::FALLBACK_FONT_FAMILY;
		}
	}
}