<?php
namespace Arkfield\Admin\ThemeCustomizer;

if ( ! class_exists( __NAMESPACE__ . '\\Theme_Options_Builder' ) ) {
	/**
	 * Class Theme_Options_Builder
	 * @package Arkfield\Admin\ThemeCustomizer
	 */
	class Theme_Options_Builder {

		/**
		 * @var Theme_Options_Config
		 */
		protected $theme_options_config;

		/**
		 * @var Theme_Options_Wrapper
		 */
		protected $theme_options_wrapper;


		/**
		 * @param Theme_Options_Wrapper $theme_options_wrapper
		 * @param Theme_Options_Config  $theme_options_config
		 */
		public function __construct( Theme_Options_Config $theme_options_config, Theme_Options_Wrapper $theme_options_wrapper ) {
			$this->theme_options_config  = $theme_options_config;
			$this->theme_options_wrapper = $theme_options_wrapper;
		}

		public function generate_theme_options() {
			$customizations = $this->theme_options_config->get_customizations();

			if ( isset( $customizations['panels'] ) ) {
				foreach ( $customizations['panels'] as $section ) {
					$this->build_panel( $section );
				}
			}

			if ( isset( $customizations['sections'] ) ) {
				foreach ( $customizations['sections'] as $section ) {
					$this->build_section( $section );
				}
			}
		}

		/**
		 * @return Theme_Options_Wrapper
		 */
		public function get_theme_options_wrapper() {
			return $this->theme_options_wrapper;
		}

		/**
		 * @param array  $section
		 * @param string $panel_id
		 */
		protected function build_section( $section, $panel_id = null ) {
			$section_id = $section['id'];

			if ( null !== $panel_id && ( ! isset( $section['built-in'] ) || ! $section['built-in'] ) ) {
				$section_id = $this->theme_options_wrapper->add_section(
					$section['id'],
					$panel_id,
					$this->get_item_value( $section, 'title' ),
					$this->get_item_value( $section, 'description' ),
					$this->get_item_value( $section, 'priority' )
				);
			}

			if ( isset( $section['controls'] ) ) {
				foreach ( $section['controls'] as $control ) {
					$this->build_control( $control, $section_id );
				}
			}

		}

		/**
		 * @param array  $control
		 * @param string $section_id
		 */
		protected function build_control( $control, $section_id ) {
			$this->theme_options_wrapper->add_control( $control['id'], $section_id, $control['type'], $control );
		}

		/**
		 * @param array $panel
		 */
		protected function build_panel( $panel ) {
			$panel_id = $this->theme_options_wrapper->add_panel(
				$panel['id'],
				$panel['title'],
				$this->get_item_value( $panel, 'description' ),
				$this->get_item_value( $panel, 'priority' )
			);

			if ( isset( $panel['sections'] ) ) {
				foreach ( $panel['sections'] as $section ) {
					$this->build_section( $section, $panel_id );
				}
			}
		}

		/**
		 * @param array  $array
		 * @param string $item_name
		 * @param string $default
		 *
		 * @return mixed
		 */
		protected function get_item_value( $array, $item_name, $default = '' ) {
			return isset( $array[ $item_name ] ) ? $array[ $item_name ] : $default;
		}
	}
}
