<?php
namespace Arkfield\Admin\ThemeCustomizer;

if ( ! class_exists( __NAMESPACE__ . '\\Google_Fonts_Options' ) ) {
	/**
	 * Class Google_Fonts_Options
	 * @package Arkfield\Admin\ThemeCustomizer
	 */
	class Google_Fonts_Options {

		public function __construct() {
			$this->register_add_google_font_ajax();
		}

		/**
		 * @return array
		 */
		public function get_google_fonts() {
			$google_fonts_option_key = $this->build_option_key( 'google_fonts' );
			$fonts                   = \get_option( $google_fonts_option_key );

			if ( ! $fonts ) {
				$default_google_fonts = $this->format_fonts( $this->get_default_google_fonts() );
				\add_option( $google_fonts_option_key, $default_google_fonts );
				$fonts = $default_google_fonts;
			}

			return $fonts;
		}

		public function enqueue_google_fonts( array $fonts_to_enqueue = array() ) {
			$google_fonts             = $this->get_google_fonts();
			$google_fonts_url_pattern = $this->get_google_fonts_url_pattern();
			\add_action( 'wp_enqueue_scripts', function () use ( $google_fonts, $fonts_to_enqueue, $google_fonts_url_pattern ) {
				if ( \is_customize_preview() ) {
					$fonts_to_enqueue = array_merge( $fonts_to_enqueue, $google_fonts );
				}

				\wp_enqueue_style(
					'arkfield' . '-google-fonts',
					sprintf( $google_fonts_url_pattern, implode( '|', array_unique( $fonts_to_enqueue ) ) )
				);
			} );
		}

		/**
		 * @return array
		 */
		protected function get_default_google_fonts() {
			return array(
				'Arimo:400,400italic,700,700italic',
				'Arvo:400,400italic,700,700italic',
				'Bitter:400,400italic,700',
				'Denk+One',
				'Droid+Sans:400,700',
				'Droid+Serif:400,400italic,700,700italic',
				'Josefin+Sans:100,100italic,300,300italic,400,400italic,600,600italic,700,700italic',
				'Josefin+Slab:100,100italic,300,300italic,400,400italic,600,600italic,700,700italic',
				'Lato:100,100italic,300,300italic,400,400italic,700,700italic,900,900italic',
				'Lora:400,400italic,700italic,700',
				'Montserrat:400,700',
				'Open+Sans:300,300italic,400,400italic,600,600italic,700,700italic,800,800italic',
				'Open+Sans+Condensed:300,300italic,700',
				'Oswald:300,400,700',
				'PT+Sans:400,400italic,700,700italic',
				'PT+Sans+Narrow:400,700',
				'Raleway:100,200,300,400,500,600,700,800,900',
				'Roboto:100,100italic,300,300italic,400,400italic,500,500italic,700,700italic,900,900italic',
				'Roboto+Condensed:300,300italic,400,400italic,700,700italic',
				'Roboto+Slab:100,300,400,700',
				'Rokkitt:400,700',
				'Source+Sans+Pro:200,200italic,300,300italic,400,400italic,600,600italic,700,700italic,900,900italic',
				'Ubuntu:300,300italic,400,400italic,500,500italic,700,700italic',
				'Yanone+Kaffeesatz:200,300,400,700',
			);
		}

		/**
		 * @param string $key
		 *
		 * @return string
		 */
		protected function build_option_key( $key ) {
			return 'arkfield' . '_' . $key;
		}

		protected function get_google_fonts_url_pattern() {
			return ( \is_ssl() ? 'https' : 'http' ) . '://fonts.googleapis.com/css?family=%s';
		}


		protected function register_add_google_font_ajax() {
			$fonts                    = $this->get_google_fonts();
			$format_fonts_callback    = $this->format_fonts_callback();
			$google_fonts_option_key  = $this->build_option_key( 'google_fonts' );
			$google_fonts_url_pattern = $this->get_google_fonts_url_pattern();

			\add_action( 'wp_ajax_add_google_font', function () use ( $fonts, $format_fonts_callback, $google_fonts_option_key, $google_fonts_url_pattern ) {
				$encodedGoogleFont = filter_input( INPUT_POST, 'googleFont', FILTER_SANITIZE_URL );
				$errorMessage      = esc_html__( 'Invalid font. Retype it carefully again.', 'arkfield' );

				if ( empty( $encodedGoogleFont ) ) {
					\wp_send_json_error( $errorMessage );

					return;
				}

				$googleFont = str_replace( ' ', '+', urldecode( $encodedGoogleFont ) );

				if ( in_array( $googleFont, $fonts ) ) {
					\wp_send_json_error( esc_html__( 'Font already exists. See Heading font family / Text font family dropdown-lists from above', 'arkfield' ) );

					return;
				}

				$response = \wp_remote_get(
					sprintf( $google_fonts_url_pattern, str_replace( '%2B', '+', $encodedGoogleFont ) )
				);

				if ( 200 === $response['response']['code'] ) {

					if ( strpos( $googleFont, '|' ) !== false ) {
						\wp_send_json_error( esc_html__( 'Please add only one font at once', 'arkfield' ) );

						return;
					}

					$fonts[] = $googleFont;
					$fonts   = $format_fonts_callback( $fonts );
					\update_option( $google_fonts_option_key, $fonts );

					\wp_send_json_success( array(
						'message'     => esc_html__( 'Font was added. See Heading font family / Text font family dropdown-lists from above', 'arkfield' ),
						'fontContent' => $response['body']
					) );
				} else {
					\wp_send_json_error( $errorMessage );
				}
			} );
		}

		/**
		 * @param array $fonts
		 *
		 * @return array
		 */
		protected function format_fonts( array $fonts ) {
			$format_fonts_callback = $this->format_fonts_callback();

			return $format_fonts_callback( $fonts );
		}

		/**
		 * @return \Closure
		 */
		protected function format_fonts_callback() {
			return function ( array $fonts ) {
				$fonts = array_unique( $fonts );
				natsort( $fonts );

				return $fonts;
			};
		}
	}
}