<?php
/**
 * Rejection email.
 *
 * @package     wpum-user-verification
 * @copyright   Copyright (c) 2016, Alessandro Tesoro
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.1.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * This class registers a new email for the editor.
 * @since 1.0.0
 */
class WPUM_reject_Email extends WPUM_Emails {

	/**
	 * This function sets up a custom email.
	 *
	 * @since 1.0.0
	 * @return  void
	 */
	function __construct() {

		// Configure Email
		$this->name        = 'reject';
		$this->title       = __( "Rejection Email", 'wpum-user-verification' );
		$this->description = __( "This is the email that is sent to the user when his registration is rejected.", 'wpum-user-verification' );
		$this->subject     = $this->subject();
		$this->message     = $this->message();

		// do not delete!
		parent::__construct();

	}

	/**
	 * The default subject of the email.
	 *
	 * @since 1.0.0
	 * @return  void
	 */
	public static function subject() {

		$subject = sprintf( esc_html__( 'Your registration at %s has been rejected.', 'wpum-user-verification' ), get_option( 'blogname' ) );

		return $subject;

	}

	/**
	 * The default message of the email.
	 *
	 * @since 1.0.0
	 * @return  void
	 */
	public static function message() {

		$message = __( "Hello {username}, \n\n", 'wpum-user-verification' );
		$message .= __( "Unfortunately, your registration has been rejected and your account deleted. \n\n", 'wpum-user-verification' );

		return $message;

	}

}

new WPUM_reject_Email();
