<?php
use Arkfield\Misc\Service;

$page_builder_section = \Zend_Registry::get( 'page_builder_section' );

$projects      = Service::project_dal()->get_projects( $page_builder_section['nb_projects'] );
$categories    = Service::project_dal()->get_unique_projects_categories( $projects );
$project_utils = Service::project_utils();

if ( ! empty( $projects ) ): ?>
	<article class="page-builder page-builder--projects">
		<div class="page-builder__container">
			<header class="article__header main__header--classic">

				<div class="mesh__filter">
					<ul class="mesh__filter__options">
						<li>
							<a class="btn--selected"
							   href="#" data-option-value="*"> <?php esc_html_e( 'All', 'arkfield' ) ?> </a>
						</li>

						<?php foreach ( $categories as $id => $category ): ?>
							<li>
								<a class="btn--not-selected" href="#"
								   data-option-value=".<?php echo esc_attr( $project_utils->get_project_category_filter_option( $id, $category->slug ) ) ?>">
									<?php echo esc_html( $category->name ) ?></a>
							</li>
						<?php endforeach; ?>
					</ul>
				</div>
			</header>

			<div class="article__content">
				<div class="mesh mesh--<?php echo esc_attr( $page_builder_section['projects_display'] ) ?>">
					<?php
					foreach ( $projects as $project_index => $project ) :
						\Zend_Registry::set( 'project', $project );
						\Zend_Registry::set( 'project_index', $project_index );
						Service::utils()->get_partial( 'project/single-project' );
					endforeach; ?>
				</div>
			</div>
		</div>
	</article>

<?php endif;