<?php
use Arkfield\Misc\Service;

?>
<!-- Main Area -->
<main id="site-main" class="site-main site-main--diary" role="main">
	<div class="site-main__container">

		<?php if ( have_posts() ) :
			Service::utils()->get_partial( 'blog/header', get_post_format() );
			$posts_speed = (int) Service::theme_options_utils()->get_custom_option( 'posts_speed' ); ?>

			<div class="news" data-items-speed="<?php echo esc_attr( $posts_speed ) ?>">
				<?php while ( have_posts() ) :
					the_post();

					Service::utils()->get_partial( 'blog/content', get_post_format() );

				endwhile; ?>
			</div>

			<?php
			echo get_the_posts_pagination( array(
				'screen_reader_text' => ' ',
				'prev_text'          => '',
				'next_text'          => '',
			) );

		else :
			Service::utils()->get_partial( 'blog/content', 'none' );
		endif; ?>

	</div>
</main>