<?php
/**
 * Register new project post type and its taxonomies
 *
 * @package    Arkfield
 * @subpackage Project
 */

namespace Arkfield\Project;

use Arkfield\Admin\MetaBoxes\Meta_Box_Utils;

if ( ! class_exists( __NAMESPACE__ . '\Project_Register' ) ) {

	/**
	 * Class Project_Register
	 * @package Arkfield\Project
	 */
	class Project_Register {
		/**
		 * @var Project_Config
		 */
		protected $project_config;

		/**
		 * @var Meta_Box_Utils
		 */
		protected $meta_box_utils;

		/**
		 * Project_Register constructor.
		 *
		 * @param Project_Config $project_config
		 * @param Meta_Box_Utils $meta_box_utils
		 */
		public function __construct( Project_Config $project_config, Meta_Box_Utils $meta_box_utils ) {
			$this->project_config = $project_config;
			$this->meta_box_utils = $meta_box_utils;
		}


		/**
		 * Register project post type and its taxonomies
		 */
		public function setup() {
			$project_config = $this->project_config;
			add_action( 'init', function () use ( $project_config ) {
				\register_post_type( Project_Config::PROJECT_SLUG, $project_config->get_project_config() );
				\register_taxonomy(
					Project_Config::PROJECT_CATEGORY_SLUG,
					array( Project_Config::PROJECT_SLUG ),
					$project_config->get_project_taxonomies_config()
				);
			} );

			$this->register_meta_boxes();
		}

		/**
		 * Registers project meta_boxes
		 */
		protected function register_meta_boxes() {
			$this->meta_box_utils->register_meta_boxes(
				Project_Config::PROJECT_SLUG, $this->project_config->get_meta_boxes_config() );
		}
	}
}
