<?php
namespace Arkfield\PageBuilder;

use Arkfield\Misc\Utils;

if ( ! class_exists( __NAMESPACE__ . '\Page_Builder_Utils' ) ) {
	/**
	 * Class Page_Builder_Utils
	 * @package Arkfield\PageBuilder
	 */
	class Page_Builder_Utils {
		/**
		 * @var Page_Builder_Config
		 */
		protected $page_builder_config;

		/**
		 * @var Page_Builder_DAL
		 */
		protected $page_builder_dal;

		/**
		 * @var Utils
		 */
		protected $utils;

		/**
		 * Page_Builder_Utils constructor.
		 *
		 * @param Page_Builder_Config $page_builder_config
		 * @param Page_Builder_DAL    $page_builder_dal
		 * @param Utils               $utils
		 */
		public function __construct( Page_Builder_Config $page_builder_config, Page_Builder_DAL $page_builder_dal, Utils $utils ) {
			$this->page_builder_config = $page_builder_config;
			$this->page_builder_dal    = $page_builder_dal;
			$this->utils               = $utils;
		}


		/**
		 * @param int $page_id
		 *
		 * @return array
		 */
		public function get_page_builder_sections( $page_id ) {
			return $this->page_builder_dal->get_meta_box_data( $page_id );
		}

		/**
		 * @param array $section
		 */
		public function get_page_builder_partial( array $section ) {
			\Zend_Registry::set( 'page_builder_section', $section );
			$partials_config           = $this->page_builder_config->get_partials_config();
			$specialized_template_name = isset( $partials_config[ $section['content_type'] ] )
				? $section[ $partials_config[ $section['content_type'] ] ] : null;

			$this->utils->get_partial(
				'page-builder/' . $this->utils->normalize_meta_value_to_partial_name( $section['content_type'] ),
				$this->utils->normalize_meta_value_to_partial_name( $specialized_template_name )
			);
		}
	}
}