<?php
namespace Arkfield\PageBuilder;

use Arkfield\Admin\MetaBoxes\Meta_Box_Utils;

if ( ! class_exists( __NAMESPACE__ . '\Page_Builder_Meta_Box' ) ) {
	/**
	 * Class Page_Builder_Meta_Box
	 * @package Arkfield\PageBuilder
	 */
	class Page_Builder_Meta_Box {
		const POST_TYPE = 'page';

		/**
		 * @var Page_Builder_Config
		 */
		protected $page_builder_config;

		/**
		 * @var Page_Builder_DAL
		 */
		protected $page_builder_dal;

		/**
		 * @var Meta_Box_Utils
		 */
		protected $meta_box_utils;

		/**
		 * Page_Builder_Meta_Box constructor.
		 *
		 * @param Page_Builder_Config $page_builder_config
		 * @param Page_Builder_DAL    $page_builder_dal
		 * @param Meta_Box_Utils      $meta_box_utils
		 */
		public function __construct( Page_Builder_Config $page_builder_config, Page_Builder_DAL $page_builder_dal, Meta_Box_Utils $meta_box_utils ) {
			$this->page_builder_config = $page_builder_config;
			$this->page_builder_dal    = $page_builder_dal;
			$this->meta_box_utils      = $meta_box_utils;
		}

		/**
		 * @param int $page_id
		 */
		public function generate_meta_boxes( $page_id ) {
			$sections = $this->page_builder_dal->get_meta_box_data( $page_id );
			$this->meta_box_utils->generate_meta_boxes(
				self::POST_TYPE, $this->get_meta_boxes_config( $sections ) );
		}

		/**
		 * @param int $meta_box_index
		 */
		public function generate_meta_box_by_index( $meta_box_index ) {
			$meta_box_id     = Page_Builder_Config::PAGE_BUILDER_SECTIONS_META_KEY . $meta_box_index;
			$meta_box_config = $this->add_index_to_meta_box_config(
				$this->page_builder_config->get_meta_boxes_page_section_config(), $meta_box_index );

			$this->meta_box_utils->generate_meta_box( self::POST_TYPE, $meta_box_id, $meta_box_config );
		}

		/**
		 * @param array $sections
		 *
		 * @return array
		 */
		protected function get_meta_boxes_config( $sections ) {
			if ( empty( $sections ) ) {
				return array();
			}

			$default_config    = $this->page_builder_config->get_meta_boxes_page_section_config();
			$meta_boxes_config = array();

			foreach ( $sections as $section_index => $field_values ) {
				$meta_boxes_config[ Page_Builder_Config::PAGE_BUILDER_SECTIONS_META_KEY . $section_index ] =
					$this->add_index_to_meta_box_config( $default_config, $section_index, $field_values );
			}

			return $meta_boxes_config;
		}

		/**
		 * @param array $meta_box_config
		 * @param int   $meta_box_index
		 * @param array $field_values
		 *
		 * @return array
		 */
		protected function add_index_to_meta_box_config( array $meta_box_config, $meta_box_index, array $field_values = array() ) {
			$sections_meta_key_pattern        = Page_Builder_Config::PAGE_BUILDER_SECTIONS_META_KEY
			                                    . '[' . $meta_box_index . '][%s]';
			$meta_box_config['nonce']['name'] = sprintf( $sections_meta_key_pattern, $meta_box_config['nonce']['name'] );

			foreach ( $meta_box_config['fields'] as &$field_config ) {
				$id = $field_config['id'];

				if ( isset( $field_values[ $id ] ) ) {
					$field_config['value'] = $field_values[ $id ];
				}

				$field_config['id'] = sprintf( $sections_meta_key_pattern, $id );
			}

			return $meta_box_config;
		}
	}
}