<?php
namespace Arkfield\Admin\MetaBoxes\Generator;

if ( ! class_exists( __NAMESPACE__ . '\\Line_Generator' ) ) {
	/**
	 * Class Line_Generator
	 * @package Arkfield\Admin\MetaBoxes\Generator
	 */
	class Line_Generator {
		const HTML_CONTAINER_PATTERN = '<div class="meta-box-custom-field">%s</div>';
		const HTML_LABEL_PATTERN = '<label for="%s">%s</label>';
		const HTML_DESCRIPTION_PATTERN = '<span class="meta-box-custom-field__description">%s</span>';
		const FIELD_GENERATOR_METHOD_PATTERN = 'generate_%s';

		/**
		 * @var Field_Generator
		 */
		protected $field_generator;

		/**
		 * Line_Generator constructor.
		 *
		 * @param Field_Generator $field_generator
		 */
		public function __construct( Field_Generator $field_generator ) {
			$this->field_generator = $field_generator;
		}

		/**
		 * @param array $field_config
		 *
		 * @return string
		 */
		public function generate( array $field_config ) {
			$content = $this->generate_label( $field_config );

			$field_config['attributes'] = $this->get_attribute_list_string( $field_config );

			$content .= $this->generate_field( $field_config );

			$content .= $this->generate_description( $field_config );

			return sprintf( self::HTML_CONTAINER_PATTERN, $content );
		}

		/**
		 * @param array $field_config
		 *
		 * @return string
		 */
		protected function generate_field( array $field_config ) {
			$field_method = sprintf( self::FIELD_GENERATOR_METHOD_PATTERN, $field_config['type'] );

			if ( ! method_exists( $this->field_generator, $field_method ) ) {
				$field_method = sprintf( self::FIELD_GENERATOR_METHOD_PATTERN, 'input' );
			}

			return $this->field_generator->$field_method( $field_config );
		}

		/**
		 * @param array $field_config
		 *
		 * @return string
		 */
		protected function get_attribute_list_string( array $field_config ) {
			if ( ! isset( $field_config['attributes'] ) ) {
				return '';
			}

			$attributes_list = array();
			foreach ( $field_config['attributes'] as $attr => $val ) {
				$attributes_list[] = sprintf( '%s="%s"', $attr, $val );
			}

			return implode( ' ', $attributes_list );
		}

		/**
		 * @param array $field_config
		 *
		 * @return string
		 */
		protected function generate_description( array $field_config ) {
			return isset( $field_config['description'] )
				? sprintf( self::HTML_DESCRIPTION_PATTERN, $field_config['description'] ) : '';
		}

		/**
		 * @param array $field_config
		 *
		 * @return string
		 */
		protected function generate_label( array $field_config ) {
			return isset( $field_config['label'] ) && ! empty( $field_config['label'] )
				? sprintf( self::HTML_LABEL_PATTERN, $field_config['id'], $field_config['label'] ) : '';
		}
	}
}