![](https://travis-ci.org/inboundnow/cta.svg?branch=master)

# WordPress Calls to Action #

**Contributors:** David Wells, Hudson Atwell  
**Donate link:** mailto:marketplace@inboundnow.com  
**License:** GPLv2 or later  
**License URI:** http://www.gnu.org/licenses/gpl-2.0.html  
**Tags:** Call to action, Calls to Action, CTA, inbound marketing, call outs, ad management, split testing, a b test, a b testing, a/b test, a/b testing, popups, email list, landing page, pop up, list building, inbound now, wp-call-to-actions, cpa, click tracking, ad placement, banner ads, slide in call outs, like to download, social media share buttons  
**Requires at least:** 3.8  
**Tested up to:** 4.1  
**Stable Tag:** 2.3.0  

Create Calls to Action for your WordPress site. Monitor and improve conversion rates, run A/B split tests, customize your own CTA templates and more.

## Description ##

> WordPress Calls to Action works as a standalone plugin or hand in hand with [WordPress Landing Pages](http://wordpress.org/plugins/landing-pages/ "Learn more about Landing Pages") & [WordPress Leads](http://wordpress.org/plugins/leads/ "Learn more about WordPress Leads") to create a powerful & free lead generation system for your business.

This plugin creates calls to action for your WordPress site. It gives site owners the ability to monitor and track conversion rates, run a/b or multivariate split tests on calls to action, and most importantly increase lead flow!

The calls to action plugin was specifically designed with inbound marketing best practices in mind and will help you drive & convert more leads on your site.

Calls to action are an ideal way to convert more of your passive website visitors into active leads or email list subscribers.

http://www.youtube.com/watch?v=-qaYgwV7p-8

### Highlights ###

* Create beautiful calls to action on your WordPress site.
* Visual Editor to view changes being made on the fly!
* Create Popups Calls to Actions for improved conversion rates
* Track conversion rates on your calls to action for continual optimization.
* Easily clone existing calls to action and run A/B Split tests on variations.
* Gather lead intelligence and track lead activity with <a href="http://wordpress.org/plugins/leads/screenshots/">WordPress Leads</a>
* Easily implement your own custom call to action design or use our library of custom call to action designs


### Developers & Designers ###

We built the calls to action plugin as a framework! Need A/B testing out of the box implemented for your existing designs? Use WordPress Calls to Action to quickly spin up new calls to action that have all the functionality your clients will need.

You can quickly take your existing designs and implement them using our <a href="http://docs.inboundnow.com/landing-pages/dev">templating framework</a>.

The plugin is also fully extendable and has a number of actions, filters, and hooks available for use. If a hook doesn't exist, simply ask and we can implement custom changes.


[Follow Development on GitHub ](https://github.com/inboundnow/cta "Follow & Contribute to core development on GitHub")
 |
[Follow Development on Twitter ](https://twitter.com/gitcta "See our latest development commits on Twitter")

## Installation ##

1. Upload `wp-call-to-actions` folder to the `/wp-content/plugins/` directory
1. Activate the plugin through the 'Plugins' menu in WordPress

## Frequently Asked Questions ##
*Can I create my own call to action designs?,
*Yes! You can learn how to <a href="http://plugins.inboundnow.com/docs/dev/creating-templates/">create your own call to action template here</a>.

## Screenshots ##

### 1. Convert more web traffic with calls to action to drive the visitor into a landing page or capture their email address right in the call to action ###
![Convert more web traffic with calls to action to drive the visitor into a landing page or capture their email address right in the call to action](screenshot-1.jpg)

### 2. Create Popup Calls to action and capture more emails ###
![Create Popup Calls to action and capture more emails](screenshot-2.jpg)

### 3. Easy to use templates ###
![Easy to use templates](screenshot-3.jpg)

### 4. Visual fronted editing to see live changes on the fly ###
![Visual fronted editing to see live changes on the fly](screenshot-4.jpg)

### 5. Choose from a ton of pre-made templates, use your existing design, or design your own call to action template. The system is a framework that allows for as many templates as you want. ###
![Choose from a ton of pre-made templates, use your existing design, or design your own call to action template. The system is a framework that allows for as many templates as you want.](screenshot-5.jpg)

### 6. Track conversion rates and continuously improve your marketing ###
![Track conversion rates and continuously improve your marketing](screenshot-6.jpg)

### 7. Easy placement within pages/posts/custom post types ###
![Easy placement within pages/posts/custom post types](screenshot-7.jpg)

### 8. Global placements via your sites sidebar ###
![Global placements via your sites sidebar](screenshot-8.jpg)


## Changelog ##
### 2.3.0 ###
* Conversion tracking bug fixed for CTAs

### 2.2.9 ###
* Conversion tracking bug fixed for CTAs
* Safari ajax bug fix

### 2.2.8 ###
* Even more security updates! Security for the win!

### 2.2.7 ###
* security update

### 2.2.6 ###
* Fix double lead notification email

### 2.2.5 ###
* Fixed double email submission on contact form 7

### 2.2.4 ###
* Added form field exclusions

### 2.2.2 ###
* See changelog here: https://github.com/inboundnow/cta/issues?q=is%3Aclosed+is%3Aissue+label%3Av2.2.2

### 2.2.1 ###
* Improved form email typo detection
* Improved Template Styles
* Improved frontend editor
* Fixed content wysiwyg scroll freezing bug

### 2.2.0 ###
* French - 100% Translated
* Converted code standards to CLASS based system.
* Better code documentation.
* New filter: inbound-email-post-params

### 2.1.4 ###
* "Translation 100% for Romanian." - FX Benard

### 2.1.3 ###
* Fix: Lead email notifications now working again.

### 2.1.2 ###
* Major code refactoring for improved developer experience.
* Added: Button to clear all cta stats at once
* Fix: Open cta links in new window


### 2.0.9 ###
* Bug Fix: Check all required fields

### 2.0.8 ###
* Bug Fix: Improvement to our custom ajax handler script module.ajax-get-variation.php


### 2.0.7 ###
* Fix to insert marketing shortcode popup

### 2.0.6 ###
* Updated & added language packs
* Added button to clear all landing page stats.
* Added 'do-not-track' class listener for disabling link tracking in CTAs.
* Converted serveral non class modules to class instances
* Added popups back to CTA display options.
* Optimized CTA Tracking JS.
* Bug Fix: Marketing Button
* Bug Fix: CTA Preview Mode

### 2.0.5 ###
* Bug Fix - Remove JS Alert

### 2.0.4 ###
* Temporary fix for shortcodes disappearing from wordpress 3.8 to 3.9
* Performance improvements on analytics and lead tracking

### 2.0.3 ###
* Added Variation ID Attribute to Shortcode
* Misc bug fixes

### 2.0.2 ###
* Misc bug fixes

### 2.0.1 ###
* Misc bug fixes
* Update bug on checkbox forms
* Adding better compatibility for JS errors

### 2.0.0 ###
* Faster Call to Action load times with inline CTAs
* Better A/B Testing functionality
* Mobile responsive Call to action templates
* A new & improved call to action templating engine
* All around code improvements and bug fixes

### 1.3.0 ###
* Updated Popup Functionality
* Updated CTA Editing Preview Screen
* Fixed missing height/width issues
* Added New HTML Lead Email Template with clickable links for faster lead management
* Added Button Shortcodes!
* Added HTML field option to form tool
* Added Divider Option to Form tool
* Added multi column support to icon list shortcode
* Added Font Awesome Icons option to Inbound Form Submit buttons
* Added Social Sharing Shortcode

### 1.2.5 ###
* Bug fix - missing trackingObj

### 1.2.4 ###
* Added feature request form to all plugin admin pages. Submit your feature requests today! =)

### 1.2.3 ###
* Bug fixes for form creation issues
* Bug fixes for safari page tracking not firing
* Added quick menu to WP admin bar for quicker marketing!

### 1.2.2 ###
* Updated: Styles for WordPress 3.8

### 1.2.0 ###

* Added: Added email confirmation support to Inbound Forms tool
* Added: Added additional popup call to action options
* Added: Added Slide out Call to Action option for calls to action to slide out from left or right side of screen
* Added: Fancy List and Column shortcodes

### 1.1.1 ###

* Added: Added InboundNow form creation and management system (beta)
* Added: Support for InboundNow cross plugin extensions
* Added: 'header' setting component to global settings.

Released

### 1.0.1 ###

Released
