"use strict";

/*************************************************************
CORE PLUGIN BACKEND SCRIPTS

CUSTOM META BOX (POST)
CUSTOM META BOX (PAGE)
CUSTOM META BOX (CPT_PEOPLE): SOCIAL LINKS CONTROL
CUSTOM META BOX (POST): FEATURE STYLE SELECT

*************************************************************/

/*************************************************************
CUSTOM META BOX (POST)
*************************************************************/

	jQuery(document).ready(function($) {

		//auto generate buttons
		if ($('.auto_generate').size() > 0) {

			$('.auto_generate').on('click', function () {
				var $this = $(this);
				var autoGeneratedContent =  $this.val();
				var tagName = $this.prev().prop('tagName');
				if (tagName == "INPUT") {
					$this.prev().val(autoGeneratedContent);
				} else if (tagName == "TEXTAREA") {
					$this.prev().text(autoGeneratedContent);
				}
			});
		}

		//post format specific options

		//init
		if ($('#post-formats-select').size() > 0) {

			var td_format = $('#post-formats-select input[checked="checked"]').val();
			$('.options_post_format[data-post_format="'+ td_format + '"]').show();

			//on change
			$('#post-formats-select input').on('change', function() {
				var $this=$(this);
				td_format = $this.val();
				$('.options_post_format').slideUp();
				$('.options_post_format[data-post_format="'+ td_format + '"]').slideDown();

			});

		}

	});

/*************************************************************
CUSTOM META BOX (PAGE)
*************************************************************/

	jQuery(document).ready(function($) {
		//template specific options init
		if ($('#page_template').size() > 0) {

			var selectValue = $('#page_template option[selected="selected"]').val();
			if (typeof selectValue != 'undefined') {
				selectValue = selectValue.split('.');
				$('.option_' + selectValue[0]).show();
			} else {
				$('.option_default').show();
			}

			//on change
			$('#page_template').on('change', function () {
				//first hide all
				$('.option_template_specific').hide();
				//then show relevant
				selectValue = $(this).val();
				selectValue = selectValue.split('.');
				$('.option_' + selectValue[0]).show();
			});

		}

		//options container toggle
		$('.option_heading').on('click', function(e) {
			var $this = $(this);
			$this.next('.option_content_container').slideToggle();
		})

	});


/*****************************************
CUSTOM META BOX (CPT_PEOPLE): SOCIAL LINKS CONTROL
*****************************************/

	jQuery(document).ready(function($) {
		if ($('.cmb_social_links').size() > 0) {

			$('.cmb_button_add_social_link').on('click', function(event) {
				var $this = $(this);
				var $socialLinks = $this.closest('.cmb_social_links_control').prev('.cmb_social_links');
				var $socialLinksRows = $this.closest('.cmb_social_links_control').prev('.cmb_social_links').find('.cmb_social_links_row');
				var numLinks = $socialLinksRows.size();
				var memberIndex = $this.closest('.option_page-team').find('.option_content_container').index($this.closest('.option_content_container'));

				$socialLinksRows.last().clone().appendTo($socialLinks);

				var $newRow = $this.closest('.cmb_social_links_control').prev('.cmb_social_links').find('.cmb_social_links_row').last();
				var newTitle = "Social link "+(numLinks+1);

				var newNameIcon = "cmb_social_links["+numLinks+"][icon]";
				var newNameLink = "cmb_social_links["+numLinks+"][link]";

				//update indexes
				$newRow.find('th').html(newTitle);
				$newRow.find('.cmb_social_links_icon').attr('name', newNameIcon);
				$newRow.find('.cmb_social_links_link').attr('name', newNameLink);
				$newRow.find('.cmb_social_links_link').attr('value', '');

			});

			$('.cmb_button_remove_social_link').on('click', function(event) {
				var $this = $(this);
				var $socialLinksRows =  $this.closest('.cmb_social_links_control').prev('.cmb_social_links').find('.cmb_social_links_row');
				var numLinks = $socialLinksRows.size();

				if (numLinks > 1) {
					$socialLinksRows.last().remove();	
				}
			});

		}


	});




/*****************************************
CUSTOM META BOX (POST): FEATURE STYLE SELECT
*****************************************/

	jQuery(document).ready(function($) {

		if ($('#cmb_feature').size() > 0) {

			//init
			updateFeatureStyle();

			//on change
			$('#cmb_feature').on('change', function(event) {
				updateFeatureStyle();	
			});


		}

		function updateFeatureStyle () {
			var $featureSelect = $('#cmb_feature');
			var $relatedInput = $featureSelect.closest('.option_item').next('.option_item');
			var $relatedInputLabel = $relatedInput.find('label');
			var featureSelectValue = $featureSelect.val();
			var helpMsg = "";

			if (featureSelectValue == "media") {
				$relatedInput.slideDown();
				helpMsg = "Featured media - <i>(use embed code e.g. &lt;iframe&gt;)</i>";
				$relatedInputLabel.html(helpMsg);

					
			} else if (featureSelectValue == "media_in_lightbox") {
				$relatedInput.slideDown();
				helpMsg = "Featured media - <i>(use standard media link e.g. http://vimeo.com/22428395 or player link http://player.vimeo.com/video/22428395)</i>";
				$relatedInputLabel.html(helpMsg);
					
			} else {
				$relatedInput.slideUp();
			}
		}

	});
