/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2017-01-18 10:44:19 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_jzkb_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_jzkb_frm_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_key` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` text COLLATE utf8mb4_unicode_ci,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `type` text COLLATE utf8mb4_unicode_ci,
  `default_value` longtext COLLATE utf8mb4_unicode_ci,
  `options` longtext COLLATE utf8mb4_unicode_ci,
  `field_order` int(11) DEFAULT '0',
  `required` int(1) DEFAULT NULL,
  `field_options` longtext COLLATE utf8mb4_unicode_ci,
  `form_id` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `field_key` (`field_key`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_frm_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_key` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `parent_form_id` int(11) DEFAULT '0',
  `logged_in` tinyint(1) DEFAULT NULL,
  `editable` tinyint(1) DEFAULT NULL,
  `is_template` tinyint(1) DEFAULT '0',
  `default_template` tinyint(1) DEFAULT '0',
  `status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `options` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_key` (`form_key`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_frm_item_metas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  `field_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `field_id` (`field_id`),
  KEY `item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_frm_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_key` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `ip` text COLLATE utf8mb4_unicode_ci,
  `form_id` int(11) DEFAULT NULL,
  `post_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `parent_item_id` int(11) DEFAULT '0',
  `is_draft` tinyint(1) DEFAULT '0',
  `updated_by` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_key` (`item_key`),
  KEY `form_id` (`form_id`),
  KEY `post_id` (`post_id`),
  KEY `user_id` (`user_id`),
  KEY `parent_item_id` (`parent_item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=134652 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_participants_database` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `private_id` varchar(9) COLLATE utf8_unicode_ci DEFAULT NULL,
  `first_name` tinytext COLLATE utf8_unicode_ci,
  `last_name` tinytext COLLATE utf8_unicode_ci,
  `address` tinytext COLLATE utf8_unicode_ci,
  `city` tinytext COLLATE utf8_unicode_ci,
  `state` tinytext COLLATE utf8_unicode_ci,
  `country` tinytext COLLATE utf8_unicode_ci,
  `zip` tinytext COLLATE utf8_unicode_ci,
  `phone` tinytext COLLATE utf8_unicode_ci,
  `email` tinytext COLLATE utf8_unicode_ci,
  `mailing_list` text COLLATE utf8_unicode_ci,
  `photo` text COLLATE utf8_unicode_ci,
  `website` text COLLATE utf8_unicode_ci,
  `interests` text COLLATE utf8_unicode_ci,
  `approved` text COLLATE utf8_unicode_ci,
  `date_recorded` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_updated` timestamp NULL DEFAULT NULL,
  `last_accessed` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_jzkb_participants_database_fields` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `order` int(3) NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `title` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `default` tinytext COLLATE utf8_unicode_ci,
  `group` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `help_text` text COLLATE utf8_unicode_ci,
  `form_element` tinytext COLLATE utf8_unicode_ci,
  `values` longtext COLLATE utf8_unicode_ci,
  `validation` tinytext COLLATE utf8_unicode_ci,
  `display_column` int(3) DEFAULT '0',
  `admin_column` int(3) DEFAULT '0',
  `sortable` tinyint(1) DEFAULT '0',
  `CSV` tinyint(1) DEFAULT '0',
  `persistent` tinyint(1) DEFAULT '0',
  `signup` tinyint(1) DEFAULT '0',
  `readonly` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `order` (`order`),
  KEY `group` (`group`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_jzkb_participants_database_groups` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `order` int(3) NOT NULL DEFAULT '0',
  `display` tinyint(1) DEFAULT '1',
  `admin` tinyint(1) NOT NULL DEFAULT '0',
  `title` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `wp_jzkb_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1535 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=3580 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=189 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jzkb_wpum_field_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `description` mediumtext NOT NULL,
  `group_order` bigint(20) NOT NULL DEFAULT '0',
  `can_delete` tinyint(1) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `can_delete` (`can_delete`),
  KEY `is_primary` (`is_primary`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_jzkb_wpum_fields` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) unsigned NOT NULL,
  `type` varchar(150) NOT NULL,
  `name` varchar(150) NOT NULL,
  `description` longtext NOT NULL,
  `field_order` bigint(20) NOT NULL DEFAULT '0',
  `is_required` tinyint(1) NOT NULL DEFAULT '0',
  `show_on_registration` tinyint(1) NOT NULL DEFAULT '0',
  `can_delete` tinyint(1) NOT NULL DEFAULT '1',
  `default_visibility` varchar(150) NOT NULL DEFAULT 'public',
  `allow_custom_visibility` varchar(150) NOT NULL DEFAULT 'disallowed',
  `options` longtext,
  `meta` longtext,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `field_order` (`field_order`),
  KEY `can_delete` (`can_delete`),
  KEY `is_required` (`is_required`),
  KEY `show_on_registration` (`show_on_registration`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: wp_jzkb_comments */
INSERT INTO `wp_jzkb_comments` VALUES("2", "157", "Erik Choi", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 16:15:58", "2015-09-23 16:15:58", "The other day, admiring the pictures taken during our recent trip to rural Malawi with my new DLSR camera, the honest simplicity of the locals\' existence got me thinking.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("3", "157", "Paul S. Smith", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 16:17:24", "2015-09-23 16:17:24", "I wondered the other day. Does anyone still have friends not using an iPhone 5?", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("4", "157", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 22:08:27", "2015-09-23 22:08:27", "Good to know that, cheers!", "0", "1", "", "", "2", "0");
INSERT INTO `wp_jzkb_comments` VALUES("5", "3245", "Betty A. Richeson", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 22:06:56", "2015-09-23 22:06:56", "One of my favorites! Excellent work!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("6", "3245", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 22:07:18", "2015-09-23 22:07:18", "Thank you for your quick feedback!", "0", "1", "", "", "5", "0");
INSERT INTO `wp_jzkb_comments` VALUES("7", "3246", "Frank T. Kroeger", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 14:15:44", "2015-09-23 14:15:44", "Layers, background, experience, shot – engaging dude", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("8", "3246", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 16:32:40", "2015-09-23 16:32:40", "Thank you, Frank.", "0", "1", "", "", "7", "0");
INSERT INTO `wp_jzkb_comments` VALUES("9", "3261", "Kenneth Watkins", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 21:38:40", "2015-09-23 21:38:40", "Another great design (as usual from you), good luck!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("10", "3261", "Andrea Jaques", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 21:39:49", "2015-09-23 21:39:49", "I knew you\'d come up with some amazing design Kevin! Each detail in the right place, perfect colours palette, such warm vibe...a winner in my books! Awesome job!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("11", "3261", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 21:41:52", "2015-09-23 21:41:52", "Thank you for your kind words!", "0", "1", "", "", "9", "0");
INSERT INTO `wp_jzkb_comments` VALUES("12", "3261", "Andrea L. Jaques", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 21:42:23", "2015-09-23 21:42:23", "Thank you Andrea for your support, I do appreciate it!", "0", "1", "", "", "10", "0");
INSERT INTO `wp_jzkb_comments` VALUES("13", "3262", "Jimmie Orr", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 21:58:18", "2015-09-23 21:58:18", "The moment I saw this design I recognized your style and thought of your last yours design...may I say this one surpassed the last one...this is just simply brilliant.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("14", "3262", "Patrick McMahon", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 22:00:04", "2015-09-23 22:00:04", "Oh well, this is absolutely stunning! Love the cover image", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("15", "3262", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 22:01:01", "2015-09-23 22:01:01", "Hey! Thank you so much.", "0", "1", "", "", "13", "0");
INSERT INTO `wp_jzkb_comments` VALUES("16", "3263", "Jessica R. Bloomberg", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 14:17:40", "2015-09-23 14:17:40", "I wonder what would have happened if I made this", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("17", "3263", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 22:02:41", "2015-09-23 22:02:41", "Thank you for your feedback!", "0", "1", "", "", "16", "0");
INSERT INTO `wp_jzkb_comments` VALUES("18", "3264", "Anthony L. Walker", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 16:26:50", "2015-09-23 16:26:50", "Mission accomplished. It\'s strong, my friend!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("19", "3264", "Roy P. Smith", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 16:27:34", "2015-09-23 16:27:34", "Looks neat and gorgeous", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("20", "3264", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 16:31:09", "2015-09-23 16:31:09", "Thank you, Roy!", "0", "1", "", "", "19", "0");
INSERT INTO `wp_jzkb_comments` VALUES("21", "180", "Jeffrey Maynard", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 13:57:56", "2015-09-23 13:57:56", "Magical dude Love the use of playfulness and avatar!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("22", "180", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 13:59:04", "2015-09-23 13:59:04", "Thanks for your nice words, Jeffrey.", "0", "1", "", "", "21", "0");
INSERT INTO `wp_jzkb_comments` VALUES("23", "182", "Irene J. Cave", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 14:48:49", "2015-09-23 14:48:49", "Nice use of grey in this style =)", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("24", "182", "Leona Turner", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 15:59:04", "2015-09-23 15:59:04", "Great project, thanks for sharing with us.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("25", "182", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 16:00:04", "2015-09-23 16:00:04", "Thank you for your support, dear Irene!", "0", "1", "", "", "23", "0");
INSERT INTO `wp_jzkb_comments` VALUES("26", "183", "Lila Garcia", "Garcia@gmail.com", "", "79.112.8.241", "2015-09-22 21:52:28", "2015-09-22 21:52:28", "Life is full of temporary situations, ultimately ending in a permanent solution.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("27", "183", "Daryl Jones", "Daryl@gmail.com", "", "79.112.8.241", "2015-09-22 21:54:38", "2015-09-22 21:54:38", "Sometimes I wonder if I really can. But then I think to myself, maybe I can\'t. But if I could, that would be good. Maybe it\'s all a lie?", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("28", "183", "MAI BENSON", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 13:42:09", "2015-09-23 13:42:09", "It’s fun not just engaging!", "0", "1", "", "", "26", "0");
INSERT INTO `wp_jzkb_comments` VALUES("29", "184", "Helen Brady", "Helen@gmail.com", "", "79.112.8.241", "2015-09-22 21:46:05", "2015-09-22 21:46:05", "If I could I would. Wether or not I should, I still would.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("30", "184", "claudiu", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 21:32:46", "2015-09-23 21:32:46", "Very well structured, nice minimalist style and a superb colour scheme. Great job!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("31", "186", "Erskine Kuno", "Kuno@gmail.com", "", "79.112.8.241", "2015-09-22 21:44:05", "2015-09-22 21:44:05", "I see you have something to talk about. Well, I have something to shout about. Infact something to sing about. But I\'ll just keep quiet and let you carry on.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("32", "186", "Juan Greene", "Juan@gmail.com", "", "79.112.8.241", "2015-09-22 21:45:02", "2015-09-22 21:45:02", "If you really wanted to do that, then why wouldn\'t you do that? Instead you do this. It makes no sense.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("33", "187", "Waldo Eckbert", "claudiu.pantiru21@gmail.com", "", "79.112.8.241", "2015-09-22 22:09:52", "2015-09-22 22:09:52", "Really thought out! I\'d love to see a video of how it works.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("34", "187", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 13:19:33", "2015-09-23 13:19:33", "Hi there, Waldo, actually we\'re working right now on it, stay tuned!", "0", "1", "", "", "33", "0");
INSERT INTO `wp_jzkb_comments` VALUES("35", "187", "John Hodge", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 13:20:37", "2015-09-23 13:20:37", "This is exquisite and appealing mate.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("36", "188", "Fredrick Peregrine", "Fredrick@gmail.com", "", "79.112.8.241", "2015-09-22 21:34:05", "2015-09-22 21:34:05", "Engaging. It keeps your mind occupied while you wait.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("37", "188", "Timmy Roberts", "Timmy@gmail.com", "", "79.112.8.241", "2015-09-22 21:35:25", "2015-09-22 21:35:25", "Congrats on the new adventure!!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("38", "188", "Kayla Briggs", "Kayla@gmail.com", "", "79.112.8.241", "2015-09-22 21:40:45", "2015-09-22 21:40:45", "Cornflower blue. I think clients would love this.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("39", "188", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 13:03:34", "2015-09-23 13:03:34", "Many thanks, dear Timmy", "0", "1", "", "", "37", "0");
INSERT INTO `wp_jzkb_comments` VALUES("40", "188", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 13:04:00", "2015-09-23 13:04:00", "I\'m sure they will, Kayla.", "0", "1", "", "", "38", "0");
INSERT INTO `wp_jzkb_comments` VALUES("41", "189", "Kay Gregor", "Gregor@gmail.com", "", "79.112.8.241", "2015-09-22 21:25:14", "2015-09-22 21:25:14", "Neat dude, I adore the use of background and lines!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("42", "189", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.98.30", "2015-09-23 13:02:17", "2015-09-23 13:02:17", "Thank you, Kay!", "0", "1", "", "", "41", "0");
INSERT INTO `wp_jzkb_comments` VALUES("43", "190", "Nicolaos Ángel", "Nicolaos@gmail.com", "", "79.112.8.241", "2015-09-22 21:18:40", "2015-09-22 21:18:40", "One conversation dominated the interval chit-chat at my most recent visit to the Globe Theatre. How can we expect the next generation to get their five-a-day when even Waitrose don\'t sell traditional British apple varieties? ", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("44", "190", "Roberto Reed", "Roberto@gmail.com", "", "79.112.8.241", "2015-09-22 21:21:53", "2015-09-22 21:21:53", "Mission accomplished. It\'s fresh dude!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("45", "190", "Hector Howell", "Hector@gmail.com", "", "79.112.8.241", "2015-09-22 21:49:23", "2015-09-22 21:49:23", "Minimal! I love the use of layers and navigation!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_jzkb_comments` VALUES("46", "190", "Misi Dyson", "claudiu.pantiru21@gmail.com", "", "79.112.8.241", "2015-09-22 22:12:15", "2015-09-22 22:12:15", "Leading the way mate.", "0", "1", "", "", "43", "0");
INSERT INTO `wp_jzkb_comments` VALUES("47", "190", "Kevin", "claudiu.pantiru21@gmail.com", "", "79.112.8.241", "2015-09-22 22:14:52", "2015-09-22 22:14:52", "Thank you, dear Hector, I\'m glad you like it!", "0", "1", "", "", "45", "0");

/* INSERT TABLE DATA: wp_jzkb_duplicator_packages */
INSERT INTO `wp_jzkb_duplicator_packages` VALUES("1", "20170118_dgtalmind", "587f46893c8fd7603170118104217", "20", "2017-01-18 10:44:19", "anthony@dgtalmind.com", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-01-18 10:42:17\";s:7:\"Version\";s:6:\"1.1.26\";s:9:\"VersionWP\";s:5:\"4.7.1\";s:9:\"VersionDB\";s:6:\"5.6.32\";s:10:\"VersionPHP\";s:6:\"5.4.43\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:18:\"20170118_dgtalmind\";s:4:\"Hash\";s:29:\"587f46893c8fd7603170118104217\";s:8:\"NameHash\";s:48:\"20170118_dgtalmind_587f46893c8fd7603170118104217\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:44:\"/home1/dgtalmin/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://www.dgtal-mind.com/wp-snapshots/\";s:8:\"ScanFile\";s:58:\"20170118_dgtalmind_587f46893c8fd7603170118104217_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:21:\"anthony@dgtalmind.com\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:60:\"20170118_dgtalmind_587f46893c8fd7603170118104217_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:27:\"/home1/dgtalmin/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-01-18 10:42:17\";s:7:\"Version\";s:6:\"1.1.26\";s:9:\"VersionWP\";s:5:\"4.7.1\";s:9:\"VersionDB\";s:6:\"5.6.32\";s:10:\"VersionPHP\";s:6:\"5.4.43\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20170118_dgtalmind\";s:4:\"Hash\";s:29:\"587f46893c8fd7603170118104217\";s:8:\"NameHash\";s:48:\"20170118_dgtalmind_587f46893c8fd7603170118104217\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:44:\"/home1/dgtalmin/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://www.dgtal-mind.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:62:\"20170118_dgtalmind_587f46893c8fd7603170118104217_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:61:\"20170118_dgtalmind_587f46893c8fd7603170118104217_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: wp_jzkb_frm_fields */
INSERT INTO `wp_jzkb_frm_fields` VALUES("1", "qh4icy", "Name", "First", "text", NULL, NULL, "1", "1", "a:4:{s:5:\"blank\";s:0:\"\";s:14:\"separate_value\";i:0;s:7:\"classes\";s:18:\"frm_first frm_half\";s:10:\"in_section\";i:0;}", "1", "2016-02-11 11:35:06");
INSERT INTO `wp_jzkb_frm_fields` VALUES("2", "ocfup1", "Last", "Last", "text", NULL, NULL, "2", "1", "a:4:{s:5:\"label\";s:6:\"hidden\";s:5:\"blank\";s:0:\"\";s:7:\"classes\";s:8:\"frm_half\";s:10:\"in_section\";i:0;}", "1", "2016-02-11 11:35:06");
INSERT INTO `wp_jzkb_frm_fields` VALUES("3", "29yf4d", "Email", "", "email", NULL, NULL, "3", "1", "a:4:{s:5:\"blank\";s:0:\"\";s:7:\"invalid\";s:34:\"Please enter a valid email address\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "1", "2016-02-11 11:35:06");
INSERT INTO `wp_jzkb_frm_fields` VALUES("4", "itt5me", "Website", "", "url", NULL, NULL, "4", "0", "a:4:{s:5:\"blank\";s:0:\"\";s:7:\"invalid\";s:28:\"Please enter a valid website\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "1", "2016-02-11 11:35:06");
INSERT INTO `wp_jzkb_frm_fields` VALUES("5", "e6lis6", "Subject", "", "text", NULL, NULL, "5", "1", "a:3:{s:5:\"blank\";s:0:\"\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "1", "2016-02-11 11:35:06");
INSERT INTO `wp_jzkb_frm_fields` VALUES("6", "9jv0r1", "Message", "", "textarea", NULL, NULL, "6", "1", "a:4:{s:3:\"max\";s:1:\"5\";s:5:\"blank\";s:0:\"\";s:7:\"classes\";s:8:\"frm_full\";s:10:\"in_section\";i:0;}", "1", "2016-02-11 11:35:06");
INSERT INTO `wp_jzkb_frm_fields` VALUES("7", "62n6q3", "Captcha", "", "captcha", NULL, NULL, "7", "0", "a:5:{s:5:\"label\";s:4:\"none\";s:5:\"blank\";s:0:\"\";s:14:\"clear_on_focus\";i:0;s:13:\"default_blank\";i:0;s:10:\"in_section\";i:0;}", "1", "2016-02-11 11:35:06");

/* INSERT TABLE DATA: wp_jzkb_frm_forms */
INSERT INTO `wp_jzkb_frm_forms` VALUES("1", "contact", "Contact Us", "We would like to hear from you. Please send us a message by filling out the form below and we will get back with you shortly.", "0", "0", "0", "1", "1", "published", "a:12:{s:12:\"custom_style\";i:1;s:12:\"submit_value\";s:6:\"Submit\";s:14:\"success_action\";s:7:\"message\";s:11:\"success_msg\";s:54:\"Your responses were successfully submitted. Thank you!\";s:9:\"show_form\";i:0;s:7:\"akismet\";s:0:\"\";s:7:\"no_save\";i:0;s:9:\"ajax_load\";i:0;s:10:\"form_class\";s:0:\"\";s:11:\"before_html\";s:217:\"<legend class=\"frm_hidden\">[form_name]</legend>\n[if form_name]<h3 class=\"frm_form_title\">[form_name]</h3>[/if form_name]\n[if form_description]<div class=\"frm_description\">[form_description]</div>[/if form_description]\";s:10:\"after_html\";s:0:\"\";s:11:\"submit_html\";s:440:\"<div class=\"frm_submit\">\n[if back_button]<input type=\"button\" value=\"[back_label]\" name=\"frm_prev_page\" formnovalidate=\"formnovalidate\" class=\"frm_prev_page\" [back_hook] />[/if back_button]\n<input type=\"submit\" value=\"[button_label]\" [button_action] />\n<img class=\"frm_ajax_loading\" src=\"[frmurl]/images/ajax_loader.gif\" alt=\"Sending\"/>\n[if save_draft]<a href=\"#\" class=\"frm_save_draft\" [draft_hook]>[draft_label]</a>[/if save_draft]\n</div>\";}", "2009-11-24 00:17:31");

/* INSERT TABLE DATA: wp_jzkb_options */
INSERT INTO `wp_jzkb_options` VALUES("1", "siteurl", "http://www.dgtal-mind.com/", "yes");
INSERT INTO `wp_jzkb_options` VALUES("2", "home", "http://www.dgtal-mind.com", "yes");
INSERT INTO `wp_jzkb_options` VALUES("3", "blogname", "DGtal-Mind", "yes");
INSERT INTO `wp_jzkb_options` VALUES("4", "blogdescription", "...designing experience!", "yes");
INSERT INTO `wp_jzkb_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("6", "admin_email", "hello@dgtal-mind.com", "yes");
INSERT INTO `wp_jzkb_options` VALUES("7", "start_of_week", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("10", "require_name_email", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("12", "posts_per_rss", "12", "yes");
INSERT INTO `wp_jzkb_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_jzkb_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_jzkb_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_jzkb_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_jzkb_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("19", "default_comment_status", "closed", "yes");
INSERT INTO `wp_jzkb_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_jzkb_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("22", "posts_per_page", "12", "yes");
INSERT INTO `wp_jzkb_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_jzkb_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_jzkb_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_jzkb_options` VALUES("26", "comment_moderation", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_jzkb_options` VALUES("29", "hack_file", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("30", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_jzkb_options` VALUES("31", "moderation_keys", "", "no");
INSERT INTO `wp_jzkb_options` VALUES("32", "active_plugins", "a:14:{i:0;s:19:\"akismet/akismet.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:67:\"favicon-by-realfavicongenerator/favicon-by-realfavicongenerator.php\";i:4;s:25:\"formidable/formidable.php\";i:5;s:9:\"hello.php\";i:6;s:19:\"jetpack/jetpack.php\";i:7;s:47:\"mojo-marketplace-wp-plugin/mojo-marketplace.php\";i:8;s:47:\"participants-database/participants-database.php\";i:9;s:21:\"pixcodes/pixcodes.php\";i:10;s:41:\"wordpress-importer/wordpress-importer.php\";i:11;s:35:\"wp-user-manager/wp-user-manager.php\";i:12;s:33:\"wpum-recaptcha/wpum-recaptcha.php\";i:13;s:49:\"wpum-user-verification/wpum-user-verification.php\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("33", "category_base", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("34", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_jzkb_options` VALUES("35", "comment_max_links", "2", "yes");
INSERT INTO `wp_jzkb_options` VALUES("36", "gmt_offset", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("37", "default_email_category", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("38", "recently_edited", "a:5:{i:0;s:62:\"/home1/dgtalmin/public_html/wp-content/themes/arkfield/rtl.css\";i:1;s:64:\"/home1/dgtalmin/public_html/wp-content/themes/arkfield/style.css\";i:2;s:94:\"/home1/dgtalmin/public_html/wp-content/plugins/participants-database/participants-database.php\";i:3;s:66:\"/home1/dgtalmin/public_html/wp-content/plugins/akismet/akismet.php\";i:4;s:0:\"\";}", "no");
INSERT INTO `wp_jzkb_options` VALUES("39", "template", "arkfield", "yes");
INSERT INTO `wp_jzkb_options` VALUES("40", "stylesheet", "arkfield", "yes");
INSERT INTO `wp_jzkb_options` VALUES("41", "comment_whitelist", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("42", "blacklist_keys", "", "no");
INSERT INTO `wp_jzkb_options` VALUES("43", "comment_registration", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("44", "html_type", "text/html", "yes");
INSERT INTO `wp_jzkb_options` VALUES("45", "use_trackback", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("46", "default_role", "subscriber", "yes");
INSERT INTO `wp_jzkb_options` VALUES("47", "db_version", "38590", "yes");
INSERT INTO `wp_jzkb_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("49", "upload_path", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("50", "blog_public", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("51", "default_link_category", "2", "yes");
INSERT INTO `wp_jzkb_options` VALUES("52", "show_on_front", "page", "yes");
INSERT INTO `wp_jzkb_options` VALUES("53", "tag_base", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("54", "show_avatars", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("55", "avatar_rating", "G", "yes");
INSERT INTO `wp_jzkb_options` VALUES("56", "upload_url_path", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("57", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_jzkb_options` VALUES("58", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_jzkb_options` VALUES("59", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("60", "medium_size_w", "300", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61", "medium_size_h", "300", "yes");
INSERT INTO `wp_jzkb_options` VALUES("62", "avatar_default", "mystery", "yes");
INSERT INTO `wp_jzkb_options` VALUES("63", "large_size_w", "1920", "yes");
INSERT INTO `wp_jzkb_options` VALUES("64", "large_size_h", "1280", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65", "image_default_link_type", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("66", "image_default_size", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("67", "image_default_align", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("68", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("69", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_jzkb_options` VALUES("70", "thread_comments", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("71", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_jzkb_options` VALUES("72", "page_comments", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("73", "comments_per_page", "50", "yes");
INSERT INTO `wp_jzkb_options` VALUES("74", "default_comments_page", "newest", "yes");
INSERT INTO `wp_jzkb_options` VALUES("75", "comment_order", "asc", "yes");
INSERT INTO `wp_jzkb_options` VALUES("76", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("77", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("78", "widget_text", "a:3:{i:1;a:0:{}i:3;a:3:{s:5:\"title\";s:17:\"Let\'s talk soon..\";s:4:\"text\";s:711:\"<b>Contact Address: </b>\r\n28 Carville Cresent, Brentford, TW8 9RD<p>\r\n\r\n<b>Registered Address: </b>\r\nBrunel House, 340 Firecrest Court, Centre Park, Warrington, WA1 1RG<p>\r\n<b>Registered in England:</b> No. 9857717<p>\r\n<b>VAT Registration Number:</b> 229 3363 04<p>\r\n\r\n<b>E: </b><a style=\"display: inline\" href=\"mailto:hello@dgtal-mind.com\"target=\"_blank\">hello@dgtal-mind.com</a><p>\r\n<b>T: </b>+44 203 302 2397 \r\n\r\n<b>M: </b>+44 705 118 6728<p>\r\n\r\n<a href=\"#\" onclick=\"window.open(\'https://www.sitelock.com/verify.php?site=dgtal-mind.com\',\'SiteLock\',\'width=600,height=600,left=160,top=170\');\" ><img class=\"img-responsive\" alt=\"SiteLock\" title=\"SiteLock\" src=\"//shield.sitelock.com/shield/dgtal-mind.com\" /></a>\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("80", "uninstall_plugins", "a:1:{s:47:\"participants-database/participants-database.php\";a:2:{i:0;s:8:\"PDb_Init\";i:1;s:12:\"on_uninstall\";}}", "no");
INSERT INTO `wp_jzkb_options` VALUES("81", "timezone_string", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("82", "page_for_posts", "89", "yes");
INSERT INTO `wp_jzkb_options` VALUES("83", "page_on_front", "2650", "yes");
INSERT INTO `wp_jzkb_options` VALUES("84", "default_post_format", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("85", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("86", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("87", "site_icon", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("88", "medium_large_size_w", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("89", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("90", "initial_db_version", "35700", "yes");
INSERT INTO `wp_jzkb_options` VALUES("91", "wp_jzkb_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:67:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:14:\"frm_view_forms\";b:1;s:14:\"frm_edit_forms\";b:1;s:16:\"frm_delete_forms\";b:1;s:19:\"frm_change_settings\";b:1;s:16:\"frm_view_entries\";b:1;s:18:\"frm_delete_entries\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("92", "frm_aff", "mojo", "yes");
INSERT INTO `wp_jzkb_options` VALUES("93", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("94", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("95", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("96", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("97", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("98", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:27:\"arkfield_footer_widget_area\";a:3:{i:0;s:6:\"text-3\";i:1;s:18:\"facebook-likebox-2\";i:2;s:18:\"twitter_timeline-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("99", "jetpack_activated", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("100", "cron", "a:16:{i:1484736428;a:2:{s:17:\"jetpack_sync_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"jetpack_sync_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}s:22:\"jetpack_sync_full_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"jetpack_sync_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1484736499;a:1:{s:40:\"jetpack_display_posts_widget_cron_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"minutes_10\";s:4:\"args\";a:0:{}s:8:\"interval\";i:600;}}}i:1484737699;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1484739259;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1484739261;a:3:{s:13:\"mm_cron_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"mm_cron_twicedaily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:14:\"mm_cron_hourly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1484739305;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484748504;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484748563;a:1:{s:24:\"jp_purge_transients_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484748568;a:1:{s:24:\"grunion_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484751703;a:1:{s:31:\"wpumuv_check_non_verified_users\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484753953;a:1:{s:23:\"fbrfg_check_for_updates\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484755241;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484776242;a:1:{s:29:\"wp_session_garbage_collection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1484825661;a:1:{s:14:\"mm_cron_weekly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1486640061;a:1:{s:15:\"mm_cron_monthly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2419200;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("101", "jetpack_options", "a:12:{s:7:\"version\";s:14:\"4.5:1484696528\";s:11:\"old_version\";s:16:\"4.0.3:1464305968\";s:28:\"fallback_no_verify_ssl_certs\";i:0;s:9:\"time_diff\";i:0;s:2:\"id\";i:106814531;s:6:\"public\";i:0;s:9:\"jumpstart\";s:19:\"jumpstart_activated\";s:11:\"master_user\";i:1;s:14:\"last_heartbeat\";i:1484662337;s:20:\"sync_bulk_reindexing\";b:1;s:21:\"publicize_connections\";a:4:{s:8:\"facebook\";a:1:{i:13895278;a:9:{s:7:\"user_id\";i:1;s:8:\"provider\";s:21:\"facebook:249643311490\";s:6:\"issued\";s:19:\"2016-03-03 20:44:20\";s:7:\"expires\";s:19:\"2016-05-02 20:44:20\";s:11:\"external_id\";s:15:\"135181623539214\";s:13:\"external_name\";s:0:\"\";s:16:\"external_display\";s:14:\"Anthony Kolade\";s:4:\"type\";s:6:\"access\";s:15:\"connection_data\";a:5:{s:2:\"id\";s:8:\"13895278\";s:8:\"token_id\";s:8:\"13824957\";s:7:\"blog_id\";s:9:\"106814531\";s:7:\"user_id\";i:1;s:4:\"meta\";a:5:{s:16:\"external_user_id\";i:1;s:13:\"facebook_page\";i:1690487024555938;s:14:\"follower_count\";i:1;s:4:\"link\";s:35:\"https://www.facebook.com/DGtalMind/\";s:12:\"display_name\";s:18:\"DGtal-Mind Limited\";}}}}s:7:\"twitter\";a:1:{i:13895292;a:9:{s:7:\"user_id\";i:1;s:8:\"provider\";s:13:\"twitter:38869\";s:6:\"issued\";s:19:\"2016-03-03 20:45:30\";s:7:\"expires\";s:19:\"0000-00-00 00:00:00\";s:11:\"external_id\";s:10:\"1259482706\";s:13:\"external_name\";s:13:\"Anthoy_Kolade\";s:16:\"external_display\";s:14:\"@Anthoy_Kolade\";s:4:\"type\";s:6:\"access\";s:15:\"connection_data\";a:5:{s:2:\"id\";s:8:\"13895292\";s:8:\"token_id\";s:8:\"13824967\";s:7:\"blog_id\";s:9:\"106814531\";s:7:\"user_id\";i:1;s:4:\"meta\";a:1:{s:16:\"external_user_id\";i:1;}}}}s:8:\"linkedin\";a:1:{i:13895306;a:9:{s:7:\"user_id\";i:1;s:8:\"provider\";s:15:\"linkedin:131428\";s:6:\"issued\";s:19:\"2016-03-03 20:46:48\";s:7:\"expires\";s:19:\"2016-05-02 20:46:47\";s:11:\"external_id\";s:10:\"bhPihqs6En\";s:13:\"external_name\";s:0:\"\";s:16:\"external_display\";s:14:\"Anthony Kolade\";s:4:\"type\";s:6:\"access\";s:15:\"connection_data\";a:5:{s:2:\"id\";s:8:\"13895306\";s:8:\"token_id\";s:8:\"13824982\";s:7:\"blog_id\";s:9:\"106814531\";s:7:\"user_id\";i:1;s:4:\"meta\";a:2:{s:16:\"external_user_id\";i:1;s:11:\"profile_url\";s:134:\"https://www.linkedin.com/profile/view?id=AAoAAAvSgoMBvY2XdPV6J2ntUiukQrwmbcwNOmw&authType=name&authToken=nzY-&trk=api*a131428*s139819*\";}}}}s:11:\"google_plus\";a:1:{i:13895317;a:9:{s:7:\"user_id\";i:1;s:8:\"provider\";s:20:\"google_plus:20130624\";s:6:\"issued\";s:19:\"2016-03-03 20:47:57\";s:7:\"expires\";s:19:\"0000-00-00 00:00:00\";s:11:\"external_id\";s:21:\"104300077990840314084\";s:13:\"external_name\";s:0:\"\";s:16:\"external_display\";s:0:\"\";s:4:\"type\";s:6:\"access\";s:15:\"connection_data\";a:5:{s:2:\"id\";s:8:\"13895317\";s:8:\"token_id\";s:8:\"13824991\";s:7:\"blog_id\";s:9:\"106814531\";s:7:\"user_id\";i:1;s:4:\"meta\";a:1:{s:16:\"external_user_id\";i:1;}}}}}s:24:\"custom_css_4.7_migration\";b:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("66172", "carousel_display_geo", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("103", "jetpack_available_modules", "a:1:{s:3:\"4.5\";a:38:{s:18:\"after-the-deadline\";s:3:\"1.1\";s:8:\"carousel\";s:3:\"1.5\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:20:\"custom-content-types\";s:3:\"3.1\";s:10:\"custom-css\";s:3:\"1.7\";s:21:\"enhanced-distribution\";s:3:\"1.2\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:6:\"manage\";s:3:\"3.4\";s:8:\"markdown\";s:3:\"2.8\";s:9:\"minileven\";s:3:\"1.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"omnisearch\";s:3:\"2.3\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:9:\"seo-tools\";s:3:\"4.4\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";s:7:\"wordads\";s:5:\"4.5.0\";}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("104", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("105", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("106", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("107", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("108", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("109", "widget_frm_show_form", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("111", "frm_options", "O:11:\"FrmSettings\":22:{s:11:\"option_name\";s:11:\"frm_options\";s:4:\"menu\";N;s:7:\"mu_menu\";N;s:15:\"preview_page_id\";N;s:8:\"use_html\";N;s:10:\"jquery_css\";N;s:12:\"accordion_js\";N;s:11:\"success_msg\";N;s:9:\"blank_msg\";N;s:10:\"unique_msg\";N;s:11:\"invalid_msg\";N;s:10:\"failed_msg\";N;s:12:\"submit_value\";N;s:9:\"login_msg\";N;s:16:\"admin_permission\";N;s:8:\"email_to\";N;s:10:\"load_style\";N;s:12:\"custom_style\";N;s:6:\"pubkey\";N;s:7:\"privkey\";N;s:7:\"re_lang\";N;s:6:\"re_msg\";N;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("112", "_transient_frm_options", "O:11:\"FrmSettings\":22:{s:11:\"option_name\";s:11:\"frm_options\";s:4:\"menu\";N;s:7:\"mu_menu\";N;s:15:\"preview_page_id\";N;s:8:\"use_html\";N;s:10:\"jquery_css\";N;s:12:\"accordion_js\";N;s:11:\"success_msg\";N;s:9:\"blank_msg\";N;s:10:\"unique_msg\";N;s:11:\"invalid_msg\";N;s:10:\"failed_msg\";N;s:12:\"submit_value\";N;s:9:\"login_msg\";N;s:16:\"admin_permission\";N;s:8:\"email_to\";N;s:10:\"load_style\";N;s:12:\"custom_style\";N;s:6:\"pubkey\";N;s:7:\"privkey\";N;s:7:\"re_lang\";N;s:6:\"re_msg\";N;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("113", "mm_install_date", "Feb 11, 2016", "yes");
INSERT INTO `wp_jzkb_options` VALUES("114", "mm_cron", "a:4:{s:6:\"hourly\";a:0:{}s:5:\"daily\";a:1:{s:14:\"plugin_version\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:14:\"plugin_version\";s:2:\"el\";s:5:\"1.0.1\";}}s:7:\"monthly\";a:4:{s:11:\"php_version\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:11:\"php_version\";s:2:\"el\";s:6:\"5.4.43\";}s:12:\"plugin_count\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:12:\"plugin_count\";s:2:\"el\";i:13;}s:11:\"theme_count\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:11:\"theme_count\";s:2:\"el\";i:5;}s:13:\"current_theme\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:13:\"current_theme\";s:2:\"el\";s:8:\"arkfield\";}}s:6:\"weekly\";a:1:{s:10:\"wp_version\";a:4:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:9:\"scheduled\";s:2:\"ea\";s:10:\"wp_version\";s:2:\"el\";s:5:\"4.7.1\";}}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("115", "mm_coming_soon", "false", "yes");
INSERT INTO `wp_jzkb_options` VALUES("118", "jetpack_security_report", "a:0:{}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("129", "frm_last_style_update", "1021651", "yes");
INSERT INTO `wp_jzkb_options` VALUES("292", "theme_mods_twentysixteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1456327399;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("125", "allow_major_auto_core_updates", "true", "yes");
INSERT INTO `wp_jzkb_options` VALUES("130", "frmpro_css", "/* WARNING: Any changes made to this file will be lost when your Formidable settings are updated */\n.frm_hidden,.with_frm_style .frm_button.frm_hidden{display:none;}.with_frm_style fieldset{min-width:0;}legend.frm_hidden{display:none !important;}.frm_transparent{color:transparent;}.input[type=file].frm_transparent:focus, .with_frm_style input[type=file]{background-color:transparent;border:none;outline:none;box-shadow:none;}.with_frm_style input[type=file]{display:initial;}.frm_preview_page:before{content:normal !important;}.frm_preview_page{padding:25px;}.with_frm_style .form-field.frm_col_field{clear:none;float:left;margin-right:20px;}.with_frm_style label.frm_primary_label{max-width:100%;}.with_frm_style .frm_top_container label.frm_primary_label,.with_frm_style .frm_hidden_container label.frm_primary_label,.with_frm_style .frm_pos_top{display:block;float:none;width:auto;}.with_frm_style .frm_inline_container label.frm_primary_label{margin-right:10px;}.with_frm_style .frm_right_container label.frm_primary_label,.with_frm_style .frm_pos_right{display:inline;float:right;margin-left:10px;}.with_frm_style .frm_none_container label.frm_primary_label,.with_frm_style .frm_pos_none,.frm_none_container label.frm_primary_label{display:none;}.with_frm_style .frm_section_heading.frm_hide_section{margin-top:0 !important;}.with_frm_style .frm_hidden_container label.frm_primary_label,.with_frm_style .frm_pos_hidden,.frm_hidden_container label.frm_primary_label{visibility:hidden;}.with_frm_style .frm_description{clear:both;}.with_frm_style .frm_scale{margin-right:10px;text-align:center;float:left;}.with_frm_style .frm_scale input{display:block;}.with_frm_style select[multiple=\"multiple\"]{height:auto;line-height:normal;}.with_frm_style select{white-space:nowrap;}.with_frm_style .frm_catlevel_2,.with_frm_style .frm_catlevel_3,.with_frm_style .frm_catlevel_4,.with_frm_style .frm_catlevel_5{margin-left:18px;}.with_frm_style .wp-editor-container{border:1px solid #e5e5e5;}.with_frm_style .quicktags-toolbar input{font-size:12px !important;}.with_frm_style .wp-editor-container textarea{border:none;}.with_frm_style .auto_width #loginform input,.with_frm_style .auto_width input,.with_frm_style input.auto_width,.with_frm_style select.auto_width,.with_frm_style textarea.auto_width{width:auto;}.with_frm_style .frm_repeat_buttons{white-space:nowrap;}.with_frm_style .frm_button{text-decoration:none;border:1px solid #eee;padding:5px;display:inline;}.with_frm_style .frm_submit{clear:both;}.frm_inline_form .frm_form_field.form-field{margin-right:2.5%;display:inline-block;}.frm_inline_form .frm_submit{display:inline-block;}.with_frm_style.frm_center_submit .frm_submit{text-align:center;}.with_frm_style.frm_center_submit .frm_submit input[type=submit],.with_frm_style.frm_center_submit .frm_submit input[type=button]{margin-bottom:8px !important;}.with_frm_style .frm_submit input[type=submit],.with_frm_style .frm_submit input[type=button]{-webkit-appearance: none;}.with_frm_style.frm_center_submit .frm_submit .frm_ajax_loading{display: block;margin: 0 auto;}.frm_forms.frm_style_formidable-style.with_frm_style{max-width:100%;direction:ltr;}.frm_style_formidable-style.with_frm_style,.frm_style_formidable-style.with_frm_style form,.frm_style_formidable-style.with_frm_style .frm-show-form div.frm_description p {text-align:left;}.frm_style_formidable-style.with_frm_style fieldset{border:0px solid #000000;margin:0;padding:0 0 15px 0;background-color:transparent;}.frm_style_formidable-style.with_frm_style legend + h3,.frm_style_formidable-style.with_frm_style h3.frm_form_title{font-size:20px;color:#444444;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;margin-top:10px;margin-bottom:10px;}.frm_style_formidable-style.with_frm_style .frm-show-form  .frm_section_heading h3{padding:15px 0 3px 0;margin:0;font-size:18px;font-weight:bold;color:#444444;border:none;border-top:2px solid #e8e8e8;background-color:transparent}.frm_style_formidable-style.with_frm_style h3 .frm_after_collapse{display:inline;}.frm_style_formidable-style.with_frm_style h3 .frm_before_collapse{display:none;}.menu-edit #post-body-content .frm_style_formidable-style.with_frm_style .frm_section_heading h3{margin:0;}.frm_style_formidable-style.with_frm_style .frm_section_heading{margin-top:15px;}.frm_style_formidable-style.with_frm_style  .frm-show-form .frm_section_heading .frm_section_spacing,.menu-edit #post-body-content .frm_style_formidable-style.with_frm_style  .frm-show-form .frm_section_heading .frm_section_spacing{margin-bottom:12px;}.frm_style_formidable-style.with_frm_style .frm_repeat_sec{margin-bottom:20px;margin-top:20px;}.frm_style_formidable-style.with_frm_style label.frm_primary_label,.frm_style_formidable-style.with_frm_style.frm_login_form label{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;color:#444444;font-weight:bold;text-align:left;margin:0;padding:0 0 3px 0;width:auto;display:block;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_html_container{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;color:#666666;}.frm_style_formidable-style.with_frm_style .frm_icon_font{color:#444444;}.frm_style_formidable-style.with_frm_style .frm_icon_font.frm_minus_icon:before{content:\"\\e600\";}.frm_style_formidable-style.with_frm_style .frm_icon_font.frm_plus_icon:before{content:\"\\e602\";}.frm_style_formidable-style.with_frm_style .frm_icon_font.frm_minus_icon:before,.frm_style_formidable-style.with_frm_style .frm_icon_font.frm_plus_icon:before{color:#444444;}.frm_style_formidable-style.with_frm_style .frm_trigger.active .frm_icon_font.frm_arrow_icon:before{content:\"\\e62d\";color:#444444;}.frm_style_formidable-style.with_frm_style .frm_trigger .frm_icon_font.frm_arrow_icon:before{content:\"\\e62a\";color:#444444;}.frm_style_formidable-style.with_frm_style .form-field{margin-bottom:20px;}.frm_style_formidable-style.with_frm_style .frm_grid,.frm_style_formidable-style.with_frm_style .frm_grid_first,.frm_style_formidable-style.with_frm_style .frm_grid_odd {margin-bottom:0;}.frm_style_formidable-style.with_frm_style .form-field.frm_section_heading{margin-bottom:0;}.frm_style_formidable-style.with_frm_style p.description,.frm_style_formidable-style.with_frm_style div.description,.frm_style_formidable-style.with_frm_style div.frm_description,.frm_style_formidable-style.with_frm_style .frm-show-form > div.frm_description,.frm_style_formidable-style.with_frm_style .frm_error{margin:0;padding:0;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:12px;color:#666666;font-weight:normal;text-align:left;font-style:normal;max-width:100%;}.frm_style_formidable-style.with_frm_style .frm-show-form div.frm_description p{font-size:14px;color:#666666;margin-top:10px;margin-bottom:25px;}.frm_style_formidable-style.with_frm_style .frm_left_container label.frm_primary_label{float:left;display:inline;width:150px;max-width:33%;margin-right:10px;}.frm_style_formidable-style.with_frm_style .frm_right_container label.frm_primary_label{display:inline;width:150px;max-width:33%;margin-left:10px;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container input:not([type=radio]):not([type=checkbox]),.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container:not(.frm_dynamic_select_container) select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .chosen-container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container input:not([type=radio]):not([type=checkbox]),.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container:not(.frm_dynamic_select_container) select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .chosen-container{max-width:62%;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm_combo_inputs_container .frm_form_field input,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm_combo_inputs_container .frm_form_field select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm_combo_inputs_container .frm_form_field input,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm_combo_inputs_container .frm_form_field select{max-width:100%;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm-g-recaptcha{display:inline-block;}.frm_style_formidable-style.with_frm_style .frm_left_container > p.description::before,.frm_style_formidable-style.with_frm_style .frm_left_container > div.description::before,.frm_style_formidable-style.with_frm_style .frm_left_container > div.frm_description::before,.frm_style_formidable-style.with_frm_style .frm_left_container > .frm_error::before,.frm_style_formidable-style.with_frm_style .frm_right_container > p.description::after,.frm_style_formidable-style.with_frm_style .frm_right_container > div.description::after,.frm_style_formidable-style.with_frm_style .frm_right_container > div.frm_description::after,.frm_style_formidable-style.with_frm_style .frm_right_container > .frm_error::after{content:\'\';display:inline-block;width:150px;max-width:33%;margin-right:10px;}.frm_style_formidable-style.with_frm_style .frm_left_container.frm_inline label.frm_primary_label{max-width:90%;}.frm_style_formidable-style.with_frm_style .form-field.frm_col_field div.frm_description{width:100%;max-width:100%;}.frm_style_formidable-style.with_frm_style .frm_inline_container label.frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_inline_container.frm_dynamic_select_container .frm_opt_container{display:inline;}.frm_style_formidable-style.with_frm_style .frm_inline_container label.frm_primary_label{margin-right:10px;}.frm_style_formidable-style.with_frm_style .frm_pos_right{display:inline;width:150px;}.frm_style_formidable-style.with_frm_style .frm_none_container label.frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_pos_none{display:none;}.frm_style_formidable-style.with_frm_style .frm_scale label{font-weight:normal;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:13px;color:#444444;}.frm_style_formidable-style.with_frm_style .frm_required{color:#B94A48;font-weight:bold;}.frm_style_formidable-style.with_frm_style input[type=text],.frm_style_formidable-style.with_frm_style input[type=password],.frm_style_formidable-style.with_frm_style input[type=email],.frm_style_formidable-style.with_frm_style input[type=number],.frm_style_formidable-style.with_frm_style input[type=url],.frm_style_formidable-style.with_frm_style input[type=tel],.frm_style_formidable-style.with_frm_style input[type=search],.frm_style_formidable-style.with_frm_style select,.frm_style_formidable-style.with_frm_style textarea,.frm_style_formidable-style.with_frm_style .chosen-container{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;margin-bottom:0;}.frm_style_formidable-style.with_frm_style input[type=text],.frm_style_formidable-style.with_frm_style input[type=password],.frm_style_formidable-style.with_frm_style input[type=email],.frm_style_formidable-style.with_frm_style input[type=number],.frm_style_formidable-style.with_frm_style input[type=url],.frm_style_formidable-style.with_frm_style input[type=tel],.frm_style_formidable-style.with_frm_style input[type=phone],.frm_style_formidable-style.with_frm_style input[type=search],.frm_style_formidable-style.with_frm_style select,.frm_style_formidable-style.with_frm_style textarea,.frm_form_fields_style,.frm_style_formidable-style.with_frm_style .frm_scroll_box .frm_opt_container,.frm_form_fields_active_style,.frm_form_fields_error_style,.frm_style_formidable-style.with_frm_style .chosen-container-multi .chosen-choices,.frm_style_formidable-style.with_frm_style .chosen-container-single .chosen-single{color:#555555;background-color:#ffffff;border-color:#cccccc;border-width:1px;border-style:solid;-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;width:100%;max-width:100%;font-size:14px;padding:6px 10px;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;outline:none;font-weight:normal;box-shadow:0 1px 1px rgba(0, 0, 0, 0.075) inset;}.frm_style_formidable-style.with_frm_style input[type=file]::-webkit-file-upload-button{color:#555555;background-color:#ffffff;padding:6px 10px;border-radius:4px;border-color:#cccccc;border-width:1px;border-style:solid;}.frm_style_formidable-style.with_frm_style input[type=text],.frm_style_formidable-style.with_frm_style input[type=password],.frm_style_formidable-style.with_frm_style input[type=email],.frm_style_formidable-style.with_frm_style input[type=number],.frm_style_formidable-style.with_frm_style input[type=url],.frm_style_formidable-style.with_frm_style input[type=tel],.frm_style_formidable-style.with_frm_style input[type=file],.frm_style_formidable-style.with_frm_style input[type=search],.frm_style_formidable-style.with_frm_style select{height:32px;line-height:1.3;}.frm_style_formidable-style.with_frm_style select[multiple=\"multiple\"]{height:auto ;}.frm_style_formidable-style.with_frm_style input[type=file]{color:#555555;padding:0px;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;}.frm_style_formidable-style.with_frm_style input[type=file].frm_transparent{color:transparent;}.frm_style_formidable-style.with_frm_style .frm_default,.frm_style_formidable-style.with_frm_style .placeholder,.frm_style_formidable-style.with_frm_style .chosen-container-multi .chosen-choices li.search-field .default,.frm_style_formidable-style.with_frm_style .chosen-container-single .chosen-default{color:#555555;font-style:italic;}.frm_style_formidable-style.with_frm_style select{width:100%;max-width:100%;}.frm_style_formidable-style.with_frm_style input.frm_other_input:not(.frm_other_full){width:auto ;margin-left:5px ;}.frm_style_formidable-style.with_frm_style .frm_full input.frm_other_input:not(.frm_other_full){margin-left:0 ;margin-top:8px;}.frm_style_formidable-style.with_frm_style .frm_other_container select:not([multiple=\"multiple\"]){width:auto;}.frm_style_formidable-style.with_frm_style .wp-editor-wrap{width:100%;max-width:100%;}.frm_style_formidable-style.with_frm_style .wp-editor-container textarea{border:none;}.frm_style_formidable-style.with_frm_style .mceIframeContainer{background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .auto_width input,.frm_style_formidable-style.with_frm_style input.auto_width,.frm_style_formidable-style.with_frm_style select.auto_width,.frm_style_formidable-style.with_frm_style textarea.auto_width{width:auto;}.frm_style_formidable-style.with_frm_style input[disabled],.frm_style_formidable-style.with_frm_style select[disabled],.frm_style_formidable-style.with_frm_style textarea[disabled],.frm_style_formidable-style.with_frm_style input[readonly],.frm_style_formidable-style.with_frm_style select[readonly],.frm_style_formidable-style.with_frm_style textarea[readonly]{background-color:#ffffff;color:#A1A1A1;border-color:#E5E5E5;}.frm_style_formidable-style.with_frm_style input::placeholder{color:#A1A1A1;}.frm_style_formidable-style.with_frm_style input::-webkit-input-placeholder{color:#A1A1A1;}.frm_style_formidable-style.with_frm_style input::-moz-placeholder{color:#A1A1A1;}.frm_style_formidable-style.with_frm_style input:-ms-input-placeholder{color:#A1A1A1;}.frm_style_formidable-style.with_frm_style input:-moz-placeholder{color:#A1A1A1;}.frm_style_formidable-style.with_frm_style .form-field input:not([type=file]):focus,.frm_style_formidable-style.with_frm_style select:focus,.frm_style_formidable-style.with_frm_style textarea:focus,.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=text],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=password],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=email],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=number],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=url],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=tel],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=search],.frm_form_fields_active_style,.frm_style_formidable-style.with_frm_style .chosen-container-active .chosen-choices{background-color:#ffffff;border-color:#66afe9;box-shadow:0 1px 1px rgba(0, 0, 0, 0.075) inset, 0 0 8px rgba(102,175,233, 0.6);}.frm_style_formidable-style.with_frm_style .frm_compact .frm_dropzone.dz-clickable .dz-message,.frm_style_formidable-style.with_frm_style input[type=submit],.frm_style_formidable-style.with_frm_style .frm_submit input[type=button],.frm_form_submit_style,.frm_style_formidable-style.with_frm_style.frm_login_form input[type=submit]{width:auto;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;height:auto;line-height:normal;text-align:center;background:#ffffff;border-width:1px;border-color:#cccccc;border-style:solid;color:#444444;cursor:pointer;font-weight:normal;-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;text-shadow:none;padding:6px 11px;-moz-box-sizing:border-box;box-sizing:border-box;-ms-box-sizing:border-box;-moz-box-shadow:0 1px 1px #eeeeee;-webkit-box-shadow:0px 1px 1px #eeeeee;box-shadow:0 1px 1px #eeeeee;-ms-filter:\"progid:DXImageTransform.Microsoft.Shadow(Strength=3, Direction=135, Color=\'#eeeeee\')\";filter:progid:DXImageTransform.Microsoft.Shadow(Strength=3, Direction=135, Color=\'#eeeeee\');margin:10px;margin-left:0;margin-right:0;vertical-align:middle;}.frm_style_formidable-style.with_frm_style input[type=submit]:hover,.frm_style_formidable-style.with_frm_style .frm_submit input[type=button]:hover,.frm_style_formidable-style.with_frm_style.frm_login_form input[type=submit]:hover{background:#efefef;border-color:#cccccc;color:#444444;}.frm_style_formidable-style.with_frm_style.frm_center_submit .frm_submit .frm_ajax_loading{margin-bottom:10px;}.frm_style_formidable-style.with_frm_style input[type=submit]:focus,.frm_style_formidable-style.with_frm_style .frm_submit input[type=button]:focus,.frm_style_formidable-style.with_frm_style.frm_login_form input[type=submit]:focus,.frm_style_formidable-style.with_frm_style input[type=submit]:active,.frm_style_formidable-style.with_frm_style .frm_submit input[type=button]:active,.frm_style_formidable-style.with_frm_style.frm_login_form input[type=submit]:active{background:#efefef;border-color:#cccccc;color:#444444;}.frm_style_formidable-style.with_frm_style a.frm_save_draft{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;font-weight:normal;}.frm_style_formidable-style.with_frm_style #frm_field_cptch_number_container{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;color:#444444;font-weight:bold;clear:both;}.frm_style_formidable-style.with_frm_style .frm_radio{display:block;}.frm_style_formidable-style.with_frm_style .horizontal_radio .frm_radio{margin:0 5px 0 0;}.frm_style_formidable-style.with_frm_style .frm_checkbox{display:block;}.frm_style_formidable-style.with_frm_style .vertical_radio .frm_checkbox,.frm_style_formidable-style.with_frm_style .vertical_radio .frm_radio,.vertical_radio .frm_catlevel_1{display:block;}.frm_style_formidable-style.with_frm_style .horizontal_radio .frm_checkbox,.frm_style_formidable-style.with_frm_style .horizontal_radio .frm_radio,.horizontal_radio .frm_catlevel_1{display:inline-block;}.frm_style_formidable-style.with_frm_style .frm_radio label,.frm_style_formidable-style.with_frm_style .frm_checkbox label{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:13px;color:#444444;font-weight:normal;display:inline;white-space:normal;}.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=text],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=password],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=url],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=tel],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=number],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=email],.frm_style_formidable-style.with_frm_style .frm_blank_field textarea,.frm_style_formidable-style.with_frm_style .frm_blank_field .mce-edit-area iframe,.frm_style_formidable-style.with_frm_style .frm_blank_field select,.frm_form_fields_error_style,.frm_style_formidable-style.with_frm_style .frm_blank_field .frm-g-recaptcha iframe,.frm_style_formidable-style.with_frm_style .frm_blank_field .g-recaptcha iframe,.frm_style_formidable-style.with_frm_style .frm_blank_field .chosen-container-multi .chosen-choices,.frm_style_formidable-style.with_frm_style .frm_form_field :invalid{color:#444444;background-color:#ffffff;border-color:#B94A48;border-width:1px;border-style:solid;}.frm_style_formidable-style.with_frm_style .frm_error{font-weight:bold;}.frm_style_formidable-style.with_frm_style .frm_blank_field label,.frm_style_formidable-style.with_frm_style .frm_error{color:#B94A48;}.frm_style_formidable-style.with_frm_style .frm_error_style{background-color:#F2DEDE;border:1px solid #EBCCD1;border-radius:4px;color:#B94A48;font-size:14px;margin:0;margin-bottom:20px;}.frm_style_formidable-style.with_frm_style .frm_message,.frm_success_style{border:1px solid #D6E9C6;background-color:#DFF0D8;color:#468847;border-radius:4px;}.frm_style_formidable-style.with_frm_style .frm_message{margin:5px 0 15px;font-size:14px;}.frm_style_formidable-style.with_frm_style .frm-grid td,.frm-grid th{border-color:#cccccc;}.form_results.frm_style_formidable-style.with_frm_style{border:1px solid #cccccc;}.form_results.frm_style_formidable-style.with_frm_style tr td{color:#555555;border-top:1px solid #cccccc;}.form_results.frm_style_formidable-style.with_frm_style tr.frm_even,.frm-grid .frm_even{background-color:#ffffff;}.frm_style_formidable-style.with_frm_style #frm_loading .progress-striped .progress-bar{background-image:linear-gradient(45deg, #cccccc 25%, rgba(0, 0, 0, 0) 25%, rgba(0, 0, 0, 0) 50%, #cccccc 50%, #cccccc 75%, rgba(0, 0, 0, 0) 75%, rgba(0, 0, 0, 0));}.frm_style_formidable-style.with_frm_style #frm_loading .progress-bar{background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .frm_grid,.frm_style_formidable-style.with_frm_style .frm_grid_first,.frm_style_formidable-style.with_frm_style .frm_grid_odd{border-color:#cccccc;}.frm_style_formidable-style.with_frm_style .frm_grid.frm_blank_field,.frm_style_formidable-style.with_frm_style .frm_grid_first.frm_blank_field,.frm_style_formidable-style.with_frm_style .frm_grid_odd.frm_blank_field{background-color:#F2DEDE;border-color:#EBCCD1;}.frm_style_formidable-style.with_frm_style .frm_grid_first,.frm_style_formidable-style.with_frm_style .frm_grid_odd{background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .frm_grid{background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_html_scroll_box{background-color:#ffffff;border-color:#cccccc;border-width:1px;border-style:solid;-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;width:100%;font-size:14px;padding:6px 10px;outline:none;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_total input,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_total textarea{color:#555555;background-color:transparent;border:none;display:inline;padding:0;}.frm_style_formidable-style.with_frm_style .frm_text_block input,.frm_style_formidable-style.with_frm_style .frm_text_block label.frm_primary_label{margin-left:-20px;}.frm_style_formidable-style.with_frm_style .frm_button{padding:6px 11px;-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;font-size:14px;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-weight:normal;color:#444444;background:#ffffff;border-width:1px;border-color:#cccccc;height:auto;}.frm_style_formidable-style.with_frm_style .frm_button .frm_icon_font:before{font-size:14px;}.frm_style_formidable-style.with_frm_style .frm_dropzone{border-color:#cccccc;border-radius:4px;color:#555555;background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .frm_dropzone .frm_upload_icon:before,.frm_style_formidable-style.with_frm_style .frm_dropzone .dz-remove{color:#555555;}.frm_style_formidable-style.with_frm_style .frm_blank_field .frm_dropzone{border-color:#B94A48;color:#444444;background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .chosen-container{font-size:14px;}.frm_style_formidable-style.with_frm_style .chosen-container-single .chosen-single{height:32px;line-height:1.3;}.frm_style_formidable-style.with_frm_style .chosen-container-single .chosen-single div{top:3px;}.frm_style_formidable-style.with_frm_style .chosen-container-single .chosen-search input[type=\"text\"]{height:32px;}.frm_style_formidable-style.with_frm_style .chosen-container-multi .chosen-choices li.search-field input[type=\"text\"]{height:15px;}@media only screen and (max-width: 600px){.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container input:not([type=radio]):not([type=checkbox]),.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container.frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container.g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container .chosen-container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container input:not([type=radio]):not([type=checkbox]),.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container.frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container.g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container .chosen-container{max-width:100%;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_half.frm_left_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_half.frm_left_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half.frm_left_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_last_half.frm_left_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_half.frm_right_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_half.frm_right_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half.frm_right_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_last_half.frm_right_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container .frm_primary_label{max-width:100%;margin-right:0;margin-left:0;padding-right:0;padding-left:0;width:100%;}.frm_style_formidable-style.with_frm_style .frm_repeat_inline,.frm_style_formidable-style.with_frm_style .frm_repeat_grid{margin: 20px 0;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half.frm_right_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half.frm_right_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half .frm_right_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half .frm_right_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_last_half.frm_right_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_last_half.frm_right_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half.frm_left_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half.frm_left_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half .frm_left_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half .frm_left_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_last_half.frm_left_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_last_half.frm_left_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container .frm_error{margin-right:0;margin-left:0;padding-right:0;padding-left:0;}}@media only screen and (max-width: 500px) {.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container input:not([type=radio]):not([type=checkbox]),.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container:not(.frm_dynamic_select_container) select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .chosen-container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container input:not([type=radio]):not([type=checkbox]),.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container:not(.frm_dynamic_select_container) select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .chosen-container{max-width:100%;}.frm_style_formidable-style.with_frm_style .frm_left_container > p.description::before,.frm_style_formidable-style.with_frm_style .frm_left_container > div.description::before,.frm_style_formidable-style.with_frm_style .frm_left_container > div.frm_description::before,.frm_style_formidable-style.with_frm_style .frm_left_container > .frm_error::before,.frm_style_formidable-style.with_frm_style .frm_right_container > p.description::after,.frm_style_formidable-style.with_frm_style .frm_right_container > div.description::after,.frm_style_formidable-style.with_frm_style .frm_right_container > div.frm_description::after,.frm_style_formidable-style.with_frm_style .frm_right_container > .frm_error::after{display:none;}.frm_style_formidable-style.with_frm_style .frm_left_container label.frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_right_container label.frm_primary_label{width:100%;max-width:100%;margin-right:0;margin-left:0;padding-right:0;padding-left:0;}}.frm_ajax_loading{visibility:hidden;width:auto;}.frm_ajax_loading.frm_loading_now{visibility:visible !important;}.frm_form_submit_style{height:auto;}a.frm_save_draft{cursor:pointer;}.horizontal_radio .frm_radio{margin:0 5px 0 0;}.horizontal_radio .frm_checkbox{margin:0;margin-right:5px;}.vertical_radio .frm_checkbox,.vertical_radio .frm_radio,.vertical_radio .frm_catlevel_1{display:block;}.horizontal_radio .frm_checkbox,.horizontal_radio .frm_radio,.horizontal_radio .frm_catlevel_1{display:inline-block;}.frm_file_container .frm_file_link,.with_frm_style .frm_radio label .frm_file_container,.with_frm_style .frm_checkbox label .frm_file_container{display:inline-block;margin:5px;vertical-align:middle;}.with_frm_style .frm_radio input[type=radio]{border-radius:10px;-webkit-appearance:radio;}.with_frm_style .frm_checkbox input[type=checkbox]{border-radius:0;-webkit-appearance:checkbox;}.with_frm_style .frm_radio input[type=radio],.with_frm_style .frm_checkbox input[type=checkbox]{margin-right:5px;width:auto;border:none;vertical-align:baseline;}.with_frm_style :invalid,.with_frm_style :-moz-submit-invalid,.with_frm_style :-moz-ui-invalid{box-shadow:none;}.with_frm_style .frm_error_style img{padding-right:10px;vertical-align:middle;border:none;}.with_frm_style .frm_trigger{cursor:pointer;}.with_frm_style .frm_error_style,.with_frm_style .frm_message,.frm_success_style{-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;padding:15px;}.with_frm_style .frm_message p{margin-bottom:5px;}.frm_form_fields_style,.frm_form_fields_active_style,.frm_form_fields_error_style,.frm_form_submit_style{width:auto;}.with_frm_style .frm_trigger span{float:left;}.with_frm_style table.frm-grid,#content .with_frm_style table.frm-grid{border-collapse:collapse;border:none;}.frm-grid td,.frm-grid th{padding:5px;border-width:1px;border-style:solid;border-color:#cccccc;border-top:none;border-left:none;border-right:none;}table.form_results.with_frm_style{border:1px solid #ccc;}table.form_results.with_frm_style tr td{text-align:left;color:#555555;padding:7px 9px;border-top:1px solid #cccccc;}table.form_results.with_frm_style tr.frm_even,.frm-grid .frm_even{background-color:#fff;}table.form_results.with_frm_style tr.frm_odd,.frm-grid .frm_odd{background-color:#ffffff;}.frm_collapse .ui-icon{display:inline-block;}.frm_toggle_container{border:1px solid transparent;}.frm_toggle_container ul{margin:5px 0;padding-left:0;list-style-type:none;}.frm_toggle_container .frm_month_heading{text-indent:15px;}.frm_toggle_container .frm_month_listing{margin-left:40px;}#frm_loading{display:none;position:fixed;top:0;left:0;width:100%;height:100%;z-index:99999;}#frm_loading h3{font-weight:500;padding-bottom:15px;color:#fff;font-size:24px;}#frm_loading_content{position:fixed;top:20%;left:33%;width:33%;text-align:center;padding-top:30px;font-weight:bold;z-index:9999999;}#frm_loading img{max-width:100%;}#frm_loading .progress{border-radius:4px;box-shadow:0 1px 2px rgba(0, 0, 0, 0.1) inset;height:20px;margin-bottom:20px;overflow:hidden;}#frm_loading .progress.active .progress-bar{animation:2s linear 0s normal none infinite progress-bar-stripes;}#frm_loading .progress-striped .progress-bar{background-image:linear-gradient(45deg, #cccccc 25%, rgba(0, 0, 0, 0) 25%, rgba(0, 0, 0, 0) 50%, #cccccc 50%, #cccccc 75%, rgba(0, 0, 0, 0) 75%, rgba(0, 0, 0, 0));background-size:40px 40px;}#frm_loading .progress-bar{background-color:#ffffff;box-shadow:0 -1px 0 rgba(0, 0, 0, 0.15) inset;float:left;height:100%;line-height:20px;text-align:center;transition:width 0.6s ease 0s;width:100%;}.frm_pagination_cont ul.frm_pagination{display:inline-block;list-style:none;margin-left:0 !important;}.frm_pagination_cont ul.frm_pagination > li{display:inline;list-style:none;margin:2px;background-image:none;}ul.frm_pagination > li.active a{text-decoration:none;}.frm_pagination_cont ul.frm_pagination > li:first-child{margin-left:0;}.archive-pagination.frm_pagination_cont ul.frm_pagination > li{margin:0;}.frmcal{padding-top:30px;}.frmcal-title{font-size:116%;}.frmcal table.frmcal-calendar{border-collapse:collapse;margin-top:20px;color:#555555;}.frmcal table.frmcal-calendar,.frmcal table.frmcal-calendar tbody tr td{border:1px solid #cccccc;}.frmcal table.frmcal-calendar,.frmcal,.frmcal-header{width:100%;}.frmcal-header{text-align:center;}.frmcal-prev{margin-right:10px;}.frmcal-prev,.frmcal-dropdown{float:left;}.frmcal-dropdown{margin-left:5px;}.frmcal-next{float:right;}.frmcal table.frmcal-calendar thead tr th{text-align:center;padding:2px 4px;}.frmcal table.frmcal-calendar tbody tr td{height:110px;width:14.28%;vertical-align:top;padding:0 !important;color:#555555;font-size:12px;}table.frmcal-calendar .frmcal_date{background-color:#ffffff;padding:0 5px;text-align:right;-moz-box-shadow:0 2px 5px #cccccc;-webkit-box-shadow:0 2px 5px #cccccc;box-shadow:0 2px 5px #cccccc;-ms-filter:\"progid:DXImageTransform.Microsoft.Shadow(Strength=4, Direction=180, Color=\'#cccccc\')\";filter:progid:DXImageTransform.Microsoft.Shadow(Strength=4, Direction=180, Color=\'#cccccc\');}table.frmcal-calendar .frmcal-today .frmcal_date{background-color:#ffffff;padding:0 5px;text-align:right;-moz-box-shadow:0 2px 5px #66afe9;-webkit-box-shadow:0 2px 5px #66afe9;box-shadow:0 2px 5px #66afe9;-ms-filter:\"progid:DXImageTransform.Microsoft.Shadow(Strength=4, Direction=180, Color=\'#66afe9\')\";filter:progid:DXImageTransform.Microsoft.Shadow(Strength=4, Direction=180, Color=\'#66afe9\');}.frmcal_num{display:inline;}.frmcal-content{padding:2px 4px;}.frm_image_from_url{height:50px;}.frm-loading-img{background:url(//www.dgtal-mind.com/wp-content/plugins/formidable/images/ajax_loader.gif) no-repeat center center;padding:6px 12px;}#ui-datepicker-div{display:none;z-index:999999 !important;}.frm_form_fields div.rating-cancel{display:none !important;}.frm_form_fields div.rating-cancel,.frm_form_fields div.star-rating{float:left;width:17px;height:17px;font-size:16px;line-height:normal;cursor:pointer;display:block;background:transparent;overflow:hidden;clear:none;}.frm_form_fields div.rating-cancel a:before{font:16px/1 \'dashicons\';content:\'\\f460\';color:#CDCDCD;}.frm_form_fields div.star-rating:before,.frm_form_fields div.star-rating a:before{font:16px/1 \'dashicons\';content:\'\\f154\';color:#F0AD4E;}.frm_form_fields div.rating-cancel a,.frm_form_fields div.star-rating a{display:block;width:16px;height:100%;border:0;}.frm_form_fields div.star-rating-on:before,.frm_form_fields div.star-rating-on a:before{content:\'\\f155\';}.frm_form_fields div.star-rating-hover:before,.frm_form_fields div.star-rating-hover a:before{content:\'\\f155\';}.frm_form_fields div.frm_half_star:before,.frm_form_fields div.frm_half_star a:before{content:\'\\f459\';}.frm_form_fields div.rating-cancel.star-rating-hover a:before{color:#B63E3F;}.frm_form_fields div.star-rating-readonly,.frm_form_fields div.star-rating-readonly a{cursor:default !important;}.frm_form_fields div.star-rating{overflow:hidden!important;}.with_frm_style .frm_form_field{clear:both;}.frm_form_field.frm_right_half,.frm_form_field.frm_right_third,.frm_form_field.frm_right_two_thirds,.frm_form_field.frm_right_fourth,.frm_form_field.frm_right_fifth,.frm_form_field.frm_right_inline,.frm_form_field.frm_last_half,.frm_form_field.frm_last_third,.frm_form_field.frm_last_two_thirds,.frm_form_field.frm_last_fourth,.frm_form_field.frm_last_fifth,.frm_form_field.frm_last_sixth,.frm_form_field.frm_last_seventh,.frm_form_field.frm_last_eighth,.frm_form_field.frm_last_inline,.frm_form_field.frm_last,.frm_form_field.frm_half,.frm_submit.frm_half,.frm_form_field.frm_third,.frm_submit.frm_third,.frm_form_field.frm_two_thirds,.frm_form_field.frm_fourth,.frm_submit.frm_fourth,.frm_form_field.frm_three_fourths,.frm_form_field.frm_fifth,.frm_submit.frm_fifth,.frm_form_field.frm_two_fifths,.frm_form_field.frm_three_fifths,.frm_form_field.frm_four_fifths,.frm_form_field.frm_sixth,.frm_submit.frm_sixth,.frm_form_field.frm_seventh,.frm_submit.frm_seventh,.frm_form_field.frm_eighth,.frm_submit.frm_eighth,.frm_form_field.frm_inline,.frm_submit.frm_inline{clear:none;float:left;margin-left:2.5%;}.frm_form_field.frm_left_half,.frm_form_field.frm_left_third,.frm_form_field.frm_left_two_thirds,.frm_form_field.frm_left_fourth,.frm_form_field.frm_left_fifth,.frm_form_field.frm_left_inline,.frm_form_field.frm_first_half,.frm_form_field.frm_first_third,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_first_fourth,.frm_form_field.frm_first_fifth,.frm_form_field.frm_first_sixth,.frm_form_field.frm_first_seventh,.frm_form_field.frm_first_eighth,.frm_form_field.frm_first_inline,.frm_form_field.frm_first{clear:left;float:left;margin-left:0;}.frm_form_field.frm_alignright{float:right !important;}.frm_form_field.frm_left_half,.frm_form_field.frm_right_half,.frm_form_field.frm_first_half,.frm_form_field.frm_last_half,.frm_form_field.frm_half,.frm_submit.frm_half{width:48.75%;}.frm_form_field.frm_left_third,.frm_form_field.frm_third,.frm_submit.frm_third,.frm_form_field.frm_right_third,.frm_form_field.frm_first_third,.frm_form_field.frm_last_third{width:31.66%;}.frm_form_field.frm_left_two_thirds,.frm_form_field.frm_right_two_thirds,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_last_two_thirds,.frm_form_field.frm_two_thirds{width:65.82%;}.frm_form_field.frm_left_fourth,.frm_form_field.frm_fourth,.frm_submit.frm_fourth,.frm_form_field.frm_right_fourth,.frm_form_field.frm_first_fourth,.frm_form_field.frm_last_fourth{width:23.12%;}.frm_form_field.frm_three_fourths{width:74.36%;}.frm_form_field.frm_left_fifth,.frm_form_field.frm_fifth,.frm_submit.frm_fifth,.frm_form_field.frm_right_fifth,.frm_form_field.frm_first_fifth,.frm_form_field.frm_last_fifth{width:18%;}.frm_form_field.frm_two_fifths {width:38.5%;}.frm_form_field.frm_three_fifths {width:59%;}.frm_form_field.frm_four_fifths {width:79.5%;}.frm_form_field.frm_sixth,.frm_submit.frm_sixth,.frm_form_field.frm_first_sixth,.frm_form_field.frm_last_sixth{width:14.58%;}.frm_form_field.frm_seventh,.frm_submit.frm_seventh,.frm_form_field.frm_first_seventh,.frm_form_field.frm_last_seventh{width:12.14%;}.frm_form_field.frm_eighth,.frm_submit.frm_eighth,.frm_form_field.frm_first_eighth,.frm_form_field.frm_last_eighth{width:10.31%;}.frm_form_field.frm_left_inline,.frm_form_field.frm_first_inline,.frm_form_field.frm_inline,.frm_submit.frm_inline,.frm_form_field.frm_right_inline,.frm_form_field.frm_last_inline{width:auto;}.frm_full,.frm_full .wp-editor-wrap,.frm_full input:not([type=\'checkbox\']):not([type=\'radio\']):not([type=\'button\']),.frm_full select,.frm_full textarea{width:100% !important;}.frm_full .wp-editor-wrap input{width:auto !important;}@media only screen and (max-width: 600px) {.frm_form_field.frm_half,.frm_submit.frm_half,.frm_form_field.frm_left_half,.frm_form_field.frm_right_half,.frm_form_field.frm_first_half,.frm_form_field.frm_last_half,.frm_form_field.frm_first_third,.frm_form_field.frm_third,.frm_submit.frm_third,.frm_form_field.frm_last_third,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_last_two_thirds,.frm_form_field.frm_two_thirds,.frm_form_field.frm_left_fourth,.frm_form_field.frm_fourth,.frm_submit.frm_fourth,.frm_form_field.frm_right_fourth,.frm_form_field.frm_first_fourth,.frm_form_field.frm_last_fourth,.frm_form_field.frm_three_fourths,.frm_form_field.frm_fifth,.frm_submit.frm_fifth,.frm_form_field.frm_two_fifths,.frm_form_field.frm_three_fifths,.frm_form_field.frm_four_fifths,.frm_form_field.frm_sixth,.frm_submit.frm_sixth,.frm_form_field.frm_seventh,.frm_submit.frm_seventh,.frm_form_field.frm_eighth,.frm_submit.frm_eighth,.frm_form_field.frm_first_inline,.frm_form_field.frm_inline,.frm_submit.frm_inline,.frm_form_field.frm_last_inline{width:100%;margin-left:0;margin-right:0;clear:both;float:none;}}.frm_form_field.frm_left_container label.frm_primary_label{float:left;display:inline;max-width:33%;margin-right:10px;}.frm_form_field.frm_left_container input:not([type=radio]):not([type=checkbox]),.frm_form_field.frm_left_container:not(.frm_dynamic_select_container) select,.frm_form_field.frm_left_container textarea,.frm_form_field.frm_left_container .wp-editor-wrap,.frm_form_field.frm_left_container .frm_opt_container,.frm_form_field.frm_left_container .frm_dropzone,.frm_form_field.frm_left_container .frm-g-recaptcha,.frm_form_field.frm_left_container .g-recaptcha,.frm_form_field.frm_left_container .chosen-container,.frm_form_field.frm_left_container .frm_combo_inputs_container,.frm_form_field.frm_right_container input:not([type=radio]):not([type=checkbox]),.frm_form_field.frm_right_container:not(.frm_dynamic_select_container) select,.frm_form_field.frm_right_container textarea,.frm_form_field.frm_right_container .wp-editor-wrap,.frm_form_field.frm_right_container .frm_opt_container,.frm_form_field.frm_right_container .frm_dropzone,.frm_form_field.frm_right_container .frm-g-recaptcha,.frm_form_field.frm_right_container .g-recaptcha,.frm_form_field.frm_right_container .chosen-container,.frm_form_field.frm_right_container .frm_combo_inputs_container{max-width:62%;}.frm_form_field.frm_left_container .frm_combo_inputs_container input,.frm_form_field.frm_left_container .frm_combo_inputs_container select,.frm_form_field.frm_right_container .frm_combo_inputs_container input,.frm_form_field.frm_right_container .frm_combo_inputs_container select{max-width:100%;}.frm_form_field.frm_left_container .frm_opt_container,.frm_form_field.frm_right_container .frm_opt_container,.frm_form_field.frm_inline_container .frm_opt_container,.frm_form_field.frm_left_container .frm_combo_inputs_container,.frm_form_field.frm_right_container .frm_combo_inputs_container,.frm_form_field.frm_inline_container .frm_combo_inputs_container,.frm_form_field.frm_left_container .wp-editor-wrap,.frm_form_field.frm_right_container .wp-editor-wrap,.frm_form_field.frm_inline_container .wp-editor-wrap,.frm_form_field.frm_left_container .frm_dropzone,.frm_form_field.frm_right_container .frm_dropzone,.frm_form_field.frm_inline_container .frm_dropzone,.frm_form_field.frm_left_container .frm-g-recaptcha,.frm_form_field.frm_right_container .frm-g-recaptcha,.frm_form_field.frm_inline_container .frm-g-recaptcha,.frm_form_field.frm_left_container .g-recaptcha,.frm_form_field.frm_right_container .g-recaptcha,.frm_form_field.frm_inline_container .g-recaptcha{display:inline-block;}.frm_form_field.frm_left_half.frm_left_container .frm_primary_label,.frm_form_field.frm_right_half.frm_left_container .frm_primary_label,.frm_form_field.frm_left_half.frm_right_container .frm_primary_label,.frm_form_field.frm_right_half.frm_right_container .frm_primary_label,.frm_form_field.frm_first_half.frm_left_container .frm_primary_label,.frm_form_field.frm_last_half.frm_left_container .frm_primary_label,.frm_form_field.frm_first_half.frm_right_container .frm_primary_label,.frm_form_field.frm_last_half.frm_right_container .frm_primary_label,.frm_form_field.frm_half.frm_right_container .frm_primary_label,.frm_form_field.frm_half.frm_left_container .frm_primary_label{-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;max-width:33%;}.wp-editor-wrap *,.wp-editor-wrap *:after,.wp-editor-wrap *:before{-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;}.with_frm_style .frm_grid,.with_frm_style .frm_grid_first,.with_frm_style .frm_grid_odd{clear:both;margin-bottom:0 !important;padding:5px;border-width:1px;border-style:solid;border-color:#cccccc;border-left:none;border-right:none;}.with_frm_style .frm_grid,.with_frm_style .frm_grid_odd{border-top:none;}.frm_grid .frm_error,.frm_grid_first .frm_error,.frm_grid_odd .frm_error{display:none;}.frm_grid:after,.frm_grid_first:after,.frm_grid_odd:after{visibility:hidden;display:block;font-size:0;content:\" \";clear:both;height:0;}.frm_grid_first{margin-top:20px;}.frm_grid_first,.frm_grid_odd{background-color:#ffffff;}.frm_grid{background-color:#ffffff;}.frm_grid .frm_primary_label,.frm_grid_first .frm_primary_label,.frm_grid_odd .frm_primary_label,.frm_grid .frm_radio,.frm_grid_first .frm_radio,.frm_grid_odd .frm_radio,.frm_grid .frm_checkbox,.frm_grid_first .frm_checkbox,.frm_grid_odd .frm_checkbox{float:left !important;display:block;margin-top:0;margin-left:0 !important;}.frm_grid_first .frm_radio label,.frm_grid .frm_radio label,.frm_grid_odd .frm_radio label,.frm_grid_first .frm_checkbox label,.frm_grid .frm_checkbox label,.frm_grid_odd .frm_checkbox label{visibility:hidden;white-space:nowrap;text-align:left;}.frm_grid_first .frm_radio label input,.frm_grid .frm_radio label input,.frm_grid_odd .frm_radio label input,.frm_grid_first .frm_checkbox label input,.frm_grid .frm_checkbox label input,.frm_grid_odd .frm_checkbox label input{visibility:visible;margin:2px 0 0;float:right;}.frm_grid .frm_radio,.frm_grid_first .frm_radio,.frm_grid_odd .frm_radio,.frm_grid .frm_checkbox,.frm_grid_first .frm_checkbox,.frm_grid_odd .frm_checkbox{display:inline;}.frm_grid_2 .frm_radio,.frm_grid_2 .frm_checkbox,.frm_grid_2 label.frm_primary_label{width:48% !important;}.frm_grid_2 .frm_radio,.frm_grid_2 .frm_checkbox{margin-right:4%;}.frm_grid_3 .frm_radio,.frm_grid_3 .frm_checkbox,.frm_grid_3 label.frm_primary_label{width:30% !important;}.frm_grid_3 .frm_radio,.frm_grid_3 .frm_checkbox{margin-right:3%;}.frm_grid_4 .frm_radio,.frm_grid_4 .frm_checkbox{width:20% !important;}.frm_grid_4 label.frm_primary_label{width:28% !important;}.frm_grid_4 .frm_radio,.frm_grid_4 .frm_checkbox{margin-right:4%;}.frm_grid_5 label.frm_primary_label,.frm_grid_7 label.frm_primary_label{width:24% !important;}.frm_grid_5 .frm_radio,.frm_grid_5 .frm_checkbox{width:17% !important;margin-right:2%;}.frm_grid_6 label.frm_primary_label{width:25% !important;}.frm_grid_6 .frm_radio,.frm_grid_6 .frm_checkbox{width:14% !important;margin-right:1%;}.frm_grid_7 label.frm_primary_label{width:22% !important;}.frm_grid_7 .frm_radio,.frm_grid_7 .frm_checkbox{width:12% !important;margin-right:1%;}.frm_grid_8 label.frm_primary_label{width:23% !important;}.frm_grid_8 .frm_radio,.frm_grid_8 .frm_checkbox{width:10% !important;margin-right:1%;}.frm_grid_9 label.frm_primary_label{width:20% !important;}.frm_grid_9 .frm_radio,.frm_grid_9 .frm_checkbox{width:9% !important;margin-right:1%;}.frm_grid_10 label.frm_primary_label{width:19% !important;}.frm_grid_10 .frm_radio,.frm_grid_10 .frm_checkbox{width:8% !important;margin-right:1%;}.with_frm_style .frm_inline_container.frm_grid_first label.frm_primary_label,.with_frm_style .frm_inline_container.frm_grid label.frm_primary_label,.with_frm_style .frm_inline_container.frm_grid_odd label.frm_primary_label,.with_frm_style .frm_inline_container.frm_grid_first .frm_opt_container,.with_frm_style .frm_inline_container.frm_grid .frm_opt_container,.with_frm_style .frm_inline_container.frm_grid_odd .frm_opt_container{margin-right:0;}.with_frm_style .frm_inline_container.frm_scale_container label.frm_primary_label{float:left;}.with_frm_style .frm_other_input.frm_other_full{margin-top:10px;}.with_frm_style .frm_repeat_sec{margin-bottom:20px;margin-top:20px;}.with_frm_style .frm_repeat_inline{clear:both;}.frm_form_field .frm_repeat_sec .frm_add_form_row{opacity:0;display:none;*display:inline;display:inline\\0/; -moz-transition: opacity .15s ease-in-out;-webkit-transition: opacity .15s ease-in-out;transition: opacity .15s ease-in-out;pointer-events:none;}.frm_section_heading div.frm_repeat_sec:last-child .frm_add_form_row{opacity:100;display:inline;pointer-events:auto;}.frm_form_field .frm_repeat_grid .frm_form_field label.frm_primary_label{display:none !important;}.frm_form_field .frm_repeat_grid.frm_first_repeat .frm_form_field label.frm_primary_label{display:inherit !important;}.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_four_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox,.frm_form_field.frm_three_col .frm_checkbox,.frm_form_field.frm_four_col .frm_checkbox{float:left;}.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox{width:48%;margin-right:4%;}.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_three_col .frm_checkbox{width:30%;margin-right:5%;}.frm_form_field.frm_four_col .frm_radio,.frm_form_field.frm_four_col .frm_checkbox{width:22%;margin-right:4%;}.frm_form_field.frm_two_col .frm_radio:nth-child(2n+2),.frm_form_field.frm_two_col .frm_checkbox:nth-child(2n+2),.frm_form_field.frm_three_col .frm_radio:nth-child(3n+3),.frm_form_field.frm_three_col .frm_checkbox:nth-child(3n+3),.frm_form_field.frm_four_col .frm_radio:nth-child(4n+4),.frm_form_field.frm_four_col .frm_checkbox:nth-child(4n+4){margin-right:0;}.frm_form_field.frm_scroll_box .frm_opt_container{height:100px;overflow:auto;}.frm_form_field.frm_html_scroll_box{height:100px;overflow:auto;background-color:#ffffff;border-color:#cccccc;border-width:1px;border-style:solid;-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;width:100%;max-width:100%;font-size:14px;padding:6px 10px;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;outline:none;font-weight:normal;box-shadow:0 1px 1px rgba(0, 0, 0, 0.075) inset;}.frm_form_field.frm_two_col .frm_opt_container:after,.frm_form_field.frm_three_col .frm_opt_container:after,.frm_form_field.frm_four_col .frm_opt_container:after{content:\".\";display:block;clear:both;visibility:hidden;line-height:0;height:0;}.frm_form_field.frm_total input,.frm_form_field.frm_total textarea{opacity:1;background-color:transparent !important;border:none !important;font-weight:bold;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none !important;display:inline;-moz-appearance:textfield;padding:0;}.frm_form_field.frm_total input::-webkit-outer-spin-button,.frm_form_field.frm_total input::-webkit-inner-spin-button {-webkit-appearance: none;}.frm_form_field.frm_total input:focus,.frm_form_field.frm_total textarea:focus{background-color:transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;}.frm_text_block{margin-left:20px;}.frm_text_block input,.frm_text_block label.frm_primary_label{margin-left:-20px;}.frm_text_block .frm_checkbox input[type=checkbox],.frm_text_block .frm_radio input[type=radio]{margin-right:4px;}.frm_form_field.frm_capitalize input,.frm_form_field.frm_capitalize select,.frm_form_field.frm_capitalize .frm_opt_container label{text-transform:capitalize;}.frm_clearfix:after{content:\".\";display:block;clear:both;visibility:hidden;line-height:0;height:0;}.frm_clearfix{display:inline-block;}html[xmlns] .frm_clearfix{display:block;}* html .frm_clearfix{height:1%;}.with_frm_style.frm_login_form,.with_frm_style.frm_login_form form{clear:both;}.with_frm_style.frm_login_form.frm_inline_login .login-remember input{vertical-align:baseline;}.with_frm_style.frm_login_form.frm_inline_login .login-submit{float:left;}.with_frm_style.frm_login_form.frm_inline_login label{display:inline;}.with_frm_style.frm_login_form.frm_inline_login .login-username,.with_frm_style.frm_login_form.frm_inline_login .login-password,.with_frm_style.frm_login_form.frm_inline_login .login-remember{float:left;margin-right:5px;}.with_frm_style.frm_login_form.frm_inline_login form{position:relative;clear:none;}.with_frm_style.frm_login_form.frm_inline_login .login-remember{position:absolute;top:35px;}.with_frm_style.frm_login_form.frm_inline_login input[type=submit]{margin:0 !important;}.with_frm_style.frm_login_form.frm_no_labels .login-username label,.with_frm_style.frm_login_form.frm_no_labels .login-password label{display:none;}.with_frm_style .frm-open-login{float:left;margin-right:15px;}.with_frm_style .frm-open-login a{text-decoration:none;border:none;outline:none;}.with_frm_style.frm_slide.frm_login_form form{display:none;}.with_frm_style .chosen-container{font-size:14px;position:relative;display:inline-block;zoom:1;vertical-align:middle;width:100% !important;-webkit-user-select:none;-moz-user-select:none;user-select:none;*display:inline;}.with_frm_style .chosen-container .chosen-drop{background:#fff;border:1px solid #aaa;border-top:0;position:absolute;top:100%;left:-9999px;box-shadow:0 4px 5px rgba(0,0,0,.15);z-index:1010;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;width:100%;}.with_frm_style .chosen-container.chosen-with-drop .chosen-drop{left:0;}.with_frm_style .chosen-container a{cursor:pointer;}.with_frm_style .chosen-container-single .chosen-single{position:relative;display:block;overflow:hidden;padding:0 0 0 8px;height:25px;background:-webkit-gradient(linear, 50% 0%, 50% 100%, color-stop(20%, #ffffff), color-stop(50%, #f6f6f6), color-stop(52%, #eeeeee), color-stop(100%, #f4f4f4));background:-webkit-linear-gradient(top, #ffffff 20%, #f6f6f6 50%, #eeeeee 52%, #f4f4f4 100%);background:-moz-linear-gradient(top, #ffffff 20%, #f6f6f6 50%, #eeeeee 52%, #f4f4f4 100%);background:-o-linear-gradient(top, #ffffff 20%, #f6f6f6 50%, #eeeeee 52%, #f4f4f4 100%);background:linear-gradient(top, #ffffff 20%, #f6f6f6 50%, #eeeeee 52%, #f4f4f4 100%);background-clip:padding-box;box-shadow:0 0 3px white inset, 0 1px 1px rgba(0, 0, 0, 0.1);text-decoration:none;white-space:nowrap;line-height:24px;}.with_frm_style .chosen-container-single .chosen-single span{margin-right:26px;display:block;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;}.with_frm_style .chosen-container-single .chosen-single-with-deselect span{margin-right:38px;}.with_frm_style .chosen-container-single .chosen-single abbr{display:block;position:absolute;right:26px;top:6px;width:12px;height:12px;font-size:1px;background:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') -42px 1px no-repeat;}.with_frm_style .chosen-container-single .chosen-single abbr:hover{background-position:-42px -10px;}.with_frm_style .chosen-container-single.chosen-disabled .chosen-single abbr:hover{background-position:-42px -10px;}.with_frm_style .chosen-container-single .chosen-single div{position:absolute;right:0;top:0;display:block;height:100%;width:18px;}.with_frm_style .chosen-container-single .chosen-single div b{background:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') no-repeat 0 2px;display:block;width:100%;height:100%;}.with_frm_style .chosen-container-single .chosen-search{padding:3px 4px;position:relative;margin:0;white-space:nowrap;z-index:1010;}.with_frm_style .chosen-container-single .chosen-search input[type=\"text\"]{-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;width:100% !important;max-width:100% !important;height:auto;background:white url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') no-repeat 100% -20px;background:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') no-repeat 100% -20px;font-size:1em;font-family:sans-serif;line-height:normal;border-radius:0;}.with_frm_style .chosen-container-single .chosen-drop{margin-top:-1px;border-radius:0 0 4px 4px;background-clip:padding-box;}.with_frm_style .chosen-container-single.chosen-container-single-nosearch .chosen-search{position:absolute;left:-9999px;}.with_frm_style .chosen-container .chosen-results{cursor:text;overflow-x:hidden;overflow-y:auto;position:relative;margin:0 4px 4px 0;padding:0 0 0 4px;max-height:240px;word-wrap:break-word;-webkit-overflow-scrolling:touch;}.with_frm_style .chosen-container .chosen-results li:before{background:none;}.with_frm_style .chosen-container .chosen-results li{display:none;margin:0;padding:5px 6px;list-style:none;line-height:15px;-webkit-touch-callout:none;}.with_frm_style .chosen-container .chosen-results li.active-result{display:list-item;cursor:pointer;}.with_frm_style .chosen-container .chosen-results li.disabled-result{display:list-item;color:#ccc;cursor:default;}.with_frm_style .chosen-container .chosen-results li.highlighted{background-color:#3875d7;color:#fff;}.with_frm_style .chosen-container .chosen-results li.no-results{display:list-item;background:#f4f4f4;}.with_frm_style .chosen-container .chosen-results li.group-result{display:list-item;font-weight:bold;cursor:default;}.with_frm_style .chosen-container .chosen-results li.group-option{padding-left:15px;}.with_frm_style .chosen-container .chosen-results li em{font-style:normal;text-decoration:underline;}.with_frm_style .chosen-container-multi .chosen-choices{position:relative;overflow:hidden;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;margin:0;padding:0 5px;width:100%;height:auto !important;height:1%;cursor:text;}.with_frm_style .chosen-container-multi .chosen-choices li{float:left;list-style:none;}.with_frm_style .chosen-container-multi .chosen-choices li.search-field{margin:0;padding:0;white-space:nowrap;}.with_frm_style .chosen-container-multi .chosen-choices li.search-field input[type=\"text\"]{margin:1px 0;padding:0;height:25px;outline:0;border:0 !important;background:transparent !important;box-shadow:none;color:#666;font-size:100%;font-family:sans-serif;line-height:normal;border-radius:0;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice{position:relative;margin:3px 5px 3px 0;padding:3px 20px 3px 5px;border:1px solid #aaa;max-width:100%;border-radius:3px;background-color:#eee;background-size:100% 19px;background-repeat:repeat-x;background-clip:padding-box;box-shadow:0 0 2px white inset, 0 1px 0 rgba(0, 0, 0, 0.05);color:#333;line-height:13px;cursor:default;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice .search-choice-close{position:absolute;top:4px;right:3px;display:block;width:12px;height:12px;background:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') -42px 1px no-repeat;font-size:1px;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice .search-choice-close:hover{background-position:-42px -10px;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice-disabled{padding-right:5px;border:1px solid #ccc;background-color:#e4e4e4;color:#666;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice-focus{background:#d4d4d4;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice-focus .search-choice-close{background-position:-42px -10px;}.with_frm_style .chosen-container-multi .chosen-results{margin:0;padding:0;}.with_frm_style .chosen-container-multi .chosen-drop .result-selected{display:list-item;color:#ccc;cursor:default;}.with_frm_style .chosen-container-active .chosen-single{border:1px solid #5897fb;box-shadow:0 0 5px rgba(0, 0, 0, 0.3);}.with_frm_style .chosen-container-active.chosen-with-drop .chosen-single{border:1px solid #aaa;-moz-border-radius-bottomright:0;border-bottom-right-radius:0;-moz-border-radius-bottomleft:0;border-bottom-left-radius:0;box-shadow:0 1px 0 #fff inset;}.with_frm_style .chosen-container-active.chosen-with-drop .chosen-single div{border-left:none;background:transparent;}.with_frm_style .chosen-container-active.chosen-with-drop .chosen-single div b{background-position:-18px 2px;}.with_frm_style .chosen-container-active .chosen-choices li.search-field input[type=\"text\"]{color:#111 !important;}.with_frm_style .chosen-disabled{opacity:0.5 !important;cursor:default;}.with_frm_style .chosen-disabled .chosen-single{cursor:default;}.with_frm_style .chosen-disabled .chosen-choices .search-choice .search-choice-close{cursor:default;}.with_frm_style .chosen-rtl{text-align:right;}.with_frm_style .chosen-rtl .chosen-single{overflow:visible;padding:0 8px 0 0;}.with_frm_style .chosen-rtl .chosen-single span{margin-right:0;margin-left:26px;direction:rtl;}.with_frm_style .chosen-rtl .chosen-single-with-deselect span{margin-left:38px;}.with_frm_style .chosen-rtl .chosen-single div{right:auto;left:3px;}.with_frm_style .chosen-rtl .chosen-single abbr{right:auto;left:26px;}.with_frm_style .chosen-rtl .chosen-choices li{float:right;}.with_frm_style .chosen-rtl .chosen-choices li.search-field input[type=\"text\"]{direction:rtl;}.with_frm_style .chosen-rtl .chosen-choices li.search-choice{margin:3px 5px 3px 0;padding:3px 5px 3px 19px;}.with_frm_style .chosen-rtl .chosen-choices li.search-choice .search-choice-close{right:auto;left:4px;}.with_frm_style .chosen-rtl.chosen-container-single-nosearch .chosen-search, .with_frm_style .chosen-rtl .chosen-drop{left:9999px;}.with_frm_style .chosen-rtl.chosen-container-single .chosen-results{margin:0 0 4px 4px;padding:0 4px 0 0;}.with_frm_style .chosen-rtl .chosen-results li.group-option{padding-right:15px;padding-left:0;}.with_frm_style .chosen-rtl.chosen-container-active.chosen-with-drop .chosen-single div{border-right:none;}.with_frm_style .chosen-rtl .chosen-search input[type=\"text\"]{padding:4px 5px 4px 20px;background:white url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') no-repeat -30px -20px;background:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') no-repeat -30px -20px;direction:rtl;}.with_frm_style .chosen-rtl.chosen-container-single .chosen-single div b{background-position:6px 2px;}.with_frm_style .chosen-rtl.chosen-container-single.chosen-with-drop .chosen-single div b{background-position:-12px 2px;}@font-face {font-family:\'s11-fp\';src:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/fonts/s11-fp.eot\');src:local(\'☺\'), url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/fonts/s11-fp.woff\') format(\'woff\'), url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/fonts/s11-fp.ttf\') format(\'truetype\'), url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/fonts/s11-fp.svg\') format(\'svg\');font-weight:normal;font-style:normal;}.frm_icon_font,.frm_dashicon_font{text-decoration:none;text-shadow: none;font-weight:normal;}i.frm_icon_font{font-style:normal;}.frm_icon_font:before,select.frm_icon_font{font-family: \'s11-fp\' !important;font-size:16px;speak: none;-webkit-font-smoothing: antialiased;-moz-osx-font-smoothing: grayscale;-moz-transition: all .1s ease-in-out;-webkit-transition: all .1s ease-in-out;transition: all .1s ease-in-out;}.frm_icon_font,a.frm_icon_font.frm_icon_font:hover,a.frm_icon_font:hover{text-decoration:none !important;}.frm_icon_font:focus,.frm_dashicon_font:focus{box-shadow:none;-webkit-box-shadow:none;}.frm_duplicate_icon:active,.frm_move_icon:active,.frm_delete_icon:active{outline:none;}.frm_trigger .frm_icon_font{padding:0 5px;}.ab-icon.frm_dashicon_font:before{content: \"\\f324\";}.frm_logo_icon:before {content: \"\\e601\";}.frm_required_icon:before {content: \"\\e612\";}.frm_delete_icon:before {content: \"\\e610\" !important;}.frm_move_icon:before {content: \"\\e61a\";}.frm_clear_icon:before {content: \"\\e60a\";}.frm_noclear_icon:before {content: \"\\e60b\";}.frm_duplicate_icon:before {content: \"\\e61b\";}.frm_new_icon:before {content: \"\\e614\";}.frm_tooltip_icon:before {content: \"\\e611\";}.frm_forbid_icon:before {content: \"\\e636\";}.frm_check_icon:before {content: \"\\e605\";}.frm_check1_icon:before {content: \"\\e606\";}.frm_plus_icon:before {content: \"\\e62f\";}.frm_plus1_icon:before {content: \"\\e602\";}.frm_plus2_icon:before {content: \"\\e603\";}.frm_plus3_icon:before {content: \"\\e632\";}.frm_plus4_icon:before {content: \"\\e60f\";}.frm_minus_icon:before {content: \"\\e62e\";}.frm_minus1_icon:before {content: \"\\e600\";}.frm_minus2_icon:before {content: \"\\e604\";}.frm_minus3_icon:before {content: \"\\e633\";}.frm_minus4_icon:before {content: \"\\e613\";}.frm_cancel_icon:before {content: \"\\e607\";}.frm_cancel1_icon:before {content: \"\\e608\";}.frm_arrowup_icon:before {content: \"\\e60d\";}.frm_arrowup1_icon:before {content: \"\\e60e\";}.frm_arrowup2_icon:before {content: \"\\e630\";}.frm_arrowup3_icon:before {content: \"\\e62b\";}.frm_arrowup4_icon:before {content: \"\\e62c\";}.frm_arrowup5_icon:before {content: \"\\e635\";}.frm_arrowup6_icon:before {content: \"\\e62d\";}.frm_arrowdown_icon:before {content: \"\\e609\";}.frm_arrowdown1_icon:before {content: \"\\e60c\";}.frm_arrowdown2_icon:before {content: \"\\e631\";}.frm_arrowdown3_icon:before {content: \"\\e628\";}.frm_arrowdown4_icon:before {content: \"\\e629\";}.frm_arrowdown5_icon:before {content: \"\\e634\";}.frm_arrowdown6_icon:before {content: \"\\e62a\";}.frm_download_icon:before {content: \"\\e615\";}.frm_upload_icon:before {content: \"\\e616\";}.frm_menu_icon:before {content: \"\\e618\";}.frm_twitter_icon:before {content: \"\\e619\";}.frm_sms_icon:before {content: \"\\e61c\";}.frm_pencil_icon:before {content: \"\\e61d\";}.frm_pencil1_icon:before {content: \"\\e61e\";}.frm_paypal_icon:before {content: \"\\e61f\";}.frm_twilio_icon:before {content: \"\\e620\";}.frm_googleplus_icon:before {content: \"\\e621\";}.frm_mailchimp_icon:before {content: \"\\e622\";}.frm_pdf_icon:before {content: \"\\e623\";}.frm_highrise_icon:before {content: \"\\e617\";}.frm_feed_icon:before {content: \"\\e624\";}.frm_facebook_icon:before {content: \"\\e625\";}.frm_email_icon:before {content: \"\\e626\";}.frm_aweber_icon:before {content: \"\\e627\";}.frm_register_icon:before {content: \"\\e637\";}.frm_authorize_icon:before {content: \"\\e900\";}.frm_stripe_icon:before {content: \"\\e902\";}.frm_woocommerce_icon:before {content: \"\\e903\";}.frm_paste_icon:before {content: \"\\e901\";}@-webkit-keyframes passing-through {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30%, 70% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}100% {opacity: 0;-webkit-transform: translateY(-40px);-moz-transform: translateY(-40px);-ms-transform: translateY(-40px);-o-transform: translateY(-40px);transform: translateY(-40px);}}@-moz-keyframes passing-through {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30%, 70% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}100% {opacity: 0;-webkit-transform: translateY(-40px);-moz-transform: translateY(-40px);-ms-transform: translateY(-40px);-o-transform: translateY(-40px);transform: translateY(-40px);}}@keyframes passing-through {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30%, 70% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}100% {opacity: 0;-webkit-transform: translateY(-40px);-moz-transform: translateY(-40px);-ms-transform: translateY(-40px);-o-transform: translateY(-40px);transform: translateY(-40px);}}@-webkit-keyframes slide-in {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}}@-moz-keyframes slide-in {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}}@keyframes slide-in {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}}@-webkit-keyframes pulse {0% {-webkit-transform: scale(1);-moz-transform: scale(1);-ms-transform: scale(1);-o-transform: scale(1);transform: scale(1);}10% {-webkit-transform: scale(1.1);-moz-transform: scale(1.1);-ms-transform: scale(1.1);-o-transform: scale(1.1);transform: scale(1.1);}20% {-webkit-transform: scale(1);-moz-transform: scale(1);-ms-transform: scale(1);-o-transform: scale(1);transform: scale(1);}}@-moz-keyframes pulse {0% {-webkit-transform: scale(1);-moz-transform: scale(1);-ms-transform: scale(1);-o-transform: scale(1);transform: scale(1);}10% {-webkit-transform: scale(1.1);-moz-transform: scale(1.1);-ms-transform: scale(1.1);-o-transform: scale(1.1);transform: scale(1.1);}20% {-webkit-transform: scale(1);-moz-transform: scale(1);-ms-transform: scale(1);-o-transform: scale(1);transform: scale(1);}}@keyframes pulse {0% {-webkit-transform: scale(1);-moz-transform: scale(1);-ms-transform: scale(1);-o-transform: scale(1);transform: scale(1);}10% {-webkit-transform: scale(1.1);-moz-transform: scale(1.1);-ms-transform: scale(1.1);-o-transform: scale(1.1);transform: scale(1.1);}20% {-webkit-transform: scale(1);-moz-transform: scale(1);-ms-transform: scale(1);-o-transform: scale(1);transform: scale(1);}}.frm_dropzone, .frm_dropzone * {box-sizing: border-box;}.frm_dropzone.dz-clickable {min-height: 150px;border: 2px dashed #dfdfdf;background:#ffffff;padding: 20px 20px;border-radius:5px;cursor: pointer;margin-top:5px;line-height:1.42857143;}.frm_dropzone.dz-clickable * {cursor: default;}.frm_dropzone.dz-clickable.frm_single_upload{max-width: 200px;}.frm_dropzone .dz-message{display:none;font-size:20px;text-align: center;margin: .5em 0 1em;}.frm_dropzone.dz-clickable.frm_single_upload .dz-message{margin: 0 0 .5em 0;}.frm_dropzone.dz-clickable .dz-message,.frm_dropzone .frm_upload_icon{display:block;}.frm_dropzone.dz-clickable .dz-message,.frm_dropzone.dz-clickable .dz-message * {cursor: pointer;}#frm_form_editor_container .frm_dropzone.dz-clickable,#frm_form_editor_container .frm_dropzone.dz-clickable *{cursor: default;}.frm_dropzone.dz-started .dz-message {display: none;}.frm_dropzone.dz-drag-hover .dz-message {opacity: 0.5;}.frm_dropzone .frm_upload_icon:before{font-size:40px;}.frm_dropzone .frm_small_text {font-size:14px;}.frm_dropzone.dz-drag-hover {border-style: solid;}.frm_dropzone .dz-preview {position: relative;display: inline-block;vertical-align: top;margin: 16px;min-height: 100px;}.frm_dropzone .dz-preview:hover {z-index: 1000;}.frm_dropzone .dz-preview:hover .dz-details {opacity: 1;}.frm_dropzone .dz-preview.dz-file-preview .dz-image {border-radius: 20px;background: #999;background: linear-gradient(to bottom, #eee, #ddd);}.frm_dropzone .dz-preview.dz-file-preview .dz-details {opacity: 1;}.frm_dropzone .dz-preview.dz-image-preview .dz-details {-webkit-transition: opacity 0.2s linear;-moz-transition: opacity 0.2s linear;-ms-transition: opacity 0.2s linear;-o-transition: opacity 0.2s linear;transition: opacity 0.2s linear;}.frm_dropzone .dz-preview .dz-remove {font-size: 14px;text-align: center;display: block;cursor: pointer;border: none;}.frm_dropzone .dz-preview .dz-remove:hover {text-decoration: underline;}.frm_dropzone .dz-preview:hover .dz-details {opacity: 1;}.frm_dropzone .dz-preview .dz-details {z-index: 20;position: absolute;top: 0;left: 0;opacity: 0;font-size: 13px;min-width: 100%;max-width: 100%;padding: 2em 1em;text-align: center;color: rgba(0, 0, 0, 0.9);line-height: 150%;}.frm_dropzone .dz-preview .dz-details .dz-size {margin-bottom: 1em;font-size: 16px;}.frm_dropzone .dz-preview .dz-details .dz-filename {white-space: nowrap;}.frm_dropzone .dz-preview .dz-details .dz-filename:hover span {border: 1px solid rgba(200, 200, 200, 0.8);background-color: rgba(255, 255, 255, 0.8);}.frm_dropzone .dz-preview .dz-details .dz-filename:not(:hover) {overflow: hidden;text-overflow: ellipsis;}.frm_dropzone .dz-preview .dz-details .dz-filename:not(:hover) span {border: 1px solid transparent;}.frm_dropzone .dz-preview .dz-details .dz-filename span,.frm_dropzone .dz-preview .dz-details .dz-size span {background-color: rgba(255, 255, 255, 0.4);padding: 0 0.4em;border-radius: 3px;}.frm_dropzone .dz-preview .dz-details .dz-filename a{cursor:pointer;}.frm_dropzone .dz-preview:hover .dz-image img {-webkit-transform: scale(1.05, 1.05);-moz-transform: scale(1.05, 1.05);-ms-transform: scale(1.05, 1.05);-o-transform: scale(1.05, 1.05);transform: scale(1.05, 1.05);-webkit-filter: blur(8px);filter: blur(8px);}.frm_dropzone .dz-preview .dz-image {border-radius: 20px;overflow: hidden;width: 120px;height: 120px;position: relative;display: block;z-index: 10;}.frm_dropzone .dz-preview .dz-image img {display: block;margin:0 auto;}.frm_dropzone .dz-preview.dz-success .dz-success-mark {-webkit-animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);-moz-animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);-ms-animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);-o-animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);}.frm_dropzone .dz-preview.dz-error .dz-error-mark {opacity: 1;-webkit-animation: slide-in 3s cubic-bezier(0.77, 0, 0.175, 1);-moz-animation: slide-in 3s cubic-bezier(0.77, 0, 0.175, 1);-ms-animation: slide-in 3s cubic-bezier(0.77, 0, 0.175, 1);-o-animation: slide-in 3s cubic-bezier(0.77, 0, 0.175, 1);animation: slide-in 3s cubic-bezier(0.77, 0, 0.175, 1);}.frm_dropzone .dz-preview .dz-success-mark, .frm_dropzone .dz-preview .dz-error-mark {pointer-events: none;opacity: 0;z-index: 500;position: absolute;display: block;top: 50%;left: 50%;margin-left: -27px;margin-top: -27px;}.frm_dropzone .dz-preview .dz-success-mark svg, .frm_dropzone .dz-preview .dz-error-mark svg {display: block;width: 54px;height: 54px;}.frm_dropzone .dz-preview.dz-processing .dz-progress {opacity: 1;-webkit-transition: all 0.2s linear;-moz-transition: all 0.2s linear;-ms-transition: all 0.2s linear;-o-transition: all 0.2s linear;transition: all 0.2s linear;}.frm_dropzone .dz-preview.dz-complete .dz-progress {opacity: 0;-webkit-transition: opacity 0.4s ease-in;-moz-transition: opacity 0.4s ease-in;-ms-transition: opacity 0.4s ease-in;-o-transition: opacity 0.4s ease-in;transition: opacity 0.4s ease-in;}.frm_dropzone .dz-preview:not(.dz-processing) .dz-progress {-webkit-animation: pulse 6s ease infinite;-moz-animation: pulse 6s ease infinite;-ms-animation: pulse 6s ease infinite;-o-animation: pulse 6s ease infinite;animation: pulse 6s ease infinite;}.frm_dropzone .dz-preview .dz-progress {opacity: 1;z-index: 1000;pointer-events: none;position: absolute;height: 16px;left: 50%;top: 50%;margin-top: -8px;width: 80px;margin-left: -40px;background: rgba(255, 255, 255, 0.9);-webkit-transform: scale(1);border-radius: 8px;overflow: hidden;}.frm_dropzone .dz-preview .dz-progress .dz-upload {background: #333;background: linear-gradient(to bottom, #666, #444);position: absolute;top: 0;left: 0;bottom: 0;width: 0;-webkit-transition: width 300ms ease-in-out;-moz-transition: width 300ms ease-in-out;-ms-transition: width 300ms ease-in-out;-o-transition: width 300ms ease-in-out;transition: width 300ms ease-in-out;}.frm_dropzone .dz-preview.dz-error .dz-error-message {display: block;}.frm_dropzone .dz-preview.dz-error:hover .dz-error-message {opacity: 1;pointer-events: auto;}.frm_dropzone .dz-preview .dz-error-message {pointer-events: none;z-index: 1000;position: absolute;display: block;display: none;opacity: 0;-webkit-transition: opacity 0.3s ease;-moz-transition: opacity 0.3s ease;-ms-transition: opacity 0.3s ease;-o-transition: opacity 0.3s ease;transition: opacity 0.3s ease;border-radius: 8px;font-size: 13px;top: 29px;left: -10px;width: 140px;background: #be2626;background: linear-gradient(to bottom, #be2626, #a92222);padding: 0.5em 1.2em;color: white;}.frm_dropzone .fallback input[type=file]{display:block;}.frm_compact_text{display:none;}.frm_compact .frm_dropzone.dz-clickable{min-height:60px;padding:5px;border:none;background-color:transparent;}.frm_compact .frm_dropzone.dz-clickable.frm_single_upload{max-width:100%;}.frm_compact .frm_compact_text{display:inline;}.frm_compact .frm_dropzone.dz-clickable.frm_single_upload .dz-message,.frm_compact .frm_dropzone.dz-clickable .dz-message{font-size:14px;border:1px solid #dfdfdf;background:#fff;display: inline-block;border-radius: 4px;padding: 6px 11px;box-sizing: border-box;box-shadow: 0 1px 1px #eeeeee;vertical-align: middle;}.frm_compact .frm_dropzone .frm_upload_icon:before{font-size:22px;padding-right:7px;vertical-align: middle;}.frm_compact .frm_dropzone .frm_upload_icon{display:inline;}.frm_compact .frm_dropzone .dz-preview{min-height:20px;max-width:175px;margin:5px;}.frm_compact .frm_dropzone .frm_upload_text,.frm_compact .frm_dropzone .frm_small_text,.frm_compact .frm_dropzone .dz-preview .dz-image,.frm_compact .frm_dropzone .dz-preview .dz-details .dz-size{display:none;}.frm_compact .frm_dropzone .dz-preview.dz-error .dz-error-message{top: -40px;padding: 4px;width: auto;text-align: center;}.frm_compact .frm_dropzone .dz-preview .dz-success-mark,.frm_compact .frm_dropzone .dz-preview .dz-error-mark{margin-left: -16px;margin-top: 0;top: 6px;}.frm_compact .frm_dropzone .dz-preview:hover .dz-error-mark{display:none;}.frm_compact .frm_dropzone .dz-preview .dz-success-mark svg,.frm_compact .frm_dropzone .dz-preview .dz-error-mark svg{height:35px;width:35px;}.frm_compact .frm_dropzone .dz-preview .dz-details{opacity:1;position:relative;padding:5px;}.frm_compact .frm_dropzone .dz-preview .dz-details .dz-filename {overflow: hidden;text-overflow: ellipsis;}.frm_compact .frm_dropzone .dz-preview .dz-details .dz-filename span{border:none;background:transparent;}@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min-resolution: 144dpi){.with_frm_style .chosen-rtl .chosen-search input[type=\"text\"],.with_frm_style .chosen-container-single .chosen-single abbr,.with_frm_style .chosen-container-single .chosen-single div b,.with_frm_style .chosen-container-single .chosen-search input[type=\"text\"],.with_frm_style .chosen-container-multi .chosen-choices .search-choice .search-choice-close,.with_frm_style .chosen-container .chosen-results-scroll-down span,.with_frm_style .chosen-container .chosen-results-scroll-up span{background-image:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite2x.png\') !important;background-size:52px 37px !important;background-repeat:no-repeat !important;}}@media only screen and (max-width: 900px) {.frm_form_field .frm_repeat_grid .frm_form_field.frm_sixth label.frm_primary_label,.frm_form_field .frm_repeat_grid .frm_form_field.frm_seventh label.frm_primary_label,.frm_form_field .frm_repeat_grid .frm_form_field.frm_eighth label.frm_primary_label{display: block !important;}.frm_form_field .frm_repeat_grid .frm_form_field.frm_repeat_buttons.frm_seventh label.frm_primary_label{display:none !important;}}@media only screen and (max-width: 600px) {.frm_form_field.frm_four_col .frm_radio,.frm_form_field.frm_four_col .frm_checkbox{width:48%;margin-right:4%;}.frm_form_field.frm_four_col .frm_radio:nth-child(2n+2),.frm_form_field.frm_four_col .frm_checkbox:nth-child(2n+2){margin-right:0;}.frm_form_field .frm_repeat_grid.frm_first_repeat .frm_form_field.frm_repeat_buttons:not(.frm_fourth):not(.frm_sixth):not(.frm_eighth) label.frm_primary_label{display:none !important;}.frm_form_field .frm_repeat_grid .frm_form_field.frm_fifth label.frm_primary_label{display:block !important;}.frm_form_field .frm_repeat_grid .frm_form_field.frm_repeat_buttons.frm_fifth label.frm_primary_label{display:none !important;}}@media only screen and (max-width: 500px) {.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox,.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_three_col .frm_checkbox{width: auto;margin-right: 0;float: none;display:block;}.frm_form_field input[type=file] {max-width:220px;}.with_frm_style.frm_login_form.frm_inline_login p{clear:both;float:none;}.with_frm_style.frm_login_form.frm_inline_login form{position:static;}.with_frm_style.frm_login_form.frm_inline_login .login-remember{position:static;}.with_frm_style .frm-g-recaptcha > div > div,.with_frm_style .g-recaptcha > div > div{width:inherit !important;display:block;overflow:hidden;max-width:302px;border-right:1px solid #d3d3d3;border-radius:4px;box-shadow:2px 0px 4px -1px rgba(0,0,0,.08);-moz-box-shadow:2px 0px 4px -1px rgba(0,0,0,.08);}.with_frm_style .g-recaptcha iframe,.with_frm_style .frm-g-recaptcha iframe{width:100%;}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("95921", "_transient_frmpro_css", "/* WARNING: Any changes made to this file will be lost when your Formidable settings are updated */\n.frm_hidden,.with_frm_style .frm_button.frm_hidden{display:none;}.with_frm_style fieldset{min-width:0;}legend.frm_hidden{display:none !important;}.frm_transparent{color:transparent;}.input[type=file].frm_transparent:focus, .with_frm_style input[type=file]{background-color:transparent;border:none;outline:none;box-shadow:none;}.with_frm_style input[type=file]{display:initial;}.frm_preview_page:before{content:normal !important;}.frm_preview_page{padding:25px;}.with_frm_style .form-field.frm_col_field{clear:none;float:left;margin-right:20px;}.with_frm_style label.frm_primary_label{max-width:100%;}.with_frm_style .frm_top_container label.frm_primary_label,.with_frm_style .frm_hidden_container label.frm_primary_label,.with_frm_style .frm_pos_top{display:block;float:none;width:auto;}.with_frm_style .frm_inline_container label.frm_primary_label{margin-right:10px;}.with_frm_style .frm_right_container label.frm_primary_label,.with_frm_style .frm_pos_right{display:inline;float:right;margin-left:10px;}.with_frm_style .frm_none_container label.frm_primary_label,.with_frm_style .frm_pos_none,.frm_none_container label.frm_primary_label{display:none;}.with_frm_style .frm_section_heading.frm_hide_section{margin-top:0 !important;}.with_frm_style .frm_hidden_container label.frm_primary_label,.with_frm_style .frm_pos_hidden,.frm_hidden_container label.frm_primary_label{visibility:hidden;}.with_frm_style .frm_description{clear:both;}.with_frm_style .frm_scale{margin-right:10px;text-align:center;float:left;}.with_frm_style .frm_scale input{display:block;}.with_frm_style select[multiple=\"multiple\"]{height:auto;line-height:normal;}.with_frm_style select{white-space:nowrap;}.with_frm_style .frm_catlevel_2,.with_frm_style .frm_catlevel_3,.with_frm_style .frm_catlevel_4,.with_frm_style .frm_catlevel_5{margin-left:18px;}.with_frm_style .wp-editor-container{border:1px solid #e5e5e5;}.with_frm_style .quicktags-toolbar input{font-size:12px !important;}.with_frm_style .wp-editor-container textarea{border:none;}.with_frm_style .auto_width #loginform input,.with_frm_style .auto_width input,.with_frm_style input.auto_width,.with_frm_style select.auto_width,.with_frm_style textarea.auto_width{width:auto;}.with_frm_style .frm_repeat_buttons{white-space:nowrap;}.with_frm_style .frm_button{text-decoration:none;border:1px solid #eee;padding:5px;display:inline;}.with_frm_style .frm_submit{clear:both;}.frm_inline_form .frm_form_field.form-field{margin-right:2.5%;display:inline-block;}.frm_inline_form .frm_submit{display:inline-block;}.with_frm_style.frm_center_submit .frm_submit{text-align:center;}.with_frm_style.frm_center_submit .frm_submit input[type=submit],.with_frm_style.frm_center_submit .frm_submit input[type=button]{margin-bottom:8px !important;}.with_frm_style .frm_submit input[type=submit],.with_frm_style .frm_submit input[type=button]{-webkit-appearance: none;}.with_frm_style.frm_center_submit .frm_submit .frm_ajax_loading{display: block;margin: 0 auto;}.frm_forms.frm_style_formidable-style.with_frm_style{max-width:100%;direction:ltr;}.frm_style_formidable-style.with_frm_style,.frm_style_formidable-style.with_frm_style form,.frm_style_formidable-style.with_frm_style .frm-show-form div.frm_description p {text-align:left;}.frm_style_formidable-style.with_frm_style fieldset{border:0px solid #000000;margin:0;padding:0 0 15px 0;background-color:transparent;}.frm_style_formidable-style.with_frm_style legend + h3,.frm_style_formidable-style.with_frm_style h3.frm_form_title{font-size:20px;color:#444444;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;margin-top:10px;margin-bottom:10px;}.frm_style_formidable-style.with_frm_style .frm-show-form  .frm_section_heading h3{padding:15px 0 3px 0;margin:0;font-size:18px;font-weight:bold;color:#444444;border:none;border-top:2px solid #e8e8e8;background-color:transparent}.frm_style_formidable-style.with_frm_style h3 .frm_after_collapse{display:inline;}.frm_style_formidable-style.with_frm_style h3 .frm_before_collapse{display:none;}.menu-edit #post-body-content .frm_style_formidable-style.with_frm_style .frm_section_heading h3{margin:0;}.frm_style_formidable-style.with_frm_style .frm_section_heading{margin-top:15px;}.frm_style_formidable-style.with_frm_style  .frm-show-form .frm_section_heading .frm_section_spacing,.menu-edit #post-body-content .frm_style_formidable-style.with_frm_style  .frm-show-form .frm_section_heading .frm_section_spacing{margin-bottom:12px;}.frm_style_formidable-style.with_frm_style .frm_repeat_sec{margin-bottom:20px;margin-top:20px;}.frm_style_formidable-style.with_frm_style label.frm_primary_label,.frm_style_formidable-style.with_frm_style.frm_login_form label{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;color:#444444;font-weight:bold;text-align:left;margin:0;padding:0 0 3px 0;width:auto;display:block;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_html_container{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;color:#666666;}.frm_style_formidable-style.with_frm_style .frm_icon_font{color:#444444;}.frm_style_formidable-style.with_frm_style .frm_icon_font.frm_minus_icon:before{content:\"\\e600\";}.frm_style_formidable-style.with_frm_style .frm_icon_font.frm_plus_icon:before{content:\"\\e602\";}.frm_style_formidable-style.with_frm_style .frm_icon_font.frm_minus_icon:before,.frm_style_formidable-style.with_frm_style .frm_icon_font.frm_plus_icon:before{color:#444444;}.frm_style_formidable-style.with_frm_style .frm_trigger.active .frm_icon_font.frm_arrow_icon:before{content:\"\\e62d\";color:#444444;}.frm_style_formidable-style.with_frm_style .frm_trigger .frm_icon_font.frm_arrow_icon:before{content:\"\\e62a\";color:#444444;}.frm_style_formidable-style.with_frm_style .form-field{margin-bottom:20px;}.frm_style_formidable-style.with_frm_style .frm_grid,.frm_style_formidable-style.with_frm_style .frm_grid_first,.frm_style_formidable-style.with_frm_style .frm_grid_odd {margin-bottom:0;}.frm_style_formidable-style.with_frm_style .form-field.frm_section_heading{margin-bottom:0;}.frm_style_formidable-style.with_frm_style p.description,.frm_style_formidable-style.with_frm_style div.description,.frm_style_formidable-style.with_frm_style div.frm_description,.frm_style_formidable-style.with_frm_style .frm-show-form > div.frm_description,.frm_style_formidable-style.with_frm_style .frm_error{margin:0;padding:0;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:12px;color:#666666;font-weight:normal;text-align:left;font-style:normal;max-width:100%;}.frm_style_formidable-style.with_frm_style .frm-show-form div.frm_description p{font-size:14px;color:#666666;margin-top:10px;margin-bottom:25px;}.frm_style_formidable-style.with_frm_style .frm_left_container label.frm_primary_label{float:left;display:inline;width:150px;max-width:33%;margin-right:10px;}.frm_style_formidable-style.with_frm_style .frm_right_container label.frm_primary_label{display:inline;width:150px;max-width:33%;margin-left:10px;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container input:not([type=radio]):not([type=checkbox]),.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container:not(.frm_dynamic_select_container) select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .chosen-container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container input:not([type=radio]):not([type=checkbox]),.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container:not(.frm_dynamic_select_container) select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .chosen-container{max-width:62%;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm_combo_inputs_container .frm_form_field input,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm_combo_inputs_container .frm_form_field select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm_combo_inputs_container .frm_form_field input,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm_combo_inputs_container .frm_form_field select{max-width:100%;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm-g-recaptcha{display:inline-block;}.frm_style_formidable-style.with_frm_style .frm_left_container > p.description::before,.frm_style_formidable-style.with_frm_style .frm_left_container > div.description::before,.frm_style_formidable-style.with_frm_style .frm_left_container > div.frm_description::before,.frm_style_formidable-style.with_frm_style .frm_left_container > .frm_error::before,.frm_style_formidable-style.with_frm_style .frm_right_container > p.description::after,.frm_style_formidable-style.with_frm_style .frm_right_container > div.description::after,.frm_style_formidable-style.with_frm_style .frm_right_container > div.frm_description::after,.frm_style_formidable-style.with_frm_style .frm_right_container > .frm_error::after{content:\'\';display:inline-block;width:150px;max-width:33%;margin-right:10px;}.frm_style_formidable-style.with_frm_style .frm_left_container.frm_inline label.frm_primary_label{max-width:90%;}.frm_style_formidable-style.with_frm_style .form-field.frm_col_field div.frm_description{width:100%;max-width:100%;}.frm_style_formidable-style.with_frm_style .frm_inline_container label.frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_inline_container.frm_dynamic_select_container .frm_opt_container{display:inline;}.frm_style_formidable-style.with_frm_style .frm_inline_container label.frm_primary_label{margin-right:10px;}.frm_style_formidable-style.with_frm_style .frm_pos_right{display:inline;width:150px;}.frm_style_formidable-style.with_frm_style .frm_none_container label.frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_pos_none{display:none;}.frm_style_formidable-style.with_frm_style .frm_scale label{font-weight:normal;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:13px;color:#444444;}.frm_style_formidable-style.with_frm_style .frm_required{color:#B94A48;font-weight:bold;}.frm_style_formidable-style.with_frm_style input[type=text],.frm_style_formidable-style.with_frm_style input[type=password],.frm_style_formidable-style.with_frm_style input[type=email],.frm_style_formidable-style.with_frm_style input[type=number],.frm_style_formidable-style.with_frm_style input[type=url],.frm_style_formidable-style.with_frm_style input[type=tel],.frm_style_formidable-style.with_frm_style input[type=search],.frm_style_formidable-style.with_frm_style select,.frm_style_formidable-style.with_frm_style textarea,.frm_style_formidable-style.with_frm_style .chosen-container{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;margin-bottom:0;}.frm_style_formidable-style.with_frm_style input[type=text],.frm_style_formidable-style.with_frm_style input[type=password],.frm_style_formidable-style.with_frm_style input[type=email],.frm_style_formidable-style.with_frm_style input[type=number],.frm_style_formidable-style.with_frm_style input[type=url],.frm_style_formidable-style.with_frm_style input[type=tel],.frm_style_formidable-style.with_frm_style input[type=phone],.frm_style_formidable-style.with_frm_style input[type=search],.frm_style_formidable-style.with_frm_style select,.frm_style_formidable-style.with_frm_style textarea,.frm_form_fields_style,.frm_style_formidable-style.with_frm_style .frm_scroll_box .frm_opt_container,.frm_form_fields_active_style,.frm_form_fields_error_style,.frm_style_formidable-style.with_frm_style .chosen-container-multi .chosen-choices,.frm_style_formidable-style.with_frm_style .chosen-container-single .chosen-single{color:#555555;background-color:#ffffff;border-color:#cccccc;border-width:1px;border-style:solid;-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;width:100%;max-width:100%;font-size:14px;padding:6px 10px;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;outline:none;font-weight:normal;box-shadow:0 1px 1px rgba(0, 0, 0, 0.075) inset;}.frm_style_formidable-style.with_frm_style input[type=file]::-webkit-file-upload-button{color:#555555;background-color:#ffffff;padding:6px 10px;border-radius:4px;border-color:#cccccc;border-width:1px;border-style:solid;}.frm_style_formidable-style.with_frm_style input[type=text],.frm_style_formidable-style.with_frm_style input[type=password],.frm_style_formidable-style.with_frm_style input[type=email],.frm_style_formidable-style.with_frm_style input[type=number],.frm_style_formidable-style.with_frm_style input[type=url],.frm_style_formidable-style.with_frm_style input[type=tel],.frm_style_formidable-style.with_frm_style input[type=file],.frm_style_formidable-style.with_frm_style input[type=search],.frm_style_formidable-style.with_frm_style select{height:32px;line-height:1.3;}.frm_style_formidable-style.with_frm_style select[multiple=\"multiple\"]{height:auto ;}.frm_style_formidable-style.with_frm_style input[type=file]{color:#555555;padding:0px;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;}.frm_style_formidable-style.with_frm_style input[type=file].frm_transparent{color:transparent;}.frm_style_formidable-style.with_frm_style .frm_default,.frm_style_formidable-style.with_frm_style .placeholder,.frm_style_formidable-style.with_frm_style .chosen-container-multi .chosen-choices li.search-field .default,.frm_style_formidable-style.with_frm_style .chosen-container-single .chosen-default{color:#555555;font-style:italic;}.frm_style_formidable-style.with_frm_style select{width:100%;max-width:100%;}.frm_style_formidable-style.with_frm_style input.frm_other_input:not(.frm_other_full){width:auto ;margin-left:5px ;}.frm_style_formidable-style.with_frm_style .frm_full input.frm_other_input:not(.frm_other_full){margin-left:0 ;margin-top:8px;}.frm_style_formidable-style.with_frm_style .frm_other_container select:not([multiple=\"multiple\"]){width:auto;}.frm_style_formidable-style.with_frm_style .wp-editor-wrap{width:100%;max-width:100%;}.frm_style_formidable-style.with_frm_style .wp-editor-container textarea{border:none;}.frm_style_formidable-style.with_frm_style .mceIframeContainer{background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .auto_width input,.frm_style_formidable-style.with_frm_style input.auto_width,.frm_style_formidable-style.with_frm_style select.auto_width,.frm_style_formidable-style.with_frm_style textarea.auto_width{width:auto;}.frm_style_formidable-style.with_frm_style input[disabled],.frm_style_formidable-style.with_frm_style select[disabled],.frm_style_formidable-style.with_frm_style textarea[disabled],.frm_style_formidable-style.with_frm_style input[readonly],.frm_style_formidable-style.with_frm_style select[readonly],.frm_style_formidable-style.with_frm_style textarea[readonly]{background-color:#ffffff;color:#A1A1A1;border-color:#E5E5E5;}.frm_style_formidable-style.with_frm_style input::placeholder{color:#A1A1A1;}.frm_style_formidable-style.with_frm_style input::-webkit-input-placeholder{color:#A1A1A1;}.frm_style_formidable-style.with_frm_style input::-moz-placeholder{color:#A1A1A1;}.frm_style_formidable-style.with_frm_style input:-ms-input-placeholder{color:#A1A1A1;}.frm_style_formidable-style.with_frm_style input:-moz-placeholder{color:#A1A1A1;}.frm_style_formidable-style.with_frm_style .form-field input:not([type=file]):focus,.frm_style_formidable-style.with_frm_style select:focus,.frm_style_formidable-style.with_frm_style textarea:focus,.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=text],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=password],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=email],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=number],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=url],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=tel],.frm_style_formidable-style.with_frm_style .frm_focus_field input[type=search],.frm_form_fields_active_style,.frm_style_formidable-style.with_frm_style .chosen-container-active .chosen-choices{background-color:#ffffff;border-color:#66afe9;box-shadow:0 1px 1px rgba(0, 0, 0, 0.075) inset, 0 0 8px rgba(102,175,233, 0.6);}.frm_style_formidable-style.with_frm_style .frm_compact .frm_dropzone.dz-clickable .dz-message,.frm_style_formidable-style.with_frm_style input[type=submit],.frm_style_formidable-style.with_frm_style .frm_submit input[type=button],.frm_form_submit_style,.frm_style_formidable-style.with_frm_style.frm_login_form input[type=submit]{width:auto;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;height:auto;line-height:normal;text-align:center;background:#ffffff;border-width:1px;border-color:#cccccc;border-style:solid;color:#444444;cursor:pointer;font-weight:normal;-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;text-shadow:none;padding:6px 11px;-moz-box-sizing:border-box;box-sizing:border-box;-ms-box-sizing:border-box;-moz-box-shadow:0 1px 1px #eeeeee;-webkit-box-shadow:0px 1px 1px #eeeeee;box-shadow:0 1px 1px #eeeeee;-ms-filter:\"progid:DXImageTransform.Microsoft.Shadow(Strength=3, Direction=135, Color=\'#eeeeee\')\";filter:progid:DXImageTransform.Microsoft.Shadow(Strength=3, Direction=135, Color=\'#eeeeee\');margin:10px;margin-left:0;margin-right:0;vertical-align:middle;}.frm_style_formidable-style.with_frm_style input[type=submit]:hover,.frm_style_formidable-style.with_frm_style .frm_submit input[type=button]:hover,.frm_style_formidable-style.with_frm_style.frm_login_form input[type=submit]:hover{background:#efefef;border-color:#cccccc;color:#444444;}.frm_style_formidable-style.with_frm_style.frm_center_submit .frm_submit .frm_ajax_loading{margin-bottom:10px;}.frm_style_formidable-style.with_frm_style input[type=submit]:focus,.frm_style_formidable-style.with_frm_style .frm_submit input[type=button]:focus,.frm_style_formidable-style.with_frm_style.frm_login_form input[type=submit]:focus,.frm_style_formidable-style.with_frm_style input[type=submit]:active,.frm_style_formidable-style.with_frm_style .frm_submit input[type=button]:active,.frm_style_formidable-style.with_frm_style.frm_login_form input[type=submit]:active{background:#efefef;border-color:#cccccc;color:#444444;}.frm_style_formidable-style.with_frm_style a.frm_save_draft{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;font-weight:normal;}.frm_style_formidable-style.with_frm_style #frm_field_cptch_number_container{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:14px;color:#444444;font-weight:bold;clear:both;}.frm_style_formidable-style.with_frm_style .frm_radio{display:block;}.frm_style_formidable-style.with_frm_style .horizontal_radio .frm_radio{margin:0 5px 0 0;}.frm_style_formidable-style.with_frm_style .frm_checkbox{display:block;}.frm_style_formidable-style.with_frm_style .vertical_radio .frm_checkbox,.frm_style_formidable-style.with_frm_style .vertical_radio .frm_radio,.vertical_radio .frm_catlevel_1{display:block;}.frm_style_formidable-style.with_frm_style .horizontal_radio .frm_checkbox,.frm_style_formidable-style.with_frm_style .horizontal_radio .frm_radio,.horizontal_radio .frm_catlevel_1{display:inline-block;}.frm_style_formidable-style.with_frm_style .frm_radio label,.frm_style_formidable-style.with_frm_style .frm_checkbox label{font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-size:13px;color:#444444;font-weight:normal;display:inline;white-space:normal;}.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=text],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=password],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=url],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=tel],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=number],.frm_style_formidable-style.with_frm_style .frm_blank_field input[type=email],.frm_style_formidable-style.with_frm_style .frm_blank_field textarea,.frm_style_formidable-style.with_frm_style .frm_blank_field .mce-edit-area iframe,.frm_style_formidable-style.with_frm_style .frm_blank_field select,.frm_form_fields_error_style,.frm_style_formidable-style.with_frm_style .frm_blank_field .frm-g-recaptcha iframe,.frm_style_formidable-style.with_frm_style .frm_blank_field .g-recaptcha iframe,.frm_style_formidable-style.with_frm_style .frm_blank_field .chosen-container-multi .chosen-choices,.frm_style_formidable-style.with_frm_style .frm_form_field :invalid{color:#444444;background-color:#ffffff;border-color:#B94A48;border-width:1px;border-style:solid;}.frm_style_formidable-style.with_frm_style .frm_error{font-weight:bold;}.frm_style_formidable-style.with_frm_style .frm_blank_field label,.frm_style_formidable-style.with_frm_style .frm_error{color:#B94A48;}.frm_style_formidable-style.with_frm_style .frm_error_style{background-color:#F2DEDE;border:1px solid #EBCCD1;border-radius:4px;color:#B94A48;font-size:14px;margin:0;margin-bottom:20px;}.frm_style_formidable-style.with_frm_style .frm_message,.frm_success_style{border:1px solid #D6E9C6;background-color:#DFF0D8;color:#468847;border-radius:4px;}.frm_style_formidable-style.with_frm_style .frm_message{margin:5px 0 15px;font-size:14px;}.frm_style_formidable-style.with_frm_style .frm-grid td,.frm-grid th{border-color:#cccccc;}.form_results.frm_style_formidable-style.with_frm_style{border:1px solid #cccccc;}.form_results.frm_style_formidable-style.with_frm_style tr td{color:#555555;border-top:1px solid #cccccc;}.form_results.frm_style_formidable-style.with_frm_style tr.frm_even,.frm-grid .frm_even{background-color:#ffffff;}.frm_style_formidable-style.with_frm_style #frm_loading .progress-striped .progress-bar{background-image:linear-gradient(45deg, #cccccc 25%, rgba(0, 0, 0, 0) 25%, rgba(0, 0, 0, 0) 50%, #cccccc 50%, #cccccc 75%, rgba(0, 0, 0, 0) 75%, rgba(0, 0, 0, 0));}.frm_style_formidable-style.with_frm_style #frm_loading .progress-bar{background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .frm_grid,.frm_style_formidable-style.with_frm_style .frm_grid_first,.frm_style_formidable-style.with_frm_style .frm_grid_odd{border-color:#cccccc;}.frm_style_formidable-style.with_frm_style .frm_grid.frm_blank_field,.frm_style_formidable-style.with_frm_style .frm_grid_first.frm_blank_field,.frm_style_formidable-style.with_frm_style .frm_grid_odd.frm_blank_field{background-color:#F2DEDE;border-color:#EBCCD1;}.frm_style_formidable-style.with_frm_style .frm_grid_first,.frm_style_formidable-style.with_frm_style .frm_grid_odd{background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .frm_grid{background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_html_scroll_box{background-color:#ffffff;border-color:#cccccc;border-width:1px;border-style:solid;-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;width:100%;font-size:14px;padding:6px 10px;outline:none;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_total input,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_total textarea{color:#555555;background-color:transparent;border:none;display:inline;padding:0;}.frm_style_formidable-style.with_frm_style .frm_text_block input,.frm_style_formidable-style.with_frm_style .frm_text_block label.frm_primary_label{margin-left:-20px;}.frm_style_formidable-style.with_frm_style .frm_button{padding:6px 11px;-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;font-size:14px;font-family:\"Lucida Grande\",\"Lucida Sans Unicode\",Tahoma,sans-serif;font-weight:normal;color:#444444;background:#ffffff;border-width:1px;border-color:#cccccc;height:auto;}.frm_style_formidable-style.with_frm_style .frm_button .frm_icon_font:before{font-size:14px;}.frm_style_formidable-style.with_frm_style .frm_dropzone{border-color:#cccccc;border-radius:4px;color:#555555;background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .frm_dropzone .frm_upload_icon:before,.frm_style_formidable-style.with_frm_style .frm_dropzone .dz-remove{color:#555555;}.frm_style_formidable-style.with_frm_style .frm_blank_field .frm_dropzone{border-color:#B94A48;color:#444444;background-color:#ffffff;}.frm_style_formidable-style.with_frm_style .chosen-container{font-size:14px;}.frm_style_formidable-style.with_frm_style .chosen-container-single .chosen-single{height:32px;line-height:1.3;}.frm_style_formidable-style.with_frm_style .chosen-container-single .chosen-single div{top:3px;}.frm_style_formidable-style.with_frm_style .chosen-container-single .chosen-search input[type=\"text\"]{height:32px;}.frm_style_formidable-style.with_frm_style .chosen-container-multi .chosen-choices li.search-field input[type=\"text\"]{height:15px;}@media only screen and (max-width: 600px){.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container input:not([type=radio]):not([type=checkbox]),.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container.frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container.g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container .chosen-container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container input:not([type=radio]):not([type=checkbox]),.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container.frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container.g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container .chosen-container{max-width:100%;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_half.frm_left_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_half.frm_left_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half.frm_left_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_last_half.frm_left_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_half.frm_right_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_half.frm_right_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half.frm_right_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_last_half.frm_right_container .frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container .frm_primary_label{max-width:100%;margin-right:0;margin-left:0;padding-right:0;padding-left:0;width:100%;}.frm_style_formidable-style.with_frm_style .frm_repeat_inline,.frm_style_formidable-style.with_frm_style .frm_repeat_grid{margin: 20px 0;}.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half.frm_right_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half.frm_right_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half .frm_right_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half .frm_right_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_last_half.frm_right_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_last_half.frm_right_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_right_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half.frm_left_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half.frm_left_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half .frm_left_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_first_half .frm_left_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_last_half.frm_left_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_last_half.frm_left_container .frm_error,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container div.frm_description,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_half.frm_left_container .frm_error{margin-right:0;margin-left:0;padding-right:0;padding-left:0;}}@media only screen and (max-width: 500px) {.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container input:not([type=radio]):not([type=checkbox]),.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container:not(.frm_dynamic_select_container) select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_left_container .chosen-container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container input:not([type=radio]):not([type=checkbox]),.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container:not(.frm_dynamic_select_container) select,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container textarea,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm_opt_container,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .frm-g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .g-recaptcha,.frm_style_formidable-style.with_frm_style .frm_form_field.frm_right_container .chosen-container{max-width:100%;}.frm_style_formidable-style.with_frm_style .frm_left_container > p.description::before,.frm_style_formidable-style.with_frm_style .frm_left_container > div.description::before,.frm_style_formidable-style.with_frm_style .frm_left_container > div.frm_description::before,.frm_style_formidable-style.with_frm_style .frm_left_container > .frm_error::before,.frm_style_formidable-style.with_frm_style .frm_right_container > p.description::after,.frm_style_formidable-style.with_frm_style .frm_right_container > div.description::after,.frm_style_formidable-style.with_frm_style .frm_right_container > div.frm_description::after,.frm_style_formidable-style.with_frm_style .frm_right_container > .frm_error::after{display:none;}.frm_style_formidable-style.with_frm_style .frm_left_container label.frm_primary_label,.frm_style_formidable-style.with_frm_style .frm_right_container label.frm_primary_label{width:100%;max-width:100%;margin-right:0;margin-left:0;padding-right:0;padding-left:0;}}.frm_ajax_loading{visibility:hidden;width:auto;}.frm_ajax_loading.frm_loading_now{visibility:visible !important;}.frm_form_submit_style{height:auto;}a.frm_save_draft{cursor:pointer;}.horizontal_radio .frm_radio{margin:0 5px 0 0;}.horizontal_radio .frm_checkbox{margin:0;margin-right:5px;}.vertical_radio .frm_checkbox,.vertical_radio .frm_radio,.vertical_radio .frm_catlevel_1{display:block;}.horizontal_radio .frm_checkbox,.horizontal_radio .frm_radio,.horizontal_radio .frm_catlevel_1{display:inline-block;}.frm_file_container .frm_file_link,.with_frm_style .frm_radio label .frm_file_container,.with_frm_style .frm_checkbox label .frm_file_container{display:inline-block;margin:5px;vertical-align:middle;}.with_frm_style .frm_radio input[type=radio]{border-radius:10px;-webkit-appearance:radio;}.with_frm_style .frm_checkbox input[type=checkbox]{border-radius:0;-webkit-appearance:checkbox;}.with_frm_style .frm_radio input[type=radio],.with_frm_style .frm_checkbox input[type=checkbox]{margin-right:5px;width:auto;border:none;vertical-align:baseline;}.with_frm_style :invalid,.with_frm_style :-moz-submit-invalid,.with_frm_style :-moz-ui-invalid{box-shadow:none;}.with_frm_style .frm_error_style img{padding-right:10px;vertical-align:middle;border:none;}.with_frm_style .frm_trigger{cursor:pointer;}.with_frm_style .frm_error_style,.with_frm_style .frm_message,.frm_success_style{-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;padding:15px;}.with_frm_style .frm_message p{margin-bottom:5px;}.frm_form_fields_style,.frm_form_fields_active_style,.frm_form_fields_error_style,.frm_form_submit_style{width:auto;}.with_frm_style .frm_trigger span{float:left;}.with_frm_style table.frm-grid,#content .with_frm_style table.frm-grid{border-collapse:collapse;border:none;}.frm-grid td,.frm-grid th{padding:5px;border-width:1px;border-style:solid;border-color:#cccccc;border-top:none;border-left:none;border-right:none;}table.form_results.with_frm_style{border:1px solid #ccc;}table.form_results.with_frm_style tr td{text-align:left;color:#555555;padding:7px 9px;border-top:1px solid #cccccc;}table.form_results.with_frm_style tr.frm_even,.frm-grid .frm_even{background-color:#fff;}table.form_results.with_frm_style tr.frm_odd,.frm-grid .frm_odd{background-color:#ffffff;}.frm_collapse .ui-icon{display:inline-block;}.frm_toggle_container{border:1px solid transparent;}.frm_toggle_container ul{margin:5px 0;padding-left:0;list-style-type:none;}.frm_toggle_container .frm_month_heading{text-indent:15px;}.frm_toggle_container .frm_month_listing{margin-left:40px;}#frm_loading{display:none;position:fixed;top:0;left:0;width:100%;height:100%;z-index:99999;}#frm_loading h3{font-weight:500;padding-bottom:15px;color:#fff;font-size:24px;}#frm_loading_content{position:fixed;top:20%;left:33%;width:33%;text-align:center;padding-top:30px;font-weight:bold;z-index:9999999;}#frm_loading img{max-width:100%;}#frm_loading .progress{border-radius:4px;box-shadow:0 1px 2px rgba(0, 0, 0, 0.1) inset;height:20px;margin-bottom:20px;overflow:hidden;}#frm_loading .progress.active .progress-bar{animation:2s linear 0s normal none infinite progress-bar-stripes;}#frm_loading .progress-striped .progress-bar{background-image:linear-gradient(45deg, #cccccc 25%, rgba(0, 0, 0, 0) 25%, rgba(0, 0, 0, 0) 50%, #cccccc 50%, #cccccc 75%, rgba(0, 0, 0, 0) 75%, rgba(0, 0, 0, 0));background-size:40px 40px;}#frm_loading .progress-bar{background-color:#ffffff;box-shadow:0 -1px 0 rgba(0, 0, 0, 0.15) inset;float:left;height:100%;line-height:20px;text-align:center;transition:width 0.6s ease 0s;width:100%;}.frm_pagination_cont ul.frm_pagination{display:inline-block;list-style:none;margin-left:0 !important;}.frm_pagination_cont ul.frm_pagination > li{display:inline;list-style:none;margin:2px;background-image:none;}ul.frm_pagination > li.active a{text-decoration:none;}.frm_pagination_cont ul.frm_pagination > li:first-child{margin-left:0;}.archive-pagination.frm_pagination_cont ul.frm_pagination > li{margin:0;}.frmcal{padding-top:30px;}.frmcal-title{font-size:116%;}.frmcal table.frmcal-calendar{border-collapse:collapse;margin-top:20px;color:#555555;}.frmcal table.frmcal-calendar,.frmcal table.frmcal-calendar tbody tr td{border:1px solid #cccccc;}.frmcal table.frmcal-calendar,.frmcal,.frmcal-header{width:100%;}.frmcal-header{text-align:center;}.frmcal-prev{margin-right:10px;}.frmcal-prev,.frmcal-dropdown{float:left;}.frmcal-dropdown{margin-left:5px;}.frmcal-next{float:right;}.frmcal table.frmcal-calendar thead tr th{text-align:center;padding:2px 4px;}.frmcal table.frmcal-calendar tbody tr td{height:110px;width:14.28%;vertical-align:top;padding:0 !important;color:#555555;font-size:12px;}table.frmcal-calendar .frmcal_date{background-color:#ffffff;padding:0 5px;text-align:right;-moz-box-shadow:0 2px 5px #cccccc;-webkit-box-shadow:0 2px 5px #cccccc;box-shadow:0 2px 5px #cccccc;-ms-filter:\"progid:DXImageTransform.Microsoft.Shadow(Strength=4, Direction=180, Color=\'#cccccc\')\";filter:progid:DXImageTransform.Microsoft.Shadow(Strength=4, Direction=180, Color=\'#cccccc\');}table.frmcal-calendar .frmcal-today .frmcal_date{background-color:#ffffff;padding:0 5px;text-align:right;-moz-box-shadow:0 2px 5px #66afe9;-webkit-box-shadow:0 2px 5px #66afe9;box-shadow:0 2px 5px #66afe9;-ms-filter:\"progid:DXImageTransform.Microsoft.Shadow(Strength=4, Direction=180, Color=\'#66afe9\')\";filter:progid:DXImageTransform.Microsoft.Shadow(Strength=4, Direction=180, Color=\'#66afe9\');}.frmcal_num{display:inline;}.frmcal-content{padding:2px 4px;}.frm_image_from_url{height:50px;}.frm-loading-img{background:url(//www.dgtal-mind.com/wp-content/plugins/formidable/images/ajax_loader.gif) no-repeat center center;padding:6px 12px;}#ui-datepicker-div{display:none;z-index:999999 !important;}.frm_form_fields div.rating-cancel{display:none !important;}.frm_form_fields div.rating-cancel,.frm_form_fields div.star-rating{float:left;width:17px;height:17px;font-size:16px;line-height:normal;cursor:pointer;display:block;background:transparent;overflow:hidden;clear:none;}.frm_form_fields div.rating-cancel a:before{font:16px/1 \'dashicons\';content:\'\\f460\';color:#CDCDCD;}.frm_form_fields div.star-rating:before,.frm_form_fields div.star-rating a:before{font:16px/1 \'dashicons\';content:\'\\f154\';color:#F0AD4E;}.frm_form_fields div.rating-cancel a,.frm_form_fields div.star-rating a{display:block;width:16px;height:100%;border:0;}.frm_form_fields div.star-rating-on:before,.frm_form_fields div.star-rating-on a:before{content:\'\\f155\';}.frm_form_fields div.star-rating-hover:before,.frm_form_fields div.star-rating-hover a:before{content:\'\\f155\';}.frm_form_fields div.frm_half_star:before,.frm_form_fields div.frm_half_star a:before{content:\'\\f459\';}.frm_form_fields div.rating-cancel.star-rating-hover a:before{color:#B63E3F;}.frm_form_fields div.star-rating-readonly,.frm_form_fields div.star-rating-readonly a{cursor:default !important;}.frm_form_fields div.star-rating{overflow:hidden!important;}.with_frm_style .frm_form_field{clear:both;}.frm_form_field.frm_right_half,.frm_form_field.frm_right_third,.frm_form_field.frm_right_two_thirds,.frm_form_field.frm_right_fourth,.frm_form_field.frm_right_fifth,.frm_form_field.frm_right_inline,.frm_form_field.frm_last_half,.frm_form_field.frm_last_third,.frm_form_field.frm_last_two_thirds,.frm_form_field.frm_last_fourth,.frm_form_field.frm_last_fifth,.frm_form_field.frm_last_sixth,.frm_form_field.frm_last_seventh,.frm_form_field.frm_last_eighth,.frm_form_field.frm_last_inline,.frm_form_field.frm_last,.frm_form_field.frm_half,.frm_submit.frm_half,.frm_form_field.frm_third,.frm_submit.frm_third,.frm_form_field.frm_two_thirds,.frm_form_field.frm_fourth,.frm_submit.frm_fourth,.frm_form_field.frm_three_fourths,.frm_form_field.frm_fifth,.frm_submit.frm_fifth,.frm_form_field.frm_two_fifths,.frm_form_field.frm_three_fifths,.frm_form_field.frm_four_fifths,.frm_form_field.frm_sixth,.frm_submit.frm_sixth,.frm_form_field.frm_seventh,.frm_submit.frm_seventh,.frm_form_field.frm_eighth,.frm_submit.frm_eighth,.frm_form_field.frm_inline,.frm_submit.frm_inline{clear:none;float:left;margin-left:2.5%;}.frm_form_field.frm_left_half,.frm_form_field.frm_left_third,.frm_form_field.frm_left_two_thirds,.frm_form_field.frm_left_fourth,.frm_form_field.frm_left_fifth,.frm_form_field.frm_left_inline,.frm_form_field.frm_first_half,.frm_form_field.frm_first_third,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_first_fourth,.frm_form_field.frm_first_fifth,.frm_form_field.frm_first_sixth,.frm_form_field.frm_first_seventh,.frm_form_field.frm_first_eighth,.frm_form_field.frm_first_inline,.frm_form_field.frm_first{clear:left;float:left;margin-left:0;}.frm_form_field.frm_alignright{float:right !important;}.frm_form_field.frm_left_half,.frm_form_field.frm_right_half,.frm_form_field.frm_first_half,.frm_form_field.frm_last_half,.frm_form_field.frm_half,.frm_submit.frm_half{width:48.75%;}.frm_form_field.frm_left_third,.frm_form_field.frm_third,.frm_submit.frm_third,.frm_form_field.frm_right_third,.frm_form_field.frm_first_third,.frm_form_field.frm_last_third{width:31.66%;}.frm_form_field.frm_left_two_thirds,.frm_form_field.frm_right_two_thirds,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_last_two_thirds,.frm_form_field.frm_two_thirds{width:65.82%;}.frm_form_field.frm_left_fourth,.frm_form_field.frm_fourth,.frm_submit.frm_fourth,.frm_form_field.frm_right_fourth,.frm_form_field.frm_first_fourth,.frm_form_field.frm_last_fourth{width:23.12%;}.frm_form_field.frm_three_fourths{width:74.36%;}.frm_form_field.frm_left_fifth,.frm_form_field.frm_fifth,.frm_submit.frm_fifth,.frm_form_field.frm_right_fifth,.frm_form_field.frm_first_fifth,.frm_form_field.frm_last_fifth{width:18%;}.frm_form_field.frm_two_fifths {width:38.5%;}.frm_form_field.frm_three_fifths {width:59%;}.frm_form_field.frm_four_fifths {width:79.5%;}.frm_form_field.frm_sixth,.frm_submit.frm_sixth,.frm_form_field.frm_first_sixth,.frm_form_field.frm_last_sixth{width:14.58%;}.frm_form_field.frm_seventh,.frm_submit.frm_seventh,.frm_form_field.frm_first_seventh,.frm_form_field.frm_last_seventh{width:12.14%;}.frm_form_field.frm_eighth,.frm_submit.frm_eighth,.frm_form_field.frm_first_eighth,.frm_form_field.frm_last_eighth{width:10.31%;}.frm_form_field.frm_left_inline,.frm_form_field.frm_first_inline,.frm_form_field.frm_inline,.frm_submit.frm_inline,.frm_form_field.frm_right_inline,.frm_form_field.frm_last_inline{width:auto;}.frm_full,.frm_full .wp-editor-wrap,.frm_full input:not([type=\'checkbox\']):not([type=\'radio\']):not([type=\'button\']),.frm_full select,.frm_full textarea{width:100% !important;}.frm_full .wp-editor-wrap input{width:auto !important;}@media only screen and (max-width: 600px) {.frm_form_field.frm_half,.frm_submit.frm_half,.frm_form_field.frm_left_half,.frm_form_field.frm_right_half,.frm_form_field.frm_first_half,.frm_form_field.frm_last_half,.frm_form_field.frm_first_third,.frm_form_field.frm_third,.frm_submit.frm_third,.frm_form_field.frm_last_third,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_last_two_thirds,.frm_form_field.frm_two_thirds,.frm_form_field.frm_left_fourth,.frm_form_field.frm_fourth,.frm_submit.frm_fourth,.frm_form_field.frm_right_fourth,.frm_form_field.frm_first_fourth,.frm_form_field.frm_last_fourth,.frm_form_field.frm_three_fourths,.frm_form_field.frm_fifth,.frm_submit.frm_fifth,.frm_form_field.frm_two_fifths,.frm_form_field.frm_three_fifths,.frm_form_field.frm_four_fifths,.frm_form_field.frm_sixth,.frm_submit.frm_sixth,.frm_form_field.frm_seventh,.frm_submit.frm_seventh,.frm_form_field.frm_eighth,.frm_submit.frm_eighth,.frm_form_field.frm_first_inline,.frm_form_field.frm_inline,.frm_submit.frm_inline,.frm_form_field.frm_last_inline{width:100%;margin-left:0;margin-right:0;clear:both;float:none;}}.frm_form_field.frm_left_container label.frm_primary_label{float:left;display:inline;max-width:33%;margin-right:10px;}.frm_form_field.frm_left_container input:not([type=radio]):not([type=checkbox]),.frm_form_field.frm_left_container:not(.frm_dynamic_select_container) select,.frm_form_field.frm_left_container textarea,.frm_form_field.frm_left_container .wp-editor-wrap,.frm_form_field.frm_left_container .frm_opt_container,.frm_form_field.frm_left_container .frm_dropzone,.frm_form_field.frm_left_container .frm-g-recaptcha,.frm_form_field.frm_left_container .g-recaptcha,.frm_form_field.frm_left_container .chosen-container,.frm_form_field.frm_left_container .frm_combo_inputs_container,.frm_form_field.frm_right_container input:not([type=radio]):not([type=checkbox]),.frm_form_field.frm_right_container:not(.frm_dynamic_select_container) select,.frm_form_field.frm_right_container textarea,.frm_form_field.frm_right_container .wp-editor-wrap,.frm_form_field.frm_right_container .frm_opt_container,.frm_form_field.frm_right_container .frm_dropzone,.frm_form_field.frm_right_container .frm-g-recaptcha,.frm_form_field.frm_right_container .g-recaptcha,.frm_form_field.frm_right_container .chosen-container,.frm_form_field.frm_right_container .frm_combo_inputs_container{max-width:62%;}.frm_form_field.frm_left_container .frm_combo_inputs_container input,.frm_form_field.frm_left_container .frm_combo_inputs_container select,.frm_form_field.frm_right_container .frm_combo_inputs_container input,.frm_form_field.frm_right_container .frm_combo_inputs_container select{max-width:100%;}.frm_form_field.frm_left_container .frm_opt_container,.frm_form_field.frm_right_container .frm_opt_container,.frm_form_field.frm_inline_container .frm_opt_container,.frm_form_field.frm_left_container .frm_combo_inputs_container,.frm_form_field.frm_right_container .frm_combo_inputs_container,.frm_form_field.frm_inline_container .frm_combo_inputs_container,.frm_form_field.frm_left_container .wp-editor-wrap,.frm_form_field.frm_right_container .wp-editor-wrap,.frm_form_field.frm_inline_container .wp-editor-wrap,.frm_form_field.frm_left_container .frm_dropzone,.frm_form_field.frm_right_container .frm_dropzone,.frm_form_field.frm_inline_container .frm_dropzone,.frm_form_field.frm_left_container .frm-g-recaptcha,.frm_form_field.frm_right_container .frm-g-recaptcha,.frm_form_field.frm_inline_container .frm-g-recaptcha,.frm_form_field.frm_left_container .g-recaptcha,.frm_form_field.frm_right_container .g-recaptcha,.frm_form_field.frm_inline_container .g-recaptcha{display:inline-block;}.frm_form_field.frm_left_half.frm_left_container .frm_primary_label,.frm_form_field.frm_right_half.frm_left_container .frm_primary_label,.frm_form_field.frm_left_half.frm_right_container .frm_primary_label,.frm_form_field.frm_right_half.frm_right_container .frm_primary_label,.frm_form_field.frm_first_half.frm_left_container .frm_primary_label,.frm_form_field.frm_last_half.frm_left_container .frm_primary_label,.frm_form_field.frm_first_half.frm_right_container .frm_primary_label,.frm_form_field.frm_last_half.frm_right_container .frm_primary_label,.frm_form_field.frm_half.frm_right_container .frm_primary_label,.frm_form_field.frm_half.frm_left_container .frm_primary_label{-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;max-width:33%;}.wp-editor-wrap *,.wp-editor-wrap *:after,.wp-editor-wrap *:before{-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;}.with_frm_style .frm_grid,.with_frm_style .frm_grid_first,.with_frm_style .frm_grid_odd{clear:both;margin-bottom:0 !important;padding:5px;border-width:1px;border-style:solid;border-color:#cccccc;border-left:none;border-right:none;}.with_frm_style .frm_grid,.with_frm_style .frm_grid_odd{border-top:none;}.frm_grid .frm_error,.frm_grid_first .frm_error,.frm_grid_odd .frm_error{display:none;}.frm_grid:after,.frm_grid_first:after,.frm_grid_odd:after{visibility:hidden;display:block;font-size:0;content:\" \";clear:both;height:0;}.frm_grid_first{margin-top:20px;}.frm_grid_first,.frm_grid_odd{background-color:#ffffff;}.frm_grid{background-color:#ffffff;}.frm_grid .frm_primary_label,.frm_grid_first .frm_primary_label,.frm_grid_odd .frm_primary_label,.frm_grid .frm_radio,.frm_grid_first .frm_radio,.frm_grid_odd .frm_radio,.frm_grid .frm_checkbox,.frm_grid_first .frm_checkbox,.frm_grid_odd .frm_checkbox{float:left !important;display:block;margin-top:0;margin-left:0 !important;}.frm_grid_first .frm_radio label,.frm_grid .frm_radio label,.frm_grid_odd .frm_radio label,.frm_grid_first .frm_checkbox label,.frm_grid .frm_checkbox label,.frm_grid_odd .frm_checkbox label{visibility:hidden;white-space:nowrap;text-align:left;}.frm_grid_first .frm_radio label input,.frm_grid .frm_radio label input,.frm_grid_odd .frm_radio label input,.frm_grid_first .frm_checkbox label input,.frm_grid .frm_checkbox label input,.frm_grid_odd .frm_checkbox label input{visibility:visible;margin:2px 0 0;float:right;}.frm_grid .frm_radio,.frm_grid_first .frm_radio,.frm_grid_odd .frm_radio,.frm_grid .frm_checkbox,.frm_grid_first .frm_checkbox,.frm_grid_odd .frm_checkbox{display:inline;}.frm_grid_2 .frm_radio,.frm_grid_2 .frm_checkbox,.frm_grid_2 label.frm_primary_label{width:48% !important;}.frm_grid_2 .frm_radio,.frm_grid_2 .frm_checkbox{margin-right:4%;}.frm_grid_3 .frm_radio,.frm_grid_3 .frm_checkbox,.frm_grid_3 label.frm_primary_label{width:30% !important;}.frm_grid_3 .frm_radio,.frm_grid_3 .frm_checkbox{margin-right:3%;}.frm_grid_4 .frm_radio,.frm_grid_4 .frm_checkbox{width:20% !important;}.frm_grid_4 label.frm_primary_label{width:28% !important;}.frm_grid_4 .frm_radio,.frm_grid_4 .frm_checkbox{margin-right:4%;}.frm_grid_5 label.frm_primary_label,.frm_grid_7 label.frm_primary_label{width:24% !important;}.frm_grid_5 .frm_radio,.frm_grid_5 .frm_checkbox{width:17% !important;margin-right:2%;}.frm_grid_6 label.frm_primary_label{width:25% !important;}.frm_grid_6 .frm_radio,.frm_grid_6 .frm_checkbox{width:14% !important;margin-right:1%;}.frm_grid_7 label.frm_primary_label{width:22% !important;}.frm_grid_7 .frm_radio,.frm_grid_7 .frm_checkbox{width:12% !important;margin-right:1%;}.frm_grid_8 label.frm_primary_label{width:23% !important;}.frm_grid_8 .frm_radio,.frm_grid_8 .frm_checkbox{width:10% !important;margin-right:1%;}.frm_grid_9 label.frm_primary_label{width:20% !important;}.frm_grid_9 .frm_radio,.frm_grid_9 .frm_checkbox{width:9% !important;margin-right:1%;}.frm_grid_10 label.frm_primary_label{width:19% !important;}.frm_grid_10 .frm_radio,.frm_grid_10 .frm_checkbox{width:8% !important;margin-right:1%;}.with_frm_style .frm_inline_container.frm_grid_first label.frm_primary_label,.with_frm_style .frm_inline_container.frm_grid label.frm_primary_label,.with_frm_style .frm_inline_container.frm_grid_odd label.frm_primary_label,.with_frm_style .frm_inline_container.frm_grid_first .frm_opt_container,.with_frm_style .frm_inline_container.frm_grid .frm_opt_container,.with_frm_style .frm_inline_container.frm_grid_odd .frm_opt_container{margin-right:0;}.with_frm_style .frm_inline_container.frm_scale_container label.frm_primary_label{float:left;}.with_frm_style .frm_other_input.frm_other_full{margin-top:10px;}.with_frm_style .frm_repeat_sec{margin-bottom:20px;margin-top:20px;}.with_frm_style .frm_repeat_inline{clear:both;}.frm_form_field .frm_repeat_sec .frm_add_form_row{opacity:0;display:none;*display:inline;display:inline\\0/; -moz-transition: opacity .15s ease-in-out;-webkit-transition: opacity .15s ease-in-out;transition: opacity .15s ease-in-out;pointer-events:none;}.frm_section_heading div.frm_repeat_sec:last-child .frm_add_form_row{opacity:100;display:inline;pointer-events:auto;}.frm_form_field .frm_repeat_grid .frm_form_field label.frm_primary_label{display:none !important;}.frm_form_field .frm_repeat_grid.frm_first_repeat .frm_form_field label.frm_primary_label{display:inherit !important;}.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_four_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox,.frm_form_field.frm_three_col .frm_checkbox,.frm_form_field.frm_four_col .frm_checkbox{float:left;}.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox{width:48%;margin-right:4%;}.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_three_col .frm_checkbox{width:30%;margin-right:5%;}.frm_form_field.frm_four_col .frm_radio,.frm_form_field.frm_four_col .frm_checkbox{width:22%;margin-right:4%;}.frm_form_field.frm_two_col .frm_radio:nth-child(2n+2),.frm_form_field.frm_two_col .frm_checkbox:nth-child(2n+2),.frm_form_field.frm_three_col .frm_radio:nth-child(3n+3),.frm_form_field.frm_three_col .frm_checkbox:nth-child(3n+3),.frm_form_field.frm_four_col .frm_radio:nth-child(4n+4),.frm_form_field.frm_four_col .frm_checkbox:nth-child(4n+4){margin-right:0;}.frm_form_field.frm_scroll_box .frm_opt_container{height:100px;overflow:auto;}.frm_form_field.frm_html_scroll_box{height:100px;overflow:auto;background-color:#ffffff;border-color:#cccccc;border-width:1px;border-style:solid;-moz-border-radius:4px;-webkit-border-radius:4px;border-radius:4px;width:100%;max-width:100%;font-size:14px;padding:6px 10px;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;outline:none;font-weight:normal;box-shadow:0 1px 1px rgba(0, 0, 0, 0.075) inset;}.frm_form_field.frm_two_col .frm_opt_container:after,.frm_form_field.frm_three_col .frm_opt_container:after,.frm_form_field.frm_four_col .frm_opt_container:after{content:\".\";display:block;clear:both;visibility:hidden;line-height:0;height:0;}.frm_form_field.frm_total input,.frm_form_field.frm_total textarea{opacity:1;background-color:transparent !important;border:none !important;font-weight:bold;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none !important;display:inline;-moz-appearance:textfield;padding:0;}.frm_form_field.frm_total input::-webkit-outer-spin-button,.frm_form_field.frm_total input::-webkit-inner-spin-button {-webkit-appearance: none;}.frm_form_field.frm_total input:focus,.frm_form_field.frm_total textarea:focus{background-color:transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;}.frm_text_block{margin-left:20px;}.frm_text_block input,.frm_text_block label.frm_primary_label{margin-left:-20px;}.frm_text_block .frm_checkbox input[type=checkbox],.frm_text_block .frm_radio input[type=radio]{margin-right:4px;}.frm_form_field.frm_capitalize input,.frm_form_field.frm_capitalize select,.frm_form_field.frm_capitalize .frm_opt_container label{text-transform:capitalize;}.frm_clearfix:after{content:\".\";display:block;clear:both;visibility:hidden;line-height:0;height:0;}.frm_clearfix{display:inline-block;}html[xmlns] .frm_clearfix{display:block;}* html .frm_clearfix{height:1%;}.with_frm_style.frm_login_form,.with_frm_style.frm_login_form form{clear:both;}.with_frm_style.frm_login_form.frm_inline_login .login-remember input{vertical-align:baseline;}.with_frm_style.frm_login_form.frm_inline_login .login-submit{float:left;}.with_frm_style.frm_login_form.frm_inline_login label{display:inline;}.with_frm_style.frm_login_form.frm_inline_login .login-username,.with_frm_style.frm_login_form.frm_inline_login .login-password,.with_frm_style.frm_login_form.frm_inline_login .login-remember{float:left;margin-right:5px;}.with_frm_style.frm_login_form.frm_inline_login form{position:relative;clear:none;}.with_frm_style.frm_login_form.frm_inline_login .login-remember{position:absolute;top:35px;}.with_frm_style.frm_login_form.frm_inline_login input[type=submit]{margin:0 !important;}.with_frm_style.frm_login_form.frm_no_labels .login-username label,.with_frm_style.frm_login_form.frm_no_labels .login-password label{display:none;}.with_frm_style .frm-open-login{float:left;margin-right:15px;}.with_frm_style .frm-open-login a{text-decoration:none;border:none;outline:none;}.with_frm_style.frm_slide.frm_login_form form{display:none;}.with_frm_style .chosen-container{font-size:14px;position:relative;display:inline-block;zoom:1;vertical-align:middle;width:100% !important;-webkit-user-select:none;-moz-user-select:none;user-select:none;*display:inline;}.with_frm_style .chosen-container .chosen-drop{background:#fff;border:1px solid #aaa;border-top:0;position:absolute;top:100%;left:-9999px;box-shadow:0 4px 5px rgba(0,0,0,.15);z-index:1010;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;width:100%;}.with_frm_style .chosen-container.chosen-with-drop .chosen-drop{left:0;}.with_frm_style .chosen-container a{cursor:pointer;}.with_frm_style .chosen-container-single .chosen-single{position:relative;display:block;overflow:hidden;padding:0 0 0 8px;height:25px;background:-webkit-gradient(linear, 50% 0%, 50% 100%, color-stop(20%, #ffffff), color-stop(50%, #f6f6f6), color-stop(52%, #eeeeee), color-stop(100%, #f4f4f4));background:-webkit-linear-gradient(top, #ffffff 20%, #f6f6f6 50%, #eeeeee 52%, #f4f4f4 100%);background:-moz-linear-gradient(top, #ffffff 20%, #f6f6f6 50%, #eeeeee 52%, #f4f4f4 100%);background:-o-linear-gradient(top, #ffffff 20%, #f6f6f6 50%, #eeeeee 52%, #f4f4f4 100%);background:linear-gradient(top, #ffffff 20%, #f6f6f6 50%, #eeeeee 52%, #f4f4f4 100%);background-clip:padding-box;box-shadow:0 0 3px white inset, 0 1px 1px rgba(0, 0, 0, 0.1);text-decoration:none;white-space:nowrap;line-height:24px;}.with_frm_style .chosen-container-single .chosen-single span{margin-right:26px;display:block;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;}.with_frm_style .chosen-container-single .chosen-single-with-deselect span{margin-right:38px;}.with_frm_style .chosen-container-single .chosen-single abbr{display:block;position:absolute;right:26px;top:6px;width:12px;height:12px;font-size:1px;background:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') -42px 1px no-repeat;}.with_frm_style .chosen-container-single .chosen-single abbr:hover{background-position:-42px -10px;}.with_frm_style .chosen-container-single.chosen-disabled .chosen-single abbr:hover{background-position:-42px -10px;}.with_frm_style .chosen-container-single .chosen-single div{position:absolute;right:0;top:0;display:block;height:100%;width:18px;}.with_frm_style .chosen-container-single .chosen-single div b{background:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') no-repeat 0 2px;display:block;width:100%;height:100%;}.with_frm_style .chosen-container-single .chosen-search{padding:3px 4px;position:relative;margin:0;white-space:nowrap;z-index:1010;}.with_frm_style .chosen-container-single .chosen-search input[type=\"text\"]{-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;width:100% !important;max-width:100% !important;height:auto;background:white url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') no-repeat 100% -20px;background:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') no-repeat 100% -20px;font-size:1em;font-family:sans-serif;line-height:normal;border-radius:0;}.with_frm_style .chosen-container-single .chosen-drop{margin-top:-1px;border-radius:0 0 4px 4px;background-clip:padding-box;}.with_frm_style .chosen-container-single.chosen-container-single-nosearch .chosen-search{position:absolute;left:-9999px;}.with_frm_style .chosen-container .chosen-results{cursor:text;overflow-x:hidden;overflow-y:auto;position:relative;margin:0 4px 4px 0;padding:0 0 0 4px;max-height:240px;word-wrap:break-word;-webkit-overflow-scrolling:touch;}.with_frm_style .chosen-container .chosen-results li:before{background:none;}.with_frm_style .chosen-container .chosen-results li{display:none;margin:0;padding:5px 6px;list-style:none;line-height:15px;-webkit-touch-callout:none;}.with_frm_style .chosen-container .chosen-results li.active-result{display:list-item;cursor:pointer;}.with_frm_style .chosen-container .chosen-results li.disabled-result{display:list-item;color:#ccc;cursor:default;}.with_frm_style .chosen-container .chosen-results li.highlighted{background-color:#3875d7;color:#fff;}.with_frm_style .chosen-container .chosen-results li.no-results{display:list-item;background:#f4f4f4;}.with_frm_style .chosen-container .chosen-results li.group-result{display:list-item;font-weight:bold;cursor:default;}.with_frm_style .chosen-container .chosen-results li.group-option{padding-left:15px;}.with_frm_style .chosen-container .chosen-results li em{font-style:normal;text-decoration:underline;}.with_frm_style .chosen-container-multi .chosen-choices{position:relative;overflow:hidden;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;margin:0;padding:0 5px;width:100%;height:auto !important;height:1%;cursor:text;}.with_frm_style .chosen-container-multi .chosen-choices li{float:left;list-style:none;}.with_frm_style .chosen-container-multi .chosen-choices li.search-field{margin:0;padding:0;white-space:nowrap;}.with_frm_style .chosen-container-multi .chosen-choices li.search-field input[type=\"text\"]{margin:1px 0;padding:0;height:25px;outline:0;border:0 !important;background:transparent !important;box-shadow:none;color:#666;font-size:100%;font-family:sans-serif;line-height:normal;border-radius:0;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice{position:relative;margin:3px 5px 3px 0;padding:3px 20px 3px 5px;border:1px solid #aaa;max-width:100%;border-radius:3px;background-color:#eee;background-size:100% 19px;background-repeat:repeat-x;background-clip:padding-box;box-shadow:0 0 2px white inset, 0 1px 0 rgba(0, 0, 0, 0.05);color:#333;line-height:13px;cursor:default;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice .search-choice-close{position:absolute;top:4px;right:3px;display:block;width:12px;height:12px;background:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') -42px 1px no-repeat;font-size:1px;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice .search-choice-close:hover{background-position:-42px -10px;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice-disabled{padding-right:5px;border:1px solid #ccc;background-color:#e4e4e4;color:#666;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice-focus{background:#d4d4d4;}.with_frm_style .chosen-container-multi .chosen-choices li.search-choice-focus .search-choice-close{background-position:-42px -10px;}.with_frm_style .chosen-container-multi .chosen-results{margin:0;padding:0;}.with_frm_style .chosen-container-multi .chosen-drop .result-selected{display:list-item;color:#ccc;cursor:default;}.with_frm_style .chosen-container-active .chosen-single{border:1px solid #5897fb;box-shadow:0 0 5px rgba(0, 0, 0, 0.3);}.with_frm_style .chosen-container-active.chosen-with-drop .chosen-single{border:1px solid #aaa;-moz-border-radius-bottomright:0;border-bottom-right-radius:0;-moz-border-radius-bottomleft:0;border-bottom-left-radius:0;box-shadow:0 1px 0 #fff inset;}.with_frm_style .chosen-container-active.chosen-with-drop .chosen-single div{border-left:none;background:transparent;}.with_frm_style .chosen-container-active.chosen-with-drop .chosen-single div b{background-position:-18px 2px;}.with_frm_style .chosen-container-active .chosen-choices li.search-field input[type=\"text\"]{color:#111 !important;}.with_frm_style .chosen-disabled{opacity:0.5 !important;cursor:default;}.with_frm_style .chosen-disabled .chosen-single{cursor:default;}.with_frm_style .chosen-disabled .chosen-choices .search-choice .search-choice-close{cursor:default;}.with_frm_style .chosen-rtl{text-align:right;}.with_frm_style .chosen-rtl .chosen-single{overflow:visible;padding:0 8px 0 0;}.with_frm_style .chosen-rtl .chosen-single span{margin-right:0;margin-left:26px;direction:rtl;}.with_frm_style .chosen-rtl .chosen-single-with-deselect span{margin-left:38px;}.with_frm_style .chosen-rtl .chosen-single div{right:auto;left:3px;}.with_frm_style .chosen-rtl .chosen-single abbr{right:auto;left:26px;}.with_frm_style .chosen-rtl .chosen-choices li{float:right;}.with_frm_style .chosen-rtl .chosen-choices li.search-field input[type=\"text\"]{direction:rtl;}.with_frm_style .chosen-rtl .chosen-choices li.search-choice{margin:3px 5px 3px 0;padding:3px 5px 3px 19px;}.with_frm_style .chosen-rtl .chosen-choices li.search-choice .search-choice-close{right:auto;left:4px;}.with_frm_style .chosen-rtl.chosen-container-single-nosearch .chosen-search, .with_frm_style .chosen-rtl .chosen-drop{left:9999px;}.with_frm_style .chosen-rtl.chosen-container-single .chosen-results{margin:0 0 4px 4px;padding:0 4px 0 0;}.with_frm_style .chosen-rtl .chosen-results li.group-option{padding-right:15px;padding-left:0;}.with_frm_style .chosen-rtl.chosen-container-active.chosen-with-drop .chosen-single div{border-right:none;}.with_frm_style .chosen-rtl .chosen-search input[type=\"text\"]{padding:4px 5px 4px 20px;background:white url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') no-repeat -30px -20px;background:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite.png\') no-repeat -30px -20px;direction:rtl;}.with_frm_style .chosen-rtl.chosen-container-single .chosen-single div b{background-position:6px 2px;}.with_frm_style .chosen-rtl.chosen-container-single.chosen-with-drop .chosen-single div b{background-position:-12px 2px;}@font-face {font-family:\'s11-fp\';src:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/fonts/s11-fp.eot\');src:local(\'☺\'), url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/fonts/s11-fp.woff\') format(\'woff\'), url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/fonts/s11-fp.ttf\') format(\'truetype\'), url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/fonts/s11-fp.svg\') format(\'svg\');font-weight:normal;font-style:normal;}.frm_icon_font,.frm_dashicon_font{text-decoration:none;text-shadow: none;font-weight:normal;}i.frm_icon_font{font-style:normal;}.frm_icon_font:before,select.frm_icon_font{font-family: \'s11-fp\' !important;font-size:16px;speak: none;-webkit-font-smoothing: antialiased;-moz-osx-font-smoothing: grayscale;-moz-transition: all .1s ease-in-out;-webkit-transition: all .1s ease-in-out;transition: all .1s ease-in-out;}.frm_icon_font,a.frm_icon_font.frm_icon_font:hover,a.frm_icon_font:hover{text-decoration:none !important;}.frm_icon_font:focus,.frm_dashicon_font:focus{box-shadow:none;-webkit-box-shadow:none;}.frm_duplicate_icon:active,.frm_move_icon:active,.frm_delete_icon:active{outline:none;}.frm_trigger .frm_icon_font{padding:0 5px;}.ab-icon.frm_dashicon_font:before{content: \"\\f324\";}.frm_logo_icon:before {content: \"\\e601\";}.frm_required_icon:before {content: \"\\e612\";}.frm_delete_icon:before {content: \"\\e610\" !important;}.frm_move_icon:before {content: \"\\e61a\";}.frm_clear_icon:before {content: \"\\e60a\";}.frm_noclear_icon:before {content: \"\\e60b\";}.frm_duplicate_icon:before {content: \"\\e61b\";}.frm_new_icon:before {content: \"\\e614\";}.frm_tooltip_icon:before {content: \"\\e611\";}.frm_forbid_icon:before {content: \"\\e636\";}.frm_check_icon:before {content: \"\\e605\";}.frm_check1_icon:before {content: \"\\e606\";}.frm_plus_icon:before {content: \"\\e62f\";}.frm_plus1_icon:before {content: \"\\e602\";}.frm_plus2_icon:before {content: \"\\e603\";}.frm_plus3_icon:before {content: \"\\e632\";}.frm_plus4_icon:before {content: \"\\e60f\";}.frm_minus_icon:before {content: \"\\e62e\";}.frm_minus1_icon:before {content: \"\\e600\";}.frm_minus2_icon:before {content: \"\\e604\";}.frm_minus3_icon:before {content: \"\\e633\";}.frm_minus4_icon:before {content: \"\\e613\";}.frm_cancel_icon:before {content: \"\\e607\";}.frm_cancel1_icon:before {content: \"\\e608\";}.frm_arrowup_icon:before {content: \"\\e60d\";}.frm_arrowup1_icon:before {content: \"\\e60e\";}.frm_arrowup2_icon:before {content: \"\\e630\";}.frm_arrowup3_icon:before {content: \"\\e62b\";}.frm_arrowup4_icon:before {content: \"\\e62c\";}.frm_arrowup5_icon:before {content: \"\\e635\";}.frm_arrowup6_icon:before {content: \"\\e62d\";}.frm_arrowdown_icon:before {content: \"\\e609\";}.frm_arrowdown1_icon:before {content: \"\\e60c\";}.frm_arrowdown2_icon:before {content: \"\\e631\";}.frm_arrowdown3_icon:before {content: \"\\e628\";}.frm_arrowdown4_icon:before {content: \"\\e629\";}.frm_arrowdown5_icon:before {content: \"\\e634\";}.frm_arrowdown6_icon:before {content: \"\\e62a\";}.frm_download_icon:before {content: \"\\e615\";}.frm_upload_icon:before {content: \"\\e616\";}.frm_menu_icon:before {content: \"\\e618\";}.frm_twitter_icon:before {content: \"\\e619\";}.frm_sms_icon:before {content: \"\\e61c\";}.frm_pencil_icon:before {content: \"\\e61d\";}.frm_pencil1_icon:before {content: \"\\e61e\";}.frm_paypal_icon:before {content: \"\\e61f\";}.frm_twilio_icon:before {content: \"\\e620\";}.frm_googleplus_icon:before {content: \"\\e621\";}.frm_mailchimp_icon:before {content: \"\\e622\";}.frm_pdf_icon:before {content: \"\\e623\";}.frm_highrise_icon:before {content: \"\\e617\";}.frm_feed_icon:before {content: \"\\e624\";}.frm_facebook_icon:before {content: \"\\e625\";}.frm_email_icon:before {content: \"\\e626\";}.frm_aweber_icon:before {content: \"\\e627\";}.frm_register_icon:before {content: \"\\e637\";}.frm_authorize_icon:before {content: \"\\e900\";}.frm_stripe_icon:before {content: \"\\e902\";}.frm_woocommerce_icon:before {content: \"\\e903\";}.frm_paste_icon:before {content: \"\\e901\";}@-webkit-keyframes passing-through {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30%, 70% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}100% {opacity: 0;-webkit-transform: translateY(-40px);-moz-transform: translateY(-40px);-ms-transform: translateY(-40px);-o-transform: translateY(-40px);transform: translateY(-40px);}}@-moz-keyframes passing-through {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30%, 70% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}100% {opacity: 0;-webkit-transform: translateY(-40px);-moz-transform: translateY(-40px);-ms-transform: translateY(-40px);-o-transform: translateY(-40px);transform: translateY(-40px);}}@keyframes passing-through {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30%, 70% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}100% {opacity: 0;-webkit-transform: translateY(-40px);-moz-transform: translateY(-40px);-ms-transform: translateY(-40px);-o-transform: translateY(-40px);transform: translateY(-40px);}}@-webkit-keyframes slide-in {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}}@-moz-keyframes slide-in {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}}@keyframes slide-in {0% {opacity: 0;-webkit-transform: translateY(40px);-moz-transform: translateY(40px);-ms-transform: translateY(40px);-o-transform: translateY(40px);transform: translateY(40px);}30% {opacity: 1;-webkit-transform: translateY(0px);-moz-transform: translateY(0px);-ms-transform: translateY(0px);-o-transform: translateY(0px);transform: translateY(0px);}}@-webkit-keyframes pulse {0% {-webkit-transform: scale(1);-moz-transform: scale(1);-ms-transform: scale(1);-o-transform: scale(1);transform: scale(1);}10% {-webkit-transform: scale(1.1);-moz-transform: scale(1.1);-ms-transform: scale(1.1);-o-transform: scale(1.1);transform: scale(1.1);}20% {-webkit-transform: scale(1);-moz-transform: scale(1);-ms-transform: scale(1);-o-transform: scale(1);transform: scale(1);}}@-moz-keyframes pulse {0% {-webkit-transform: scale(1);-moz-transform: scale(1);-ms-transform: scale(1);-o-transform: scale(1);transform: scale(1);}10% {-webkit-transform: scale(1.1);-moz-transform: scale(1.1);-ms-transform: scale(1.1);-o-transform: scale(1.1);transform: scale(1.1);}20% {-webkit-transform: scale(1);-moz-transform: scale(1);-ms-transform: scale(1);-o-transform: scale(1);transform: scale(1);}}@keyframes pulse {0% {-webkit-transform: scale(1);-moz-transform: scale(1);-ms-transform: scale(1);-o-transform: scale(1);transform: scale(1);}10% {-webkit-transform: scale(1.1);-moz-transform: scale(1.1);-ms-transform: scale(1.1);-o-transform: scale(1.1);transform: scale(1.1);}20% {-webkit-transform: scale(1);-moz-transform: scale(1);-ms-transform: scale(1);-o-transform: scale(1);transform: scale(1);}}.frm_dropzone, .frm_dropzone * {box-sizing: border-box;}.frm_dropzone.dz-clickable {min-height: 150px;border: 2px dashed #dfdfdf;background:#ffffff;padding: 20px 20px;border-radius:5px;cursor: pointer;margin-top:5px;line-height:1.42857143;}.frm_dropzone.dz-clickable * {cursor: default;}.frm_dropzone.dz-clickable.frm_single_upload{max-width: 200px;}.frm_dropzone .dz-message{display:none;font-size:20px;text-align: center;margin: .5em 0 1em;}.frm_dropzone.dz-clickable.frm_single_upload .dz-message{margin: 0 0 .5em 0;}.frm_dropzone.dz-clickable .dz-message,.frm_dropzone .frm_upload_icon{display:block;}.frm_dropzone.dz-clickable .dz-message,.frm_dropzone.dz-clickable .dz-message * {cursor: pointer;}#frm_form_editor_container .frm_dropzone.dz-clickable,#frm_form_editor_container .frm_dropzone.dz-clickable *{cursor: default;}.frm_dropzone.dz-started .dz-message {display: none;}.frm_dropzone.dz-drag-hover .dz-message {opacity: 0.5;}.frm_dropzone .frm_upload_icon:before{font-size:40px;}.frm_dropzone .frm_small_text {font-size:14px;}.frm_dropzone.dz-drag-hover {border-style: solid;}.frm_dropzone .dz-preview {position: relative;display: inline-block;vertical-align: top;margin: 16px;min-height: 100px;}.frm_dropzone .dz-preview:hover {z-index: 1000;}.frm_dropzone .dz-preview:hover .dz-details {opacity: 1;}.frm_dropzone .dz-preview.dz-file-preview .dz-image {border-radius: 20px;background: #999;background: linear-gradient(to bottom, #eee, #ddd);}.frm_dropzone .dz-preview.dz-file-preview .dz-details {opacity: 1;}.frm_dropzone .dz-preview.dz-image-preview .dz-details {-webkit-transition: opacity 0.2s linear;-moz-transition: opacity 0.2s linear;-ms-transition: opacity 0.2s linear;-o-transition: opacity 0.2s linear;transition: opacity 0.2s linear;}.frm_dropzone .dz-preview .dz-remove {font-size: 14px;text-align: center;display: block;cursor: pointer;border: none;}.frm_dropzone .dz-preview .dz-remove:hover {text-decoration: underline;}.frm_dropzone .dz-preview:hover .dz-details {opacity: 1;}.frm_dropzone .dz-preview .dz-details {z-index: 20;position: absolute;top: 0;left: 0;opacity: 0;font-size: 13px;min-width: 100%;max-width: 100%;padding: 2em 1em;text-align: center;color: rgba(0, 0, 0, 0.9);line-height: 150%;}.frm_dropzone .dz-preview .dz-details .dz-size {margin-bottom: 1em;font-size: 16px;}.frm_dropzone .dz-preview .dz-details .dz-filename {white-space: nowrap;}.frm_dropzone .dz-preview .dz-details .dz-filename:hover span {border: 1px solid rgba(200, 200, 200, 0.8);background-color: rgba(255, 255, 255, 0.8);}.frm_dropzone .dz-preview .dz-details .dz-filename:not(:hover) {overflow: hidden;text-overflow: ellipsis;}.frm_dropzone .dz-preview .dz-details .dz-filename:not(:hover) span {border: 1px solid transparent;}.frm_dropzone .dz-preview .dz-details .dz-filename span,.frm_dropzone .dz-preview .dz-details .dz-size span {background-color: rgba(255, 255, 255, 0.4);padding: 0 0.4em;border-radius: 3px;}.frm_dropzone .dz-preview .dz-details .dz-filename a{cursor:pointer;}.frm_dropzone .dz-preview:hover .dz-image img {-webkit-transform: scale(1.05, 1.05);-moz-transform: scale(1.05, 1.05);-ms-transform: scale(1.05, 1.05);-o-transform: scale(1.05, 1.05);transform: scale(1.05, 1.05);-webkit-filter: blur(8px);filter: blur(8px);}.frm_dropzone .dz-preview .dz-image {border-radius: 20px;overflow: hidden;width: 120px;height: 120px;position: relative;display: block;z-index: 10;}.frm_dropzone .dz-preview .dz-image img {display: block;margin:0 auto;}.frm_dropzone .dz-preview.dz-success .dz-success-mark {-webkit-animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);-moz-animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);-ms-animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);-o-animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);animation: passing-through 3s cubic-bezier(0.77, 0, 0.175, 1);}.frm_dropzone .dz-preview.dz-error .dz-error-mark {opacity: 1;-webkit-animation: slide-in 3s cubic-bezier(0.77, 0, 0.175, 1);-moz-animation: slide-in 3s cubic-bezier(0.77, 0, 0.175, 1);-ms-animation: slide-in 3s cubic-bezier(0.77, 0, 0.175, 1);-o-animation: slide-in 3s cubic-bezier(0.77, 0, 0.175, 1);animation: slide-in 3s cubic-bezier(0.77, 0, 0.175, 1);}.frm_dropzone .dz-preview .dz-success-mark, .frm_dropzone .dz-preview .dz-error-mark {pointer-events: none;opacity: 0;z-index: 500;position: absolute;display: block;top: 50%;left: 50%;margin-left: -27px;margin-top: -27px;}.frm_dropzone .dz-preview .dz-success-mark svg, .frm_dropzone .dz-preview .dz-error-mark svg {display: block;width: 54px;height: 54px;}.frm_dropzone .dz-preview.dz-processing .dz-progress {opacity: 1;-webkit-transition: all 0.2s linear;-moz-transition: all 0.2s linear;-ms-transition: all 0.2s linear;-o-transition: all 0.2s linear;transition: all 0.2s linear;}.frm_dropzone .dz-preview.dz-complete .dz-progress {opacity: 0;-webkit-transition: opacity 0.4s ease-in;-moz-transition: opacity 0.4s ease-in;-ms-transition: opacity 0.4s ease-in;-o-transition: opacity 0.4s ease-in;transition: opacity 0.4s ease-in;}.frm_dropzone .dz-preview:not(.dz-processing) .dz-progress {-webkit-animation: pulse 6s ease infinite;-moz-animation: pulse 6s ease infinite;-ms-animation: pulse 6s ease infinite;-o-animation: pulse 6s ease infinite;animation: pulse 6s ease infinite;}.frm_dropzone .dz-preview .dz-progress {opacity: 1;z-index: 1000;pointer-events: none;position: absolute;height: 16px;left: 50%;top: 50%;margin-top: -8px;width: 80px;margin-left: -40px;background: rgba(255, 255, 255, 0.9);-webkit-transform: scale(1);border-radius: 8px;overflow: hidden;}.frm_dropzone .dz-preview .dz-progress .dz-upload {background: #333;background: linear-gradient(to bottom, #666, #444);position: absolute;top: 0;left: 0;bottom: 0;width: 0;-webkit-transition: width 300ms ease-in-out;-moz-transition: width 300ms ease-in-out;-ms-transition: width 300ms ease-in-out;-o-transition: width 300ms ease-in-out;transition: width 300ms ease-in-out;}.frm_dropzone .dz-preview.dz-error .dz-error-message {display: block;}.frm_dropzone .dz-preview.dz-error:hover .dz-error-message {opacity: 1;pointer-events: auto;}.frm_dropzone .dz-preview .dz-error-message {pointer-events: none;z-index: 1000;position: absolute;display: block;display: none;opacity: 0;-webkit-transition: opacity 0.3s ease;-moz-transition: opacity 0.3s ease;-ms-transition: opacity 0.3s ease;-o-transition: opacity 0.3s ease;transition: opacity 0.3s ease;border-radius: 8px;font-size: 13px;top: 29px;left: -10px;width: 140px;background: #be2626;background: linear-gradient(to bottom, #be2626, #a92222);padding: 0.5em 1.2em;color: white;}.frm_dropzone .fallback input[type=file]{display:block;}.frm_compact_text{display:none;}.frm_compact .frm_dropzone.dz-clickable{min-height:60px;padding:5px;border:none;background-color:transparent;}.frm_compact .frm_dropzone.dz-clickable.frm_single_upload{max-width:100%;}.frm_compact .frm_compact_text{display:inline;}.frm_compact .frm_dropzone.dz-clickable.frm_single_upload .dz-message,.frm_compact .frm_dropzone.dz-clickable .dz-message{font-size:14px;border:1px solid #dfdfdf;background:#fff;display: inline-block;border-radius: 4px;padding: 6px 11px;box-sizing: border-box;box-shadow: 0 1px 1px #eeeeee;vertical-align: middle;}.frm_compact .frm_dropzone .frm_upload_icon:before{font-size:22px;padding-right:7px;vertical-align: middle;}.frm_compact .frm_dropzone .frm_upload_icon{display:inline;}.frm_compact .frm_dropzone .dz-preview{min-height:20px;max-width:175px;margin:5px;}.frm_compact .frm_dropzone .frm_upload_text,.frm_compact .frm_dropzone .frm_small_text,.frm_compact .frm_dropzone .dz-preview .dz-image,.frm_compact .frm_dropzone .dz-preview .dz-details .dz-size{display:none;}.frm_compact .frm_dropzone .dz-preview.dz-error .dz-error-message{top: -40px;padding: 4px;width: auto;text-align: center;}.frm_compact .frm_dropzone .dz-preview .dz-success-mark,.frm_compact .frm_dropzone .dz-preview .dz-error-mark{margin-left: -16px;margin-top: 0;top: 6px;}.frm_compact .frm_dropzone .dz-preview:hover .dz-error-mark{display:none;}.frm_compact .frm_dropzone .dz-preview .dz-success-mark svg,.frm_compact .frm_dropzone .dz-preview .dz-error-mark svg{height:35px;width:35px;}.frm_compact .frm_dropzone .dz-preview .dz-details{opacity:1;position:relative;padding:5px;}.frm_compact .frm_dropzone .dz-preview .dz-details .dz-filename {overflow: hidden;text-overflow: ellipsis;}.frm_compact .frm_dropzone .dz-preview .dz-details .dz-filename span{border:none;background:transparent;}@media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min-resolution: 144dpi){.with_frm_style .chosen-rtl .chosen-search input[type=\"text\"],.with_frm_style .chosen-container-single .chosen-single abbr,.with_frm_style .chosen-container-single .chosen-single div b,.with_frm_style .chosen-container-single .chosen-search input[type=\"text\"],.with_frm_style .chosen-container-multi .chosen-choices .search-choice .search-choice-close,.with_frm_style .chosen-container .chosen-results-scroll-down span,.with_frm_style .chosen-container .chosen-results-scroll-up span{background-image:url(\'//www.dgtal-mind.com/wp-content/plugins/formidable/pro/images/chosen-sprite2x.png\') !important;background-size:52px 37px !important;background-repeat:no-repeat !important;}}@media only screen and (max-width: 900px) {.frm_form_field .frm_repeat_grid .frm_form_field.frm_sixth label.frm_primary_label,.frm_form_field .frm_repeat_grid .frm_form_field.frm_seventh label.frm_primary_label,.frm_form_field .frm_repeat_grid .frm_form_field.frm_eighth label.frm_primary_label{display: block !important;}.frm_form_field .frm_repeat_grid .frm_form_field.frm_repeat_buttons.frm_seventh label.frm_primary_label{display:none !important;}}@media only screen and (max-width: 600px) {.frm_form_field.frm_four_col .frm_radio,.frm_form_field.frm_four_col .frm_checkbox{width:48%;margin-right:4%;}.frm_form_field.frm_four_col .frm_radio:nth-child(2n+2),.frm_form_field.frm_four_col .frm_checkbox:nth-child(2n+2){margin-right:0;}.frm_form_field .frm_repeat_grid.frm_first_repeat .frm_form_field.frm_repeat_buttons:not(.frm_fourth):not(.frm_sixth):not(.frm_eighth) label.frm_primary_label{display:none !important;}.frm_form_field .frm_repeat_grid .frm_form_field.frm_fifth label.frm_primary_label{display:block !important;}.frm_form_field .frm_repeat_grid .frm_form_field.frm_repeat_buttons.frm_fifth label.frm_primary_label{display:none !important;}}@media only screen and (max-width: 500px) {.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox,.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_three_col .frm_checkbox{width: auto;margin-right: 0;float: none;display:block;}.frm_form_field input[type=file] {max-width:220px;}.with_frm_style.frm_login_form.frm_inline_login p{clear:both;float:none;}.with_frm_style.frm_login_form.frm_inline_login form{position:static;}.with_frm_style.frm_login_form.frm_inline_login .login-remember{position:static;}.with_frm_style .frm-g-recaptcha > div > div,.with_frm_style .g-recaptcha > div > div{width:inherit !important;display:block;overflow:hidden;max-width:302px;border-right:1px solid #d3d3d3;border-radius:4px;box-shadow:2px 0px 4px -1px rgba(0,0,0,.08);-moz-box-shadow:2px 0px 4px -1px rgba(0,0,0,.08);}.with_frm_style .g-recaptcha iframe,.with_frm_style .frm-g-recaptcha iframe{width:100%;}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("164", "akismet_show_user_comments_approved", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("133", "mm_churn", "a:4:{s:2:\"ip\";s:12:\"67.20.76.143\";s:6:\"whoami\";s:8:\"dgtalmin\";s:3:\"key\";s:13:\"gyLK2udXxitd2\";s:4:\"test\";s:0:\"\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("136", "mm_previous_tests", "a:1:{i:0;s:32:\"jetpack-onboarding-v1.1.1-exempt\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("137", "frm_db_version", "35", "yes");
INSERT INTO `wp_jzkb_options` VALUES("162", "wordpress_api_key", "f5de9134ae6b", "yes");
INSERT INTO `wp_jzkb_options` VALUES("163", "akismet_strictness", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("262", "stats_cache", "a:2:{s:32:\"f67506ed7ff4e837630009377d706631\";a:1:{i:1484735561;a:1:{i:0;a:4:{s:7:\"post_id\";s:4:\"2650\";s:10:\"post_title\";s:8:\"Homepage\";s:14:\"post_permalink\";s:26:\"http://www.dgtal-mind.com/\";s:5:\"views\";s:1:\"1\";}}}s:32:\"564c4f787abbb6d8a2534d67e1485713\";a:1:{i:1484735562;a:0:{}}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("16285", "rewrite_rules", "a:171:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:37:\"profile/([^/]*)/([^/]*)/page/([0-9]+)\";s:73:\"index.php?page_id=3515&user=$matches[1]&tab=$matches[2]&paged=$matches[3]\";s:23:\"profile/([^/]*)/([^/]*)\";s:55:\"index.php?page_id=3515&user=$matches[1]&tab=$matches[2]\";s:15:\"profile/([^/]*)\";s:39:\"index.php?page_id=3515&user=$matches[1]\";s:15:\"account/([^/]*)\";s:46:\"index.php?page_id=3514&account_tab=$matches[1]\";s:10:\"project/?$\";s:34:\"index.php?post_type=pikart-project\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=pikart-project&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=pikart-project&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:52:\"index.php?post_type=pikart-project&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:38:\"frm_styles/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"frm_styles/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"frm_styles/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"frm_styles/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"frm_styles/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"frm_styles/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"frm_styles/([^/]+)/embed/?$\";s:43:\"index.php?frm_styles=$matches[1]&embed=true\";s:31:\"frm_styles/([^/]+)/trackback/?$\";s:37:\"index.php?frm_styles=$matches[1]&tb=1\";s:39:\"frm_styles/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?frm_styles=$matches[1]&paged=$matches[2]\";s:46:\"frm_styles/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?frm_styles=$matches[1]&cpage=$matches[2]\";s:35:\"frm_styles/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?frm_styles=$matches[1]&page=$matches[2]\";s:27:\"frm_styles/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"frm_styles/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"frm_styles/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"frm_styles/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"frm_styles/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"frm_styles/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"frm_form_actions/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"frm_form_actions/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"frm_form_actions/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"frm_form_actions/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"frm_form_actions/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"frm_form_actions/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"frm_form_actions/([^/]+)/embed/?$\";s:49:\"index.php?frm_form_actions=$matches[1]&embed=true\";s:37:\"frm_form_actions/([^/]+)/trackback/?$\";s:43:\"index.php?frm_form_actions=$matches[1]&tb=1\";s:45:\"frm_form_actions/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?frm_form_actions=$matches[1]&paged=$matches[2]\";s:52:\"frm_form_actions/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?frm_form_actions=$matches[1]&cpage=$matches[2]\";s:41:\"frm_form_actions/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?frm_form_actions=$matches[1]&page=$matches[2]\";s:33:\"frm_form_actions/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"frm_form_actions/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"frm_form_actions/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"frm_form_actions/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"frm_form_actions/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"frm_form_actions/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"wpum_directory/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"wpum_directory/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"wpum_directory/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"wpum_directory/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"wpum_directory/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"wpum_directory/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"wpum_directory/([^/]+)/embed/?$\";s:47:\"index.php?wpum_directory=$matches[1]&embed=true\";s:35:\"wpum_directory/([^/]+)/trackback/?$\";s:41:\"index.php?wpum_directory=$matches[1]&tb=1\";s:43:\"wpum_directory/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?wpum_directory=$matches[1]&paged=$matches[2]\";s:50:\"wpum_directory/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?wpum_directory=$matches[1]&cpage=$matches[2]\";s:39:\"wpum_directory/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?wpum_directory=$matches[1]&page=$matches[2]\";s:31:\"wpum_directory/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"wpum_directory/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"wpum_directory/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"wpum_directory/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"wpum_directory/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"wpum_directory/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"project/([^/]+)/embed/?$\";s:47:\"index.php?pikart-project=$matches[1]&embed=true\";s:28:\"project/([^/]+)/trackback/?$\";s:41:\"index.php?pikart-project=$matches[1]&tb=1\";s:48:\"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?pikart-project=$matches[1]&feed=$matches[2]\";s:43:\"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?pikart-project=$matches[1]&feed=$matches[2]\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?pikart-project=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?pikart-project=$matches[1]&cpage=$matches[2]\";s:32:\"project/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?pikart-project=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"project-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?pikart-project-category=$matches[1]&feed=$matches[2]\";s:52:\"project-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?pikart-project-category=$matches[1]&feed=$matches[2]\";s:33:\"project-category/([^/]+)/embed/?$\";s:56:\"index.php?pikart-project-category=$matches[1]&embed=true\";s:45:\"project-category/([^/]+)/page/?([0-9]{1,})/?$\";s:63:\"index.php?pikart-project-category=$matches[1]&paged=$matches[2]\";s:27:\"project-category/([^/]+)/?$\";s:45:\"index.php?pikart-project-category=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=2650&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("161", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("165", "jetpack_log", "a:12:{i:0;a:4:{s:4:\"time\";i:1455199675;s:7:\"user_id\";i:1;s:7:\"blog_id\";b:0;s:4:\"code\";s:8:\"register\";}i:1;a:4:{s:4:\"time\";i:1455199696;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:106814531;s:4:\"code\";s:9:\"authorize\";}i:2;a:5:{s:4:\"time\";i:1455199741;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:106814531;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:6:\"manage\";}i:3;a:5:{s:4:\"time\";i:1455199742;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:106814531;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:10:\"sharedaddy\";}i:4;a:5:{s:4:\"time\";i:1455199743;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:106814531;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:13:\"subscriptions\";}i:5;a:5:{s:4:\"time\";i:1455199743;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:106814531;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:19:\"gravatar-hovercards\";}i:6;a:5:{s:4:\"time\";i:1455199743;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:106814531;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:12:\"contact-form\";}i:7;a:5:{s:4:\"time\";i:1455199743;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:106814531;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:8:\"carousel\";}i:8;a:5:{s:4:\"time\";i:1455199744;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:106814531;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:6:\"photon\";}i:9;a:5:{s:4:\"time\";i:1455199744;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:106814531;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:13:\"related-posts\";}i:10;a:5:{s:4:\"time\";i:1455199745;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:106814531;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:3:\"sso\";}i:11;a:5:{s:4:\"time\";i:1481353404;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:106814531;s:4:\"code\";s:24:\"custom_css_4.7_migration\";s:4:\"data\";s:5:\"start\";}}", "no");
INSERT INTO `wp_jzkb_options` VALUES("166", "jetpack_private_options", "a:3:{s:8:\"register\";s:76:\"dF72kelQ3X1p43ATiyvnY4bOojlLRxSv:t4HTHY2EpcSIoCuqt1Bd4PgAXQlUbiiE:1455200275\";s:10:\"blog_token\";s:65:\"ovLmifq2*e)v#SMKcqW&Wvy5fgGmS^9o.gYZjl#lIEHlF^o!(2nnOA7#6QNazwQO4\";s:11:\"user_tokens\";a:1:{i:1;s:67:\"d!(jE7FFK6W88R@ivpMWEM(PDsureDAP.(tnzVdAq#f@UAExdK@vVvuZSUmKQKMbi.1\";}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("169", "jetpack_unique_connection", "a:3:{s:9:\"connected\";i:1;s:12:\"disconnected\";i:0;s:7:\"version\";s:5:\"3.6.1\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("170", "jetpack_active_modules", "a:25:{i:0;s:18:\"after-the-deadline\";i:1;s:12:\"contact-form\";i:2;s:20:\"custom-content-types\";i:3;s:10:\"custom-css\";i:4;s:19:\"gravatar-hovercards\";i:5;s:5:\"latex\";i:6;s:5:\"notes\";i:7;s:10:\"omnisearch\";i:8;s:13:\"post-by-email\";i:9;s:7:\"protect\";i:10;s:9:\"publicize\";i:11;s:10:\"sharedaddy\";i:12;s:10:\"shortcodes\";i:13;s:10:\"shortlinks\";i:14;s:5:\"stats\";i:15;s:13:\"subscriptions\";i:17;s:18:\"verification-tools\";i:18;s:17:\"widget-visibility\";i:19;s:7:\"widgets\";i:20;s:6:\"photon\";i:21;s:6:\"manage\";i:22;s:8:\"carousel\";i:23;s:13:\"related-posts\";i:24;s:3:\"sso\";i:25;s:7:\"monitor\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("189", "stats_options", "a:7:{s:9:\"admin_bar\";b:1;s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:11:\"count_roles\";a:0:{}s:7:\"blog_id\";i:106814531;s:12:\"do_not_track\";b:1;s:10:\"hide_smile\";b:1;s:7:\"version\";s:1:\"9\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("177", "widget_blog_subscription", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("178", "widget_facebook-likebox", "a:2:{i:2;a:2:{s:5:\"title\";s:21:\"Follow us on Facebook\";s:9:\"like_args\";a:6:{s:4:\"href\";s:34:\"https://www.facebook.com/DGtalMind\";s:5:\"width\";i:400;s:6:\"height\";i:500;s:10:\"show_faces\";b:0;s:6:\"stream\";b:0;s:5:\"cover\";b:0;}}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("179", "widget_wpcom-goodreads", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("180", "widget_googleplus-badge", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("181", "widget_grofile", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("182", "widget_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("183", "widget_rss_links", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("184", "widget_wpcom_social_media_icons_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("185", "widget_twitter_timeline", "a:2:{i:2;a:9:{s:5:\"title\";s:20:\"Follow us on Twitter\";s:5:\"width\";s:0:\"\";s:6:\"height\";i:250;s:11:\"tweet-limit\";i:1;s:9:\"widget-id\";s:18:\"705426184029474816\";s:10:\"link-color\";s:7:\"#f96e5b\";s:12:\"border-color\";s:7:\"#e8e8e8\";s:5:\"theme\";s:5:\"light\";s:6:\"chrome\";a:0:{}}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("186", "widget_jetpack_display_posts_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("188", "jetpack_protect_key", "83de1a46ee502c5cec5e188e86a6863c6163384f", "yes");
INSERT INTO `wp_jzkb_options` VALUES("194", "trusted_ip_header", "O:8:\"stdClass\":3:{s:14:\"trusted_header\";s:11:\"REMOTE_ADDR\";s:8:\"segments\";i:1;s:7:\"reverse\";b:0;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("197", "sharing-services", "a:2:{s:7:\"visible\";a:4:{i:0;s:7:\"twitter\";i:1;s:8:\"facebook\";i:2;s:13:\"google-plus-1\";i:3;s:8:\"linkedin\";}s:6:\"hidden\";a:0:{}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("196", "sharing-options", "a:1:{s:6:\"global\";a:5:{s:12:\"button_style\";s:4:\"icon\";s:13:\"sharing_label\";b:0;s:10:\"open_links\";s:4:\"same\";s:4:\"show\";a:4:{i:0;s:5:\"index\";i:1;s:4:\"post\";i:2;s:4:\"page\";i:3;s:14:\"pikart-project\";}s:6:\"custom\";a:0:{}}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("5865", "pikart-project-category_children", "a:0:{}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("2973", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("293", "current_theme", "Arkfield", "yes");
INSERT INTO `wp_jzkb_options` VALUES("294", "theme_mods_arkfield", "a:11:{i:0;b:0;s:27:\"arkfield_setting_logo_image\";s:75:\"http://www.dgtal-mind.com/wp-content/uploads/2016/02/logo_1856457_print.png\";s:31:\"arkfield_setting_copyright_text\";s:38:\"Copyright © DGtal-Mind Limited, 2016.\";s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:2;s:6:\"footer\";i:2;s:6:\"social\";i:66;}s:31:\"arkfield_setting_logo_dimension\";i:100;s:27:\"arkfield_setting_custom_css\";s:135:\".pikode--heading h1, .pikode--heading h3 { text-transform: sentence; } input[type=text] { border: 1px solid #acacac; padding: 0.7rem; }\";s:27:\"arkfield_setting_blog_title\";s:15:\"Follow my diary\";s:35:\"arkfield_setting_projects_lazy_load\";i:0;s:26:\"arkfield_setting_logo_text\";s:18:\"DGtal-Mind Limited\";s:18:\"custom_css_post_id\";i:-1;s:18:\"jetpack_custom_css\";a:3:{s:12:\"preprocessor\";s:0:\"\";s:7:\"replace\";b:0;s:13:\"content_width\";s:0:\"\";}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("295", "theme_switched", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("296", "safecss_rev", "2", "yes");
INSERT INTO `wp_jzkb_options` VALUES("297", "arkfield_google_fonts", "a:24:{i:0;s:33:\"Arimo:400,400italic,700,700italic\";i:1;s:32:\"Arvo:400,400italic,700,700italic\";i:2;s:24:\"Bitter:400,400italic,700\";i:3;s:8:\"Denk+One\";i:4;s:18:\"Droid+Sans:400,700\";i:5;s:39:\"Droid+Serif:400,400italic,700,700italic\";i:6;s:82:\"Josefin+Sans:100,100italic,300,300italic,400,400italic,600,600italic,700,700italic\";i:7;s:82:\"Josefin+Slab:100,100italic,300,300italic,400,400italic,600,600italic,700,700italic\";i:8;s:74:\"Lato:100,100italic,300,300italic,400,400italic,700,700italic,900,900italic\";i:9;s:32:\"Lora:400,400italic,700italic,700\";i:10;s:18:\"Montserrat:400,700\";i:12;s:37:\"Open+Sans+Condensed:300,300italic,700\";i:11;s:79:\"Open+Sans:300,300italic,400,400italic,600,600italic,700,700italic,800,800italic\";i:13;s:18:\"Oswald:300,400,700\";i:15;s:22:\"PT+Sans+Narrow:400,700\";i:14;s:35:\"PT+Sans:400,400italic,700,700italic\";i:16;s:43:\"Raleway:100,200,300,400,500,600,700,800,900\";i:18;s:58:\"Roboto+Condensed:300,300italic,400,400italic,700,700italic\";i:19;s:27:\"Roboto+Slab:100,300,400,700\";i:17;s:90:\"Roboto:100,100italic,300,300italic,400,400italic,500,500italic,700,700italic,900,900italic\";i:20;s:15:\"Rokkitt:400,700\";i:21;s:99:\"Source+Sans+Pro:200,200italic,300,300italic,400,400italic,600,600italic,700,700italic,900,900italic\";i:22;s:62:\"Ubuntu:300,300italic,400,400italic,500,500italic,700,700italic\";i:23;s:33:\"Yanone+Kaffeesatz:200,300,400,700\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("300", "widget_widget_contact_info", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("301", "widget_top-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("315", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("1281", "carousel_background_color", "black", "yes");
INSERT INTO `wp_jzkb_options` VALUES("1282", "carousel_display_exif", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("727", "wpgrade_shortcodes_list", "a:9:{i:0;s:7:\"Columns\";i:1;s:7:\"Heading\";i:2;s:5:\"Quote\";i:3;s:6:\"Button\";i:4;s:4:\"Icon\";i:5;s:9:\"Separator\";i:6;s:6:\"Slider\";i:7;s:11:\"ProgressBar\";i:8;s:10:\"TeamMember\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("728", "wpcf7", "a:2:{s:7:\"version\";s:3:\"4.6\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1456407895;s:7:\"version\";s:3:\"4.4\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("736", "jetpack_temp_active_plugins_before", "a:8:{i:0;s:19:\"akismet/akismet.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:67:\"favicon-by-realfavicongenerator/favicon-by-realfavicongenerator.php\";i:3;s:25:\"formidable/formidable.php\";i:4;s:9:\"hello.php\";i:5;s:19:\"jetpack/jetpack.php\";i:6;s:47:\"mojo-marketplace-wp-plugin/mojo-marketplace.php\";i:7;s:21:\"pixcodes/pixcodes.php\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("760", "fbrfg_preview_file_name", "preview_651b7313b1983a2425bd8ccd82f0b17a.png", "yes");
INSERT INTO `wp_jzkb_options` VALUES("761", "fbrfg_html_code", "<link rel=\"apple-touch-icon\" sizes=\"57x57\" href=\"/wp-content/uploads/fbrfg/apple-touch-icon-57x57.png\">\n<link rel=\"apple-touch-icon\" sizes=\"60x60\" href=\"/wp-content/uploads/fbrfg/apple-touch-icon-60x60.png\">\n<link rel=\"apple-touch-icon\" sizes=\"72x72\" href=\"/wp-content/uploads/fbrfg/apple-touch-icon-72x72.png\">\n<link rel=\"apple-touch-icon\" sizes=\"76x76\" href=\"/wp-content/uploads/fbrfg/apple-touch-icon-76x76.png\">\n<link rel=\"apple-touch-icon\" sizes=\"114x114\" href=\"/wp-content/uploads/fbrfg/apple-touch-icon-114x114.png\">\n<link rel=\"apple-touch-icon\" sizes=\"120x120\" href=\"/wp-content/uploads/fbrfg/apple-touch-icon-120x120.png\">\n<link rel=\"apple-touch-icon\" sizes=\"144x144\" href=\"/wp-content/uploads/fbrfg/apple-touch-icon-144x144.png\">\n<link rel=\"apple-touch-icon\" sizes=\"152x152\" href=\"/wp-content/uploads/fbrfg/apple-touch-icon-152x152.png\">\n<link rel=\"apple-touch-icon\" sizes=\"180x180\" href=\"/wp-content/uploads/fbrfg/apple-touch-icon-180x180.png\">\n<link rel=\"icon\" type=\"image/png\" href=\"/wp-content/uploads/fbrfg/favicon-32x32.png\" sizes=\"32x32\">\n<link rel=\"icon\" type=\"image/png\" href=\"/wp-content/uploads/fbrfg/android-chrome-192x192.png\" sizes=\"192x192\">\n<link rel=\"icon\" type=\"image/png\" href=\"/wp-content/uploads/fbrfg/favicon-96x96.png\" sizes=\"96x96\">\n<link rel=\"icon\" type=\"image/png\" href=\"/wp-content/uploads/fbrfg/favicon-16x16.png\" sizes=\"16x16\">\n<link rel=\"manifest\" href=\"/wp-content/uploads/fbrfg/manifest.json\">\n<link rel=\"mask-icon\" href=\"/wp-content/uploads/fbrfg/safari-pinned-tab.svg\" color=\"#5bbad5\">\n<link rel=\"shortcut icon\" href=\"/wp-content/uploads/fbrfg/favicon.ico\">\n<meta name=\"msapplication-TileColor\" content=\"#da532c\">\n<meta name=\"msapplication-TileImage\" content=\"/wp-content/uploads/fbrfg/mstile-144x144.png\">\n<meta name=\"msapplication-config\" content=\"/wp-content/uploads/fbrfg/browserconfig.xml\">\n<meta name=\"theme-color\" content=\"#ffffff\">", "yes");
INSERT INTO `wp_jzkb_options` VALUES("762", "fbrfg_favicon_configured", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("763", "fbrfg_favicon_in_root", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("764", "fbrfg_favicon_current_version", "0.12", "yes");
INSERT INTO `wp_jzkb_options` VALUES("765", "fbrfg_latest_manual_available_update", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("766", "fbrfg_favicon_non_interactive_api_request", "{\"favicon_generation\":{\"api_key\":\"87d5cd739b05c00416c4a19cd14a8bb5632ea563\",\"master_picture\":{\"type\":\"inline\",\"content\":\"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\"},\"favicon_design\":{\"ios\":{\"picture_aspect\":\"background_and_margin\",\"background_color\":\"#ffffff\",\"margin\":\"14%\"},\"desktop_browser\":[],\"windows\":{\"picture_aspect\":\"no_change\",\"background_color\":\"#da532c\",\"on_conflict\":\"override\"},\"android_chrome\":{\"picture_aspect\":\"no_change\",\"theme_color\":\"#ffffff\",\"manifest\":{\"name\":\"DGtal-Mind\",\"display\":\"browser\",\"orientation\":\"not_set\",\"on_conflict\":\"override\",\"declared\":true}},\"safari_pinned_tab\":{\"picture_aspect\":\"silhouette\",\"theme_color\":\"#5bbad5\"}},\"settings\":{\"scaling_algorithm\":\"Mitchell\",\"error_on_image_too_small\":false}}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("790", "WPLANG", "en_GB", "yes");
INSERT INTO `wp_jzkb_options` VALUES("791", "allow_minor_auto_core_updates", "true", "yes");
INSERT INTO `wp_jzkb_options` VALUES("792", "auto_update_theme", "true", "yes");
INSERT INTO `wp_jzkb_options` VALUES("793", "auto_update_plugin", "true", "yes");
INSERT INTO `wp_jzkb_options` VALUES("794", "auto_update_translation", "true", "yes");
INSERT INTO `wp_jzkb_options` VALUES("799", "sharedaddy_disable_resources", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("800", "jetpack-twitter-cards-site-tag", "Anthoy_Kolade", "yes");
INSERT INTO `wp_jzkb_options` VALUES("801", "stb_enabled", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("802", "stc_enabled", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("803", "gravatar_disable_hovercards", "enabled", "yes");
INSERT INTO `wp_jzkb_options` VALUES("807", "subscription_options", "a:2:{s:10:\"invitation\";s:226:\"Howdy.\r\n\r\nYou recently followed this blog\'s posts. This means you will receive each new post by email.\r\n\r\nTo activate, click confirm below. If you believe this is an error, ignore this message and we\'ll never bother you again.\";s:14:\"comment_follow\";s:239:\"Howdy.\r\n\r\nYou recently followed one of my posts. This means you will receive an email when new comments are posted.\r\n\r\nTo activate, click confirm below. If you believe this is an error, ignore this message and we\'ll never bother you again.\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("808", "jetpack_relatedposts", "a:4:{s:7:\"enabled\";b:1;s:13:\"show_headline\";b:1;s:15:\"show_thumbnails\";b:0;s:4:\"size\";N;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("2975", "jetpack-portfolio-type_children", "a:0:{}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("5913", "jetpack_protect_blocked_attempts", "3504", "no");
INSERT INTO `wp_jzkb_options` VALUES("21188", "db_upgraded", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("21194", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"hello@dgtal-mind.com\";s:7:\"version\";s:5:\"4.7.1\";s:9:\"timestamp\";i:1484164429;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134217", "_transient_timeout_mm_spam_fcb3cf4d6bd962470e43002db845ae81", "1484760197", "no");
INSERT INTO `wp_jzkb_options` VALUES("134218", "_transient_mm_spam_fcb3cf4d6bd962470e43002db845ae81", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("70203", "do_activate", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("134550", "_transient_timeout_jetpack_sync_constants_await", "1484737039", "no");
INSERT INTO `wp_jzkb_options` VALUES("134551", "_transient_jetpack_sync_constants_await", "1484733439.1749", "no");
INSERT INTO `wp_jzkb_options` VALUES("134624", "_transient_timeout_jetpack_sync_last_checked_queue_state_sync", "1484736237", "no");
INSERT INTO `wp_jzkb_options` VALUES("134625", "_transient_jetpack_sync_last_checked_queue_state_sync", "a:2:{i:0;i:0;i:1;i:0;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("65557", "safecss_add", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65558", "verification_services_codes", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65559", "open_graph_protocol_site_type", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65560", "facebook_admins", "a:0:{}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65547", "jetpack_next_sync_time", "1473781304", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65544", "jetpack_constants_sync_checksum", "a:17:{s:16:\"EMPTY_TRASH_DAYS\";i:2473281379;s:17:\"WP_POST_REVISIONS\";i:4261170317;s:26:\"AUTOMATIC_UPDATER_DISABLED\";i:634125391;s:7:\"ABSPATH\";i:132007160;s:14:\"WP_CONTENT_DIR\";i:4109734598;s:9:\"FS_METHOD\";i:634125391;s:18:\"DISALLOW_FILE_EDIT\";i:634125391;s:18:\"DISALLOW_FILE_MODS\";i:634125391;s:19:\"WP_AUTO_UPDATE_CORE\";i:634125391;s:22:\"WP_HTTP_BLOCK_EXTERNAL\";i:634125391;s:19:\"WP_ACCESSIBLE_HOSTS\";i:634125391;s:16:\"JETPACK__VERSION\";i:1206389815;s:12:\"IS_PRESSABLE\";i:634125391;s:15:\"DISABLE_WP_CRON\";i:634125391;s:17:\"ALTERNATE_WP_CRON\";i:634125391;s:20:\"WP_CRON_LOCK_TIMEOUT\";i:3994858278;s:11:\"PHP_VERSION\";i:262798114;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("66178", "jetpack_callables_sync_checksum", "a:27:{s:18:\"wp_max_upload_size\";i:2450289511;s:15:\"is_main_network\";i:734881840;s:13:\"is_multi_site\";i:734881840;s:17:\"main_network_site\";i:2598290571;s:8:\"site_url\";i:2598290571;s:8:\"home_url\";i:2598290571;s:16:\"single_user_site\";i:734881840;s:7:\"updates\";i:4249955436;s:28:\"has_file_system_write_access\";i:4261170317;s:21:\"is_version_controlled\";i:734881840;s:10:\"taxonomies\";i:1528062512;s:10:\"post_types\";i:2151051956;s:18:\"post_type_features\";i:2780249831;s:27:\"rest_api_allowed_post_types\";i:2508398024;s:32:\"rest_api_allowed_public_metadata\";i:223132457;s:24:\"sso_is_two_step_required\";i:734881840;s:26:\"sso_should_hide_login_form\";i:734881840;s:18:\"sso_match_by_email\";i:4261170317;s:21:\"sso_new_user_override\";i:734881840;s:29:\"sso_bypass_default_login_form\";i:734881840;s:10:\"wp_version\";i:1749470897;s:11:\"get_plugins\";i:1371189976;s:14:\"active_modules\";i:512523386;s:6:\"locale\";i:1256278236;s:16:\"hosting_provider\";i:409470892;s:13:\"site_icon_url\";i:734881840;s:10:\"shortcodes\";i:1904240399;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("35754", "mm_brand", "HostMonster", "yes");
INSERT INTO `wp_jzkb_options` VALUES("35755", "mm_host", "b71193ce-0c17-11e2-8b3b-0030483370c8", "yes");
INSERT INTO `wp_jzkb_options` VALUES("134629", "_site_transient_timeout_theme_roots", "1484737740", "no");
INSERT INTO `wp_jzkb_options` VALUES("134630", "_site_transient_theme_roots", "a:5:{s:8:\"arkfield\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";s:14:\"twentythirteen\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_jzkb_options` VALUES("41655", "jpo_firstrun", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("53830", "PDb_Db_version", "1.0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("53831", "pdb-default_options", "a:83:{s:21:\"image_upload_location\";s:41:\"wp-content/uploads/participants-database/\";s:18:\"image_upload_limit\";s:3:\"100\";s:18:\"allowed_file_types\";s:58:\"txt,pdf,mp3,mp4a,ogg,doc,docx,odt,rtf,zip,jpg,jpeg,gif,png\";s:13:\"default_image\";s:57:\"/wp-content/plugins/participants-database/ui/no-image.png\";s:10:\"image_link\";i:0;s:11:\"file_delete\";i:0;s:10:\"make_links\";i:0;s:13:\"email_protect\";i:0;s:19:\"empty_field_message\";s:25:\"The %s field is required.\";s:21:\"invalid_field_message\";s:37:\"The %s field appears to be incorrect.\";s:25:\"nonmatching_field_message\";s:37:\"The %s field must match the %s field.\";s:21:\"captcha_field_message\";s:33:\"Pleast try the %s question again.\";s:17:\"field_error_style\";s:21:\"border: 1px solid red\";s:20:\"mark_required_fields\";i:0;s:21:\"required_field_marker\";s:29:\"%s<span class=\"reqd\">*</span>\";s:18:\"signup_button_text\";s:7:\"Sign Up\";s:18:\"signup_thanks_page\";s:4:\"none\";s:30:\"signup_show_group_descriptions\";i:0;s:12:\"unique_field\";s:5:\"email\";s:12:\"unique_email\";i:1;s:23:\"duplicate_field_message\";s:60:\"A record with that %s already exists. Please choose another.\";s:25:\"send_signup_receipt_email\";i:1;s:20:\"receipt_from_address\";s:20:\"hello@dgtal-mind.com\";s:17:\"receipt_from_name\";s:24:\"...designing experience!\";s:28:\"signup_receipt_email_subject\";s:49:\"You\'ve just signed up on ...designing experience!\";s:25:\"signup_receipt_email_body\";s:259:\"<p>Thank you, [first_name], for signing up with ...designing experience!.</p><p>You may complete your registration with additional information or update your information by visiting this private link at any time: <a href=\"[record_link]\">[record_link]</a>.</p>\";s:13:\"signup_thanks\";s:237:\"<p>Thank you, [first_name] for signing up!</p><p>You will receive an email acknowledgement shortly. You may complete your registration with additional information or update your information by visiting the link provided in the email.</p>\";s:24:\"send_signup_notify_email\";i:1;s:29:\"email_signup_notify_addresses\";s:20:\"hello@dgtal-mind.com\";s:27:\"email_signup_notify_subject\";s:38:\"New signup on ...designing experience!\";s:24:\"email_signup_notify_body\";s:196:\"<p>A new signup has been submitted</p><ul><li>Name: [first_name] [last_name]</li><li>Email: [email]</li></ul><p>Edit this new record here: <a href=\"[admin_record_link]\">[admin_record_link]</a></p>\";s:17:\"registration_page\";s:0:\"\";s:23:\"show_group_descriptions\";i:0;s:18:\"save_changes_label\";s:17:\"Save Your Changes\";s:19:\"save_changes_button\";s:4:\"Save\";s:22:\"record_updated_message\";s:33:\"Your information has been updated\";s:23:\"no_record_error_message\";s:20:\"No record was found.\";s:22:\"no_record_use_template\";i:0;s:31:\"send_record_update_notify_email\";i:0;s:27:\"record_update_email_subject\";s:58:\"A record has just been updated on ...designing experience!\";s:24:\"record_update_email_body\";s:269:\"<p>The following record was updated on [date]:</p><ul><li>Name: [first_name] [last_name]</li><li>Address: [address]</li><li>[city], [state], [country]</li><li>Phone: [phone]</li><li>Email: [email]</li></ul><p>Edit this record <a href=\"[admin_record_link]\">here.</a></p>\";s:10:\"list_limit\";i:10;s:24:\"single_record_link_field\";s:0:\"\";s:18:\"single_record_page\";s:0:\"\";s:18:\"no_records_message\";s:16:\"No Records Found\";s:10:\"show_count\";i:0;s:14:\"count_template\";s:48:\"Total Records Found: %1$s, showing %2$s per page\";s:17:\"list_default_sort\";s:12:\"date_updated\";s:23:\"list_default_sort_order\";s:4:\"desc\";s:12:\"empty_search\";i:0;s:18:\"show_retrieve_link\";i:0;s:18:\"retrieve_link_text\";s:63:\"Forget your private link? Click here to have it emailed to you.\";s:19:\"link_retrieval_page\";s:4:\"none\";s:24:\"retrieve_link_identifier\";s:5:\"email\";s:15:\"id_field_prompt\";s:58:\"Type in your %s, your private link will be emailed to you.\";s:27:\"retrieve_link_email_subject\";s:53:\"Here is your private link on ...designing experience!\";s:24:\"retrieve_link_email_body\";s:125:\"<p>Here is the private link you requested from ...designing experience!:</p><p><a href=\"[record_link]\">[record_link]</a>.</p>\";s:31:\"send_retrieve_link_notify_email\";i:0;s:28:\"retrieve_link_notify_subject\";s:66:\"A Lost Private Link has been requested on ...designing experience!\";s:25:\"retrieve_link_notify_body\";s:120:\"<p>A lost private link has been requested by:</p><ul><li>Name: [first_name] [last_name]</li><li>Email: [email]</li></ul>\";s:24:\"identifier_field_message\";s:42:\"A record matching that %s cannot be found.\";s:14:\"use_plugin_css\";i:1;s:16:\"rich_text_editor\";i:1;s:14:\"enable_wpautop\";i:1;s:16:\"strip_linebreaks\";i:0;s:27:\"primary_email_address_field\";s:5:\"email\";s:10:\"html_email\";i:1;s:12:\"strict_dates\";i:0;s:17:\"input_date_format\";s:6:\"F j, Y\";s:9:\"show_time\";i:0;s:13:\"strict_search\";i:0;s:11:\"ajax_search\";i:1;s:16:\"use_php_sessions\";i:1;s:11:\"cookie_name\";s:14:\"pdb_wp_session\";s:18:\"admin_default_sort\";s:12:\"date_updated\";s:24:\"admin_default_sort_order\";s:4:\"desc\";s:16:\"admin_thumbnails\";i:0;s:18:\"admin_horiz_scroll\";i:0;s:22:\"record_edit_capability\";s:17:\"edit_others_posts\";s:23:\"plugin_admin_capability\";s:14:\"manage_options\";s:25:\"editor_allowed_csv_export\";s:1:\"0\";s:10:\"custom_css\";s:0:\"\";s:9:\"print_css\";s:88:\"/* this prevents the search controls from printing */\r.pdb-searchform {\r	display:none;\r}\";}", "no");
INSERT INTO `wp_jzkb_options` VALUES("53833", "_transient_pdb-admin-user-settings-1", "a:1:{s:10:\"list_limit\";i:10;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("53834", "_transient_pdb-admin_list_filter-1", "a:4:{s:6:\"search\";a:1:{i:0;a:4:{s:12:\"search_field\";s:4:\"none\";s:5:\"value\";s:0:\"\";s:8:\"operator\";s:4:\"LIKE\";s:5:\"logic\";s:3:\"AND\";}}s:6:\"sortBy\";s:12:\"date_updated\";s:7:\"ascdesc\";s:4:\"desc\";s:17:\"list_filter_count\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("53837", "pdb-option_version", "8.9", "yes");
INSERT INTO `wp_jzkb_options` VALUES("53838", "participants-database_options", "a:84:{s:21:\"image_upload_location\";s:41:\"wp-content/uploads/participants-database/\";s:18:\"image_upload_limit\";s:3:\"100\";s:18:\"allowed_file_types\";s:58:\"txt,pdf,mp3,mp4a,ogg,doc,docx,odt,rtf,zip,jpg,jpeg,gif,png\";s:13:\"default_image\";s:57:\"/wp-content/plugins/participants-database/ui/no-image.png\";s:10:\"image_link\";s:1:\"0\";s:11:\"file_delete\";s:1:\"0\";s:10:\"make_links\";s:1:\"0\";s:13:\"email_protect\";s:1:\"0\";s:19:\"empty_field_message\";s:25:\"The %s field is required.\";s:21:\"invalid_field_message\";s:37:\"The %s field appears to be incorrect.\";s:25:\"nonmatching_field_message\";s:37:\"The %s field must match the %s field.\";s:21:\"captcha_field_message\";s:33:\"Pleast try the %s question again.\";s:17:\"field_error_style\";s:22:\"border: 1px solid red;\";s:20:\"mark_required_fields\";s:1:\"1\";s:21:\"required_field_marker\";s:29:\"%s<span class=\"reqd\">*</span>\";s:18:\"signup_button_text\";s:7:\"Sign Up\";s:18:\"signup_thanks_page\";s:4:\"none\";s:30:\"signup_show_group_descriptions\";s:1:\"1\";s:12:\"unique_field\";s:5:\"email\";s:12:\"unique_email\";s:1:\"1\";s:23:\"duplicate_field_message\";s:60:\"A record with that %s already exists. Please choose another.\";s:25:\"send_signup_receipt_email\";s:1:\"1\";s:20:\"receipt_from_address\";s:20:\"hello@dgtal-mind.com\";s:17:\"receipt_from_name\";s:40:\"Dgtal-Mind usability experience research\";s:28:\"signup_receipt_email_subject\";s:60:\"You\'ve just signed up as Dgtal-Mind\'s Experience Participant\";s:25:\"signup_receipt_email_body\";s:338:\"Thank you, [first_name], for signing up with DGtal-Mind experience research group.\r\n\r\nYou may complete your registration with additional information or update your information by visiting this private link at any time: <a href=\"http://www.dgtal-mind.com/registration/\" target=\"_blank\">[record_link]</a>.\r\n\r\nRegards,\r\n\r\nAdmin @ DGtal-Mind\";s:13:\"signup_thanks\";s:261:\"Thank you, [first_name] for signing up!\r\n\r\nYou will receive an email acknowledgement shortly. You may complete your registration with additional information or update your information by visiting the link provided in the email.\r\n\r\nRegards,\r\n\r\nAdmin @ DGtal-Mind\";s:24:\"send_signup_notify_email\";s:1:\"1\";s:29:\"email_signup_notify_addresses\";s:44:\"hello@dgtal-mind.com, anthony@dgtal-mind.com\";s:27:\"email_signup_notify_subject\";s:51:\"New signup on DGtal-Mind experience research group.\";s:24:\"email_signup_notify_body\";s:196:\"A new signup has been submitted\r\n<ul>\r\n 	<li>Name: [first_name] [last_name]</li>\r\n 	<li>Email: [email]</li>\r\n</ul>\r\nEdit this new record here: <a href=\"[admin_record_link]\">[admin_record_link]</a>\";s:17:\"registration_page\";s:4:\"3490\";s:23:\"show_group_descriptions\";s:1:\"0\";s:18:\"save_changes_label\";s:17:\"Save Your Changes\";s:19:\"save_changes_button\";s:4:\"Save\";s:22:\"record_updated_message\";s:33:\"Your information has been updated\";s:23:\"no_record_error_message\";s:20:\"No record was found.\";s:22:\"no_record_use_template\";s:1:\"0\";s:31:\"send_record_update_notify_email\";s:1:\"0\";s:27:\"record_update_email_subject\";s:58:\"A record has just been updated on ...designing experience!\";s:24:\"record_update_email_body\";s:281:\"The following record was updated on [date]:\r\n<ul>\r\n 	<li>Name: [first_name] [last_name]</li>\r\n 	<li>Address: [address]</li>\r\n 	<li>[city], [state], [country]</li>\r\n 	<li>Phone: [phone]</li>\r\n 	<li>Email: [email]</li>\r\n</ul>\r\nEdit this record <a href=\"[admin_record_link]\">here.</a>\";s:10:\"list_limit\";s:2:\"10\";s:24:\"single_record_link_field\";s:4:\"none\";s:18:\"single_record_page\";s:0:\"\";s:18:\"no_records_message\";s:16:\"No Records Found\";s:10:\"show_count\";s:1:\"0\";s:14:\"count_template\";s:48:\"Total Records Found: %1$s, showing %2$s per page\";s:17:\"list_default_sort\";s:12:\"date_updated\";s:23:\"list_default_sort_order\";s:4:\"desc\";s:12:\"empty_search\";s:1:\"0\";s:18:\"show_retrieve_link\";s:1:\"0\";s:18:\"retrieve_link_text\";s:63:\"Forget your private link? Click here to have it emailed to you.\";s:19:\"link_retrieval_page\";s:4:\"none\";s:24:\"retrieve_link_identifier\";s:5:\"email\";s:15:\"id_field_prompt\";s:58:\"Type in your %s, your private link will be emailed to you.\";s:27:\"retrieve_link_email_subject\";s:53:\"Here is your private link on ...designing experience!\";s:24:\"retrieve_link_email_body\";s:115:\"Here is the private link you requested from ...designing experience!:\r\n\r\n<a href=\"[record_link]\">[record_link]</a>.\";s:31:\"send_retrieve_link_notify_email\";s:1:\"0\";s:28:\"retrieve_link_notify_subject\";s:66:\"A Lost Private Link has been requested on ...designing experience!\";s:25:\"retrieve_link_notify_body\";s:125:\"A lost private link has been requested by:\r\n<ul>\r\n 	<li>Name: [first_name] [last_name]</li>\r\n 	<li>Email: [email]</li>\r\n</ul>\";s:24:\"identifier_field_message\";s:42:\"A record matching that %s cannot be found.\";s:14:\"use_plugin_css\";s:1:\"1\";s:16:\"rich_text_editor\";s:1:\"1\";s:14:\"enable_wpautop\";s:1:\"1\";s:16:\"strip_linebreaks\";s:1:\"0\";s:27:\"primary_email_address_field\";s:5:\"email\";s:10:\"html_email\";s:1:\"1\";s:12:\"strict_dates\";s:1:\"0\";s:17:\"input_date_format\";s:6:\"F j, Y\";s:9:\"show_time\";s:1:\"0\";s:13:\"strict_search\";s:1:\"0\";s:11:\"ajax_search\";s:1:\"1\";s:16:\"use_php_sessions\";s:1:\"1\";s:11:\"cookie_name\";s:14:\"pdb_wp_session\";s:18:\"admin_default_sort\";s:12:\"date_updated\";s:24:\"admin_default_sort_order\";s:4:\"desc\";s:16:\"admin_thumbnails\";s:1:\"0\";s:18:\"admin_horiz_scroll\";s:1:\"0\";s:22:\"record_edit_capability\";s:17:\"edit_others_posts\";s:23:\"plugin_admin_capability\";s:14:\"manage_options\";s:25:\"editor_allowed_csv_export\";s:1:\"0\";s:10:\"custom_css\";s:71:\"border: 1px solid #acacac;\r\nmargin-bottom: 1.3125rem;\r\npadding: 0.7rem;\";s:9:\"print_css\";s:91:\"/* this prevents the search controls from printing */\r\n.pdb-searchform {\r\n	display:none;\r\n}\";s:28:\"use_pagination_scroll_anchor\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("134145", "_transient_timeout_jetpack_https_test", "1484748749", "no");
INSERT INTO `wp_jzkb_options` VALUES("134146", "_transient_jetpack_https_test", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("57534", "_transient_timeout_jetpack_https_test_message", "1484748749", "no");
INSERT INTO `wp_jzkb_options` VALUES("57535", "_transient_jetpack_https_test_message", "", "no");
INSERT INTO `wp_jzkb_options` VALUES("134564", "_transient_timeout_mm_api_calls", "1484822232", "no");
INSERT INTO `wp_jzkb_options` VALUES("134565", "_transient_mm_api_calls", "a:2:{s:32:\"8b6414ea1a1f66f96e32726bc72b5763\";a:6:{s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:10:{s:6:\"server\";s:12:\"nginx/1.10.1\";s:4:\"date\";s:29:\"Wed, 18 Jan 2017 10:32:28 GMT\";s:12:\"content-type\";s:16:\"application/json\";s:14:\"content-length\";s:3:\"461\";s:13:\"last-modified\";s:29:\"Thu, 19 May 2016 17:58:06 GMT\";s:4:\"etag\";s:14:\"\"573dfeae-1cd\"\";s:13:\"accept-ranges\";a:2:{i:0;s:5:\"bytes\";i:1;s:5:\"bytes\";}s:11:\"x-cacheable\";s:17:\"NO: Not Cacheable\";s:9:\"x-varnish\";s:9:\"453230534\";s:7:\"x-cache\";s:4:\"MISS\";}}s:4:\"body\";s:461:\"{\n   \"BlueHost\":\"bluehost\",\n   \"BlueHost_for_Education\":\"bluehost\",\n   \"BlueHost_Optimized_for_WordPress\":\"bluehost\",\n   \"Bluehost_QI\":\"bluehost\",\n   \"Just_Host\":\"default\",\n   \"Just_Host_QI\":\"default\",\n   \"HostMonster\":\"default\",\n   \"Hostmonster_QI\":\"default\",\n   \"HostGator_QI\":\"default\",\n   \"HostGator_com_for_Resellers\":\"default\",\n   \"Hostgator_Com_LLC\":\"default\",\n   \"HostGatorSG\":\"default\",\n   \"iPower\":\"ipower\",\n   \"iPage\":\"ipage\",\n   \"FatCow\":\"fatcow\"\n}\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;s:13:\"http_response\";O:25:\"WP_HTTP_Requests_Response\":5:{s:11:\"\0*\0response\";O:17:\"Requests_Response\":10:{s:4:\"body\";s:461:\"{\n   \"BlueHost\":\"bluehost\",\n   \"BlueHost_for_Education\":\"bluehost\",\n   \"BlueHost_Optimized_for_WordPress\":\"bluehost\",\n   \"Bluehost_QI\":\"bluehost\",\n   \"Just_Host\":\"default\",\n   \"Just_Host_QI\":\"default\",\n   \"HostMonster\":\"default\",\n   \"Hostmonster_QI\":\"default\",\n   \"HostGator_QI\":\"default\",\n   \"HostGator_com_for_Resellers\":\"default\",\n   \"Hostgator_Com_LLC\":\"default\",\n   \"HostGatorSG\":\"default\",\n   \"iPower\":\"ipower\",\n   \"iPage\":\"ipage\",\n   \"FatCow\":\"fatcow\"\n}\n\";s:3:\"raw\";s:792:\"HTTP/1.1 200 OK\r\nServer: nginx/1.10.1\r\nDate: Wed, 18 Jan 2017 10:32:28 GMT\r\nContent-Type: application/json\r\nContent-Length: 461\r\nConnection: close\r\nLast-Modified: Thu, 19 May 2016 17:58:06 GMT\r\nETag: \"573dfeae-1cd\"\r\nAccept-Ranges: bytes\r\nX-Cacheable: NO: Not Cacheable\r\nAccept-Ranges: bytes\r\nX-Varnish: 453230534\r\nX-Cache: MISS\r\n\r\n{\n   \"BlueHost\":\"bluehost\",\n   \"BlueHost_for_Education\":\"bluehost\",\n   \"BlueHost_Optimized_for_WordPress\":\"bluehost\",\n   \"Bluehost_QI\":\"bluehost\",\n   \"Just_Host\":\"default\",\n   \"Just_Host_QI\":\"default\",\n   \"HostMonster\":\"default\",\n   \"Hostmonster_QI\":\"default\",\n   \"HostGator_QI\":\"default\",\n   \"HostGator_com_for_Resellers\":\"default\",\n   \"Hostgator_Com_LLC\":\"default\",\n   \"HostGatorSG\":\"default\",\n   \"iPower\":\"ipower\",\n   \"iPage\":\"ipage\",\n   \"FatCow\":\"fatcow\"\n}\n\";s:7:\"headers\";O:25:\"Requests_Response_Headers\":1:{s:7:\"\0*\0data\";a:10:{s:6:\"server\";a:1:{i:0;s:12:\"nginx/1.10.1\";}s:4:\"date\";a:1:{i:0;s:29:\"Wed, 18 Jan 2017 10:32:28 GMT\";}s:12:\"content-type\";a:1:{i:0;s:16:\"application/json\";}s:14:\"content-length\";a:1:{i:0;s:3:\"461\";}s:13:\"last-modified\";a:1:{i:0;s:29:\"Thu, 19 May 2016 17:58:06 GMT\";}s:4:\"etag\";a:1:{i:0;s:14:\"\"573dfeae-1cd\"\";}s:13:\"accept-ranges\";a:2:{i:0;s:5:\"bytes\";i:1;s:5:\"bytes\";}s:11:\"x-cacheable\";a:1:{i:0;s:17:\"NO: Not Cacheable\";}s:9:\"x-varnish\";a:1:{i:0;s:9:\"453230534\";}s:7:\"x-cache\";a:1:{i:0;s:4:\"MISS\";}}}s:11:\"status_code\";i:200;s:16:\"protocol_version\";d:1.1000000000000001;s:7:\"success\";b:1;s:9:\"redirects\";i:0;s:3:\"url\";s:69:\"https://www.mojomarketplace.com/mojo-plugin-assets/json/branding.json\";s:7:\"history\";a:0:{}s:7:\"cookies\";O:19:\"Requests_Cookie_Jar\":1:{s:10:\"\0*\0cookies\";a:0:{}}}s:11:\"\0*\0filename\";N;s:4:\"data\";N;s:7:\"headers\";N;s:6:\"status\";N;}}s:32:\"a5ef76a6fdef8fa0451c7c8150f39e8b\";a:6:{s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:7:{s:13:\"accept-ranges\";s:5:\"bytes\";s:12:\"content-type\";s:16:\"application/json\";s:4:\"date\";s:29:\"Wed, 18 Jan 2017 10:37:12 GMT\";s:4:\"etag\";s:15:\"\"57fd06b5-4998\"\";s:13:\"last-modified\";s:29:\"Tue, 11 Oct 2016 15:35:17 GMT\";s:6:\"server\";s:12:\"nginx/1.10.1\";s:14:\"content-length\";s:5:\"18840\";}}s:4:\"body\";s:18840:\"{\n   \"\\/woo\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/commerce\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/shop\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/store\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/checkout\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/credit\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/sell\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/analytics\\/i\":{\n      \"id\":\"530697a6-92cc-4329-9cdd-21e40a140b28\",\n      \"name\":\"Google Analytics\",\n      \"title\":\"Google Analytics Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-google-analytics-to-your-wordpress-site\",\n      \"short_desc\":\" You can follow users on your site in real time and get in depth analysis as to their behaviors when browsing your website.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-530697a6-92cc-4329-9cdd-21e40a140b28-260x156-UXxnX.png\"\n   },\n   \"\\/stats\\/i\":{\n      \"id\":\"530697a6-92cc-4329-9cdd-21e40a140b28\",\n      \"name\":\"Google Analytics\",\n      \"title\":\"Google Analytics Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-google-analytics-to-your-wordpress-site\",\n      \"short_desc\":\" You can follow users on your site in real time and get in depth analysis as to their behaviors when browsing your website.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-530697a6-92cc-4329-9cdd-21e40a140b28-260x156-UXxnX.png\"\n   },\n   \"\\/sitemap\\/i\":{\n      \"id\":\"530788ba-c450-45eb-b154-47ce0a141528\",\n      \"name\":\"Sitemap\",\n      \"title\":\"SEO Sitemap Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-an-seo-friendly-sitemap-to-your-wordpress-site\",\n      \"short_desc\":\"Google loves to see a list of every page on your site and how those pages relate to each other.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-530788ba-c450-45eb-b154-47ce0a141528-260x156-r3HBm.png\"\n   },\n   \"\\/seo\\/i\":{\n      \"id\":\"53d7ea4d-e52c-42fe-9b7e-5ed50a141528\",\n      \"name\":\"Search Engine Optimization (seo)\",\n      \"title\":\"Search Engine Optimization (seo)\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/wordpress-seo\",\n      \"short_desc\":\"The service ensures your content is fully optimized for the search engines.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53d7ea4d-e52c-42fe-9b7e-5ed50a141528-260x156-0pE1j.png\"\n   },\n   \"\\/yoast\\/i\":{\n      \"id\":\"53d7ea4d-e52c-42fe-9b7e-5ed50a141528\",\n      \"name\":\"Setting Up Yoast SEO\",\n      \"title\":\"Setting Up Yoast SEO\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/wordpress-seo\",\n      \"short_desc\":\"The service ensures your content is fully optimized for the search engines.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53d7ea4d-e52c-42fe-9b7e-5ed50a141528-260x156-0pE1j.png\"\n   },\n   \"\\/buddypress\\/i\":{\n      \"id\":\"53078511-1974-470c-8ed5-43500a141528\",\n      \"name\":\"BuddyPress\",\n      \"title\":\"BuddyPress Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/install-and-setup-buddypress-wordpress-plugin\",\n      \"short_desc\":\"This service will have you all setup and ready to start using your website as a social network.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-53078511-1974-470c-8ed5-43500a141528-square-mm-resize-260x156-530bb499b8714.png\"\n   },\n   \"\\/buddy press\\/i\":{\n      \"id\":\"53078511-1974-470c-8ed5-43500a141528\",\n      \"name\":\"BuddyPress\",\n      \"title\":\"BuddyPress Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/install-and-setup-buddypress-wordpress-plugin\",\n      \"short_desc\":\"This service will have you all setup and ready to start using your website as a social network.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-53078511-1974-470c-8ed5-43500a141528-square-mm-resize-260x156-530bb499b8714.png\"\n   },\n   \"\\/bbpress\\/i\":{\n      \"id\":\"530783b3-d4d8-4823-ad1e-70310a140b28\",\n      \"name\":\"bbPress\",\n      \"title\":\"bbPress Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/install-and-setup-bbpress-wordpress-plugin\",\n      \"short_desc\":\"From within your WordPress admin, you can easily setup and moderate forums, topics and replies.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"http:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-530783b3-d4d8-4823-ad1e-70310a140b28-square-mm-resize-260x156-530bb1f321d8d.png\"\n   },\n   \"\\/bb press\\/i\":{\n      \"id\":\"530783b3-d4d8-4823-ad1e-70310a140b28\",\n      \"name\":\"bbPress\",\n      \"title\":\"bbPress Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/install-and-setup-bbpress-wordpress-plugin\",\n      \"short_desc\":\"From within your WordPress admin, you can easily setup and moderate forums, topics and replies.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"http:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-530783b3-d4d8-4823-ad1e-70310a140b28-square-mm-resize-260x156-530bb1f321d8d.png\"\n   },\n   \"\\/contact\\/i\":{\n      \"id\":\"\",\n      \"name\":\"Constant Contact Forms\",\n      \"title\":\"Constant Contact Forms\",\n      \"buy_now_btn\":\"Learn More\",\n      \"button_class\":\"button thickbox open-plugin-details-modal\",\n      \"detail_class\":\"thickbox open-plugin-details-modal\",\n      \"url\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"buy_now_link\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"short_desc\":\"Constant Contact Forms makes it fast and easy to capture visitor information right from your WordPress site.\",\n      \"author\":\"Constant Contact\",\n      \"author_url\":\"https://www.constantcontact.com/\",\n      \"img\":\"http:\\/\\/ps.w.org\\/constant-contact-forms\\/assets\\/icon-256x256.png\"\n   },\n   \"\\/ form\\/i\":{\n      \"id\":\"\",\n      \"name\":\"Constant Contact Forms\",\n      \"title\":\"Constant Contact Forms\",\n      \"buy_now_btn\":\"Learn More\",\n      \"button_class\":\"button thickbox open-plugin-details-modal\",\n      \"detail_class\":\"thickbox open-plugin-details-modal\",\n      \"url\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"buy_now_link\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"short_desc\":\"Constant Contact Forms makes it fast and easy to capture visitor information right from your WordPress site.\",\n      \"author\":\"Constant Contact\",\n      \"author_url\":\"https://www.constantcontact.com/\",\n      \"img\":\"http:\\/\\/ps.w.org\\/constant-contact-forms\\/assets\\/icon-256x256.png\"\n   },\n   \"\\/news\\/i\":{\n      \"id\":\"\",\n      \"name\":\"Constant Contact Forms\",\n      \"title\":\"Constant Contact Forms\",\n      \"buy_now_btn\":\"Learn More\",\n      \"button_class\":\"button thickbox open-plugin-details-modal\",\n      \"detail_class\":\"thickbox open-plugin-details-modal\",\n      \"url\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"buy_now_link\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"short_desc\":\"Constant Contact Forms makes it fast and easy to capture visitor information right from your WordPress site.\",\n      \"author\":\"Constant Contact\",\n      \"author_url\":\"https://www.constantcontact.com/\",\n      \"img\":\"http:\\/\\/ps.w.org\\/constant-contact-forms\\/assets\\/icon-256x256.png\"\n   },\n   \"\\/map\\/i\":{\n      \"id\":\"530786ea-27b8-4f1b-bc94-46650a141528\",\n      \"name\":\"Google Maps\",\n      \"title\":\"Setup a Google Map\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-a-google-map-to-my-wordpress-site\",\n      \"short_desc\":\"Let us add Google Maps to your WordPress website for you. We can add up to 10 different locations with include custom navigation.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"http:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-530786ea-27b8-4f1b-bc94-46650a141528-square-mm-resize-260x156-530d15d46aaab.png\"\n   },\n   \"\\/locat\\/i\":{\n      \"id\":\"530786ea-27b8-4f1b-bc94-46650a141528\",\n      \"name\":\"Google Maps\",\n      \"title\":\"Setup a Google Map\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-a-google-map-to-my-wordpress-site\",\n      \"short_desc\":\"Let us add Google Maps to your WordPress website for you. We can add up to 10 different locations with include custom navigation.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"http:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-530786ea-27b8-4f1b-bc94-46650a141528-square-mm-resize-260x156-530d15d46aaab.png\"\n   },\n   \"\\/hack\\/i\":{\n      \"id\":\"53b4501f-180c-4bd3-9b3f-56cb0a141528\",\n      \"name\":\"Securing Your WordPress Site\",\n      \"title\":\"Secure Your WordPress Site\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/make-my-wordpress-site-secure\",\n      \"short_desc\":\"Let us help you drastically increase your site’s security.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53b4501f-180c-4bd3-9b3f-56cb0a141528-260x156-Qji3u.png\"\n   },\n   \"\\/fence\\/i\":{\n      \"id\":\"53b4501f-180c-4bd3-9b3f-56cb0a141528\",\n      \"name\":\"Securing Your WordPress Site\",\n      \"title\":\"Secure Your WordPress Site\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/make-my-wordpress-site-secure\",\n      \"short_desc\":\"Let us help you drastically increase your site’s security.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53b4501f-180c-4bd3-9b3f-56cb0a141528-260x156-Qji3u.png\"\n   },\n   \"\\/protect\\/i\":{\n      \"id\":\"53b4501f-180c-4bd3-9b3f-56cb0a141528\",\n      \"name\":\"Securing Your WordPress Site\",\n      \"title\":\"Secure Your WordPress Site\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/make-my-wordpress-site-secure\",\n      \"short_desc\":\"Let us help you drastically increase your site’s security.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53b4501f-180c-4bd3-9b3f-56cb0a141528-260x156-Qji3u.png\"\n   },\n   \"\\/backup\\/i\":{\n      \"id\":\"53e00b04-03b8-4025-bb75-173c0a141528\",\n      \"name\":\"Configuring Your Site Backup\",\n      \"title\":\"Setup Site Backups\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/backup-your-wordpress-website\",\n      \"short_desc\":\"With this backup service we will set things up so you can continually backup your WordPress website.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53e00b04-03b8-4025-bb75-173c0a141528-260x156-cr17X.png\"\n   },\n   \"\\/restor\\/i\":{\n      \"id\":\"53e00b04-03b8-4025-bb75-173c0a141528\",\n      \"name\":\"Configuring Your Site Backup\",\n      \"title\":\"Setup Site Backups\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/backup-your-wordpress-website\",\n      \"short_desc\":\"With this backup service we will set things up so you can continually backup your WordPress website.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53e00b04-03b8-4025-bb75-173c0a141528-260x156-cr17X.png\"\n   },\n   \"\\/color\\/i\":{\n      \"id\":\"53ee5ec2-eff0-441a-944d-52050a140b28\",\n      \"name\":\"Changing Your Site Colors\",\n      \"title\":\"Change Your Site Colors\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/use-my-branding-to-customize-my-wordpress-site\",\n      \"short_desc\":\"\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5ec2-eff0-441a-944d-52050a140b28-260x156-1GDl6.png\"\n   },\n   \"\\/brand\\/i\":{\n      \"id\":\"53ee5ec2-eff0-441a-944d-52050a140b28\",\n      \"name\":\"Match Your Site Branding\",\n      \"title\":\"Match Your Site Branding\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/use-my-branding-to-customize-my-wordpress-site\",\n      \"short_desc\":\"This is a great way to ensure that your theme properly reflects your unique style and brand.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5ec2-eff0-441a-944d-52050a140b28-260x156-1GDl6.png\"\n   },\n   \"\\/design\\/i\":{\n      \"id\":\"53ee5ec2-eff0-441a-944d-52050a140b28\",\n      \"name\":\"Change The Colors In Your Design\",\n      \"title\":\"Change The Colors In Your Design\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/use-my-branding-to-customize-my-wordpress-site\",\n      \"short_desc\":\"This is a great way to ensure that your theme properly reflects your unique style and brand.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5ec2-eff0-441a-944d-52050a140b28-260x156-1GDl6.png\"\n   },\n   \"\\/copywri\\/i\":{\n      \"id\":\"53ee5dce-e2ec-4697-a09a-52050a140b28\",\n      \"name\":\"Professional Copywriting\",\n      \"title\":\"Professional Copywriting\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/professional-copywriting-for-your-wordpress-site\",\n      \"short_desc\":\"We have an amazing team of college grads and English majors who just love writing content (Weird, right?).\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5dce-e2ec-4697-a09a-52050a140b28-260x156-EGNP7.png\"\n   },\n   \"\\/content\\/i\":{\n      \"id\":\"53ee5dce-e2ec-4697-a09a-52050a140b28\",\n      \"name\":\"Writing Professional Content\",\n      \"title\":\"Writing Professional Content\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/professional-copywriting-for-your-wordpress-site\",\n      \"short_desc\":\"We have an amazing team of college grads and English majors who just love writing content (Weird, right?).\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5dce-e2ec-4697-a09a-52050a140b28-260x156-EGNP7.png\"\n   },\n   \"\\/write\\/i\":{\n      \"id\":\"53ee5dce-e2ec-4697-a09a-52050a140b28\",\n      \"name\":\"Professionaly Written Copy\",\n      \"title\":\"Professionaly Written Copy\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/professional-copywriting-for-your-wordpress-site\",\n      \"short_desc\":\"We have an amazing team of college grads and English majors who just love writing content (Weird, right?).\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5dce-e2ec-4697-a09a-52050a140b28-260x156-EGNP7.png\"\n   }\n}\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;s:13:\"http_response\";O:25:\"WP_HTTP_Requests_Response\":5:{s:11:\"\0*\0response\";O:17:\"Requests_Response\":10:{s:4:\"body\";s:18840:\"{\n   \"\\/woo\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/commerce\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/shop\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/store\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/checkout\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/credit\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/sell\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/analytics\\/i\":{\n      \"id\":\"530697a6-92cc-4329-9cdd-21e40a140b28\",\n      \"name\":\"Google Analytics\",\n      \"title\":\"Google Analytics Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-google-analytics-to-your-wordpress-site\",\n      \"short_desc\":\" You can follow users on your site in real time and get in depth analysis as to their behaviors when browsing your website.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-530697a6-92cc-4329-9cdd-21e40a140b28-260x156-UXxnX.png\"\n   },\n   \"\\/stats\\/i\":{\n      \"id\":\"530697a6-92cc-4329-9cdd-21e40a140b28\",\n      \"name\":\"Google Analytics\",\n      \"title\":\"Google Analytics Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-google-analytics-to-your-wordpress-site\",\n      \"short_desc\":\" You can follow users on your site in real time and get in depth analysis as to their behaviors when browsing your website.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-530697a6-92cc-4329-9cdd-21e40a140b28-260x156-UXxnX.png\"\n   },\n   \"\\/sitemap\\/i\":{\n      \"id\":\"530788ba-c450-45eb-b154-47ce0a141528\",\n      \"name\":\"Sitemap\",\n      \"title\":\"SEO Sitemap Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-an-seo-friendly-sitemap-to-your-wordpress-site\",\n      \"short_desc\":\"Google loves to see a list of every page on your site and how those pages relate to each other.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-530788ba-c450-45eb-b154-47ce0a141528-260x156-r3HBm.png\"\n   },\n   \"\\/seo\\/i\":{\n      \"id\":\"53d7ea4d-e52c-42fe-9b7e-5ed50a141528\",\n      \"name\":\"Search Engine Optimization (seo)\",\n      \"title\":\"Search Engine Optimization (seo)\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/wordpress-seo\",\n      \"short_desc\":\"The service ensures your content is fully optimized for the search engines.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53d7ea4d-e52c-42fe-9b7e-5ed50a141528-260x156-0pE1j.png\"\n   },\n   \"\\/yoast\\/i\":{\n      \"id\":\"53d7ea4d-e52c-42fe-9b7e-5ed50a141528\",\n      \"name\":\"Setting Up Yoast SEO\",\n      \"title\":\"Setting Up Yoast SEO\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/wordpress-seo\",\n      \"short_desc\":\"The service ensures your content is fully optimized for the search engines.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53d7ea4d-e52c-42fe-9b7e-5ed50a141528-260x156-0pE1j.png\"\n   },\n   \"\\/buddypress\\/i\":{\n      \"id\":\"53078511-1974-470c-8ed5-43500a141528\",\n      \"name\":\"BuddyPress\",\n      \"title\":\"BuddyPress Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/install-and-setup-buddypress-wordpress-plugin\",\n      \"short_desc\":\"This service will have you all setup and ready to start using your website as a social network.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-53078511-1974-470c-8ed5-43500a141528-square-mm-resize-260x156-530bb499b8714.png\"\n   },\n   \"\\/buddy press\\/i\":{\n      \"id\":\"53078511-1974-470c-8ed5-43500a141528\",\n      \"name\":\"BuddyPress\",\n      \"title\":\"BuddyPress Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/install-and-setup-buddypress-wordpress-plugin\",\n      \"short_desc\":\"This service will have you all setup and ready to start using your website as a social network.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-53078511-1974-470c-8ed5-43500a141528-square-mm-resize-260x156-530bb499b8714.png\"\n   },\n   \"\\/bbpress\\/i\":{\n      \"id\":\"530783b3-d4d8-4823-ad1e-70310a140b28\",\n      \"name\":\"bbPress\",\n      \"title\":\"bbPress Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/install-and-setup-bbpress-wordpress-plugin\",\n      \"short_desc\":\"From within your WordPress admin, you can easily setup and moderate forums, topics and replies.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"http:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-530783b3-d4d8-4823-ad1e-70310a140b28-square-mm-resize-260x156-530bb1f321d8d.png\"\n   },\n   \"\\/bb press\\/i\":{\n      \"id\":\"530783b3-d4d8-4823-ad1e-70310a140b28\",\n      \"name\":\"bbPress\",\n      \"title\":\"bbPress Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/install-and-setup-bbpress-wordpress-plugin\",\n      \"short_desc\":\"From within your WordPress admin, you can easily setup and moderate forums, topics and replies.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"http:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-530783b3-d4d8-4823-ad1e-70310a140b28-square-mm-resize-260x156-530bb1f321d8d.png\"\n   },\n   \"\\/contact\\/i\":{\n      \"id\":\"\",\n      \"name\":\"Constant Contact Forms\",\n      \"title\":\"Constant Contact Forms\",\n      \"buy_now_btn\":\"Learn More\",\n      \"button_class\":\"button thickbox open-plugin-details-modal\",\n      \"detail_class\":\"thickbox open-plugin-details-modal\",\n      \"url\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"buy_now_link\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"short_desc\":\"Constant Contact Forms makes it fast and easy to capture visitor information right from your WordPress site.\",\n      \"author\":\"Constant Contact\",\n      \"author_url\":\"https://www.constantcontact.com/\",\n      \"img\":\"http:\\/\\/ps.w.org\\/constant-contact-forms\\/assets\\/icon-256x256.png\"\n   },\n   \"\\/ form\\/i\":{\n      \"id\":\"\",\n      \"name\":\"Constant Contact Forms\",\n      \"title\":\"Constant Contact Forms\",\n      \"buy_now_btn\":\"Learn More\",\n      \"button_class\":\"button thickbox open-plugin-details-modal\",\n      \"detail_class\":\"thickbox open-plugin-details-modal\",\n      \"url\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"buy_now_link\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"short_desc\":\"Constant Contact Forms makes it fast and easy to capture visitor information right from your WordPress site.\",\n      \"author\":\"Constant Contact\",\n      \"author_url\":\"https://www.constantcontact.com/\",\n      \"img\":\"http:\\/\\/ps.w.org\\/constant-contact-forms\\/assets\\/icon-256x256.png\"\n   },\n   \"\\/news\\/i\":{\n      \"id\":\"\",\n      \"name\":\"Constant Contact Forms\",\n      \"title\":\"Constant Contact Forms\",\n      \"buy_now_btn\":\"Learn More\",\n      \"button_class\":\"button thickbox open-plugin-details-modal\",\n      \"detail_class\":\"thickbox open-plugin-details-modal\",\n      \"url\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"buy_now_link\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"short_desc\":\"Constant Contact Forms makes it fast and easy to capture visitor information right from your WordPress site.\",\n      \"author\":\"Constant Contact\",\n      \"author_url\":\"https://www.constantcontact.com/\",\n      \"img\":\"http:\\/\\/ps.w.org\\/constant-contact-forms\\/assets\\/icon-256x256.png\"\n   },\n   \"\\/map\\/i\":{\n      \"id\":\"530786ea-27b8-4f1b-bc94-46650a141528\",\n      \"name\":\"Google Maps\",\n      \"title\":\"Setup a Google Map\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-a-google-map-to-my-wordpress-site\",\n      \"short_desc\":\"Let us add Google Maps to your WordPress website for you. We can add up to 10 different locations with include custom navigation.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"http:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-530786ea-27b8-4f1b-bc94-46650a141528-square-mm-resize-260x156-530d15d46aaab.png\"\n   },\n   \"\\/locat\\/i\":{\n      \"id\":\"530786ea-27b8-4f1b-bc94-46650a141528\",\n      \"name\":\"Google Maps\",\n      \"title\":\"Setup a Google Map\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-a-google-map-to-my-wordpress-site\",\n      \"short_desc\":\"Let us add Google Maps to your WordPress website for you. We can add up to 10 different locations with include custom navigation.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"http:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-530786ea-27b8-4f1b-bc94-46650a141528-square-mm-resize-260x156-530d15d46aaab.png\"\n   },\n   \"\\/hack\\/i\":{\n      \"id\":\"53b4501f-180c-4bd3-9b3f-56cb0a141528\",\n      \"name\":\"Securing Your WordPress Site\",\n      \"title\":\"Secure Your WordPress Site\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/make-my-wordpress-site-secure\",\n      \"short_desc\":\"Let us help you drastically increase your site’s security.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53b4501f-180c-4bd3-9b3f-56cb0a141528-260x156-Qji3u.png\"\n   },\n   \"\\/fence\\/i\":{\n      \"id\":\"53b4501f-180c-4bd3-9b3f-56cb0a141528\",\n      \"name\":\"Securing Your WordPress Site\",\n      \"title\":\"Secure Your WordPress Site\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/make-my-wordpress-site-secure\",\n      \"short_desc\":\"Let us help you drastically increase your site’s security.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53b4501f-180c-4bd3-9b3f-56cb0a141528-260x156-Qji3u.png\"\n   },\n   \"\\/protect\\/i\":{\n      \"id\":\"53b4501f-180c-4bd3-9b3f-56cb0a141528\",\n      \"name\":\"Securing Your WordPress Site\",\n      \"title\":\"Secure Your WordPress Site\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/make-my-wordpress-site-secure\",\n      \"short_desc\":\"Let us help you drastically increase your site’s security.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53b4501f-180c-4bd3-9b3f-56cb0a141528-260x156-Qji3u.png\"\n   },\n   \"\\/backup\\/i\":{\n      \"id\":\"53e00b04-03b8-4025-bb75-173c0a141528\",\n      \"name\":\"Configuring Your Site Backup\",\n      \"title\":\"Setup Site Backups\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/backup-your-wordpress-website\",\n      \"short_desc\":\"With this backup service we will set things up so you can continually backup your WordPress website.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53e00b04-03b8-4025-bb75-173c0a141528-260x156-cr17X.png\"\n   },\n   \"\\/restor\\/i\":{\n      \"id\":\"53e00b04-03b8-4025-bb75-173c0a141528\",\n      \"name\":\"Configuring Your Site Backup\",\n      \"title\":\"Setup Site Backups\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/backup-your-wordpress-website\",\n      \"short_desc\":\"With this backup service we will set things up so you can continually backup your WordPress website.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53e00b04-03b8-4025-bb75-173c0a141528-260x156-cr17X.png\"\n   },\n   \"\\/color\\/i\":{\n      \"id\":\"53ee5ec2-eff0-441a-944d-52050a140b28\",\n      \"name\":\"Changing Your Site Colors\",\n      \"title\":\"Change Your Site Colors\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/use-my-branding-to-customize-my-wordpress-site\",\n      \"short_desc\":\"\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5ec2-eff0-441a-944d-52050a140b28-260x156-1GDl6.png\"\n   },\n   \"\\/brand\\/i\":{\n      \"id\":\"53ee5ec2-eff0-441a-944d-52050a140b28\",\n      \"name\":\"Match Your Site Branding\",\n      \"title\":\"Match Your Site Branding\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/use-my-branding-to-customize-my-wordpress-site\",\n      \"short_desc\":\"This is a great way to ensure that your theme properly reflects your unique style and brand.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5ec2-eff0-441a-944d-52050a140b28-260x156-1GDl6.png\"\n   },\n   \"\\/design\\/i\":{\n      \"id\":\"53ee5ec2-eff0-441a-944d-52050a140b28\",\n      \"name\":\"Change The Colors In Your Design\",\n      \"title\":\"Change The Colors In Your Design\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/use-my-branding-to-customize-my-wordpress-site\",\n      \"short_desc\":\"This is a great way to ensure that your theme properly reflects your unique style and brand.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5ec2-eff0-441a-944d-52050a140b28-260x156-1GDl6.png\"\n   },\n   \"\\/copywri\\/i\":{\n      \"id\":\"53ee5dce-e2ec-4697-a09a-52050a140b28\",\n      \"name\":\"Professional Copywriting\",\n      \"title\":\"Professional Copywriting\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/professional-copywriting-for-your-wordpress-site\",\n      \"short_desc\":\"We have an amazing team of college grads and English majors who just love writing content (Weird, right?).\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5dce-e2ec-4697-a09a-52050a140b28-260x156-EGNP7.png\"\n   },\n   \"\\/content\\/i\":{\n      \"id\":\"53ee5dce-e2ec-4697-a09a-52050a140b28\",\n      \"name\":\"Writing Professional Content\",\n      \"title\":\"Writing Professional Content\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/professional-copywriting-for-your-wordpress-site\",\n      \"short_desc\":\"We have an amazing team of college grads and English majors who just love writing content (Weird, right?).\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5dce-e2ec-4697-a09a-52050a140b28-260x156-EGNP7.png\"\n   },\n   \"\\/write\\/i\":{\n      \"id\":\"53ee5dce-e2ec-4697-a09a-52050a140b28\",\n      \"name\":\"Professionaly Written Copy\",\n      \"title\":\"Professionaly Written Copy\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/professional-copywriting-for-your-wordpress-site\",\n      \"short_desc\":\"We have an amazing team of college grads and English majors who just love writing content (Weird, right?).\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5dce-e2ec-4697-a09a-52050a140b28-260x156-EGNP7.png\"\n   }\n}\";s:3:\"raw\";s:19083:\"HTTP/1.1 200 OK\r\nAccept-Ranges: bytes\r\nContent-Type: application/json\r\nDate: Wed, 18 Jan 2017 10:37:12 GMT\r\nETag: \"57fd06b5-4998\"\r\nLast-Modified: Tue, 11 Oct 2016 15:35:17 GMT\r\nServer: nginx/1.10.1\r\nContent-Length: 18840\r\nConnection: Close\r\n\r\n{\n   \"\\/woo\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/commerce\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/shop\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/store\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/checkout\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/credit\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/sell\\/i\":{\n      \"id\":\"530782e3-1388-4e6a-a8ac-6f7b0a140b28\",\n      \"name\":\"WooCommerce\",\n      \"title\":\"WooCommerce Integration\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/integrate-woocommerce-onto-wordpress-site\",\n      \"short_desc\":\"WooCommerce will transform your WordPress site into a full eCommerce store that is simple to use.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-532c8ae2-5c38-4636-8c69-15550a141528-260x156-mDPp8.png\"\n   },\n   \"\\/analytics\\/i\":{\n      \"id\":\"530697a6-92cc-4329-9cdd-21e40a140b28\",\n      \"name\":\"Google Analytics\",\n      \"title\":\"Google Analytics Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-google-analytics-to-your-wordpress-site\",\n      \"short_desc\":\" You can follow users on your site in real time and get in depth analysis as to their behaviors when browsing your website.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-530697a6-92cc-4329-9cdd-21e40a140b28-260x156-UXxnX.png\"\n   },\n   \"\\/stats\\/i\":{\n      \"id\":\"530697a6-92cc-4329-9cdd-21e40a140b28\",\n      \"name\":\"Google Analytics\",\n      \"title\":\"Google Analytics Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-google-analytics-to-your-wordpress-site\",\n      \"short_desc\":\" You can follow users on your site in real time and get in depth analysis as to their behaviors when browsing your website.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-530697a6-92cc-4329-9cdd-21e40a140b28-260x156-UXxnX.png\"\n   },\n   \"\\/sitemap\\/i\":{\n      \"id\":\"530788ba-c450-45eb-b154-47ce0a141528\",\n      \"name\":\"Sitemap\",\n      \"title\":\"SEO Sitemap Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-an-seo-friendly-sitemap-to-your-wordpress-site\",\n      \"short_desc\":\"Google loves to see a list of every page on your site and how those pages relate to each other.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-530788ba-c450-45eb-b154-47ce0a141528-260x156-r3HBm.png\"\n   },\n   \"\\/seo\\/i\":{\n      \"id\":\"53d7ea4d-e52c-42fe-9b7e-5ed50a141528\",\n      \"name\":\"Search Engine Optimization (seo)\",\n      \"title\":\"Search Engine Optimization (seo)\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/wordpress-seo\",\n      \"short_desc\":\"The service ensures your content is fully optimized for the search engines.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53d7ea4d-e52c-42fe-9b7e-5ed50a141528-260x156-0pE1j.png\"\n   },\n   \"\\/yoast\\/i\":{\n      \"id\":\"53d7ea4d-e52c-42fe-9b7e-5ed50a141528\",\n      \"name\":\"Setting Up Yoast SEO\",\n      \"title\":\"Setting Up Yoast SEO\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/wordpress-seo\",\n      \"short_desc\":\"The service ensures your content is fully optimized for the search engines.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53d7ea4d-e52c-42fe-9b7e-5ed50a141528-260x156-0pE1j.png\"\n   },\n   \"\\/buddypress\\/i\":{\n      \"id\":\"53078511-1974-470c-8ed5-43500a141528\",\n      \"name\":\"BuddyPress\",\n      \"title\":\"BuddyPress Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/install-and-setup-buddypress-wordpress-plugin\",\n      \"short_desc\":\"This service will have you all setup and ready to start using your website as a social network.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-53078511-1974-470c-8ed5-43500a141528-square-mm-resize-260x156-530bb499b8714.png\"\n   },\n   \"\\/buddy press\\/i\":{\n      \"id\":\"53078511-1974-470c-8ed5-43500a141528\",\n      \"name\":\"BuddyPress\",\n      \"title\":\"BuddyPress Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/install-and-setup-buddypress-wordpress-plugin\",\n      \"short_desc\":\"This service will have you all setup and ready to start using your website as a social network.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-53078511-1974-470c-8ed5-43500a141528-square-mm-resize-260x156-530bb499b8714.png\"\n   },\n   \"\\/bbpress\\/i\":{\n      \"id\":\"530783b3-d4d8-4823-ad1e-70310a140b28\",\n      \"name\":\"bbPress\",\n      \"title\":\"bbPress Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/install-and-setup-bbpress-wordpress-plugin\",\n      \"short_desc\":\"From within your WordPress admin, you can easily setup and moderate forums, topics and replies.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"http:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-530783b3-d4d8-4823-ad1e-70310a140b28-square-mm-resize-260x156-530bb1f321d8d.png\"\n   },\n   \"\\/bb press\\/i\":{\n      \"id\":\"530783b3-d4d8-4823-ad1e-70310a140b28\",\n      \"name\":\"bbPress\",\n      \"title\":\"bbPress Setup\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/install-and-setup-bbpress-wordpress-plugin\",\n      \"short_desc\":\"From within your WordPress admin, you can easily setup and moderate forums, topics and replies.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"http:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-530783b3-d4d8-4823-ad1e-70310a140b28-square-mm-resize-260x156-530bb1f321d8d.png\"\n   },\n   \"\\/contact\\/i\":{\n      \"id\":\"\",\n      \"name\":\"Constant Contact Forms\",\n      \"title\":\"Constant Contact Forms\",\n      \"buy_now_btn\":\"Learn More\",\n      \"button_class\":\"button thickbox open-plugin-details-modal\",\n      \"detail_class\":\"thickbox open-plugin-details-modal\",\n      \"url\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"buy_now_link\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"short_desc\":\"Constant Contact Forms makes it fast and easy to capture visitor information right from your WordPress site.\",\n      \"author\":\"Constant Contact\",\n      \"author_url\":\"https://www.constantcontact.com/\",\n      \"img\":\"http:\\/\\/ps.w.org\\/constant-contact-forms\\/assets\\/icon-256x256.png\"\n   },\n   \"\\/ form\\/i\":{\n      \"id\":\"\",\n      \"name\":\"Constant Contact Forms\",\n      \"title\":\"Constant Contact Forms\",\n      \"buy_now_btn\":\"Learn More\",\n      \"button_class\":\"button thickbox open-plugin-details-modal\",\n      \"detail_class\":\"thickbox open-plugin-details-modal\",\n      \"url\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"buy_now_link\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"short_desc\":\"Constant Contact Forms makes it fast and easy to capture visitor information right from your WordPress site.\",\n      \"author\":\"Constant Contact\",\n      \"author_url\":\"https://www.constantcontact.com/\",\n      \"img\":\"http:\\/\\/ps.w.org\\/constant-contact-forms\\/assets\\/icon-256x256.png\"\n   },\n   \"\\/news\\/i\":{\n      \"id\":\"\",\n      \"name\":\"Constant Contact Forms\",\n      \"title\":\"Constant Contact Forms\",\n      \"buy_now_btn\":\"Learn More\",\n      \"button_class\":\"button thickbox open-plugin-details-modal\",\n      \"detail_class\":\"thickbox open-plugin-details-modal\",\n      \"url\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"buy_now_link\":\"plugin-install.php?tab=plugin-information&plugin=constant-contact-forms&TB_iframe=true&width=600&height=550\",\n      \"short_desc\":\"Constant Contact Forms makes it fast and easy to capture visitor information right from your WordPress site.\",\n      \"author\":\"Constant Contact\",\n      \"author_url\":\"https://www.constantcontact.com/\",\n      \"img\":\"http:\\/\\/ps.w.org\\/constant-contact-forms\\/assets\\/icon-256x256.png\"\n   },\n   \"\\/map\\/i\":{\n      \"id\":\"530786ea-27b8-4f1b-bc94-46650a141528\",\n      \"name\":\"Google Maps\",\n      \"title\":\"Setup a Google Map\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-a-google-map-to-my-wordpress-site\",\n      \"short_desc\":\"Let us add Google Maps to your WordPress website for you. We can add up to 10 different locations with include custom navigation.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"http:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-530786ea-27b8-4f1b-bc94-46650a141528-square-mm-resize-260x156-530d15d46aaab.png\"\n   },\n   \"\\/locat\\/i\":{\n      \"id\":\"530786ea-27b8-4f1b-bc94-46650a141528\",\n      \"name\":\"Google Maps\",\n      \"title\":\"Setup a Google Map\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/add-a-google-map-to-my-wordpress-site\",\n      \"short_desc\":\"Let us add Google Maps to your WordPress website for you. We can add up to 10 different locations with include custom navigation.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"http:\\/\\/images.mojomarketplace.com\\/images\\/thumbnail-530786ea-27b8-4f1b-bc94-46650a141528-square-mm-resize-260x156-530d15d46aaab.png\"\n   },\n   \"\\/hack\\/i\":{\n      \"id\":\"53b4501f-180c-4bd3-9b3f-56cb0a141528\",\n      \"name\":\"Securing Your WordPress Site\",\n      \"title\":\"Secure Your WordPress Site\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/make-my-wordpress-site-secure\",\n      \"short_desc\":\"Let us help you drastically increase your site’s security.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53b4501f-180c-4bd3-9b3f-56cb0a141528-260x156-Qji3u.png\"\n   },\n   \"\\/fence\\/i\":{\n      \"id\":\"53b4501f-180c-4bd3-9b3f-56cb0a141528\",\n      \"name\":\"Securing Your WordPress Site\",\n      \"title\":\"Secure Your WordPress Site\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/make-my-wordpress-site-secure\",\n      \"short_desc\":\"Let us help you drastically increase your site’s security.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53b4501f-180c-4bd3-9b3f-56cb0a141528-260x156-Qji3u.png\"\n   },\n   \"\\/protect\\/i\":{\n      \"id\":\"53b4501f-180c-4bd3-9b3f-56cb0a141528\",\n      \"name\":\"Securing Your WordPress Site\",\n      \"title\":\"Secure Your WordPress Site\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/make-my-wordpress-site-secure\",\n      \"short_desc\":\"Let us help you drastically increase your site’s security.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53b4501f-180c-4bd3-9b3f-56cb0a141528-260x156-Qji3u.png\"\n   },\n   \"\\/backup\\/i\":{\n      \"id\":\"53e00b04-03b8-4025-bb75-173c0a141528\",\n      \"name\":\"Configuring Your Site Backup\",\n      \"title\":\"Setup Site Backups\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/backup-your-wordpress-website\",\n      \"short_desc\":\"With this backup service we will set things up so you can continually backup your WordPress website.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53e00b04-03b8-4025-bb75-173c0a141528-260x156-cr17X.png\"\n   },\n   \"\\/restor\\/i\":{\n      \"id\":\"53e00b04-03b8-4025-bb75-173c0a141528\",\n      \"name\":\"Configuring Your Site Backup\",\n      \"title\":\"Setup Site Backups\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/backup-your-wordpress-website\",\n      \"short_desc\":\"With this backup service we will set things up so you can continually backup your WordPress website.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53e00b04-03b8-4025-bb75-173c0a141528-260x156-cr17X.png\"\n   },\n   \"\\/color\\/i\":{\n      \"id\":\"53ee5ec2-eff0-441a-944d-52050a140b28\",\n      \"name\":\"Changing Your Site Colors\",\n      \"title\":\"Change Your Site Colors\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/use-my-branding-to-customize-my-wordpress-site\",\n      \"short_desc\":\"\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5ec2-eff0-441a-944d-52050a140b28-260x156-1GDl6.png\"\n   },\n   \"\\/brand\\/i\":{\n      \"id\":\"53ee5ec2-eff0-441a-944d-52050a140b28\",\n      \"name\":\"Match Your Site Branding\",\n      \"title\":\"Match Your Site Branding\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/use-my-branding-to-customize-my-wordpress-site\",\n      \"short_desc\":\"This is a great way to ensure that your theme properly reflects your unique style and brand.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5ec2-eff0-441a-944d-52050a140b28-260x156-1GDl6.png\"\n   },\n   \"\\/design\\/i\":{\n      \"id\":\"53ee5ec2-eff0-441a-944d-52050a140b28\",\n      \"name\":\"Change The Colors In Your Design\",\n      \"title\":\"Change The Colors In Your Design\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/use-my-branding-to-customize-my-wordpress-site\",\n      \"short_desc\":\"This is a great way to ensure that your theme properly reflects your unique style and brand.\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5ec2-eff0-441a-944d-52050a140b28-260x156-1GDl6.png\"\n   },\n   \"\\/copywri\\/i\":{\n      \"id\":\"53ee5dce-e2ec-4697-a09a-52050a140b28\",\n      \"name\":\"Professional Copywriting\",\n      \"title\":\"Professional Copywriting\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/professional-copywriting-for-your-wordpress-site\",\n      \"short_desc\":\"We have an amazing team of college grads and English majors who just love writing content (Weird, right?).\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5dce-e2ec-4697-a09a-52050a140b28-260x156-EGNP7.png\"\n   },\n   \"\\/content\\/i\":{\n      \"id\":\"53ee5dce-e2ec-4697-a09a-52050a140b28\",\n      \"name\":\"Writing Professional Content\",\n      \"title\":\"Writing Professional Content\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/professional-copywriting-for-your-wordpress-site\",\n      \"short_desc\":\"We have an amazing team of college grads and English majors who just love writing content (Weird, right?).\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5dce-e2ec-4697-a09a-52050a140b28-260x156-EGNP7.png\"\n   },\n   \"\\/write\\/i\":{\n      \"id\":\"53ee5dce-e2ec-4697-a09a-52050a140b28\",\n      \"name\":\"Professionaly Written Copy\",\n      \"title\":\"Professionaly Written Copy\",\n      \"url\":\"https:\\/\\/www.mojomarketplace.com\\/item\\/professional-copywriting-for-your-wordpress-site\",\n      \"short_desc\":\"We have an amazing team of college grads and English majors who just love writing content (Weird, right?).\",\n      \"author\":\"\",\n      \"author_url\":\"\",\n      \"img\":\"https:\\/\\/marketplace-images-production.s3-us-west-2.amazonaws.com\\/vault\\/items\\/thumbnail-53ee5dce-e2ec-4697-a09a-52050a140b28-260x156-EGNP7.png\"\n   }\n}\";s:7:\"headers\";O:25:\"Requests_Response_Headers\":1:{s:7:\"\0*\0data\";a:7:{s:13:\"accept-ranges\";a:1:{i:0;s:5:\"bytes\";}s:12:\"content-type\";a:1:{i:0;s:16:\"application/json\";}s:4:\"date\";a:1:{i:0;s:29:\"Wed, 18 Jan 2017 10:37:12 GMT\";}s:4:\"etag\";a:1:{i:0;s:15:\"\"57fd06b5-4998\"\";}s:13:\"last-modified\";a:1:{i:0;s:29:\"Tue, 11 Oct 2016 15:35:17 GMT\";}s:6:\"server\";a:1:{i:0;s:12:\"nginx/1.10.1\";}s:14:\"content-length\";a:1:{i:0;s:5:\"18840\";}}}s:11:\"status_code\";i:200;s:16:\"protocol_version\";d:1.1000000000000001;s:7:\"success\";b:1;s:9:\"redirects\";i:0;s:3:\"url\";s:76:\"https://api.mojomarketplace.com/mojo-plugin-assets/json/search-patterns.json\";s:7:\"history\";a:0:{}s:7:\"cookies\";O:19:\"Requests_Cookie_Jar\":1:{s:10:\"\0*\0cookies\";a:0:{}}}s:11:\"\0*\0filename\";N;s:4:\"data\";N;s:7:\"headers\";N;s:6:\"status\";N;}}}", "no");
INSERT INTO `wp_jzkb_options` VALUES("60414", "_transient_timeout_mm_notification", "1815512414", "no");
INSERT INTO `wp_jzkb_options` VALUES("60415", "_transient_mm_notification", "O:8:\"stdClass\":2:{s:6:\"status\";s:7:\"success\";s:12:\"notification\";O:8:\"stdClass\":6:{s:2:\"id\";s:36:\"80e050b4-490a-11e6-9055-0a1706783fd3\";s:7:\"message\";s:256:\"<a href=\"http://mojo.live/wplive103\" style=\"float: left; padding-top: 10px;\n\"><div style=\"display: inline-block;\" id=\"postimagediv\"><img src=\"http://api.mojomarketplace.com/img/banners/api/wp-live-api-banner-837x86.png\"></div></a><br style=\"clear:both;\"/>\n\";s:10:\"background\";N;s:7:\"expires\";i:1815512414;s:8:\"category\";O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"WP Live Banner\";s:4:\"slug\";s:14:\"wp-live-banner\";}s:8:\"location\";O:8:\"stdClass\":1:{s:6:\"banner\";a:3:{i:0;s:10:\"themes.php\";i:1;s:14:\"(.*)wp-admin.$\";i:2;s:9:\"index.php\";}}}}", "no");
INSERT INTO `wp_jzkb_options` VALUES("61397", "pdb-csv_import_params", "a:4:{s:19:\"delimiter_character\";s:4:\"auto\";s:19:\"enclosure_character\";s:4:\"auto\";s:11:\"match_field\";s:5:\"email\";s:16:\"match_preference\";s:1:\"1\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61694", "widget_wpum-recent-users", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61695", "widget_wpum-password-recovery-form", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61696", "widget_wpum-registration-form", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61697", "widget_wpum-login-form", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61684", "wpum_settings", "a:32:{s:10:\"login_page\";s:4:\"3511\";s:22:\"password_recovery_page\";s:4:\"3512\";s:17:\"registration_page\";s:4:\"3513\";s:12:\"account_page\";s:4:\"3514\";s:12:\"profile_page\";s:4:\"3515\";s:15:\"enable_honeypot\";s:1:\"1\";s:14:\"email_template\";s:7:\"default\";s:10:\"from_email\";s:20:\"hello@dgtal-mind.com\";s:9:\"from_name\";s:10:\"DGtal-Mind\";s:17:\"password_strength\";s:6:\"strong\";s:35:\"display_password_meter_registration\";s:1:\"1\";s:12:\"login_method\";s:14:\"username_email\";s:16:\"custom_passwords\";s:1:\"1\";s:12:\"enable_terms\";s:1:\"1\";s:10:\"terms_page\";s:4:\"3537\";s:10:\"email_logo\";s:72:\"http://www.dgtal-mind.com/wp-content/uploads/2016/02/logo_DGtal-Mind.jpg\";s:14:\"custom_avatars\";s:1:\"1\";s:13:\"profile_posts\";s:1:\"1\";s:16:\"profile_comments\";s:1:\"1\";s:18:\"recaptcha_site_key\";s:40:\"6Lc5ayYTAAAAAJXfUEHs5y5JIp1hVgp_VG4pdXmv\";s:20:\"recaptcha_secret_key\";s:40:\"6Lc5ayYTAAAAANyDMf6nyJviQieV7EGxweiNFceJ\";s:18:\"recaptcha_location\";a:3:{i:0;s:12:\"registration\";i:1;s:17:\"password_recovery\";i:2;s:5:\"login\";}s:24:\"user_verification_method\";s:5:\"email\";s:25:\"user_verification_removal\";s:1:\"1\";s:34:\"wpum_user_verification_license_key\";s:32:\"655ded6d97d64ec18d55701c4beddfb6\";s:14:\"login_redirect\";s:4:\"3519\";s:15:\"logout_redirect\";s:4:\"3575\";s:21:\"registration_redirect\";s:4:\"3511\";s:26:\"wp_login_password_redirect\";s:4:\"3542\";s:24:\"backend_profile_redirect\";s:4:\"3515\";s:24:\"guests_can_view_profiles\";s:1:\"1\";s:24:\"wp_login_signup_redirect\";s:1:\"0\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61685", "wpum_emails", "a:3:{s:8:\"register\";a:2:{s:7:\"subject\";s:23:\"Your DGtal-Mind Account\";s:7:\"message\";s:178:\"Hello {username}, \r\n\r\nWelcome to {sitename}, \r\n\r\nThese are your account details \r\n\r\nPlease verify your account\r\n{verification_link}\r\n\r\nUsername: {username},\r\nPassword: {password}\";}s:8:\"password\";a:2:{s:7:\"subject\";s:30:\"Reset Your DGtal-Mind Password\";s:7:\"message\";s:273:\"Hello {username}, \n\nYou are receiving this message because you or somebody else has attempted to reset your password on {sitename}.\n\nIf this was a mistake, just ignore this email and nothing will happen.\n\nTo reset your password, visit the following address:\n\n{recovery_url}\";}s:12:\"verification\";a:2:{s:7:\"subject\";s:33:\"Verify your account at DGtal-Mind\";s:7:\"message\";s:125:\"Hello {username}, \r\n\r\nPlease click the link below to verify your account \r\n\r\n{verification_link} \r\n\r\nRegards,\r\n{sitename}\r\n\r\n\";}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61686", "wpum_permalink", "user_id", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61687", "wp_jzkb_wpum_field_groups_db_version", "1.0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61688", "wp_jzkb_wpum_fields_db_version", "1.0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61689", "wpum_activation_date", "1469810789", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61690", "wpum_version", "1.3.1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("61691", "wpum_did_121_update", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65491", "jetpack_sync_settings_disable", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65493", "jetpack_portfolio", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65494", "jetpack_testimonial", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65495", "jetpack_sync_settings_max_queue_size", "1000", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65496", "jetpack_sync_settings_max_queue_lag", "900", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65497", "jetpack_sync_settings_dequeue_max_bytes", "500000", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65498", "jetpack_sync_settings_upload_max_bytes", "600000", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65499", "jetpack_sync_settings_upload_max_rows", "500", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65500", "jetpack_sync_settings_sync_wait_time", "10", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65501", "jetpack_sync_settings_sync_wait_threshold", "5", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65502", "jetpack_sync_settings_queue_max_writes_sec", "100", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65503", "jetpack_sync_settings_post_types_blacklist", "a:0:{}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65504", "jetpack_sync_settings_meta_blacklist", "a:0:{}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65561", "safecss_revision_migrated", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("65562", "safecss", "", "yes");
INSERT INTO `wp_jzkb_options` VALUES("92275", "jetpack_sync_full__constants_config", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("67965", "jetpack_file_data", "a:1:{s:3:\"4.5\";a:51:{s:32:\"31e5b9ae08b62c2b0cd8a7792242298b\";a:14:{s:4:\"name\";s:20:\"Spelling and Grammar\";s:11:\"description\";s:40:\"Check your spelling, style, and grammar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"6\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:115:\"after the deadline, afterthedeadline, spell, spellchecker, spelling, grammar, proofreading, style, language, cliche\";}s:32:\"3f41b2d629265b5de8108b463abbe8e2\";a:14:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:76:\"Display images and galleries in a gorgeous, full-screen browsing experience.\";s:14:\"jumpstart_desc\";s:79:\"Brings your photos and images to life as full-size, easily navigable galleries.\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:80:\"gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image\";}s:32:\"c6ebb418dde302de09600a6025370583\";a:14:{s:4:\"name\";s:8:\"Comments\";s:11:\"description\";s:65:\"Allow comments with WordPress.com, Twitter, Facebook, or Google+.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:53:\"comments, comment, facebook, twitter, google+, social\";}s:32:\"836f9485669e1bbb02920cb474730df0\";a:14:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:57:\"Insert a customizable contact form anywhere on your site.\";s:14:\"jumpstart_desc\";s:111:\"Adds a button to your post and page editors, allowing you to build simple forms to help visitors stay in touch.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:18:\"Writing, Jumpstart\";s:25:\"additional_search_queries\";s:44:\"contact, form, grunion, feedback, submission\";}s:32:\"ea3970eebf8aac55fc3eca5dca0e0157\";a:14:{s:4:\"name\";s:20:\"Custom Content Types\";s:11:\"description\";s:61:\"Organize and display different types of content on your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:72:\"cpt, custom post types, portfolio, portfolios, testimonial, testimonials\";}s:32:\"d2bb05ccad3d8789df40ca3abb97336c\";a:14:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:53:\"Tweak your site’s CSS without modifying your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:108:\"css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet\";}s:32:\"a2064eec5b9c7e0d816af71dee7a715f\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"53a4ec755022ef3953699734c343da02\";a:14:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:27:\"Increase reach and traffic.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"google, seo, firehose, search, broadcast, broadcasting\";}s:32:\"72fecb67ee6704ba0a33e0225316ad06\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"d56e2886185a9eace719cc57d46770df\";a:14:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:14:\"jumpstart_desc\";s:131:\"Let commenters link their profiles to their Gravatar accounts, making it easy for your visitors to learn more about your community.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:20:\"gravatar, hovercards\";}s:32:\"e391e760617bd0e0736550e34a73d7fe\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:8:\"2.0.3 ??\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"2e345370766346c616b3c5046e817720\";a:14:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:54:\"Automatically load new content when a visitor scrolls.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:33:\"scroll, infinite, infinite scroll\";}s:32:\"bd69edbf134de5fae8fdcf2e70a45b56\";a:14:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:51:\"Allow applications to securely access your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:50:\"api, rest, develop, developers, json, klout, oauth\";}s:32:\"8110b7a4423aaa619dfa46b8843e10d1\";a:14:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:57:\"Use LaTeX markup for complex equations and other geekery.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:47:\"latex, math, equation, equations, formula, code\";}s:32:\"fd7e85d3b4887fa6b6f997d6592c1f33\";a:14:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:63:\"Give visitors an easy way to show they appreciate your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:26:\"like, likes, wordpress.com\";}s:32:\"c5dfef41fad5bcdcaae8e315e5cfc420\";a:14:{s:4:\"name\";s:6:\"Manage\";s:11:\"description\";s:54:\"Manage all of your sites from a centralized dashboard.\";s:14:\"jumpstart_desc\";s:151:\"Helps you remotely manage plugins, turn on automated updates, and more from <a href=\"https://wordpress.com/plugins/\" target=\"_blank\">wordpress.com</a>.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"3\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:35:\"Centralized Management, Recommended\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:26:\"manage, management, remote\";}s:32:\"fd6dc399b92bce76013427e3107c314f\";a:14:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:51:\"Write posts or pages in plain-text Markdown syntax.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:12:\"md, markdown\";}s:32:\"c49a35b6482b0426cb07ad28ecf5d7df\";a:14:{s:4:\"name\";s:12:\"Mobile Theme\";s:11:\"description\";s:47:\"Optimize your site for smartphones and tablets.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"21\";s:20:\"recommendation_order\";s:2:\"11\";s:10:\"introduced\";s:3:\"1.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:31:\"Appearance, Mobile, Recommended\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:24:\"mobile, theme, minileven\";}s:32:\"b42e38f6fafd2e4104ebe5bf39b4be47\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"771cfeeba0d3d23ec344d5e781fb0ae2\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"54f0661d27c814fc8bde39580181d939\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"46c4c413b5c72bbd3c3dbd14ff8f8adc\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"9ea52fa25783e5ceeb6bfaed3268e64e\";a:14:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:61:\"Receive immediate notifications if your site goes down, 24/7.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:37:\"monitor, uptime, downtime, monitoring\";}s:32:\"cfcaafd0fcad087899d715e0b877474d\";a:14:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:57:\"Receive instant notifications of site comments and likes.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:62:\"notification, notifications, toolbar, adminbar, push, comments\";}s:32:\"0d18bfa69bec61550c1d813ce64149b0\";a:14:{s:4:\"name\";s:10:\"Omnisearch\";s:11:\"description\";s:66:\"Search your entire database from a single field in your dashboard.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"16\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:6:\"search\";}s:32:\"3f0a11e23118f0788d424b646a6d465f\";a:14:{s:4:\"name\";s:6:\"Photon\";s:11:\"description\";s:27:\"Speed up images and photos.\";s:14:\"jumpstart_desc\";s:141:\"Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:34:\"Recommended, Jumpstart, Appearance\";s:25:\"additional_search_queries\";s:38:\"photon, image, cdn, performance, speed\";}s:32:\"e37cfbcb72323fb1fe8255a2edb4d738\";a:14:{s:4:\"name\";s:13:\"Post by Email\";s:11:\"description\";s:34:\"Publish posts by sending an email.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:20:\"post by email, email\";}s:32:\"728290d131a480bfe7b9e405d7cd925f\";a:14:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:43:\"Prevent and block malicious login attempts.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:65:\"security, secure, protection, botnet, brute force, protect, login\";}s:32:\"f9ce784babbbf4dcca99b8cd2ceb420c\";a:14:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:27:\"Automated social marketing.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:107:\"facebook, twitter, google+, googleplus, google, path, tumblr, linkedin, social, tweet, connections, sharing\";}s:32:\"052c03877dd3d296a71531cb07ad939a\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"52edecb2a75222e75b2dce4356a4efce\";a:14:{s:4:\"name\";s:13:\"Related Posts\";s:11:\"description\";s:64:\"Increase page views by showing related content to your visitors.\";s:14:\"jumpstart_desc\";s:113:\"Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:22:\"related, related posts\";}s:32:\"68b0d01689803c0ea7e4e60a86de2519\";a:14:{s:4:\"name\";s:9:\"SEO tools\";s:11:\"description\";s:50:\"Better results on search engines and social media.\";s:14:\"jumpstart_desc\";s:50:\"Better results on search engines and social media.\";s:4:\"sort\";s:2:\"35\";s:20:\"recommendation_order\";s:2:\"15\";s:10:\"introduced\";s:3:\"4.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:18:\"Traffic, Jumpstart\";s:25:\"additional_search_queries\";s:81:\"search engine optimization, social preview, meta description, custom title format\";}s:32:\"8b059cb50a66b717f1ec842e736b858c\";a:14:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:37:\"Allow visitors to share your content.\";s:14:\"jumpstart_desc\";s:116:\"Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:141:\"share, sharing, sharedaddy, buttons, icons, email, facebook, twitter, google+, linkedin, pinterest, pocket, press this, print, reddit, tumblr\";}s:32:\"a6d2394329871857401255533a9873f7\";a:14:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:50:\"Embed media from popular sites without any coding.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:236:\"shortcodes, shortcode, embeds, media, bandcamp, dailymotion, facebook, flickr, google calendars, google maps, google+, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube\";}s:32:\"21496e2897ea5f81605e2f2ac3beb921\";a:14:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:54:\"Create short and simple links for all posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:17:\"shortlinks, wp.me\";}s:32:\"e2a54a5d7879a4162709e6ffb540dd08\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"f5c537bc304f55b29c1a87e30be0cd24\";a:14:{s:4:\"name\";s:8:\"Sitemaps\";s:11:\"description\";s:50:\"Make it easy for search engines to find your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:20:\"Recommended, Traffic\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:39:\"sitemap, traffic, search, site map, seo\";}s:32:\"59a23643437358a9b557f1d1e20ab040\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"6a90f97c3194cfca5671728eaaeaf15e\";a:14:{s:4:\"name\";s:14:\"Single Sign On\";s:11:\"description\";s:46:\"Secure user authentication with WordPress.com.\";s:14:\"jumpstart_desc\";s:98:\"Lets you log in to all your Jetpack-enabled sites with one click using your WordPress.com account.\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:19:\"Security, Jumpstart\";s:25:\"additional_search_queries\";s:34:\"sso, single sign on, login, log in\";}s:32:\"b65604e920392e2f7134b646760b75e8\";a:14:{s:4:\"name\";s:10:\"Site Stats\";s:11:\"description\";s:44:\"Collect valuable traffic stats and insights.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:23:\"Site Stats, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"statistics, tracking, analytics, views, traffic, stats\";}s:32:\"23a586dd7ead00e69ec53eb32ef740e4\";a:14:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:55:\"Notify your readers of new posts and comments by email.\";s:14:\"jumpstart_desc\";s:126:\"Give visitors two easy subscription options — while commenting, or via a separate email subscription widget you can display.\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:74:\"subscriptions, subscription, email, follow, followers, subscribers, signup\";}s:32:\"1d978b8d84d2f378fe1a702a67633b6d\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"b3b983461d7f3d27322a3551ed8a9405\";a:14:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:61:\"Display image galleries in a variety of elegant arrangements.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:43:\"gallery, tiles, tiled, grid, mosaic, images\";}s:32:\"d924e5b05722b0e104448543598f54c0\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"36741583b10c521997e563ad8e1e8b77\";a:14:{s:4:\"name\";s:12:\"Data Backups\";s:11:\"description\";s:54:\"Off-site backups, security scans, and automatic fixes.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:16:\"Security, Health\";s:25:\"additional_search_queries\";s:28:\"vaultpress, backup, security\";}s:32:\"2b9b44f09b5459617d68dd82ee17002a\";a:14:{s:4:\"name\";s:17:\"Site Verification\";s:11:\"description\";s:58:\"Establish your site\'s authenticity with external services.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:56:\"webmaster, seo, google, bing, pinterest, search, console\";}s:32:\"5ab4c0db7c42e10e646342da0274c491\";a:14:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:45:\"Powerful, simple video hosting for WordPress.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:25:\"video, videos, videopress\";}s:32:\"60a1d3aa38bc0fe1039e59dd60888543\";a:14:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:42:\"Control where widgets appear on your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:54:\"widget visibility, logic, conditional, widgets, widget\";}s:32:\"174ed3416476c2cb9ff5b0f671280b15\";a:14:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:54:\"Add images, Twitter streams, and more to your sidebar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:65:\"widget, widgets, facebook, gallery, twitter, gravatar, image, rss\";}s:32:\"a668bc9418d6de87409f867892fcdd7f\";a:14:{s:4:\"name\";s:3:\"Ads\";s:11:\"description\";s:60:\"Earn income by allowing Jetpack to display high quality ads.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"4.5.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:19:\"Traffic, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:26:\"advertising, ad codes, ads\";}s:32:\"28b931a1db19bd24869bd54b14e733d5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}}}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("97396", "jetpack_next_sync_time_sync", "1484735563", "yes");
INSERT INTO `wp_jzkb_options` VALUES("72954", "wpum_user_verification_license_active", "valid", "yes");
INSERT INTO `wp_jzkb_options` VALUES("92277", "jetpack_sync_full__functions_config", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("92276", "jetpack_sync_full__functions_total", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("109591", "jetpack_sync_full_config", "a:3:{s:9:\"constants\";b:1;s:9:\"functions\";b:1;s:7:\"options\";b:1;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("92279", "jetpack_sync_full__options_config", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("92278", "jetpack_sync_full__options_total", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("92274", "jetpack_sync_full__constants_total", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("131929", "_transient_timeout_mm_spam_166c2143a33416187da3fd93fc5f3b55", "1484326562", "no");
INSERT INTO `wp_jzkb_options` VALUES("131930", "_transient_mm_spam_166c2143a33416187da3fd93fc5f3b55", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("92264", "jetpack_sync_settings_avoid_wp_cron", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("92288", "jpsq_full_sync_checkout", "0:0", "no");
INSERT INTO `wp_jzkb_options` VALUES("92289", "jetpack_sync_full__sent_started", "1476402003", "no");
INSERT INTO `wp_jzkb_options` VALUES("92283", "jetpack_sync_full__functions_queued", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("92285", "jetpack_sync_full__options_queued", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("92281", "jetpack_sync_full__constants_queued", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("92266", "jetpack_sync_settings_render_filtered_content", "0", "yes");
INSERT INTO `wp_jzkb_options` VALUES("92267", "jetpack_sync_settings_post_meta_whitelist", "a:0:{}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("92268", "jetpack_sync_settings_comment_meta_whitelist", "a:0:{}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("92269", "jpsq_sync_checkout", "0:0", "no");
INSERT INTO `wp_jzkb_options` VALUES("109606", "jetpack_sync_settings_sync_via_cron", "1", "yes");
INSERT INTO `wp_jzkb_options` VALUES("109611", "jetpack_sync_https_history_home_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:4:\"http\";i:3;s:4:\"http\";i:4;s:4:\"http\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("134586", "_transient_timeout_jetpack_is_single_user", "1484778753", "no");
INSERT INTO `wp_jzkb_options` VALUES("134587", "_transient_jetpack_is_single_user", "2", "no");
INSERT INTO `wp_jzkb_options` VALUES("109607", "jetpack_sync_settings_enqueue_wait_time", "10", "yes");
INSERT INTO `wp_jzkb_options` VALUES("109608", "jetpack_next_sync_time_full-sync-enqueue", "1484736257", "yes");
INSERT INTO `wp_jzkb_options` VALUES("109609", "jetpack_sync_https_history_main_network_site_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:4:\"http\";i:3;s:4:\"http\";i:4;s:4:\"http\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("109610", "jetpack_sync_https_history_site_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:4:\"http\";i:3;s:4:\"http\";i:4;s:4:\"http\";}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("109592", "jetpack_sync_full_enqueue_status", "a:4:{s:9:\"constants\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:9:\"functions\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:7:\"options\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:15:\"network_options\";b:0;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("109596", "jetpack_sync_settings_max_queue_size_full_sync", "1000", "yes");
INSERT INTO `wp_jzkb_options` VALUES("109597", "jetpack_sync_settings_max_enqueue_full_sync", "100", "yes");
INSERT INTO `wp_jzkb_options` VALUES("109603", "widget_google_translate_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("109604", "widget_jetpack_my_community", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("109926", "jetpack_active_plan", "a:6:{s:10:\"product_id\";i:2002;s:12:\"product_slug\";s:12:\"jetpack_free\";s:18:\"product_name_short\";s:4:\"Free\";s:10:\"free_trial\";b:0;s:7:\"expired\";b:0;s:13:\"user_is_owner\";b:0;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("116131", "jetpack_sync_full__started", "1481067710", "no");
INSERT INTO `wp_jzkb_options` VALUES("116132", "jetpack_sync_full__params", "a:4:{s:7:\"options\";b:1;s:15:\"network_options\";b:1;s:9:\"functions\";b:1;s:9:\"constants\";b:1;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("116133", "_transient_timeout_jetpack_sync_last_checked_queue_state_full_sync", "1481068010", "no");
INSERT INTO `wp_jzkb_options` VALUES("116134", "_transient_jetpack_sync_last_checked_queue_state_full_sync", "a:2:{i:0;i:0;i:1;i:0;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("116139", "jetpack_sync_full__queue_finished", "1481067710", "yes");
INSERT INTO `wp_jzkb_options` VALUES("116150", "jetpack_next_sync_time_full_sync", "1481067728", "yes");
INSERT INTO `wp_jzkb_options` VALUES("116145", "jetpack_sync_full__send_started", "1481067718", "no");
INSERT INTO `wp_jzkb_options` VALUES("116146", "jetpack_sync_full__constants_sent", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("116147", "jetpack_sync_full__functions_sent", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("116148", "jetpack_sync_full__options_sent", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("116149", "jetpack_sync_full__finished", "1481067718", "no");
INSERT INTO `wp_jzkb_options` VALUES("133284", "_transient_timeout_mm_spam_7c049df21bbefa4e77ee49bb1043c99c", "1484585798", "no");
INSERT INTO `wp_jzkb_options` VALUES("133285", "_transient_mm_spam_7c049df21bbefa4e77ee49bb1043c99c", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("130973", "_transient_timeout_mm_spam_d5d78429e8475703e42478a808517c8c", "1484154772", "no");
INSERT INTO `wp_jzkb_options` VALUES("130974", "_transient_mm_spam_d5d78429e8475703e42478a808517c8c", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134638", "duplicator_version_plugin", "1.1.26", "yes");
INSERT INTO `wp_jzkb_options` VALUES("131872", "_transient_mm_spam_cd16782ca1d72478ef509c6e6cf1992e", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("130922", "_transient_mm_spam_68572427bb99521f31ef1c3935e856d1", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("130940", "_transient_timeout_mm_spam_ca5f244b6217d7930111ab7352c4e9e4", "1484151815", "no");
INSERT INTO `wp_jzkb_options` VALUES("131465", "_transient_timeout_mm_spam_2fc50810a5eeff223dd3773333966b68", "1484240388", "no");
INSERT INTO `wp_jzkb_options` VALUES("132201", "_transient_mm_spam_5474ed161c5b0c571fc7a04588cc96f1", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134342", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/en_GB/wordpress-4.7.1.zip\";s:6:\"locale\";s:5:\"en_GB\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/en_GB/wordpress-4.7.1.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.7.1\";s:7:\"version\";s:5:\"4.7.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1484735937;s:15:\"version_checked\";s:5:\"4.7.1\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_jzkb_options` VALUES("130000", "_transient_mm_spam_eeceab41110c06ac03df95ed6bcd0865", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("132836", "_transient_timeout_mm_spam_2e8c5c1a88512663ab0bc44db00ecfe7", "1484499108", "no");
INSERT INTO `wp_jzkb_options` VALUES("132837", "_transient_mm_spam_2e8c5c1a88512663ab0bc44db00ecfe7", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("131871", "_transient_timeout_mm_spam_cd16782ca1d72478ef509c6e6cf1992e", "1484317242", "no");
INSERT INTO `wp_jzkb_options` VALUES("131466", "_transient_mm_spam_2fc50810a5eeff223dd3773333966b68", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("131506", "_transient_timeout_mm_spam_ae57bb74c869ac024584a164aa005ff7", "1484245819", "no");
INSERT INTO `wp_jzkb_options` VALUES("131507", "_transient_mm_spam_ae57bb74c869ac024584a164aa005ff7", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("131954", "_transient_timeout_mm_spam_15551bdffd771ab103e6719cfcdeb88b", "1484331111", "no");
INSERT INTO `wp_jzkb_options` VALUES("131955", "_transient_mm_spam_15551bdffd771ab103e6719cfcdeb88b", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("130955", "_transient_mm_spam_6740567012ad0282dd60f1523fd9f94b", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("129999", "_transient_timeout_mm_spam_eeceab41110c06ac03df95ed6bcd0865", "1483970690", "no");
INSERT INTO `wp_jzkb_options` VALUES("132200", "_transient_timeout_mm_spam_5474ed161c5b0c571fc7a04588cc96f1", "1484382558", "no");
INSERT INTO `wp_jzkb_options` VALUES("131761", "_transient_timeout_mm_spam_a434f79c189b009722c73fd8e54f2626", "1484297265", "no");
INSERT INTO `wp_jzkb_options` VALUES("131762", "_transient_mm_spam_a434f79c189b009722c73fd8e54f2626", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("132303", "_transient_timeout_mm_spam_ada7532e0d4fdac6461d039882550af0", "1484402060", "no");
INSERT INTO `wp_jzkb_options` VALUES("132304", "_transient_mm_spam_ada7532e0d4fdac6461d039882550af0", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("133728", "_transient_timeout_mm_spam_101d37e70794756ea1ca9b6646f11170", "1484671076", "no");
INSERT INTO `wp_jzkb_options` VALUES("134572", "_transient_timeout_mm_icon_hash", "1485340351", "no");
INSERT INTO `wp_jzkb_options` VALUES("134573", "_transient_mm_icon_hash", "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjwhRE9DVFlQRSBzdmcgUFVCTElDICItLy9XM0MvL0RURCBTVkcgMS4wLy9FTiIgImh0dHA6Ly93d3cudzMub3JnL1RSLzIwMDEvUkVDLVNWRy0yMDAxMDkwNC9EVEQvc3ZnMTAuZHRkIj4NCjxzdmcgdmVyc2lvbj0iMS4wIiBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeD0iMHB4IiB5PSIwcHgiDQoJIHZpZXdCb3g9IjAgMCA0MCA0MCIgZW5hYmxlLWJhY2tncm91bmQ9Im5ldyAwIDAgNDAgNDAiIHhtbDpzcGFjZT0icHJlc2VydmUiPg0KPGc+DQoJPHBhdGggZmlsbD0iI2ZmZiIgZD0iTTMuMSwzMS4zYy0wLjcsMC0xLjUtMC4zLTItMC44Yy0xLjEtMS4xLTEuMS0yLjksMC00TDE3LjksOS42YzEuMS0xLjEsMi45LTEuMSw0LDBjMS4xLDEuMSwxLjEsMi45LDAsNA0KCQlMNS4xLDMwLjRDNC41LDMxLDMuOCwzMS4zLDMuMSwzMS4zeiIvPg0KCTxwYXRoIGZpbGw9IiNmZmYiIGQ9Ik0xOS43LDMxLjNjLTAuNywwLTEuNS0wLjMtMi0wLjhjLTEuMS0xLjEtMS4xLTIuOSwwLTRMMzQuNCw5LjZjMC45LTAuOSwyLjItMS4yLDMuNC0wLjcNCgkJYzEuMiwwLjUsMS45LDEuNiwxLjksMi45djE2LjZjMCwxLjYtMS4zLDIuOC0yLjgsMi44cy0yLjgtMS4zLTIuOC0yLjhWMTguMUwyMS43LDMwLjRDMjEuMiwzMSwyMC40LDMxLjMsMTkuNywzMS4zeiIvPg0KPC9nPg0KPC9zdmc+DQo=", "no");
INSERT INTO `wp_jzkb_options` VALUES("130368", "_transient_timeout_mm_spam_5f84637c1a1489f6d2e103257ca19ed2", "1484045582", "no");
INSERT INTO `wp_jzkb_options` VALUES("130369", "_transient_mm_spam_5f84637c1a1489f6d2e103257ca19ed2", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("131704", "_transient_timeout_mm_spam_4c1efb1891a001b4f4697fcde586a89c", "1484284510", "no");
INSERT INTO `wp_jzkb_options` VALUES("131705", "_transient_mm_spam_4c1efb1891a001b4f4697fcde586a89c", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("130407", "_transient_timeout_mm_spam_53816090ab6f6a83ae84d9fe08cda21e", "1484049909", "no");
INSERT INTO `wp_jzkb_options` VALUES("130408", "_transient_mm_spam_53816090ab6f6a83ae84d9fe08cda21e", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("132637", "_transient_timeout_mm_spam_1bcece35a2015105e67a39edd9fc27e3", "1484466722", "no");
INSERT INTO `wp_jzkb_options` VALUES("132638", "_transient_mm_spam_1bcece35a2015105e67a39edd9fc27e3", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("130413", "_transient_timeout_mm_spam_e0968873e0d1b2822b0ed572bf4be18b", "1484049912", "no");
INSERT INTO `wp_jzkb_options` VALUES("130414", "_transient_mm_spam_e0968873e0d1b2822b0ed572bf4be18b", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("131309", "_transient_timeout_mm_spam_c3f7122497176c8503a5120dd067314e", "1484216057", "no");
INSERT INTO `wp_jzkb_options` VALUES("131310", "_transient_mm_spam_c3f7122497176c8503a5120dd067314e", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("131162", "_transient_timeout_mm_spam_f62092a8843f8fdd5b304b5899976566", "1484192578", "no");
INSERT INTO `wp_jzkb_options` VALUES("131163", "_transient_mm_spam_f62092a8843f8fdd5b304b5899976566", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("130800", "_transient_timeout_mm_spam_8f5af57173eb8b6e2f7f133bda14ebde", "1484130199", "no");
INSERT INTO `wp_jzkb_options` VALUES("130801", "_transient_mm_spam_8f5af57173eb8b6e2f7f133bda14ebde", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("130941", "_transient_mm_spam_ca5f244b6217d7930111ab7352c4e9e4", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("129977", "_transient_timeout_mm_spam_bbac38f42afb74bf1729e519b74a6c0c", "1483968296", "no");
INSERT INTO `wp_jzkb_options` VALUES("129978", "_transient_mm_spam_bbac38f42afb74bf1729e519b74a6c0c", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("130899", "_transient_timeout_mm_spam_934be44d2d7e46f466fda4e5c8edeafa", "1484146742", "no");
INSERT INTO `wp_jzkb_options` VALUES("130900", "_transient_mm_spam_934be44d2d7e46f466fda4e5c8edeafa", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("130921", "_transient_timeout_mm_spam_68572427bb99521f31ef1c3935e856d1", "1484149550", "no");
INSERT INTO `wp_jzkb_options` VALUES("130954", "_transient_timeout_mm_spam_6740567012ad0282dd60f1523fd9f94b", "1484153533", "no");
INSERT INTO `wp_jzkb_options` VALUES("134637", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"1.1.26\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("132849", "_transient_timeout_mm_spam_161c9f6e91adc655128da6988fc30912", "1484500383", "no");
INSERT INTO `wp_jzkb_options` VALUES("132809", "_transient_mm_spam_8978074a070ab5fb1b5f7719b456bdfa", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134345", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1484735940;s:7:\"checked\";a:5:{s:8:\"arkfield\";s:5:\"1.3.1\";s:13:\"twentyfifteen\";s:3:\"1.7\";s:14:\"twentyfourteen\";s:3:\"1.9\";s:13:\"twentysixteen\";s:3:\"1.3\";s:14:\"twentythirteen\";s:3:\"2.1\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134582", "_transient_timeout_mm_test", "1487154752", "no");
INSERT INTO `wp_jzkb_options` VALUES("132643", "_transient_timeout_mm_spam_cdf97012202b21191635ac7eaaac0e43", "1484466725", "no");
INSERT INTO `wp_jzkb_options` VALUES("132644", "_transient_mm_spam_cdf97012202b21191635ac7eaaac0e43", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("132850", "_transient_mm_spam_161c9f6e91adc655128da6988fc30912", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134583", "_transient_mm_test", "a:1:{s:3:\"key\";s:4:\"none\";}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134623", "jetpack_updates_sync_checksum", "a:3:{s:11:\"update_core\";i:2165911632;s:14:\"update_plugins\";i:2717935958;s:13:\"update_themes\";i:1646454566;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("132676", "_transient_timeout_mm_spam_3f519f6ebd2722f4d46a7321724c74e4", "1484473554", "no");
INSERT INTO `wp_jzkb_options` VALUES("132677", "_transient_mm_spam_3f519f6ebd2722f4d46a7321724c74e4", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("132844", "_transient_timeout_mm_spam_8fd5aabc6e6f77003cacde4e6fde03f3", "1484499898", "no");
INSERT INTO `wp_jzkb_options` VALUES("132845", "_transient_mm_spam_8fd5aabc6e6f77003cacde4e6fde03f3", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("132685", "_transient_timeout_mm_spam_722ab2ba741ce6871373391cda056f7b", "1484473920", "no");
INSERT INTO `wp_jzkb_options` VALUES("132686", "_transient_mm_spam_722ab2ba741ce6871373391cda056f7b", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134579", "_site_transient_browser_844f7ae4d251b2e6e152fdd13ef479f6", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"55.0.2883.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134560", "_transient_timeout_mm_spam_e4a65760d790cea23200c348c0047d69", "1484821934", "no");
INSERT INTO `wp_jzkb_options` VALUES("134561", "_transient_mm_spam_e4a65760d790cea23200c348c0047d69", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134578", "_site_transient_timeout_browser_844f7ae4d251b2e6e152fdd13ef479f6", "1485340351", "no");
INSERT INTO `wp_jzkb_options` VALUES("134574", "_transient_timeout_jpp_li_5c494bc0af8f28cc13f8b2ec59eff922", "1484735611", "no");
INSERT INTO `wp_jzkb_options` VALUES("134575", "_transient_jpp_li_5c494bc0af8f28cc13f8b2ec59eff922", "a:5:{s:6:\"status\";s:2:\"ok\";s:3:\"msg\";s:61:\"{\"trusted_header\":\"REMOTE_ADDR\",\"segments\":1,\"reverse\":false}\";s:17:\"seconds_remaining\";i:60;s:16:\"blocked_attempts\";s:4:\"3504\";s:6:\"expire\";i:1484735611;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134358", "jetpack_sync_settings_cron_sync_time_limit", "30", "yes");
INSERT INTO `wp_jzkb_options` VALUES("133097", "_transient_timeout_mm_spam_7ff3671bb44414f453f3fe8feba19a7d", "1484552399", "no");
INSERT INTO `wp_jzkb_options` VALUES("133098", "_transient_mm_spam_7ff3671bb44414f453f3fe8feba19a7d", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("132808", "_transient_timeout_mm_spam_8978074a070ab5fb1b5f7719b456bdfa", "1484495722", "no");
INSERT INTO `wp_jzkb_options` VALUES("134196", "_transient_timeout_mm_spam_0cee12a1eacb68b4b045ea26696a817a", "1484757441", "no");
INSERT INTO `wp_jzkb_options` VALUES("134197", "_transient_mm_spam_0cee12a1eacb68b4b045ea26696a817a", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134198", "_transient_timeout_jpp_li_57d609408a671a225ea1a226cd0071f5", "1484673573", "no");
INSERT INTO `wp_jzkb_options` VALUES("134199", "_transient_jpp_li_57d609408a671a225ea1a226cd0071f5", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:43:\"This IP is currently blocked (89.110.9.251)\";s:17:\"seconds_remaining\";i:2532;s:16:\"blocked_attempts\";s:4:\"3500\";s:6:\"expire\";i:1484673573;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("133729", "_transient_mm_spam_101d37e70794756ea1ca9b6646f11170", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134354", "widget_authors", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("134355", "widget_milestone_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("133737", "_transient_timeout_mm_spam_0e70f605314fe608f29e8e903aafbd1b", "1484671133", "no");
INSERT INTO `wp_jzkb_options` VALUES("133259", "_transient_timeout_mm_spam_ae3629863b09b155e2eb609b605c168a", "1484583059", "no");
INSERT INTO `wp_jzkb_options` VALUES("133260", "_transient_mm_spam_ae3629863b09b155e2eb609b605c168a", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("133945", "_transient_timeout_mm_spam_263a484447c7e267293e3a503c228673", "1484712166", "no");
INSERT INTO `wp_jzkb_options` VALUES("133946", "_transient_mm_spam_263a484447c7e267293e3a503c228673", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134219", "_transient_timeout_jpp_li_4b7d1f5f655628c790526352caba5edf", "1484677398", "no");
INSERT INTO `wp_jzkb_options` VALUES("134036", "_transient_timeout_mm_spam_390bfa91835f20d2419c096f2216288e", "1484730281", "no");
INSERT INTO `wp_jzkb_options` VALUES("134037", "_transient_mm_spam_390bfa91835f20d2419c096f2216288e", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("133310", "_transient_timeout_mm_spam_f65ad1faba6e56cf2cc930614f90acfd", "1484587617", "no");
INSERT INTO `wp_jzkb_options` VALUES("133311", "_transient_mm_spam_f65ad1faba6e56cf2cc930614f90acfd", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("133552", "_transient_timeout_mm_spam_36bad857cf65cddd88e246c43f700170", "1484635404", "no");
INSERT INTO `wp_jzkb_options` VALUES("133553", "_transient_mm_spam_36bad857cf65cddd88e246c43f700170", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("133510", "_transient_timeout_mm_spam_80f175c7198ebe3219c529b490b68ae7", "1484630003", "no");
INSERT INTO `wp_jzkb_options` VALUES("133511", "_transient_mm_spam_80f175c7198ebe3219c529b490b68ae7", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("133535", "_transient_timeout_mm_spam_091411ba40ebbe52ebde0e7263447c18", "1484633710", "no");
INSERT INTO `wp_jzkb_options` VALUES("133536", "_transient_mm_spam_091411ba40ebbe52ebde0e7263447c18", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("133738", "_transient_mm_spam_0e70f605314fe608f29e8e903aafbd1b", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("133756", "_transient_timeout_mm_spam_30f2dcc901f871b0ae7324264e2a43e8", "1484672885", "no");
INSERT INTO `wp_jzkb_options` VALUES("133757", "_transient_mm_spam_30f2dcc901f871b0ae7324264e2a43e8", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134220", "_transient_jpp_li_4b7d1f5f655628c790526352caba5edf", "a:5:{s:6:\"status\";s:2:\"ok\";s:3:\"msg\";s:53:\"No current blocks on this IP address (184.154.139.20)\";s:17:\"seconds_remaining\";i:3600;s:16:\"blocked_attempts\";s:4:\"3501\";s:6:\"expire\";i:1484677398;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134240", "_transient_timeout_mm_spam_55fc415d28a1eb2450c580484ddd5af1", "1484764398", "no");
INSERT INTO `wp_jzkb_options` VALUES("134241", "_transient_mm_spam_55fc415d28a1eb2450c580484ddd5af1", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134246", "_transient_timeout_jpp_li_930dd767b500a72b7f605a0c64ef47c6", "1484681489", "no");
INSERT INTO `wp_jzkb_options` VALUES("134247", "_transient_jpp_li_930dd767b500a72b7f605a0c64ef47c6", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (156.209.11.18)\";s:17:\"seconds_remaining\";i:3485;s:16:\"blocked_attempts\";s:4:\"3503\";s:6:\"expire\";i:1484681489;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134648", "_transient_timeout_jetpack_idc_allowed", "1484739756", "no");
INSERT INTO `wp_jzkb_options` VALUES("134649", "_transient_jetpack_idc_allowed", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("134154", "_transient_timeout_mm_spam_78b952d18d0c56964eb3d371efe75d2c", "1484750799", "no");
INSERT INTO `wp_jzkb_options` VALUES("134155", "_transient_mm_spam_78b952d18d0c56964eb3d371efe75d2c", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134160", "_transient_timeout_jpp_li_f88cfe9af699a4fa4ddc3911292c8fd6", "1484667401", "no");
INSERT INTO `wp_jzkb_options` VALUES("134161", "_transient_jpp_li_f88cfe9af699a4fa4ddc3911292c8fd6", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (91.78.49.206)\";s:17:\"seconds_remaining\";i:2999;s:16:\"blocked_attempts\";s:4:\"3498\";s:6:\"expire\";i:1484667401;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134190", "_transient_timeout_mm_spam_61924b0f29134199ec29f1e175a50e19", "1484756738", "no");
INSERT INTO `wp_jzkb_options` VALUES("134191", "_transient_mm_spam_61924b0f29134199ec29f1e175a50e19", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134192", "_transient_timeout_jpp_li_ba617902d1424a35e88f05aecc8896ed", "1484671869", "no");
INSERT INTO `wp_jzkb_options` VALUES("134193", "_transient_jpp_li_ba617902d1424a35e88f05aecc8896ed", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:42:\"This IP is currently blocked (5.18.211.96)\";s:17:\"seconds_remaining\";i:1530;s:16:\"blocked_attempts\";s:4:\"3499\";s:6:\"expire\";i:1484671869;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134473", "_transient_mm_spam_390c54db778898322da5f07e2bcbbd1d", "no", "no");
INSERT INTO `wp_jzkb_options` VALUES("134480", "_transient_timeout_jpp_li_ea5bdaf41b612eaa04ac57cd4b75daea", "1484723783", "no");
INSERT INTO `wp_jzkb_options` VALUES("134481", "_transient_jpp_li_ea5bdaf41b612eaa04ac57cd4b75daea", "a:5:{s:6:\"status\";s:2:\"ok\";s:3:\"msg\";s:49:\"No current blocks on this IP address (77.40.3.79)\";s:17:\"seconds_remaining\";i:3600;s:16:\"blocked_attempts\";s:4:\"3504\";s:6:\"expire\";i:1484723783;}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134576", "_transient_timeout_jpp_headers_updated_recently", "1484821951", "no");
INSERT INTO `wp_jzkb_options` VALUES("134577", "_transient_jpp_headers_updated_recently", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("134472", "_transient_timeout_mm_spam_390c54db778898322da5f07e2bcbbd1d", "1484806581", "no");
INSERT INTO `wp_jzkb_options` VALUES("134356", "widget_upcoming_events_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("134591", "jetpack_nonce_1484735560_YskvlTcBp1", "1484735560", "no");
INSERT INTO `wp_jzkb_options` VALUES("134592", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1484746363", "no");
INSERT INTO `wp_jzkb_options` VALUES("134593", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Jan 2017 00:21:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.8-alpha-39923\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.7.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 03:53:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4650\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:375:\"WordPress 4.7 has been downloaded over 10 million times since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7 and earlier are affected by eight security issues: [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6520:\"<p>WordPress 4.7 has been <a href=\"https://wordpress.org/download/counter/\">downloaded over 10 million times</a> since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7 and earlier are affected by eight security issues:</p>\n<ol>\n<li>Remote code execution (RCE) in PHPMailer &#8211; <em>No specific issue appears to affect WordPress</em> or any of the major plugins we investigated but, out of an abundance of caution, we updated PHPMailer in this release. This issue was fixed in PHPMailer thanks to <a href=\"https://legalhackers.com/\">Dawid Golunski</a> and <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a>.</li>\n<li>The REST API exposed user data for all users who had authored a post of a public post type. WordPress 4.7.1 limits this to only post types which have specified that they should be shown within the REST API. Reported by <a href=\"https://poststatus.com/\">Krogsgard</a> and <a href=\"https://ithemes.com/\">Chris Jean</a>.</li>\n<li>Cross-site scripting (XSS) via the plugin name or version header on <code>update-core.php</code>. Reported by <a href=\"https://dominikschilling.de/\">Dominik Schilling</a> of the WordPress Security Team.</li>\n<li>Cross-site request forgery (CSRF) bypass via uploading a Flash file. Reported by <a href=\"https://twitter.com/Abdulahhusam\">Abdullah Hussam</a>.</li>\n<li>Cross-site scripting (XSS) via theme name fallback. Reported by <a href=\"https://pentest.blog/\">Mehmet Ince</a>.</li>\n<li>Post via email checks <code>mail.example.com</code> if default settings aren&#8217;t changed. Reported by John Blackbourn of the WordPress Security Team.</li>\n<li>A cross-site request forgery (CSRF) was discovered in the accessibility mode of widget editing. Reported by <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronnie Skansing</a>.</li>\n<li>Weak cryptographic security for multisite activation key. Reported by <a href=\"https://itsjack.cc/\">Jack</a>.</li>\n</ol>\n<p>Thank you to the reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.7.1 fixes 62 bugs from 4.7. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.7.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.1.</p>\n<p>Thanks to everyone who contributed to 4.7.1: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chandrapatel/\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/christian1012/\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dreamon11/\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hristo-sg/\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/monikarao/\">monikarao</a>, <a href=\"https://profiles.wordpress.org/natereist/\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikschavan/\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nullvariable/\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/sirbrillig/\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sanketparmar/\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sfpt/\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom/\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/sstoqnov/\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/timph/\">timph</a>, <a href=\"https://profiles.wordpress.org/voldemortensen/\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n	\n\n\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 4.7 “Vaughan”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/news/2016/12/vaughan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Dec 2016 19:27:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4596\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:240:\"Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah \"Sassy\" Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2016/12/starter-content.mp4\";s:6:\"length\";s:7:\"3736020\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:59:\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4\";s:6:\"length\";s:7:\"1127483\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:58:\"https://wordpress.org/news/files/2016/12/video-headers.mp4\";s:6:\"length\";s:7:\"1549803\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:45492:\"<p>Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah &#8220;Sassy&#8221; Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.</p>\n<div id=\"v-AHz0Ca46-1\" class=\"video-player\"><video id=\"v-AHz0Ca46-1-video\" width=\"632\" height=\"354\" poster=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_scruberthumbnail_0.jpg\" controls=\"true\" preload=\"metadata\" dir=\"ltr\" lang=\"en\"><source src=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_dvd.mp4\" type=\"video/mp4; codecs=&quot;avc1.64001E, mp4a.40.2&quot;\" /><source src=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_fmt1.ogv\" type=\"video/ogg; codecs=&quot;theora, vorbis&quot;\" /><div><img alt=\"Introducing WordPress 4.7\" src=\"https://i1.wp.com/videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_scruberthumbnail_0.jpg?resize=632%2C354&#038;ssl=1\" data-recalc-dims=\"1\" /></div><p>Introducing WordPress 4.7</p></video></div>\n<hr />\n<h2 style=\"text-align:center\">Presenting Twenty Seventeen</h2>\n<p>A brand new default theme brings your site to life with immersive featured images and video headers.</p>\n<p><img class=\"alignnone wp-image-4618 size-large\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=632%2C356&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=300%2C169&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=768%2C432&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?w=1600&amp;ssl=1 1600w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>Twenty Seventeen focuses on business sites and features a customizable front page with multiple sections. Personalize it with widgets, navigation, social menus, a logo, custom colors, and more. Our default theme for 2017 works great in many languages, on any device, and for a wide range of users.</p>\n<hr />\n<h2 style=\"text-align:center\">Your Site, Your Way</h2>\n<p>WordPress 4.7 adds new features to the customizer to help take you through the initial setup of a theme, with non-destructive live previews of all your changes in one uninterrupted workflow.</p>\n<h3>Theme Starter Content</h3>\n<div style=\"width: 632px;\" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-4596-1\" width=\"632\" height=\"346\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/starter-content.mp4?_=1\" /><a href=\"https://wordpress.org/news/files/2016/12/starter-content.mp4\">https://wordpress.org/news/files/2016/12/starter-content.mp4</a></video></div>\n<p>To help give you a solid base to build from, individual themes can provide starter content that appears when you go to customize your brand new site. This can range from placing a business information widget in the best location to providing a sample menu with social icon links to a static front page complete with beautiful images. Don’t worry &#8211; nothing new will appear on the live site until you’re ready to save and publish your initial theme setup.</p>\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>Edit Shortcuts</h3>\n<div style=\"width: 300px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-4596-2\" width=\"300\" height=\"173\" poster=\"https://wordpress.org/news/files/2016/12/4.7-—-Edit-Shortcuts.jpg\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4?_=2\" /><a href=\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4\">https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4</a></video></div>\n<p>Visible icons appear to show you which parts of your site can be customized while live previewing. Click on a shortcut and get straight to editing. Paired with starter content, getting started with customizing your site is faster than ever.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Video Headers</h3>\n<div style=\"width: 300px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-4596-3\" width=\"300\" height=\"173\" poster=\"https://wordpress.org/news/files/2016/12/4.7-—-Header-Video.jpg\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/video-headers.mp4?_=3\" /><a href=\"https://wordpress.org/news/files/2016/12/video-headers.mp4\">https://wordpress.org/news/files/2016/12/video-headers.mp4</a></video></div>\n<p>Sometimes a big atmospheric video as a moving header image is just what you need to showcase your wares; go ahead and try it out with Twenty Seventeen. Need some video inspiration? Try searching for sites with video headers available for download and use.</p>\n</div>\n<div style=\"clear: both\"></div>\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>Smoother Menu Building</h3>\n<p><img class=\"wp-image-4606 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Many menus for sites contain links to the pages of your site, but what happens when you don’t have any pages yet? Now you can add new pages while building menus instead of leaving the customizer and abandoning your changes. Once you’ve published your customizations, you’ll have new pages ready for you to fill with content.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Custom CSS</h3>\n<p><img class=\"wp-image-4607 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Sometimes you just need a few visual tweaks to make your site perfect. WordPress 4.7 allows you to add custom CSS and instantly see how your changes affect your site. The live preview allows you to work quickly without page refreshes slowing you down.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>PDF Thumbnail Previews</h3>\n<p><img class=\"wp-image-4609 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Managing your document collection is easier with WordPress 4.7. Uploading PDFs will generate thumbnail images so you can more easily distinguish between all your documents.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Dashboard in your language</h3>\n<p><img class=\"wp-image-4608 size-medium alignright\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?resize=300%2C158&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Just because your site is in one language doesn’t mean that everybody helping manage it prefers that language for their admin. Add more languages to your site and a user language option will show up in your user’s profiles.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<h2 style=\"text-align:center\">Introducing REST API Content Endpoints</h2>\n<p>WordPress 4.7 comes with REST API endpoints for posts, comments, terms, users, meta, and settings.</p>\n<p><img class=\"size-large wp-image-4600 alignnone\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=632%2C205&#038;ssl=1\" alt=\"\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=1024%2C332&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=300%2C97&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=768%2C249&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>Content endpoints provide machine-readable external access to your WordPress site with a clear, standards-driven interface, paving the way for new and innovative methods of interacting with sites through plugins, themes, apps, and beyond. Ready to get started with development? <a href=\"https://developer.wordpress.org/rest-api/reference/\">Check out the REST API reference.</a></p>\n<hr />\n<h2 style=\"text-align:center\">Even More Developer Happiness <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<h3><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Post Type Templates</a></h3>\n<p>By opening up the page template functionality to all post types, theme developers have even more flexibility with the WordPress template hierarchy.</p>\n<h3>More Theme API Goodies</h3>\n<p>WordPress 4.7 includes <a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">new functions, hooks, and behavior</a> for theme developers.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\">Custom Bulk Actions</a></h3>\n<p>List tables, now with more than bulk edit and delete.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\"><code>WP_Hook</code></a></h3>\n<p>The code that lies beneath actions and filters has been overhauled and modernized, fixing bugs along the way.</p>\n<h3>Settings Registration API</h3>\n<p>register_setting() <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\">has been enhanced</a> to include type, description, and REST API visibility.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/10/12/customize-changesets-technical-design-decisions/\">Customize Changesets</a></h3>\n<p>Customize changesets make changes in the customizer persistent, like autosave drafts. They also make exciting new features like starter content possible.</p>\n<hr />\n<h2 style=\"text-align:center\">The Squad</h2>\n<p>This release was led by <a href=\"https://helen.blog\">Helen Hou-Sandí</a>, backed up by <a href=\"https://profiles.wordpress.org/jbpaul17\">Jeff Paul</a> and <a href=\"http://aaron.jorb.in/\">Aaron Jorbin</a> as Release Deputies, and with the help of these fine individuals. There are 482 contributors with props in this release—the most ever—with 205 of them contributing for the first time. Pull up some sassy Sarah Vaughan on your music service of choice, and check out some of their profiles:</p>\n<a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/abrightclearweb\">abrightclearweb</a>, <a href=\"https://profiles.wordpress.org/ibachal\">Achal Jain</a>, <a href=\"https://profiles.wordpress.org/achbed\">achbed</a>, <a href=\"https://profiles.wordpress.org/acmethemes\">Acme Themes</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/adammacias\">adammacias</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/ahmadawais\">ahmadawais</a>, <a href=\"https://profiles.wordpress.org/airesvsg\">airesvsg</a>, <a href=\"https://profiles.wordpress.org/ajoah\">ajoah</a>, <a href=\"https://profiles.wordpress.org/akibjorklund\">Aki Bj&#246;rklund</a>, <a href=\"https://profiles.wordpress.org/akshayvinchurkar\">AkshayVinchurkar</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/xavortm\">Alex Dimitrov</a>, <a href=\"https://profiles.wordpress.org/ironpaperweight\">Alex Hon</a>, <a href=\"https://profiles.wordpress.org/alex27\">alex27</a>, <a href=\"https://profiles.wordpress.org/allancole\">allancole</a>, <a href=\"https://profiles.wordpress.org/arush\">Amanda Rush</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andrewp-2\">Andreas Panag</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rarst\">Andrey \"Rarst\" Savchenko</a>, <a href=\"https://profiles.wordpress.org/andizer\">Andy Meerwaldt</a>, <a href=\"https://profiles.wordpress.org/kelderic\">Andy Mercer</a>, <a href=\"https://profiles.wordpress.org/andy\">Andy Skelton</a>, <a href=\"https://profiles.wordpress.org/aniketpant\">Aniket Pant</a>, <a href=\"https://profiles.wordpress.org/anilbasnet\">Anil Basnet</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/ahortin\">Anthony Hortin</a>, <a href=\"https://profiles.wordpress.org/antisilent\">antisilent</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/zuige\">Antti Kuosmanen</a>, <a href=\"https://profiles.wordpress.org/apokalyptik\">apokalyptik</a>, <a href=\"https://profiles.wordpress.org/artoliukkonen\">artoliukkonen</a>, <a href=\"https://profiles.wordpress.org/ideag\">Arunas Liuiza</a>, <a href=\"https://profiles.wordpress.org/attitude\">attitude</a>, <a href=\"https://profiles.wordpress.org/backermann\">backermann</a>, <a href=\"https://profiles.wordpress.org/b-07\">Bappi</a>, <a href=\"https://profiles.wordpress.org/bcole808\">Ben Cole</a>, <a href=\"https://profiles.wordpress.org/kau-boy\">Bernhard Kau</a>, <a href=\"https://profiles.wordpress.org/binarymoon\">BinaryMoon</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornw\">BjornW</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boblinthorst\">boblinthorst</a>, <a href=\"https://profiles.wordpress.org/boboudreau\">boboudreau</a>, <a href=\"https://profiles.wordpress.org/gitlost\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/brainstormforce\">Brainstorm Force</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brianhogg\">Brian Hogg</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/bronsonquick\">Bronson Quick</a>, <a href=\"https://profiles.wordpress.org/sixhours\">Caroline Moore</a>, <a href=\"https://profiles.wordpress.org/caseypatrickdriscoll\">Casey Driscoll</a>, <a href=\"https://profiles.wordpress.org/caspie\">Caspie</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/chaos-engine\">Chaos Engine</a>, <a href=\"https://profiles.wordpress.org/cheeserolls\">cheeserolls</a>, <a href=\"https://profiles.wordpress.org/chesio\">chesio</a>, <a href=\"https://profiles.wordpress.org/ketuchetan\">chetansatasiya</a>, <a href=\"https://profiles.wordpress.org/choongsavvii\">choong</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chredd\">chredd</a>, <a href=\"https://profiles.wordpress.org/chrisjean\">Chris Jean</a>, <a href=\"https://profiles.wordpress.org/cmmarslender\">Chris Marslender</a>, <a href=\"https://profiles.wordpress.org/chris_d2d\">Chris Smith</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/chriswiegman\">Chris Wiegman</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/chriseverson\">chriseverson</a>, <a href=\"https://profiles.wordpress.org/christian1012\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/cwpnolen\">Christian Nolen</a>, <a href=\"https://profiles.wordpress.org/needle\">Christian Wach</a>, <a href=\"https://profiles.wordpress.org/christophherr\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/clarionwpdeveloper\">Clarion Technologies</a>, <a href=\"https://profiles.wordpress.org/claudiosanches\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiosmweb\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiolabarbera\">ClaudioLaBarbera</a>, <a href=\"https://profiles.wordpress.org/codemovementpk\">codemovement.pk</a>, <a href=\"https://profiles.wordpress.org/coderkevin\">coderkevin</a>, <a href=\"https://profiles.wordpress.org/codfish\">codfish</a>, <a href=\"https://profiles.wordpress.org/coreymcollins\">coreymcollins</a>, <a href=\"https://profiles.wordpress.org/curdin\">Curdin Krummenacher</a>, <a href=\"https://profiles.wordpress.org/cgrymala\">Curtiss Grymala</a>, <a href=\"https://profiles.wordpress.org/cdog\">Cătălin Dogaru</a>, <a href=\"https://profiles.wordpress.org/danhgilmore\">danhgilmore</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber </a>, <a href=\"https://profiles.wordpress.org/danielkanchev\">Daniel Kanchev</a>, <a href=\"https://profiles.wordpress.org/danielpietrasik\">Daniel Pietrasik</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/dllh\">Daryl L. L. Houston (dllh)</a>, <a href=\"https://profiles.wordpress.org/davepullig\">Dave Pullig</a>, <a href=\"https://profiles.wordpress.org/goto10\">Dave Romsey (goto10)</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/turtlepod\">David Chandra Purnama</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dglingren\">David Lingren</a>, <a href=\"https://profiles.wordpress.org/davidmosterd\">David Mosterd</a>, <a href=\"https://profiles.wordpress.org/dshanske\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/davidbhayes\">davidbhayes</a>, <a href=\"https://profiles.wordpress.org/folletto\">Davide \'Folletto\' Casali</a>, <a href=\"https://profiles.wordpress.org/deeptiboddapati\">deeptiboddapati</a>, <a href=\"https://profiles.wordpress.org/delphinus\">delphinus</a>, <a href=\"https://profiles.wordpress.org/deltafactory\">deltafactory</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/pcfreak30\">Derrick Hammer</a>, <a href=\"https://profiles.wordpress.org/derrickkoo\">Derrick Koo</a>, <a href=\"https://profiles.wordpress.org/dimchik\">dimchik</a>, <a href=\"https://profiles.wordpress.org/dineshc\">Dinesh Chouhan</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dipeshkakadiya\">dipeshkakadiya</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dotancohen\">Dotan Cohen</a>, <a href=\"https://profiles.wordpress.org/dougwollison\">Doug Wollison</a>, <a href=\"https://profiles.wordpress.org/doughamlin\">doughamlin</a>, <a href=\"https://profiles.wordpress.org/dreamon11\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/duncanjbrown\">duncanjbrown</a>, <a href=\"https://profiles.wordpress.org/dungengronovius\">dungengronovius</a>, <a href=\"https://profiles.wordpress.org/dylanauty\">DylanAuty</a>, <a href=\"https://profiles.wordpress.org/hurtige\">Eddie Hurtig</a>, <a href=\"https://profiles.wordpress.org/oso96_2000\">Eduardo Reveles</a>, <a href=\"https://profiles.wordpress.org/chopinbach\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/electricfeet\">ElectricFeet</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/elyobo\">elyobo</a>, <a href=\"https://profiles.wordpress.org/enodekciw\">enodekciw</a>, <a href=\"https://profiles.wordpress.org/enshrined\">enshrined</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/pushred\">Eric Lanehart</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fencer04\">Fencer04</a>, <a href=\"https://profiles.wordpress.org/florianbrinkmann\">Florian Brinkmann</a>, <a href=\"https://profiles.wordpress.org/mista-flo\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/foliovision\">FolioVision</a>, <a href=\"https://profiles.wordpress.org/fomenkoandrey\">fomenkoandrey</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/fjarrett\">Frankie Jarrett</a>, <a href=\"https://profiles.wordpress.org/frankiet\">frankiet</a>, <a href=\"https://profiles.wordpress.org/akeif\">Fred</a>, <a href=\"https://profiles.wordpress.org/frozzare\">Fredrik Forsmo</a>, <a href=\"https://profiles.wordpress.org/fuscata\">fuscata</a>, <a href=\"https://profiles.wordpress.org/gma992\">Gabriel Maldonado</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/geekysoft\">Geeky Software</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/goranseric\">Goran &#352;erić</a>, <a href=\"https://profiles.wordpress.org/grahamarmfield\">Graham Armfield</a>, <a href=\"https://profiles.wordpress.org/grantderepas\">Grant Derepas</a>, <a href=\"https://profiles.wordpress.org/tivnet\">Gregory Karpinsky (@tivnet)</a>, <a href=\"https://profiles.wordpress.org/hardeepasrani\">Hardeep Asrani</a>, <a href=\"https://profiles.wordpress.org/henrywright\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/hiddenpearls\">hiddenpearls</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hristo-sg\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/iamjolly\">iamjolly</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianedington\">Ian Edington</a>, <a href=\"https://profiles.wordpress.org/idealien\">idealien</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/imnok\">Imnok</a>, <a href=\"https://profiles.wordpress.org/implenton\">implenton</a>, <a href=\"https://profiles.wordpress.org/ionutst\">Ionut Stanciu</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/krstarica\">Ivan</a>, <a href=\"https://profiles.wordpress.org/ivdimova\">ivdimova</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jakept\">Jacob Peattie</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/jnylen0\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jamesacero\">jamesacero</a>, <a href=\"https://profiles.wordpress.org/japh\">Japh</a>, <a href=\"https://profiles.wordpress.org/jaredcobb\">Jared Cobb</a>, <a href=\"https://profiles.wordpress.org/jayarjo\">jayarjo</a>, <a href=\"https://profiles.wordpress.org/jdolan\">jdolan</a>, <a href=\"https://profiles.wordpress.org/jdoubleu\">jdoubleu</a>, <a href=\"https://profiles.wordpress.org/jblz\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/cheffheid\">Jeffrey de Wit</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jimt\">jimt</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">Jip Moors</a>, <a href=\"https://profiles.wordpress.org/jmusal\">jmusal</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joelcj91\">Joel James</a>, <a href=\"https://profiles.wordpress.org/johanmynhardt\">johanmynhardt</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/zyphonic\">John Dittmar</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnpbloch\">John P. Bloch</a>, <a href=\"https://profiles.wordpress.org/johnregan3\">John Regan</a>, <a href=\"https://profiles.wordpress.org/johnpgreen\">johnpgreen</a>, <a href=\"https://profiles.wordpress.org/kenshino\">Jon (Kenshino)</a>, <a href=\"https://profiles.wordpress.org/jonathanbardo\">Jonathan Bardo</a>, <a href=\"https://profiles.wordpress.org/jbrinley\">Jonathan Brinley</a>, <a href=\"https://profiles.wordpress.org/daggerhart\">Jonathan Daggerhart</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jonnyauk\">jonnyauk</a>, <a href=\"https://profiles.wordpress.org/jordesign\">jordesign</a>, <a href=\"https://profiles.wordpress.org/jorritschippers\">JorritSchippers</a>, <a href=\"https://profiles.wordpress.org/joefusco\">Joseph Fusco</a>, <a href=\"https://profiles.wordpress.org/jjeaton\">Josh Eaton</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/joshcummingsdesign\">joshcummingsdesign</a>, <a href=\"https://profiles.wordpress.org/joshkadis\">joshkadis</a>, <a href=\"https://profiles.wordpress.org/joyously\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/jrgould\">JRGould</a>, <a href=\"https://profiles.wordpress.org/juanfra\">Juanfra Aldasoro</a>, <a href=\"https://profiles.wordpress.org/juhise\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/nukaga\">Junko Nukaga</a>, <a href=\"https://profiles.wordpress.org/justinbusa\">Justin Busa</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jshreve\">Justin Shreve</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/kacperszurek\">kacperszurek</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/kalenjohnson\">KalenJohnson</a>, <a href=\"https://profiles.wordpress.org/codebykat\">Kat Hagan</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/keesiemeijer\">keesiemeijer</a>, <a href=\"https://profiles.wordpress.org/kellbot\">kellbot</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/wraithkenny\">Ken Newman</a>, <a href=\"https://profiles.wordpress.org/khag7\">Kevin Hagerty</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kjbenk\">kjbenk</a>, <a href=\"https://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/koenschipper\">koenschipper</a>, <a href=\"https://profiles.wordpress.org/kokarn\">kokarn</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kouratoras\">Konstantinos Kouratoras</a>, <a href=\"https://profiles.wordpress.org/kuchenundkakao\">kuchenundkakao</a>, <a href=\"https://profiles.wordpress.org/kuldipem\">kuldipem</a>, <a href=\"https://profiles.wordpress.org/laurelfulford\">Laurel Fulford</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/leobaiano\">Leo Baiano</a>, <a href=\"https://profiles.wordpress.org/littlebigthing\">LittleBigThings (Csaba)</a>, <a href=\"https://profiles.wordpress.org/lucasstark\">Lucas Stark</a>, <a href=\"https://profiles.wordpress.org/lukecavanagh\">Luke Cavanagh</a>, <a href=\"https://profiles.wordpress.org/lgedeon\">Luke Gedeon</a>, <a href=\"https://profiles.wordpress.org/lukepettway\">lukepettway</a>, <a href=\"https://profiles.wordpress.org/lyubomir_popov\">lyubomir_popov</a>, <a href=\"https://profiles.wordpress.org/mageshp\">mageshp</a>, <a href=\"https://profiles.wordpress.org/mahesh901122\">Mahesh Waghmare</a>, <a href=\"https://profiles.wordpress.org/mangeshp\">Mangesh Parte</a>, <a href=\"https://profiles.wordpress.org/manishsongirkar36\">Manish Songirkar</a>, <a href=\"https://profiles.wordpress.org/mantismamita\">mantismamita</a>, <a href=\"https://profiles.wordpress.org/mbootsman\">Marcel Bootsman</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mariovalney\">Mario Valney</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/mrwweb\">Mark Root-Wiley</a>, <a href=\"https://profiles.wordpress.org/mapk\">Mark Uraine</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/markshep\">markshep</a>, <a href=\"https://profiles.wordpress.org/matrixik\">matrixik</a>, <a href=\"https://profiles.wordpress.org/mjbanks\">Matt Banks</a>, <a href=\"https://profiles.wordpress.org/jaworskimatt\">Matt Jaworski</a>, <a href=\"https://profiles.wordpress.org/mattking5000\">Matt King</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/veraxus\">Matt van Andel</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/maxcutler\">Max Cutler</a>, <a href=\"https://profiles.wordpress.org/maximeculea\">Maxime Culea</a>, <a href=\"https://profiles.wordpress.org/mayukojpn\">Mayo Moriyama</a>, <a href=\"https://profiles.wordpress.org/mbelchev\">mbelchev</a>, <a href=\"https://profiles.wordpress.org/mckernanin\">mckernanin</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mhowell\">mhowell</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michaelarestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/mauteri\">Mike Auteri</a>, <a href=\"https://profiles.wordpress.org/mihai2u\">Mike Crantea</a>, <a href=\"https://profiles.wordpress.org/mdgl\">Mike Glendinning</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikelittle\">Mike Little</a>, <a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeviele\">Mike Viele</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/modemlooper\">modemlooper</a>, <a href=\"https://profiles.wordpress.org/batmoo\">Mohammad Jangda</a>, <a href=\"https://profiles.wordpress.org/deremohan\">Mohan Dere</a>, <a href=\"https://profiles.wordpress.org/monikarao\">monikarao</a>, <a href=\"https://profiles.wordpress.org/morettigeorgiev\">morettigeorgiev</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mor10\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">moto hachi ( mt8.biz )</a>, <a href=\"https://profiles.wordpress.org/mrbobbybryant\">mrbobbybryant</a>, <a href=\"https://profiles.wordpress.org/nnaimov\">Naim Naimov</a>, <a href=\"https://profiles.wordpress.org/natereist\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/natewr\">NateWr</a>, <a href=\"https://profiles.wordpress.org/nathanrice\">nathanrice</a>, <a href=\"https://profiles.wordpress.org/nazgul\">Nazgul</a>, <a href=\"https://profiles.wordpress.org/greatislander\">Ned Zimmerman</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey </a>, <a href=\"https://profiles.wordpress.org/nikeo\">Nicolas GUILLAUME</a>, <a href=\"https://profiles.wordpress.org/nikschavan\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nikv\">Nikhil Vimal</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/noplanman\">noplanman</a>, <a href=\"https://profiles.wordpress.org/nullvariable\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/odie2\">odie2</a>, <a href=\"https://profiles.wordpress.org/odysseygate\">odyssey</a>, <a href=\"https://profiles.wordpress.org/hideokamoto\">Okamoto Hidetaka</a>, <a href=\"https://profiles.wordpress.org/orvils\">orvils</a>, <a href=\"https://profiles.wordpress.org/oskosk\">oskosk</a>, <a href=\"https://profiles.wordpress.org/ottok\">Otto Kek&#228;l&#228;inen</a>, <a href=\"https://profiles.wordpress.org/ovann86\">ovann86</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/patilvikasj\">patilvikasj</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/sirbrillig\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/pdufour\">pdufour</a>, <a href=\"https://profiles.wordpress.org/piewp\">Perdaan</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phh\">phh</a>, <a href=\"https://profiles.wordpress.org/php\">php</a>, <a href=\"https://profiles.wordpress.org/delawski\">Piotr Delawski</a>, <a href=\"https://profiles.wordpress.org/pippinsplugins\">pippinsplugins</a>, <a href=\"https://profiles.wordpress.org/pjgalbraith\">pjgalbraith</a>, <a href=\"https://profiles.wordpress.org/pkevan\">pkevan</a>, <a href=\"https://profiles.wordpress.org/pratikchaskar\">Pratik</a>, <a href=\"https://profiles.wordpress.org/pressionate\">Pressionate</a>, <a href=\"https://profiles.wordpress.org/presskopp\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/procodewp\">procodewp</a>, <a href=\"https://profiles.wordpress.org/quasel\">quasel</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rahulsprajapati\">Rahul Prajapati</a>, <a href=\"https://profiles.wordpress.org/superpoincare\">Ramanan</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/ramiabraham\">ramiabraham</a>, <a href=\"https://profiles.wordpress.org/ranh\">ranh</a>, <a href=\"https://profiles.wordpress.org/redsand\">Red Sand Media Group</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/iamfriendly\">Richard Tape</a>, <a href=\"https://profiles.wordpress.org/rpayne7264\">Robert D Payne</a>, <a href=\"https://profiles.wordpress.org/rnoakes3rd\">Robert Noakes</a>, <a href=\"https://profiles.wordpress.org/d4z_c0nf\">Rocco Aliberti</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/rommelxcastro\">Rommel Castro</a>, <a href=\"https://profiles.wordpress.org/fronaldaraujo\">Ronald Ara&#250;jo</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, <a href=\"https://profiles.wordpress.org/guavaworks\">Roy Sivan</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/ryanplas\">Ryan Plas</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/samikeijonen\">Sami Keijonen</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/samuelsidler\">Samuel Sidler</a>, <a href=\"https://profiles.wordpress.org/sandesh055\">Sandesh</a>, <a href=\"https://profiles.wordpress.org/smyoon315\">Sang-Min Yoon</a>, <a href=\"https://profiles.wordpress.org/sanketparmar\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/pollyplummer\">Sarah Gooding</a>, <a href=\"https://profiles.wordpress.org/sayedwp\">Sayed Taqui</a>, <a href=\"https://profiles.wordpress.org/schlessera\">schlessera</a>, <a href=\"https://profiles.wordpress.org/schrapel\">schrapel</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scrappyhuborg\">scrappy@hub.org</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/seancjones\">seancjones</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sgr33n\">Sergio De Falco</a>, <a href=\"https://profiles.wordpress.org/sfpt\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shayanys\">shayanys</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/shprink\">shprink</a>, <a href=\"https://profiles.wordpress.org/simonlampen\">simonlampen</a>, <a href=\"https://profiles.wordpress.org/skippy\">skippy</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/snacking\">snacking</a>, <a href=\"https://profiles.wordpress.org/soean\">Soeren Wrede</a>, <a href=\"https://profiles.wordpress.org/solal\">solal</a>, <a href=\"https://profiles.wordpress.org/sstoqnov\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/metodiew\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/sharkomatic\">Steph</a>, <a href=\"https://profiles.wordpress.org/sswells\">Steph Wells</a>, <a href=\"https://profiles.wordpress.org/sillybean\">Stephanie Leary</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/stevenlinx\">stevenlinx</a>, <a href=\"https://profiles.wordpress.org/stubgo\">stubgo</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/patilswapnilv\">Swapnil V. Patil</a>, <a href=\"https://profiles.wordpress.org/swapnild\">swapnild</a>, <a href=\"https://profiles.wordpress.org/szaqal21\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/takahashi_fumiki\">Takahashi Fumiki</a>, <a href=\"https://profiles.wordpress.org/miyauchi\">Takayuki Miyauchi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tapsboy\">tapsboy</a>, <a href=\"https://profiles.wordpress.org/tlovett1\">Taylor Lovett</a>, <a href=\"https://profiles.wordpress.org/team\">team</a>, <a href=\"https://profiles.wordpress.org/tg29359\">tg29359</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/the\">the</a>, <a href=\"https://profiles.wordpress.org/themeshaper\">themeshaper</a>, <a href=\"https://profiles.wordpress.org/thenbrent\">thenbrent</a>, <a href=\"https://profiles.wordpress.org/thomaswm\">thomaswm</a>, <a href=\"https://profiles.wordpress.org/tfrommen\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/tierra\">tierra</a>, <a href=\"https://profiles.wordpress.org/tnash\">Tim Nash</a>, <a href=\"https://profiles.wordpress.org/timmydcrawford\">Timmy Crawford</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timph\">timph</a>, <a href=\"https://profiles.wordpress.org/tkama\">Tkama</a>, <a href=\"https://profiles.wordpress.org/tnegri\">tnegri</a>, <a href=\"https://profiles.wordpress.org/tomauger\">Tom Auger</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tomdxw\">tomdxw</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/zodiac1978\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/transl8or\">transl8or</a>, <a href=\"https://profiles.wordpress.org/traversal\">traversal</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/nmt90\">Triet Minh</a>, <a href=\"https://profiles.wordpress.org/trishasalas\">Trisha Salas</a>, <a href=\"https://profiles.wordpress.org/tristangemus\">tristangemus</a>, <a href=\"https://profiles.wordpress.org/truongwp\">Truong Giang</a>, <a href=\"https://profiles.wordpress.org/tsl143\">tsl143</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/utkarshpatel\">Utkarsh</a>, <a href=\"https://profiles.wordpress.org/valeriutihai\">Valeriu Tihai</a>, <a href=\"https://profiles.wordpress.org/vishalkakadiya\">Vishal Kakadiya</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/vrundakansara-1\">Vrunda Kansara</a>, <a href=\"https://profiles.wordpress.org/webbgaraget\">webbgaraget</a>, <a href=\"https://profiles.wordpress.org/webmandesign\">WebMan Design &#124; Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/websupporter\">websupporter</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/earnjam\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton\">williampatton</a>, <a href=\"https://profiles.wordpress.org/wolly\">Wolly aka Paolo Valenti</a>, <a href=\"https://profiles.wordpress.org/yale01\">yale01</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/yogasukma\">Yoga Sukma</a>, <a href=\"https://profiles.wordpress.org/oxymoron\">Zach Wills</a>, <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>, <a href=\"https://profiles.wordpress.org/vanillalounge\">Ze Fontainhas</a>, <a href=\"https://profiles.wordpress.org/zhildzik\">zhildzik</a>, and <a href=\"https://profiles.wordpress.org/zsusag\">zsusag</a>.\n<p>&nbsp;<br />\nSpecial thanks go to <a href=\"https://ramiabraham.com/\">Rami Abraham</a> for producing the release video and the many fine haiku we saw in the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">beta</a> and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-release-candidate/\">RC</a> announcement posts.</p>\n<p>Finally, thanks to all the community translators who worked on WordPress 4.7. Their efforts bring WordPress 4.7 fully translated to 52 languages at release time with more on the way. Additionally, the WordPress 4.7 release video has been captioned into 44 languages.</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress &#8211; we hope you enjoy!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4596\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Moving Toward SSL\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/2016/12/moving-toward-ssl/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Dec 2016 17:20:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4588\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:327:\"We’re at a turning point: 2017 is going to be the year that we’re going to see features in WordPress which require hosts to have HTTPS available. Just as JavaScript is a near necessity for smoother user experiences and more modern PHP versions are critical for performance, SSL just makes sense as the next hurdle [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1627:\"<p>We’re at a turning point: 2017 is going to be the year that we’re going to see features in WordPress which require hosts to have HTTPS available. Just as JavaScript is a near necessity for smoother user experiences and more modern PHP versions are critical for performance, SSL just makes sense as the next hurdle our users are going to face.</p>\n<p>SSL basically means the link between your browser and the server is encrypted. SSL used to be difficult to implement, and often expensive or slow. Modern browsers, and the incredible success of projects like <a href=\"https://letsencrypt.org/\">Let&#8217;s Encrypt</a> have made getting a certificate to secure your site fast, free, and something we think every host should support by default, especially in a post-Snowden era. Google also weighs <a href=\"https://security.googleblog.com/2014/08/https-as-ranking-signal_6.html\">SSL as a search engine ranking factor</a> and will begin <a href=\"http://motherboard.vice.com/read/google-will-soon-shame-all-websites-that-are-unencrypted-chrome-https\">flagging unencrypted sites in Chrome</a>.</p>\n<p>First, early in 2017, we will only promote hosting partners that provide a SSL certificate by default in their accounts. Later we will begin to assess which features, such as API authentication, would benefit the most from SSL and make them only enabled when SSL is there.</p>\n<p>Separately, I also think the performance improvements in PHP7 are particularly impressive, and major kudos to everyone who worked on that. We will consider whether hosts use PHP7 by default for new accounts next year as well.</p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4588\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.7 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2016/11/wordpress-4-7-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Nov 2016 04:26:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4579\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:328:\"The release candidate for WordPress 4.7 is now available. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.7 on Tuesday, December 6, but we need your help to get there. If you haven’t tested 4.7 yet, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4331:\"<p>The release candidate for WordPress 4.7 is now available.</p>\n<p>RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.7 on <strong>Tuesday, December 6</strong>, but we need <em>your</em> help to get there. If you haven’t tested 4.7 yet, now is the time! To test WordPress 4.7, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.7-RC1.zip\">download the release candidate here</a> (zip).</p>\n<p>WordPress 4.7 is a jam-packed release, with a number of features focused on getting a theme set up for the first time. Highlights include a <a href=\"http://2017.wordpress.net/\">new default theme</a>, video headers, custom CSS, customizer edit shortcuts, PDF thumbnail previews, user admin languages, REST API content endpoints, post type templates, and more.</p>\n<p>We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39353&amp;stop_rev=39263&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">quite a few refinements</a> since releasing Beta 4 a week ago, including usability and accessibility enhancements for video headers, media and page template support in starter content, and polishing of how custom CSS can be migrated to and extended by plugins and themes. The REST API endpoints saw a number of bugfixes and notably now have anonymous comment off by default.</p>\n<p>Not sure where to start with testing? Try setting up a fresh site on a new installation with Twenty Seventeen (hint: head into customizing your site before touching any pages or widgets) and taking notes on what you enjoyed and what got you stuck. For more details about what&#8217;s new in version 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Think you’ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you’ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.7 and update your plugin’s <em>Tested up to</em> version in the readme to 4.7. If you find compatibility problems please be sure to post to the support forums so we can figure those out before the final release – we work hard to avoid breaking things. An in-depth field guide to developer-focused changes is coming soon on the <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> And if you haven&#8217;t yet done so, now is a great time to <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2016-survey\">take the Annual WordPress Survey</a> and send it on to your friends.</p>\n<p>Happy testing! And now for another <a href=\"https://profiles.wordpress.org/ramiabraham\">Rami Abraham</a> haiku break.</p>\n<p><em>Select your language</em><br />\n<em>Then let your users choose theirs</em><br />\n<em><code>get_user_locale()</code></em></p>\n<p><em>Theme authors rejoice</em><br />\n<em>Any option may employ</em><br />\n<em>Selective refresh</em></p>\n<p><em>Custom header video</em><br />\n<em>Make sure to <code>add_theme_support</code></em><br />\n<em>Bling above the fold</em></p>\n<p><em>A new template dawns</em><br />\n<em>A hierarchy member</em><br />\n<em>Post-type templates live</em></p>\n<p><em>PDF updates</em><br />\n<em>Pack a parade of polish</em><br />\n<em>Prettier previews</em></p>\n<p><em>Template Post Type: New</em><br />\n<em>Template Post Type: And Useful</em><br />\n<em>Template Post Type: Thing</em></p>\n<p><em>Let lists live lively</em><br />\n<em>Laud <code>wp_list_sort()</code></em><br />\n<em>Less laconic lists</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4579\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Nov 2016 01:51:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4576\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2019:\"<p>WordPress 4.7 Beta 4 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta4.zip\">download the beta here</a> (zip).</p>\n<p>For more information on what’s new in 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1,</a> <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\">Beta 3</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-7+dev-notes/\">in-depth developer guides on make/core</a>. We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39262&amp;stop_rev=39201&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">about 60 changes</a> in the last few days for beta 4, including tweaks to Twenty Seventeen, custom CSS, and the REST API content endpoints.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>We are almost there<br />\nPlease test your plugins and themes<br />\nRC coming soon<br />\n</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4576\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordCamp US 2017-2018 in Nashville\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2016/11/wordcamp-us-2017-2018-in-nashville/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2016 23:24:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4571\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:330:\"The title says it all. We had some great applications for cities to host WordCamp US after we finish up in Philadelphia this year, and the city chosen for 2017-2018 is Nashville, Tennessee. Based on the other great applications we got I&#8217;m also excited about the pipeline of communities that could host it in future [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1022:\"<p><img class=\"aligncenter\" src=\"https://i0.wp.com/wpdotorg.files.wordpress.com/2008/07/27492741871_c6fcebcad3_k-e1479248587522.jpg?resize=632%2C253&#038;ssl=1\" data-recalc-dims=\"1\" /></p>\n<p>The title says it all. We had some great applications for cities to host <a href=\"http://us.wordcamp.org/\">WordCamp US</a> after we finish up in Philadelphia this year, and the city chosen for 2017-2018 is <strong>Nashville, Tennessee</strong>.</p>\n<p>Based on the other great applications we got I&#8217;m also excited about the pipeline of communities that could host it in future years as WordCamp US travels across the United States and gives us an opportunity to learn and love a new city, as we have with Philadelphia.</p>\n<p>By the way, if you haven&#8217;t yet, now is a great time to <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2016-survey\">take the Annual WordPress Survey</a> and ask your friends to as well.</p>\n<p><a href=\"https://www.flickr.com/photos/143951935@N07/27492741871\">Photo Credit</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Nov 2016 03:30:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4566\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 3 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3120:\"<p>WordPress 4.7 Beta 3 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta3.zip\">download the beta here</a> (zip).</p>\n<p>For more information on what’s new in 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-7+dev-notes/\">in-depth field guides on make/core</a>. Some of the changes in Beta 3 include:</p>\n<ul>\n<li><strong>REST API:</strong> The <code>unfiltered_html</code> capability is now respected and <code>rest_base</code> has been added to response objects of <code>wp/v2/taxonomies</code> and <code>wp/v2/types</code>, while <code>get_allowed_query_vars()</code> and the <code>rest_get_post</code> filter have been removed.</li>\n<li><strong>Roles/Capabilities:</strong> Added meta-caps for comment, term, and user meta, which are currently only used in the REST API.</li>\n<li><strong>I18N:</strong> Added the ability to change user&#8217;s locale back to site&#8217;s locale. (<a href=\"https://core.trac.wordpress.org/ticket/38632\">#38632</a>)</li>\n<li><strong>Custom CSS:</strong> Renamed the <code>unfiltered_css</code> meta capability to <code>edit_css</code> and added revisions support to the <code>custom_css</code> post type.</li>\n<li><strong>Edit shortcuts:</strong> Theme authors should take a look at <a href=\"https://make.wordpress.org/core/2016/11/10/visible-edit-shortcuts-in-the-customizer-preview/\">the developer guide to the customizer preview&#8217;s visible edit shortcuts</a> and update their themes to take advantage of them if not already implementing selective refresh.</li>\n<li><strong>Various bug fixes:</strong> We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39200&amp;stop_rev=39143&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">over 50 changes</a> in the last week.</li>\n</ul>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>Building the future</em><br />\n<em>A global community</em><br />\n<em>Stronger together</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4566\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Nov 2016 17:39:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4552\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 2 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4240:\"<p>WordPress 4.7 Beta 2 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta2.zip\">download the beta here</a> (zip).</p>\n<p>Notable changes since WordPress 4.7 Beta 1:</p>\n<ul>\n<li><strong>Twenty Seventeen:</strong> The theme wasn&#8217;t being installed on upgrades &#8211; sorry about that! Now you should see it if you&#8217;re upgrading an existing site. There are also plenty of fixes, especially for the header and small screen views.</li>\n<li><strong>Edit shortcuts:</strong> These are always visible while editing (hide them on bigger screens by collapsing the controls) and should now work properly in Firefox. (<a href=\"https://core.trac.wordpress.org/ticket/27403\">#27403</a> and <a href=\"https://core.trac.wordpress.org/ticket/38532\">#38532</a>)</li>\n<li><strong>REST API endpoints:</strong> There have been a number of changes over the past week; your attention is requested on the following:\n<ul>\n<li>The <code>DELETE</code> response format has changed and may need to be accounted for. (<a href=\"https://core.trac.wordpress.org/ticket/38494\">#38494</a>)</li>\n<li>Enabled querying by multiple post statuses. (<a href=\"https://core.trac.wordpress.org/ticket/38420\">#38420</a>)</li>\n<li>Return an error when JSON decoding fails. (<a href=\"https://core.trac.wordpress.org/ticket/38547\">#38547</a>)</li>\n</ul>\n</li>\n<li><strong>More developer notes</strong>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2016/10/28/fine-grained-capabilities-for-taxonomy-terms-in-4-7/\">Fine grained capabilities for taxonomy terms</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/29/wp_taxonomy-in-4-7/\"><code>WP_Taxonomy</code></a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/02/wp_list_sort-and-wp_list_util-in-4-7/\"><code>wp_list_sort()</code> and <code>WP_List_Util</code></a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Post type templates</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/new-post-type-labels-in-4-7/\">New post type labels</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/attributes-for-resource-hints-in-4-7/\">Attributes for resource hints</a></li>\n</ul>\n</li>\n<li><strong>Various bug fixes:</strong> We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39142&amp;stop_rev=38995&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">almost 150 changes</a> in the last week.</li>\n</ul>\n<p>For more of what’s new in version 4.7, <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">check out the Beta 1 blog post</a>.</p>\n<p>If you want a more in-depth view of what major changes have made it into 4.7, <a href=\"https://make.wordpress.org/core/tag/4-7/\">check out posts tagged with 4.7 on the main development blog</a>, or look at a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.7&amp;group=component&amp;order=priority\">list of everything</a> that’s changed. There will be more developer notes to come, so keep an eye out for those as well.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p>Happy testing!</p>\n<p><em>Ya es la hora</em><br />\n<em> Time for another beta</em><br />\n请您帮下忙!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4552\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Oct 2016 04:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4535\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 1 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6895:\"<p>WordPress 4.7 Beta 1 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta1.zip\">download the beta here</a> (zip).</p>\n<p>WordPress 4.7 is slated for release on <a href=\"https://make.wordpress.org/core/4-7/\">December 6</a>, but we need your help to get there. We&#8217;ve been working on a lot of things, many of them to make getting your site set up the way you want it much easier. Here are some of the bigger items to test and help us find as many bugs as possible in the coming weeks:</p>\n<ul>\n<li><a href=\"http://2017.wordpress.net/\"><strong>Twenty Seventeen</strong></a> &#8211; A brand new default theme brings your site to life with immersive featured images, video headers, and subtle animations. With a focus on business sites, it features multiple sections on the front page as well as widgets, navigation and social menus, a logo, and more. Personalize its asymmetrical grid with a custom color scheme and showcase your multimedia content with post formats. Our default theme for 2017 works great in many languages, for any abilities, and on any device.</li>\n<li><strong>Video Headers</strong> &#8211; Sometimes a big atmospheric video as a moving header image is just what you need to showcase your wares; go ahead and try it out with Twenty Seventeen. Need some video inspiration? Try searching for sites with video headers available for download and use.</li>\n<li><strong>Set up your site in one flow</strong> &#8211; From finding and installing themes right inside the customizer, to automatically staged theme-specific starter content, to clickable shortcuts that jump directly to editing an item from the preview pane, to adding pages while you&#8217;re building a nav menu or setting a static front page: getting a new site spun up and ready to share with a friend or a coworker is faster and easier than it&#8217;s ever been. Note: starter content appears when live previewing brand new sites and is currently only available in Twenty Seventeen. We&#8217;ll be expanding this to other bundled themes very soon, and perhaps to sites with existing content in future releases of WordPress.</li>\n<li><strong>Custom CSS with live previews</strong> &#8211; Ever needed to hide or tweak the look of something in your theme or from a plugin? Now you can do it with CSS and live preview the results while customizing your site. CSS can be a powerful tool; you may find that you won&#8217;t need the theme editor or child themes anymore.</li>\n<li><strong>User admin languages</strong> &#8211; Just because your site is in one language doesn&#8217;t mean that everybody helping manage it prefers that language for their admin. To try this out, you&#8217;ll need to have more than one language installed, which will make a user language option available in your profile.</li>\n<li><strong>PDF thumbnail previews</strong> &#8211; Uploading PDFs will now generate thumbnail images so you can more easily distinguish between all your documents.</li>\n</ul>\n<p>As always, there have been exciting changes for developers to explore as well, such as:</p>\n<ul>\n<li><strong>REST API content endpoints</strong> &#8211; If you only test one thing as a developer, please test these. This phase is particularly helpful for people building plugins, themes, and in-admin interfaces. Can you build the things you need? Are these ready for release, and is the world ready for them? (<a href=\"https://core.trac.wordpress.org/ticket/38373\">#38373</a>)</li>\n<li><strong><code>WP_Hook</code></strong> &#8211; The code that lies beneath actions and filters has been overhauled. You likely aren&#8217;t affected, but if you&#8217;ve done things to the <code>$wp_filter</code> global or experienced funky recursion bugs in the past, <a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\">please take a moment to read the dev note</a> and test your code.</li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\"><strong>Custom bulk actions</strong></a> &#8211; List tables, now with more than bulk edit and delete.</li>\n<li>Expanded <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\"><strong>Settings Registration API</strong></a> via <code>register_setting()</code>.</li>\n<li>For theme developers: <strong>Post type templates</strong> (<a href=\"https://core.trac.wordpress.org/ticket/18375\">#18375</a>)</li>\n<li><strong><a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">More goodies for theme developers!</a></strong></li>\n<li><strong>Locale switching</strong> (<a href=\"https://core.trac.wordpress.org/ticket/26511\">#26511</a>)</li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/11/comment-allowed-checks-in-wordpress-4-7/\"><strong>Comment allowed checks</strong></a> have the potential for a back-compat break.</li>\n</ul>\n<p>If you want a more in-depth view of what major changes have made it into 4.7, <a href=\"https://make.wordpress.org/core/tag/4-7/\">check out posts tagged with 4.7 on the main development blog</a>, or look at a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.7&amp;group=component&amp;order=priority\">list of everything</a> that’s changed. There will be more developer notes to come, so keep an eye out for those as well.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p>Happy testing, and please enjoy this extended haiku break, courtesy of <a href=\"https://profiles.wordpress.org/ramiabraham\">Rami Abraham</a><em>.</em></p>\n<p><em>Exquisite endpoints</em><br />\n<em>Extol epic exabytes</em><br />\n<em>Enabling earthlings</em></p>\n<p><em>Careful interfaces</em><br />\n<em>Considerately conjured</em><br />\n<em>Customizer chic</em></p>\n<p><em>Ring in the new year</em><br />\n<em>With elegance and balance</em><br />\n<em>Twenty Seventeen</em></p>\n<p><em>Hooks hook healthily</em><br />\n<em>17817</em><br />\n<em>Sane iterations</em></p>\n<p><em>Admin in your tongue<br />\nOne site, many languages<br />\nWe all speak WordPress</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4535\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Join Us Again for Global WordPress Translation Day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wordpress.org/news/2016/10/join-us-again-for-global-wordpress-translation-day/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Oct 2016 13:33:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:19:\"contributor weekend\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:32:\"global wordpress translation day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"polyglots\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"translations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4516\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:373:\"The WordPress Polyglots team is organizing the second Global WordPress Translation Day on November 12th. Everyone is invited to join – from anywhere in the world! Translating is one of the easiest ways to get involved with WordPress and contribute to the project. Global WordPress Translation Day is your chance to learn more about translating WordPress, meet [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Petya Raykovska\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4273:\"<p>The WordPress Polyglots team is organizing the second <a href=\"https://wptranslationday.org/\">Global WordPress Translation Day</a> on November 12th. Everyone is invited to join – from anywhere in the world!</p>\n<p>Translating is one of the easiest ways to get involved with WordPress and contribute to the project. Global WordPress Translation Day is your chance to learn more about translating WordPress, meet people from all over the world, and <a href=\"https://make.wordpress.org/polyglots/teams\">translate WordPress into one of more than 160 languages</a>.</p>\n<h3>Join us on November 12th from anywhere in the world</h3>\n<p>The translation day starts on Saturday, November 12th, 2016, at 0:00 UTC and ends 24 hours later. <a href=\"http://arewemeetingyet.com/UTC/2016-11-12/00:00/Global%20WordPress%20Translation%20Day%202\">See what time that is for you!</a> You can join right from the start, or any time it&#8217;s convenient for you throughout the day.</p>\n<h3>What are we doing?</h3>\n<p>Local contributor days are happening all over the world, and are a great way to get involved. <a href=\"https://www.google.com/maps/d/viewer?mid=12Gni4JMfShyWHPqGNwh5-PMneMM&amp;usp=sharing\">Check out this map</a> to see if there&#8217;s already a local event happening near you. Can&#8217;t find one? <a href=\"https://make.wordpress.org/polyglots/2016/09/22/global-wordpress-translation-day-2-on-november-12th-2016/\">Organize a local event!</a></p>\n<p>At the same time, <a href=\"https://www.crowdcast.io/e/gwtd2/register\">join the community for 24 hours of live-streamed, remote sessions</a> in numerous languages. Sessions will cover localization, internationalization, and contributing in your language.</p>\n<h3>Who&#8217;s it for?</h3>\n<p>Whether you&#8217;re new to translating and want to learn how to translate, or an experienced translation editor building a strong team, the translation day is for <i>you</i>. Developers will also enjoy topics from experienced contributors, whether you&#8217;re learning about internationalization and or want to find more translators for your themes and plugins. There&#8217;s a session for everyone!</p>\n<h3>Get Involved</h3>\n<p>Joining is easy! On November 12th, in your own timezone, <a href=\"https://translate.wordpress.org\">translate WordPress</a> or your favorite plugins and themes into your language, while watching live sessions over the course of the day.</p>\n<p>Want to get more involved? <a href=\"https://make.wordpress.org/polyglots/2016/09/22/global-wordpress-translation-day-2-on-november-12th-2016/\">Sign up to organize a local event</a> and invite your local community to translate together on November 12th. Events can be formal or completely informal – grab your laptop and a couple of friends, and head to a local coffee shop to translate for an hour or two.</p>\n<h3>Can you get involved if you only speak English?</h3>\n<p>Absolutely! Even if you only speak English, there are great sessions about internationalization that can benefit every developer. There&#8217;s also lots of English variants that need your help! For example, English is spoken and written differently in Australia, Canada, New Zealand, South Africa, and the United Kingdom. You can learn about these differences and why these variants are important during the sessions.</p>\n<p>And if you’re feeling fun, try translating WordPress into emoji! Yep, we have a translation of WordPress in emoji! <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f30e.png\" alt=\"🌎\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f30d.png\" alt=\"🌍\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f30f.png\" alt=\"🌏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n<h3>Questions?</h3>\n<p>If you have any questions, the polyglots team and the event organizers hang out in <a href=\"http://wordpress.slack.com/messages/polyglots/\">#polyglots in Slack</a> and are happy to help! (Get an invite to Slack at <a href=\"https://chat.wordpress.org\">chat.wordpress.org</a>.)</p>\n<p>Sign up to take part in the event on the <a href=\"https://wptranslationday.org/\">official website</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4516\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 18 Jan 2017 10:32:43 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 14 Jan 2017 00:21:27 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}}s:5:\"build\";s:14:\"20160819135320\";}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134594", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1484746363", "no");
INSERT INTO `wp_jzkb_options` VALUES("134595", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1484735563", "no");
INSERT INTO `wp_jzkb_options` VALUES("134596", "_transient_timeout_feed_99b272eaef9eaa265f30d77863073f26", "1484746363", "no");
INSERT INTO `wp_jzkb_options` VALUES("134597", "_transient_feed_99b272eaef9eaa265f30d77863073f26", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: How to Add Users to BuddyPress Groups in Bulk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://wptavern.com/how-to-add-users-to-buddypress-groups-in-bulk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3220:\"<p>On a site I&#8217;m working on that runs BuddyPress, I created a new group and wanted to add nearly 400 registered users to it. Unfortunately, adding users to BuddyPress groups in bulk is not a core feature. I searched Google for a solution and while the <a href=\"http://www.youngtechleads.com/buddypress-members-import/\">BuddyPress Members Import</a> plugin is recommended in many of the support threads, the feature alone is not worth spending $49.</p>\n<p>Continuing my search, I discovered a <a href=\"https://gist.github.com/rohmann/6151699\">code snippet</a> published by <a href=\"https://premium.wpmudev.org/profile/alexander_rohmann/\">Alexander</a> on the <a href=\"https://premium.wpmudev.org/forums/topic/bulk-adding-buddypress-group-members?replies=14&utm_expid=3606929-94.Ie3dH-CaRwe6MU3VrZsdvw.0&utm_referrer=https%3A%2F%2Fwordpress.org%2Fsupport%2Ftopic%2Fimport-with-buddypress-groups%2F#post-484834\">WPMU DEV forums</a> that works perfectly. To use it, copy the code and add it to a custom WordPress plugin or paste it to your theme&#8217;s functions.php file. I added the code to the top of my theme&#8217;s functions.php file.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/CodeSnippetInThemeFunctionsPHPFile.png?ssl=1\"><img /></a>Code Snippet at the Top of my Theme&#8217;s Functions.php File\n<p>The JavaScript portion of the snippet adds a new item to the Bulk Actions drown-down menu named Add to BP Group.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/AddToBPGroup.png?ssl=1\"><img /></a>Add to BP Group Bulk Action Menu Item\n<p>Select the users you want to add to a group and select Add to BP Group. A prompt appears asking for the Buddy Group ID you want to assign the users to.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/EnterBuddyPressGroupIDPrompt.png?ssl=1\"><img /></a>BuddyPress Group ID Prompt\n<p>To locate the Group ID, click on the Groups admin menu and click on the group&#8217;s name. The URL will look something like this admin.php?page=bp-groups&amp;gid=357&amp;action=edit and the ID is the number that appears after gid=. After entering the ID number, click the Ok button. All of the users you selected will be assigned to that group.</p>\n<p>In the comments of the code snippet on GitHub, <a href=\"https://gist.github.com/rohmann/6151699#gistcomment-1580235\">Strand-C said</a> he wasn&#8217;t able to move 165 users at a time and had to move 50 instead. I tested this theory by moving nearly 400 registered users at the same time to a new BuddyPress group and didn&#8217;t encounter any issues. Keep in mind that the site I&#8217;m working on is relatively new, is running WordPress 4.7, and has very little traffic which could explain why I didn&#8217;t have a problem.</p>\n<p>Being able to manage BuddyPress groups in bulk should be a core feature. There is at least one <a href=\"https://buddypress.trac.wordpress.org/ticket/6161\">open ticket on BuddyPress trac</a> to add Bulk Edit options to Groups. Until these features make their way into BuddyPress, the code snippet above is a free work-around that makes adding users to groups in bulk a lot more convenient.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jan 2017 22:23:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: SiteGround Auto-Issues Let’s Encrypt Certificates for New Domains\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/siteground-auto-issues-lets-encrypt-certificates-for-new-domains\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3373:\"<p>SiteGround is now <a href=\"https://www.siteground.com/blog/https-2017/\" target=\"_blank\">auto-issuing Let&#8217;s Encrypt certificates</a> for every domain hosted on its shared servers. The company has also begun issuing and installing certificates on new accounts automatically after customers register domains or direct new domains to SiteGround&#8217;s servers. This also includes add-on domains added in cPanel. The certificates are also auto-renewed as long as the domains are pointed to the host&#8217;s servers.</p>\n<p>&#8220;Since the launch of Let’s Encrypt our customers have installed nearly 40,000 such certificates,&#8221; said Hristo Pandjarov, WordPress specialist at SiteGround. &#8220;This is less than 10% of the 500,000 domains we host. Together with the paid certificates we may say that 15% of the domains we host were using the HTTPS protocol before we started the auto-issuing procedure.&#8221;</p>\n<p>SiteGround is a sponsor of Let&#8217;s Encrypt and one of the first to auto-issue certificates to self-hosted WordPress customers. Let&#8217;s Encrypt <a href=\"https://wptavern.com/lets-encrypt-passes-20-million-active-certificates-in-2016\" target=\"_blank\">passed 20 million active certificates in 2016</a> and the pressure is on for more sites to adopt SSL in 2017 with Google marking insecure sites in Chrome and using HTTPS as a ranking signal.</p>\n<p>&#8220;What prompted this decision is that we truly believe HTTPS is the future standard for web protocol and we also believe it is the better protocol,&#8221; Pandjarov said. &#8220;This is a good enough motivation for us to take the step of installing it automatically. We have decided to automate the SSL issuance and setup almost right after the appearance of the Let’s Encrypt initiative. Matt Mullenweg’s statement at WordCamp US that issuing SSL certificates will be a very important factor in evaluating a web host, was one more validation that this planned automation was a decision in the right direction.&#8221;</p>\n<p>According to Pandjarov, the vast majority of SiteGround&#8217;s customers are running WordPress. Respondents to the company&#8217;s 2016 client survey indicated that more than two thirds of them use WordPress, which Pandjarov said is a 10% increase in the popularity of WordPress among SiteGround users.</p>\n<h3>Next Step for SiteGround: Pre-Configuring WordPress Installs to Use SSL with One Click </h3>\n<p>Auto-issuing certificates does not guarantee that SiteGround customers will jump through the hoops to configure their sites to use the certificates. Installing a certificate on an existing WordPress site is not as straightforward as a simple click in most cases. SiteGround is working on fully automating this process for its WordPress customers.</p>\n<p>&#8220;If we really want to get closer to 100% HTTPS usage, we need to do more than just automatically issue the certificate,&#8221; Pandjarov said. &#8220;Our next step is to provide a way to pre-configure an active WordPress site, hosted on our servers, to work with the already issued SSL with one click. Additionally, our auto-installer is being updated to install all new WordPress sites as https-ready.&#8221;</p>\n<p>SiteGround doesn&#8217;t yet have an ETA for one-click SSL configuration but Pandjarov said the announcement will be coming soon.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jan 2017 21:52:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: Postmatic Basic Rebrands as Replyable, Moves Two-Way Email Commenting to SaaS Product\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65245\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/postmatic-basic-rebrands-as-replyable-moves-two-way-email-commenting-to-saas-product\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5935:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/replyable.png?ssl=1\"><img /></a></p>\n<p>Postmatic is rebranding its WordPress.org <a href=\"https://wordpress.org/plugins/postmatic/\" target=\"_blank\">Postmatic Basic</a> plugin as Replyable and pushing the two-way email commenting feature into <a href=\"https://replyable.com/\" target=\"_blank\">a new SaaS product</a>. After discovering that many users simply want email commenting, without additional post delivery and newsletter features, Postmatic launched <a href=\"https://replyable.com/\" target=\"_blank\">Replyable</a> to offer this starting at $3/month.</p>\n<p>&#8220;Replyable was born out of user feedback,&#8221; founder Jason Lemieux said. &#8220;Postmatic does more than most sites need and the price is squarely mid-market. From the beginning we’ve heard from users that they already use another newsletter service and just want Postmatic to handle comment subscriptions &#8211; but that alone isn’t worth $20 to too many people. With Replyable we can offer it for $3.&#8221;</p>\n<p>Lemieux and his team have now transitioned Postmatic to be purely a Saas product without a presence in the WordPress.org directory.</p>\n<p>&#8220;Postmatic will continue to grow as a complete engagement system and, if anything, become even more complex and go further up market,&#8221; Lemieux said. &#8220;Sites which use Postmatic tend to dive in deeply. It is meant to function as a package. Grow a list, deliver to it, get them talking about your ideas, monetize the results.&#8221;</p>\n<p>The <a href=\"https://wordpress.org/plugins/postmatic/\" target=\"_blank\">Replyable plugin on WordPress.org</a> now simply covers comment subscriptions with all other features available in the commercial products.</p>\n<p>Ripping an existing feature out of a free plugin and making it paid is fairly unusual and can have a negative impact on how users perceive the plugin. However, Postmatic has a plan to allow legacy users to continue using the features they had before by switching to <a href=\"http://docs.replyable.com/article/284-switching-from-postmatic-basic-to-replyable\" target=\"_blank\">Postmatic Labs</a>. It&#8217;s an inconvenient change but is required for those who don&#8217;t want to upgrade to a commercial plan.</p>\n<p>Although WordPress.org says Postmatic has approximately 1,000 active installs, Lemieux estimates there are 8,000 users including those using the commercial plugin or the Labs plugin. He would not share any specific revenue figures but said he learned some important pricing lessons in leading the bootstrapped startup for the past two years.</p>\n<p>&#8220;We aren’t a runaway WordPress success story but we’re alive and loving our jobs,&#8221; Lemieux said. &#8220;About six months ago it became apparent that we needed to get out of the mid market. We had a huge group of people saying, &#8216;I just want email commenting and will totally pay you 5 bucks a month for it,&#8217; and another group saying, &#8216;We pay $6,000 a month sending Mailchimp RSS campaigns but yours are better for only $1500. Why so cheap?&#8217; That’s been a frustrating reality and a big lesson in knowing your audience and pricing appropriately.&#8221;</p>\n<h3>Next on Postmatic&#8217;s Roadmap: Epoch 2</h3>\n<p>In July 2015, <a href=\"https://wptavern.com/postmatic-brings-100-realtime-commenting-to-wordpress-with-epoch-plugin\" target=\"_blank\">Postmatic introduced Epoch</a> as a Disqus alternative, offering 100% realtime commenting for WordPress. The plugin submits comments via AJAX so that they appear instantly without refreshing the page. Lemieux and the team have been working on the second version for nearly a year.</p>\n<p>&#8220;Epoch 2 is a huge step forward,&#8221; Lemieux said. &#8220;We built it on top of the REST API and Angular. It’s fast and incredibly light. Commenting isn’t sexy &#8211; I don’t think it will ever be, but comments are great for SEO, community, and for building brands and authority. Comments aren’t going away. In fact, they are vitally important to keeping the web as a place for discourse, conversation, and the sharing of ideas. We need to continue to make them a better experience. Epoch isn’t groundbreaking in its functionality but it does the job of making sure sites of any size can still run native WordPress comments.&#8221;</p>\n<p>Postmatic continues to innovate with native comments, an aspect of WordPress that doesn&#8217;t have as many commercial players as something like forms or e-commerce. Lemieux attributes this underserved area to the poor reputation of previous non-native solutions.</p>\n<p>&#8220;I think it is because of the rise and fall of third party commenting system,&#8221; Lemieux said. &#8220;Early in WordPress history services like Disqus and Livefyre grabbed huge parts of the comment traffic on WordPress sites by offering more features, better speed, and improved moderation tools (with the hidden cost of selling your users down the river). It was certainly a siren song. But most all of them stagnated, violated user trust, or just plain didn’t work well. And commenting got a bad name. Naturally came the trend in disabling comments and, well, now here we are and people are trying to have conversations 140 characters at a time.&#8221;</p>\n<p>Lemieux said the innovation he sees happening outside WordPress makes him believe that comments can overcome their past reputation.</p>\n<p>&#8220;Things are getting better &#8211; and hopefully more folks will begin to innovate,&#8221; Lemieux said. &#8220;Lucky for us other blogging and publishing platforms are innovating and coming up with interesting ideas all the time. Some of them, like <a href=\"https://wordpress.org/plugins/inline-comments/\" target=\"_blank\">inline commenting</a> from Medium, do make their way back over to WordPress. That makes me optimistic.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Jan 2017 15:49:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: Aaron D. Campbell Replaces Nikolay Bachiyski as WordPress’ Security Czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65102\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://wptavern.com/aaron-d-campbell-replaces-nikolay-bachiyski-as-wordpress-security-czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2535:\"<p><a href=\"https://aarondcampbell.com/\">Aaron D. Campbell</a>, WordPress Core Contributor at GoDaddy, is replacing <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a> as WordPress&#8217; Security Czar or WordPress Core Security Team Lead. The role was <a href=\"https://wptavern.com/short-interview-with-nikolay-bachiyski-wordpress-security-czar\">created in 2015</a> to provide more structure and focus around incident responses.</p>\n<p>&#8220;The responsibilities of the position include, organizing the security team and making sure all security concerns and reports get triaged and ultimately fixed, coordinating the security side of releases, and being a point of contact for any security related things that need one,&#8221; Campbell said.</p>\n<p>Matt Mullenweg, co-creator of the WordPress project, <a href=\"https://make.wordpress.org/core/2017/01/09/aaron-campbell-leading-security/\">thanked Bachiyski</a> for being the first to accept the role and putting the foundation in place for future team leads, &#8220;This is also a good time to thank the dozens of volunteers who participate in the security group, and the researchers and reporters who bring issues to our attention,&#8221; he said.</p>\n<p>Campbell says he plans to finish what Bachiyski started by getting WordPress.org onto HackerOne. &#8220;Nikolay did a lot of work around expanding our team as well as getting the foundation laid for moving over to <a href=\"https://hackerone.com/\">HackerOne</a>,&#8221; he said.</p>\n<p>&#8220;We aren&#8217;t quite ready to make the move completely, but I hope to phase out the security@ E-Mail address in favor of HackerOne in the near future.&#8221;</p>\n<p>In late 2016, GoDaddy <a href=\"https://aarondcampbell.com/2016/09/joining-godaddy-as-a-full-time-wordpress-core-contributor/\">hired Campbell</a> to contribute to WordPress core full-time. The company continues to back his involvement in WordPress, &#8220;The role is completely voluntary,&#8221; Campbell said. &#8220;GoDaddy has truly been extremely hands off while funding me to do all this, and I&#8217;m grateful to have that continue.&#8221;</p>\n<p>If you think you&#8217;ve discovered a security vulnerability with the self-hosted version of WordPress, you&#8217;re encouraged to <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsibly disclose</a> it to the security team by emailing security @ wordpress.org and include as much detail as possible.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Jan 2017 23:53:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: Automattic Releases Free Plugin for Exporting Photos from Lightroom to WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65177\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://wptavern.com/automattic-releases-free-plugin-for-exporting-photos-from-lightroom-to-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2493:\"<p>Yesterday Automattic <a href=\"https://en.blog.wordpress.com/2017/01/12/wordpress-com-lightroom/\" target=\"_blank\">released</a> a new free plugin the makes it easy for Lightroom users to export their photos to WordPress. <a href=\"http://www.adobe.com/products/photoshop-lightroom.html\" target=\"_blank\">Lightroom</a> is an Adobe product for managing and editing photos, and the plugin works with the software on MacOS and Windows. It is compatible with both WordPress.com and Jetpack-powered sites.</p>\n<p>The <a href=\"https://apps.wordpress.com/lightroom/\" target=\"_blank\">Lightroom plugin</a> requires a WordPress.com account to install. Users can then select photos in Lightroom and export them to a WordPress site with all the standard settings available, such as image resizing, watermarking, output sharpening, and more. The plugin automatically exports titles and captions. A large number of photos can take awhile to export, but once the upload is finished users can find their images in the WordPress media library.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/wp-lightroom.png?ssl=1\"><img /></a></p>\n<p>When asked for tips on suggested upload size and compression, Automattic representative John Godley said, &#8220;WordPress.com can handle pretty much anything you throw at it! I personally go for a high quality and large size so it looks good on a HiDPI screen, and then let WordPress resize as necessary to fit the viewers device.&#8221;</p>\n<p>It&#8217;s not yet clear how the release of Automattic&#8217;s free plugin will affect the commercial products that exist for a similar purpose. <a href=\"https://flothemes.com/flo-plugins/\" target=\"_blank\">FloLight</a>, <a href=\"https://meowapps.com/wplr-sync/buy/\" target=\"_blank\">WPLR Sync</a>, and other solutions will need to offer more features with a quicker setup if they want to compete with the new free Lightroom plugin.</p>\n<p>Those who want to use the plugin must already have a Lightroom license (standalone or subscription). Although this is a relatively small subset of overall WordPress users, it saves a great deal of time for photobloggers and those who process a large number of photos with Lightroom before posting online. For most, this <a href=\"https://apps.wordpress.com/lightroom/\" target=\"_blank\">plugin</a> simplifies what was previously a tedious, multi-step process of manually uploading the photos after working with them in Lightroom.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Jan 2017 00:13:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Wes Bos Launches JavaScript30, a Free 30-Day Vanilla JS Coding Course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65209\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/wes-bos-launches-javascript30-a-free-30-day-vanilla-js-coding-course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2601:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/javascript30.png?ssl=1\"><img /></a></p>\n<p>For those who failed to &#8220;learn JavaScript deeply&#8221; last year, 2017 offers a clean slate for restarting your JavaScript learning goals. <a href=\"http://wesbos.com/\" target=\"_blank\">Wes Bos</a>, a developer and educator known for his high quality video tutorials, recently launched a free 30-day vanilla JS coding challenge course that provides structure for developing a new habit of daily learning.</p>\n<p><a href=\"https://javascript30.com/\" target=\"_blank\">JavaScript30</a> walks users through building 30 things in 30 days with no frameworks, no compilers, no libraries, and no boilerplate. The course is suitable for beginner to intermediate developers and designers who want to get a solid grasp of JavaScript fundamentals. It purposely steers clear of abstractions like frameworks to help students gain a better understanding of browser APIs while working in the DOM without a library.</p>\n<p>Bos designed the course to help students gain competence through building things, the advice he gives to anyone wanting to improve their JavaScript skills.</p>\n<p>&#8220;So, you&#8217;ve done a few courses and read a few books but still don&#8217;t feel great about your relationship with JavaScript,&#8221; Bos said. &#8220;How do you get better? Build things. Lots of things. Build 1,000 things. Keep it up and don&#8217;t stop.&#8221; The course is packed full of quick, interesting, and practical projects.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/javascript30-lessons.png?ssl=1\"><img /></a></p>\n<p>JavaScript30 includes access to 30 videos, 30 days of starter files, and completed HTML, CSS, and JS Solutions for each day. The videos are accessible and ESL-friendly with closed captions provided.</p>\n<p>Bos said he spent more than 300 hours creating the videos as a thank-you to those who have supported his paid courses.</p>\n<p>&#8220;I see a huge need for these videos and I really think it will help many&#8230;become comfortable creating with JavaScript,&#8221; he said.</p>\n<p>Bos is also the author of the free <a href=\"https://wptavern.com/wes-bos-launches-free-react-js-redux-online-course\" target=\"_blank\">Learn Redux</a> course, which includes 2.5 hours of videos that help students get started with React.js, Redux, and React Router. Some of his other popular <a href=\"http://wesbos.com/courses/\" target=\"_blank\">courses</a> include React for Beginners, Learn Redux, and ES6 for Everyone.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Jan 2017 22:05:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: WPWeekly Episode 259 – 2016 Year in Review Part 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=65198&preview=true&preview_id=65198\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/wpweekly-episode-259-2016-year-in-review-part-2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1040:\"<p>In this episode, <a href=\"http://www.marcuscouch.com/\">Marcus Couch</a> and I recap the news that made headlines during the second half of 2016. I explain why there wasn&#8217;t a show last week and we close out the episode with our predictions for 2017. We&#8217;ll be back to our regular show format on Wednesday, January 18th.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, January 18th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #259:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Jan 2017 09:37:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: 2nd Edition of Producing Open Source Software Now Available for Free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65181\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/2nd-edition-of-producing-open-source-software-now-available-for-free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3579:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/producing-oss.png?ssl=1\"><img /></a></p>\n<p>The second edition of <a href=\"http://www.red-bean.com/kfogel/\" target=\"_blank\">Karl Fogel</a>&#8216;s &#8220;Producing Open Source Software: How to Run a Successful Free Software Project&#8221; is now available for download. Fogel, a partner at <a href=\"https://opentechstrategies.com/\" target=\"_blank\">Open Tech Strategies</a> and OSS contributor since 1997, was a founding developer in the Subversion project. He has worked for more than a decade as an open source specialist, helping businesses and organizations evaluate, launch, and manage open source projects.</p>\n<p><a href=\"http://producingoss.com/\" target=\"_blank\">Producing Open Source Software</a> version 2 was released for free this week under the Attribution-ShareAlike 4.0 International license. The first edition was published in 2005 but the landscape of OSS has changed drastically over the past 12 years. In 2013, Fogel <a href=\"https://www.kickstarter.com/projects/kfogel/updating-producing-open-source-software-for-2nd-ed/description\" target=\"_blank\">successfully raised $15,376</a> towards his $10,000 Kickstarter goal to fund the revision.</p>\n<p>The book includes topics like &#8216;Free&#8217; Versus &#8216;Open Source,&#8217; choosing a license, version control, social and political infrastructure, the economics of open source, culture, and communication. It was written for managers and software developers but can also be informative for newcomers to open source projects.</p>\n<p>Fogel originally planned on finishing the second edition by the end of 2013 but experienced delays due to starting his company. Some chapters also took longer to revise than he anticipated.</p>\n<p>&#8220;In retrospect, if I had understood what the pressures of a young and growing company would be, I would not have started the 2nd edition when I did,&#8221; Fogel said. &#8220;It has been a lesson.&#8221; Fortunately, for the 314 Kickstarter backers  who might have been waiting on his work for four years, progress was immediately available in the public repository for the book. Fogel didn&#8217;t keep any private version of the book elsewhere.</p>\n<p>&#8220;While there are substantial changes throughout the book, the most expanded chapter is probably Chapter 5, &#8216;Participating as a Business, Non-Profit, or Government Agency,\'&#8221; Fogel said. &#8220;That chapter&#8217;s title used to be just &#8216;Money,&#8217; so that gives you some idea of what the new material is.&#8221;</p>\n<p>He also found the third chapter on technical infrastructure to be more time consuming than the others due to all of the changes in the past decade. It took roughly four and a half months to revise it to include modern development tools.</p>\n<p>One of the central focuses of the book is the value of collaboration and the direct benefits it provides to an open source software project.</p>\n<p>&#8220;Competence at cooperation itself is one of the most highly valued skills in free software,&#8221; Fogel wrote in the preface. &#8220;Good free software is a worthy goal in itself&#8230; But beyond that I also hope to convey something of the sheer pleasure to be had from working with a motivated team of open source developers, and from interacting with users in the wonderfully direct way that open source encourages. Participating in a successful free software project is a deep pleasure, and ultimately that&#8217;s what keeps the whole system going.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 23:13:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"Post Status: New Year’s resolutions for WordPress developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=32188\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://poststatus.com/new-years-resolutions-wordpress-developers/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15739:\"<p><em><strong>Editor&#8217;s Note:</strong></em> This is a guest post by <a href=\"https://poststatus.com/profiles/jack-lenox/\">Jack Lenox</a>. Jack is a developer at Automattic and hails from the United Kingdom.</p>\n<p>For just over a year now, I have been working on the <a href=\"https://vip.wordpress.com/\">WordPress.com VIP</a> team at Automattic. I had been working at Automattic for the two years prior to this – and had been developing sites with PHP and WordPress for almost ten years prior to that. So you might imagine that I had a pretty good handle on developing stuff with WordPress.</p>\n<p>And you would be wrong. Getting started with the VIP team was an eye-opening and occasionally terrifying learning experience, occasionally resulting in me thinking: &#8220;please excuse me for a moment while I go and fix some horrible vulnerability in all of my WordPress sites.&#8221;</p>\n<p>Recently, I have cautiously found myself feeling slightly more comfortable with my position on the team. For some time, I have been wanting to document the most interesting and impactful things that I have learned in the past year.</p>\n<p>As some readers may know, a significant part of a developer&#8217;s job on the VIP team is reviewing code. Thus, with us being at the start a new year, I have hereby compiled some of the most interesting best practices I have discovered as a list of New Year&#8217;s Resolutions:</p>\n<h3>1. Use strict comparison operators</h3>\n<p>One of the many quirks of PHP is that it enjoys juggling. In particular, it enjoys <a href=\"http://php.net/manual/en/language.types.type-juggling.php\">juggling types</a>. This means that without explicit instruction, PHP doesn&#8217;t see a difference between a string of &#8220;string&#8221;, an integer of 0, and a boolean value of <code>true</code>.</p>\n<p>So for example this:</p>\n<pre><code>$var = 0;\nif ( $var == \'safe_string\' ) {\n    return true;\n}\n</code></pre>\n<p>Will return true. I know, what?! The easy solution here is to simply use strict comparison operators.</p>\n<p>So that&#8217;s <code>===</code> instead of <code>==</code>, and <code>!==</code> instead of <code>!=</code>. This pops up in a few other places too. By default the <a href=\"http://php.net/manual/en/function.in-array.php\"><code>in_array()</code></a> function has its strict parameter set to false.</p>\n<p>So:</p>\n<pre><code>in_array( 0, [\'safe_value\', \'another string\'] );\n</code></pre>\n<p>Will return true. To fix this, simply pass a third parameter of <code>true</code>.</p>\n<p>While we&#8217;re here, there&#8217;s one other form of comparison we should be aware of, and that&#8217;s <a href=\"http://php.net/manual/en/function.hash-equals.php\"><code>hash_equals()</code></a>. This provides a string comparison that prevents timing attacks.</p>\n<p>While a relatively uncommon form of attack on the web, it&#8217;s worth being aware of a timing attack. What is it? Well, when PHP compares two strings, it compares them one character at a time.</p>\n<p>So in the case of something like this:</p>\n<pre><code>$submitted_password = $_POST[\'password\']; // For argument\'s sake, let\'s say it\'s \"pa45word\"\n$password = \"pa55word\";\n\nif ( $submitted password === $password ) {\n    go_forth();\n}\n</code></pre>\n<p>PHP&#8217;s thought process in human terms is: Is the first character of each string p? Yes it is. Is the second character of each string a? Yes it is. And so on.</p>\n<p>It will do this until it realizes that the third characters differ and at that point it will bail. Thus, with sophisticated timing software, a password can gradually be worked out by calculating how long the process is taking. If the process takes slightly longer with one character than it does with every other character, an attacker will know that they have worked out the first character.</p>\n<p>Automated processes can keep doing this until the entire password is worked out. <code>hash_equals()</code> will compare two values, but will not bail early if it detects a difference.</p>\n<p>In conclusion, if you&#8217;re comparing sensitive values, use <code>hash_equals()</code>!</p>\n<h3>2. Use Yoda condition checks, you must</h3>\n<p>The <a href=\"https://make.wordpress.org/core/handbook/best-practices/coding-standards/php/#yoda-conditions\">WordPress PHP Coding Standards</a> suggest that you should: &#8220;always put the variable on the right side and put constants, literals or function calls on the left side.&#8221; Initially, this might just sound like a bit of pedantry, but it actually has a very practical application.</p>\n<p>Consider how catastrophic the following typo could be:</p>\n<pre><code>if ( $session_authorized = true ) {\n    unleash_the_secrets();\n}\n</code></pre>\n<p>Oh dear, instead of checking that <code>$session_authorized</code> is true, I am instead assigning the value of true to that variable.</p>\n<p>Now the secrets are being unleashed to whoever wants them. This could easily be missed when checking the code for bugs, even by a reviewer.</p>\n<p>Now imagine if the first line was expressed as:</p>\n<pre><code>if ( true = $session_authorized ) {\n</code></pre>\n<p>Well, it doesn&#8217;t. We can&#8217;t assign a variable to the static boolean value of <code>true</code>.</p>\n<p>Hopefully it won&#8217;t take us too long to work out why our code is still broken, but the secrets remain safe. So we&#8217;re good! <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f600.png\" alt=\"😀\" class=\"wp-smiley\" /></p>\n<h3>3. ABE. A Always, B Be, E Escaping. Always Be Escaping. ALWAYS Be Escaping.</h3>\n<p>Not having a firm grasp of the concepts of validation, sanitization and escaping can make you a very dangerous developer indeed.</p>\n<p>To the extent that libraries like React escape all output by default and to bypass this functionality, you have to use the attribute: <code>dangerouslySetInnerHTML</code></p>\n<p>Validation is checking that what your code is being passed is even vaguely what it&#8217;s expecting. So for instance, if we&#8217;re expecting an integer, we can use something like: <code>$zipcode = intval( $_POST[\'my-zipcode\'] )</code></p>\n<p>The <code>intval()</code> function returns its input as an integer and defaults to zero if the input was a non-numeric value. So while this won&#8217;t prevent our code from being passed zipcodes that aren&#8217;t valid, it does protect our code from being passed anything that isn&#8217;t a number.</p>\n<p>Naturally, we could go a step further to see if the zipcode actually appears to be valid. For example, 1111111111111 is not a valid zip code, but <code>intval()</code> doesn&#8217;t know that.</p>\n<p>Fortunately, beyond integers, WordPress has <a href=\"https://codex.wordpress.org/Data_Validation#Input_Validation\">a bunch of handy helper functions for almost every data type</a> including my favourite: <code>is_email().</code></p>\n<p>Sanitization is cleaning input to make sure that it&#8217;s safe in the context where we want to use it. This prevents one of the most common forms of security vulnerability, an <a href=\"https://www.owasp.org/index.php/SQL_injection\">SQL injection attack</a>.</p>\n<p>We also sanitize to fix practical things, like checking for invalid UTF-8 characters. WordPress has a class of <a href=\"https://codex.wordpress.org/Data_Validation#Input_Validation\"><code>sanitize_*()</code> helper functions</a>; here&#8217;s an example of how one looks in the wild:</p>\n<pre><code>$title = sanitize_text_field( $_POST[\'title\'] );\nupdate_post_meta( $post-&gt;ID, \'title\', $title );\n</code></pre>\n<p>Therefore no matter what garbage we might have been passed in <code>$_POST[\'title\']</code>, it won&#8217;t cause any real problems.</p>\n<p>Escaping is similar to sanitization, but instead it is cleaning what we&#8217;re sending out, rather than what we&#8217;re taking in. A major reason for doing this is to prevent another of the most common forms of security vulnerability, a <a href=\"https://www.owasp.org/index.php/XSS\">Cross-site Scripting (or XSS) attack</a>.</p>\n<p>We want to clean our output to ensure we aren&#8217;t accidentally echoing out something very dangerous that we didn&#8217;t realize we were inadvertently storing in our database (or perhaps fetched from an API).</p>\n<p>WordPress has <a href=\"https://codex.wordpress.org/Data_Validation#Output_Sanitization\">a bunch of very useful helper functions here</a>. Some common examples of these in the wild are:</p>\n<pre><code>&lt;h4&gt;&lt;?php echo esc_html( $title ); ?&gt;&lt;/h4&gt;\n</code></pre>\n<pre><code>&lt;img alt=\"\" src=\"&lt;?php echo esc_url( $great_user_picture_url ); ?&gt;\" /&gt;\n</code></pre>\n<pre><code>&lt;ul class=\"&lt;?php echo esc_attr( $stored_class ); ?&gt;\"&gt;\n</code></pre>\n<p>There is also <a href=\"https://developer.wordpress.org/reference/functions/wp_kses/\"><code>wp_kses()</code></a> which can be used on everything that is expected to contain HTML, and will filter out elements that are not explicitly allowed.</p>\n<p>As a general rule, the <code>the_*()</code> and <code>get_the_*()</code> theme functions are already escaped. However, the <code>get_bloginfo()</code> function, for example, is not escaped.</p>\n<p>For further information here, I highly recommend checking out the VIP team&#8217;s documentation on <a href=\"https://vip.wordpress.com/documentation/vip/best-practices/security/validating-sanitizing-escaping/\">Validating, Sanitizing, and Escaping</a>.</p>\n<h3>4. Stop trusting everything</h3>\n<p>Don&#8217;t trust user input. Don&#8217;t trust what&#8217;s in your database. Don&#8217;t trust any variables.</p>\n<p>Treat every variable with contempt.</p>\n<p>This way, even if, for example, someone sneaks some dodgy XSS code into your database, it&#8217;ll still get escaped on output and your site will be better protected.</p>\n<h3>5. Avoid inserting HTML directly into the document (when using JavaScript)</h3>\n<p>Doing something like this is dangerous because the data that we&#8217;re using could include many more DOM elements that dramatically alter the anticipated behavior of this code, and make it vulnerable to XSS attacks:</p>\n<pre><code>jQuery.ajax({\n    url: \'http://any-site.com/endpoint.json\'\n}).done( function( data ) {\n    var link = \'&lt;a href=\"\' + data.url + \'\"&gt;\' + data.title + \'&lt;/a&gt;\';\n\njQuery( \'#my-div\' ).html( link );\n});\n</code></pre>\n<p>Instead, we should programmatically create DOM nodes and append them to the DOM. So the above instead becomes this:</p>\n<pre><code>jQuery.ajax({\n    url: \'http://any-site.com/endpoint.json\'\n}).done( function( data ) {\n    var a = jQuery( \'&lt;a /&gt;\' );\n    a.attr( \'href\', data.url );\n    a.text( data.title );\n\njQuery( \'#my-div\' ).append( a );\n});\n</code></pre>\n<p>This is how a library like React does things behind the scenes. You can read more about this in <a href=\"https://vip.wordpress.com/2015/03/25/preventing-xss-in-javascript/\">a wonderful post about preventing XSS attacks in JavaScript</a> by my colleague, Nick Daugherty.</p>\n<h3>6. Review code</h3>\n<p>Have you ever reviewed a plugin before using it? I know, who&#8217;s got time for that right? I&#8217;ll tell you who: you.</p>\n<p>I have come to realize that reviewing code is possibly one of the best exercises for improving as a developer. Even if you&#8217;re quite new to programming or development, and you still feel pretty green, you really should give it a go.</p>\n<p>A great way to start is to review the next plugin you decide to use on your website. Before activating it, pop it open in your text editor of choice, and just spend some time scanning through it to understand what it does.</p>\n<p>A method I like to use here is to interpret each line of the code in simple English. You can even say it loud if you like – assuming you&#8217;re not sitting in a café or co-working space where people might become worried about you.</p>\n<p>You might be surprised at how often you find bugs and quirks in the code, or that the code isn&#8217;t conforming to the best practices outlined above. And if you discover issues, why not create a patch? Or if the plugin is on GitHub, create a pull request.</p>\n<p>You can also review your own code. A great method for doing this is to never deploy code straight into production. Instead, leave it on the day you finish it, and review it line by line in the morning. This method is easiest to adopt if you&#8217;re using something like GitHub where you can create a pull request with the changes, then review the pull request yourself the next day before merging it.</p>\n<p>In this vein, I highly recommend watching my colleague, Ryan Markel&#8217;s, <a href=\"http://wordpress.tv/2016/12/10/ryan-markel-code-review-keeping-things-secure-clean-and-performant/\">fantastic talk on this topic from WordCamp US 2016</a>.</p>\n<h3>7. Upgrade your tools (or at least use PHP_CodeSniffer)</h3>\n<p>There are lots of tools that help make web development easier, but if you&#8217;re doing a lot of WordPress development, the most valuable is probably <a href=\"https://github.com/squizlabs/PHP_CodeSniffer\">PHP<em>CodeSniffer</em></a>. It reads your code and automatically reviews it for bugs and coding standards inconsistencies while you type.</p>\n<p>It&#8217;s kind of like a spell checker, but for code. No matter how good your English is, you still use spell check right? So why wouldn&#8217;t you spell check your code?</p>\n<p>Here&#8217;s a bonus for you: the WordPress VIP Coding Standards are available by default with the <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards\">WordPress Coding Standards for PHPCodeSniffer</a>. So with that, it&#8217;ll check if you&#8217;re following most of the above resolutions.</p>\n<p>As you might imagine, using PHP_CodeSniffer also really helps highlight potential problems when you&#8217;re reviewing plugins and other people&#8217;s code.</p>\n<h3>8. Be curious</h3>\n<p>Far too often, I&#8217;m guilty of searching to try to find out what a particular WordPress function does, or scanning Stack Overflow to see if someone&#8217;s having the same problem as me.</p>\n<p>I have historically had a bad habit of seeing much of what WordPress does as magic, and avoiding getting too deep in the inner workings. But actually, it can be very beneficial to find out answers for yourself, instead of trying to find others who have already done the work.</p>\n<p>In essence, WordPress is quite simple. The code largely consists of functions taking arguments, and doing things with those arguments, and passing the results onto other functions taking arguments, and so on.</p>\n<p>It doesn&#8217;t take much to start unpicking something, and working out exactly what&#8217;s happening behind the scenes. So next time you&#8217;re struggling with a function, try going straight to looking at what the function actually does.</p>\n<p>Personally I find the <a href=\"https://github.com/wordpress/wordpress\">WordPress GitHub repo</a> that mirrors the core SVN repo to be a very useful way of doing this.</p>\n<p>The WordPress strapline is that &#8220;code is poetry&#8221;, and for its flaws I find that on the most part, the WordPress codebase is very readable, if nothing else! <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" /></p>\n<p>I&#8217;ll conclude by taking this opportunity to wish you a very happy and prosperous new year!</p>\n<p><strong><em>Note</em>:</strong> Some of the above has been gleefully plagiarized from <a href=\"https://vip.wordpress.com/documentation/vip/code-review-what-we-look-for/\">WordPress.com VIP&#8217;s Code Review documentation</a>. It&#8217;s an Aladdin&#8217;s cave of useful advice, and I highly recommend working your way through it as and when you can.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 21:26:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Jack Lenox\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"WPTavern: Tom McFarlin to Launch Marketplace for Blogging Plugins, Finds New Maintainer for WordPress.org Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64899\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"https://wptavern.com/tom-mcfarlin-to-launch-marketplace-for-blogging-plugins-finds-new-maintainer-for-wordpress-org-plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5189:\"<p>Daily blogger and plugin author Tom McFarlin has found a new maintainer for five of his WordPress.org plugins. Within two days of <a href=\"https://tommcfarlin.com/wordpress-plugin-adoption/\" target=\"_blank\">putting the plugins up for adoption</a>, McFarlin <a href=\"https://tommcfarlin.com/wordpress-plugins-adopted/\" target=\"_blank\">announced</a> that <a href=\"https://twitter.com/philip_arthur\" target=\"_blank\">Philip Arthur Moore</a> will be taking over Category Sticky Post, Comment Tweets, Single Post Message, Tag Sticky Post, and Tipsy Social Icons. Moore, who is currently working as CTO at <a href=\"https://professionalthemes.nyc/\" target=\"_blank\">Professional Themes</a>, has inherited roughly 10,000 users overnight in the transfer of maintainership.</p>\n<p>WordPress.org plugin adoption stories are few and far between. The most common scenario for an orphaned plugin is to languish in the directory until it disappears from search results (with the exception of exact matches) after two years of no updates. In McFarlin&#8217;s case, he was looking to tie up some loose ends before shifting Pressware&#8217;s focus to launching Blogging Plugins, a marketplace for extensions that streamline WordPress for regular bloggers.</p>\n<p>&#8220;Last year, I had a few false starts when trying to launch what was originally called Pressware Plugins,&#8221; McFarlin said. &#8220;Fast-forward a few months and we’re going to focus on something called Blogging Plugins. We already have two free plugins available, though there’s an entire set of plugins, marketplace, and more coming.&#8221;</p>\n<p>Moore&#8217;s adoption of the plugins, which includes the first plugin McFarlin ever wrote, allows Pressware to move forward with its <a href=\"https://tommcfarlin.com/2017-plans/\" target=\"_blank\">2017 objectives</a>. McFarlin said he selected Moore based on the quality of his open source projects and reputation in the WordPress community.</p>\n<p>&#8220;For those of you who aren’t familiar with Philip’s side projects, you may be familiar with <a href=\"https://wordpress.org/plugins/subtitles/\" target=\"_blank\">Subtitles</a>,&#8221; McFarlin said. &#8220;It’s a plugin that falls right in line with my personal ethos of how things should work with WordPress: You activate it, it’s ready to go, and it feels native within the application.&#8221;</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Why would I adopt <a href=\"https://twitter.com/tommcfarlin\">@tommcfarlin</a>\'s work? Because I owe him. He\'s ethical, an amazing man, and a stellar coder: <a href=\"https://t.co/WM66Xu1vm1\">https://t.co/WM66Xu1vm1</a></p>\n<p>&mdash; Philip Arthur Moore (@philip_arthur) <a href=\"https://twitter.com/philip_arthur/status/817399604698173440\">January 6, 2017</a></p></blockquote>\n<p></p>\n<p>The <a href=\"https://wordpress.org/plugins/tags/adopt-me\" target=\"_blank\">adopt-me</a> tag is used on WordPress.org to indicate plugins where the author is looking for a new maintainer. With just two pages of listings, it&#8217;s not yet widely used. Most developers find it easier to fork an open source plugin and WordPress.org has recently made it easier than ever for authors to <a href=\"https://make.wordpress.org/plugins/2016/12/22/want-to-close-your-plugins-email/\" target=\"_blank\">close a plugin</a> by simply emailing the plugin team.</p>\n<p>However, not all orphaned plugins are ready for end of life measures. Circumstances change in plugin authors&#8217; lives, but the strength of the user base is one of the primary indicators of a project that could thrive in new hands. The built-in user base is also one of the main advantages of adopting a plugin as opposed to forking it.</p>\n<p>Developer and ZDNet columnist David Gewirtz discovered the full weight of adopting a plugin&#8217;s users when he <a href=\"http://www.zdnet.com/article/a-year-later-what-happens-when-you-adopt-an-open-source-project/\" target=\"_blank\">took on 10 plugins</a> from the adopt-me section of the directory. Gewirtz, who inherited approximately 50,000 users, said the experience helped him reconnect with real users.</p>\n<p>&#8220;The value I&#8217;ve gained as a columnist, advisor, and educator that has come from interacting with users from so many nations with so many different skill sets and missions has been off the charts,&#8221; Gewirtz said. &#8220;I thought I&#8217;d keep my programming chops up, and I&#8217;ve certainly done that. But I never expected I&#8217;d gain a much broader perspective that I&#8217;d be able to apply to all of the areas of my professional life and meet so many cool people.&#8221;</p>\n<p>Adoption is arguably the healthiest outcome for any orphaned project &#8211; not just for the sake of reducing plugin abandonment but also for continuing support for users. Many of them blindly depend on plugins with no understanding of how they work.</p>\n<p>Once a plugin is downloaded and installed on users&#8217; sites, it gains a life of its own. Adoption strengthens a project&#8217;s history by proving it can weather storms that might otherwise cause the plugin to become obsolete and wipe out the user base.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 07:59:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Thirty-Three\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47034\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2017/01/thirty-three/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4279:\"<p>I&#8217;m taking it easy this week, nothing too crazy &#8212; just sharing good meals and wine with friends. Which is probably a good example of my goals for the year: putting family and loved ones first, slowing down (<a href=\"https://ma.tt/2014/10/run-better/\">to go further</a>), and deliciousness. (<a href=\"https://www.singlethreadfarms.com/\">Single Thread Farms</a> blew me away.)</p>\n<p>2016 was a year of incredible contrasts: it was the saddest and most challenged I&#8217;ve ever been with the <a href=\"https://ma.tt/2016/04/in-memoriam-chuck-mullenweg/\">passing of my father</a>, and while that overshadowed everything there were also bright moments of coming closer to family, deepening friendships, and growing professionally with incredible progress from both WordPress and Automattic. That momentum on the professional side is carrying through and right now I&#8217;m the most optimistic I can recall, and thrilled to wake up and get to work every day with the people I do.</p>\n<p>I talked about trying to spend longer stretches of time in fewer places, and that definitely happened. I flew 162k fewer miles than <a href=\"https://ma.tt/2016/01/thirty-two/\">the year before</a>, and visited 35 fewer cities. My blogging decreased a lot too &#8212; from 252 posts in 2015 to 76 posts in 2016, but the posts I did write were at least 50% longer. I made it to 9 more of the Top 50 restaurants and stand currently at 50% of <a href=\"http://www.theworlds50best.com/list/1-50-winners\">the list</a>. I finished <a href=\"https://www.pinterest.com/saxmatt/books-in-2016/\">22 books</a>, including a lot more fiction including my first few graphic novels like Ex Machina, Y: The Last Man, and Watchmen. I watched 35 movies, 9 of which were from the Marvel universe on a single flight from Cape Town to Dubai.</p>\n<p><a href=\"https://ma.tt/2016/01/thirty-two/\">Last year</a> I said, &#8220;it’s exciting to make the most of the opportunity that the volatility, love, loss, glory, failure, inspirations, and setbacks that 2016 will bring.&#8221; I didn&#8217;t know how right I would be, and wish I hadn&#8217;t been.</p>\n<p>This year doesn&#8217;t start with new plans, but rather three intentions continued from a few months ago. I <a href=\"https://ma.tt/2017/01/rebirth-and-yellow-arrows/\">revealed one yesterday</a>, and promised I would expand today on the others, so here they are:</p>\n<ol>\n<li><strong>Symmetry</strong> &#8212; Balance in all things, including my body which is stronger on my right side and much tighter on my left side. We also need symmetry in WordPress between the .org and .com products which differ too much.</li>\n<li><strong>Stillness</strong> &#8212; In echoes <a href=\"https://www.amazon.com/Art-Stillness-Adventures-Going-Nowhere-ebook/dp/B00JSRQSJS\">of Pico Iyer</a>, so much of my life in my 20s was about movement, and &#8220;going places to be moved.&#8221; In my 30s I&#8217;m looking inward. As Saint Augustine said in Book X, chapter 8 of <em>Confessions</em>: &#8220;Men go forth to wonder at the heights of mountains, the huge waves of the sea, the broad flow of the rivers, the vast compass of the ocean, the courses of the stars, and they pass by themselves without wondering.&#8221;</li>\n<li><strong>Yellow Arrows</strong> &#8212; The idea that there are clear indications of where to go next at every fork in the road, and if not you should paint them. I wrote more <a href=\"https://ma.tt/2017/01/rebirth-and-yellow-arrows/\">on this  yesterday</a>.</li>\n</ol>\n<p>Previously: <a href=\"https://ma.tt/2003/01/bday/\">19</a>, <a href=\"https://ma.tt/2004/01/so-im-20/\">20</a>, <a href=\"https://ma.tt/2005/01/hot-barely-legal-matt/\">21</a>, <a href=\"https://ma.tt/2006/01/matt-22/\">22</a>, <a href=\"https://ma.tt/2007/01/twenty-three/\">23</a>, <a href=\"https://ma.tt/2008/01/twenty-four/\">24</a>, <a href=\"https://ma.tt/2009/01/twenty-five/\">25</a>, <a href=\"https://ma.tt/2010/01/twenty-six/\">26</a>, <a href=\"https://ma.tt/2011/01/twenty-seven/\">27</a>, <a href=\"https://ma.tt/2012/01/twenty-eight/\">28</a>, <a href=\"https://ma.tt/2013/01/twenty-nine/\">29</a>, <a href=\"https://ma.tt/2014/01/matt-3-0/\">30</a>, <a href=\"https://ma.tt/2015/01/thirty-one/\">31</a>, and <a href=\"https://ma.tt/2016/01/thirty-two/\">32</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 07:59:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: WordPress 4.7.1 Fixes Eight Security Issues\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65100\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wptavern.com/wordpress-4-7-1-fixes-eight-security-issues\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2146:\"<p>WordPress 4.7.1 <a href=\"https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\">is available</a> for download and fixes eight security issues that affect WordPress 4.7 and below. The PHPMailer library was updated to patch a remote code execution (RCE) vulnerability. WordFence <a href=\"https://www.wordfence.com/blog/2016/12/phpmailer-vulnerability/\">reported the vulnerability</a> last month as critical and that it affects WordPress core.</p>\n<p>However, in the announcement post for 4.7.1, Aaron Campbell, WordPress&#8217; <a href=\"https://make.wordpress.org/core/2017/01/09/aaron-campbell-leading-security/\">new Security Czar</a> says that, &#8220;No specific issue appears to affect WordPress or any of the major plugins we investigated but, out of an abundance of caution, we updated PHPMailer in this release.&#8221; <a href=\"https://legalhackers.com/\">Dawid Golunski</a> and <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a> are credited with <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsibly disclosing</a> the vulnerability.</p>\n<p>WordPress 4.7.1 also fixes an issue where the REST API exposed user data for all users who authored a post of a public post type. This release limits this ability to only post types which have specified that they should be shown within the API. <a href=\"https://poststatus.com/\">Brian Krogsgard</a> and <a href=\"https://ithemes.com/\">Chris Jean</a> are credited with <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsibly disclosing</a> the vulnerability.</p>\n<p>In addition to patching eight security issues, this release fixes 62 bugs. To see a full list of changes, visit the <a href=\"https://codex.wordpress.org/Version_4.7.1\">release notes</a> page or you can <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">view them on Trac</a>. Sites should update automatically but if you&#8217;d like to update sooner, visit your site&#8217;s Dashboard, select Updates, and click the Update Now button.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 23:19:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: Facebook Launches Journalism Project, Plans to Expand Monetization of Instant Articles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65121\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://wptavern.com/facebook-launches-journalism-project-plans-to-expand-monetization-of-instant-articles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3423:\"<p>After taking heat for the proliferation of &#8220;fake news&#8221; and misinformation on its platform during the US presidential election, Facebook is aiming to strengthen its ties with the news industry.</p>\n<p>&#8220;We care a great deal about making sure that a healthy news ecosystem and journalism can thrive,&#8221; Facebook director of product Fidji Simo said in the <a href=\"https://media.fb.com/2017/01/11/facebook-journalism-project/\" target=\"_blank\">announcement</a> today.</p>\n<p>The new <a href=\"https://www.facebook.com/facebookmedia/get-started/facebook-journalism-project\" target=\"_blank\">Facebook Journalism Project</a> will focus on creating news products with feedback from publishers, providing training and tools for journalists, and promoting news literacy for the public.</p>\n<p>In 2015 Facebook launched Instant Articles to deliver publishers&#8217; content instantly in exchange for advertising revenue. The platform will be expanding the feature to combine multiple Instant Articles in one post, starting January 12, 2017.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/facebook-multiple-instant-articles.png?ssl=1\"><img /></a>image credit: <a href=\"https://media.fb.com/2017/01/11/multiple-instant-articles/\">Facebook</a>\n<p>&#8220;We’ve heard from editors that they want to be able to present packages of stories to their most engaged readers on Facebook,&#8221; Simo said. &#8220;We’re starting to work with several partners on how best to do this. We’re going to start testing this using Instant Articles, so that readers can start to see <a href=\"https://media.fb.com/2017/01/11/multiple-instant-articles/\" target=\"_blank\">multiple stories</a> at a time from their favorite news organizations.&#8221; Facebook is currently testing this feature with BILD, BuzzFeed, El Pais, Fox News, Hindustan Times, The Sun, The Washington Post, and other publishers.</p>\n<p>In April 2016, Automattic partnered with Facebook and VIP-Featured-Partner agency Dekode to develop <a href=\"https://wordpress.org/plugins/fb-instant-articles/\" target=\"_blank\">Instant Articles for WP</a>, a plugin that outputs a compliant feed of posts wrapped in the required markup for Facebook. The plugin passed 10K active installs at the end of 2016, but its star rating continues to plummet due to numerous errors with updates and a lack of support. Only 1 of 42 support threads has been marked resolved in the last two months. Publishers who depend on the plugin may need to have a developer on staff to handle issues with the plugin or select another solution.</p>\n<p>Facebook is also planning to collaborate with publishers on subscription business models for their content. Participation in this feature will require the publisher to make its content available through Instant Articles.</p>\n<p>&#8220;Many of our partners have placed a renewed emphasis on growing their subscription funnel, and we’ve already begun exploring ways we can support these efforts,&#8221; Simo said. &#8220;This month our engineering team in collaboration with the engineering team of the German news organization BILD will launch a test to explore offering free trials to engaged readers, right from within Instant Articles.&#8221; Simo also said they are working on other monetization options for publishing partners, including advertising breaks in regular videos.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 21:49:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"HeroPress: Blogging, Solopreneurship, &amp; Terrorism\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1563\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://heropress.com/essays/blogging-solopreneurship-terrorism/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13067:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/01/011117-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: We will survive this, and this too will pass. You have my word.\" /><p>This story involves me as a blogger, the Prime Minister, me again as a web developer, an Islamic cult attempting a coup d&#8217;état, and me again as a solopreneur. Oh, and WordPress. And ISIS.</p>\n<h2>WordPress: My First Encounter</h2>\n<p>In the beginning of 2006, everyone in Turkey was talking about blogs. It was the hot new thing on the web. Forums were &#8220;out&#8221; and blogs were &#8220;in&#8221;. Anyways, I was getting ready for the ÖSS and studying to get into a university but I was psyched enough to register a blog on WordPress.com, on January 2006. (I moved the blog into a free hosting space the next month, and opened up <a href=\"http://beyn.org\">beyn.org</a> in July 2006.) I was in Kocaeli, the city right next to İstanbul.</p>\n<p>After the registration, I realized that I had nothing to write about. So I wrote about the day I had. The next day, I did the same thing. And the next day. And the next seven and a half years. Of course, I skipped four or five days. But that kind of dedication earned me a reputation and an award for &#8220;Best Personal Blogger of 2008&#8221;.</p>\n<p>But I didn&#8217;t just write about my days. After getting accepted into Ankara University in September 2006, I began to read and think about politics, as nearly all young Turks do in university. Eventually, I started writing about politics as well. Because you know what they say: If you want to learn something, write about it.</p>\n<p>Oh, I learned it pretty well, and I learned it the (somewhat) hard way.</p>\n<h2>Facing Jail Time with a Blog Post</h2>\n<p>2010 was probably my darkest year in my entire life. (2016 is the next candidate.) I was 22 years old, blogging daily, learning about web design and WordPress (more on that later), and keeping up with what&#8217;s going on with the country. Things were crazy back then: A very big prosecution was going on called the Ergenekon Case about military people allegedly planning a coup (Hint: This is not the coup I mentioned in the intro! These guys were all acquitted later.) and a big campaign for a constitutional referandum was more than enough to keep the whole country busy.</p>\n<p>In December 2010, Recep Tayyip Erdoğan, the Prime Minister of the time (and the President since 2014) sued me for one of my blog posts. It was about one of the slogans he used in his referandum rallies (&#8220;The terrorists and the opposition parties are soul mates!&#8221;) and me using the same sentence against him. Like, <em>the exact same sentence</em>. He didn&#8217;t like the way that the slogan was used against him, so he reported me and the state brought charges against me. I was 22 and I was being sued by the most powerful man in the country, because I used his words against him.</p>\n<p>When the Prime Minister sues you, you go to jail. There were little to no instances of winning a case against the government, especially when they were the one suing you. Thankfully, I was one of the few instances: I won the case in my third trial, February 14, 2012. (&#8220;Lovely&#8221; day, isn&#8217;t it?)</p>\n<p>There were one downside though: With the fear of the government suing me, I stopped writing about politics in 2011 and 2012, and even a few months after I won. And to this day, even though that fear is long gone, and even though I&#8217;m writing about politics again on Beyn, I still can&#8217;t write regularly like I did back then.</p>\n<p>Anyways. Moving on with the &#8220;web development&#8221; phase of my life.</p>\n<h2>Learning to Develop WordPress, and Teaching It at the Same Time</h2>\n<p>When I started Beyn, I immediately loved WordPress. I had some experience on HTML and CSS on Dreamweaver (never was a FrontPage guy), and I happily retired DW because I won&#8217;t be able to work on it while I was learning WordPress.</p>\n<p>I don&#8217;t remember trying to learn something with such passion. I loved the idea of plugins and themes extending the core. Beyn became my playground for new tricks, my laboratory for new experiments about WordPress. I installed plugins, edited themes, learned what&#8217;s right and what&#8217;s wrong with what I did&#8230; I probably crashed the website more than a hundred times!</p>\n<p>By 2012, I&#8217;d already started making websites for other people and getting paid. I had developed a few plugins, made a couple of themes from scratch. While still learning what awesome things I&#8217;m able to do with WordPress, I applied for a small writing gig at Wptuts+, which was later renamed <a href=\"https://tutsplus.com/authors/baris-unver\">Tuts+ Code</a>. Because you know what they say: If you want to learn something, write about it.</p>\n<p>That &#8220;small writing gig&#8221; was in fact my biggest source of education. I wasn&#8217;t a WordPress expert, but that gig was the ultimate reason to learn more and more about WordPress. I remember constantly feeling that &#8220;I&#8217;ve finished telling about everything I know about WordPress, so now I have to learn more!&#8221; and doing research on things to write about.</p>\n<p>I was aware that I don&#8217;t have any chance to write a sloppy tutorial, so I nagged my editors (first Japh Thomson, then Tom McFarlin) about my writing style, my choice of topics and of course, my English. They said my English was very good, and my topics are relevant and suitable for publishing on Tuts+. In almost exactly four years (from April 2012 to March 2016), I wrote 134 posts and I&#8217;m very proud of (almost) all my work there.</p>\n<p>While it was sad to leave Tuts+, I had a project in my mind that I put off so long: <a href=\"https://optimocha.com/\">Optimocha</a>.</p>\n<h2>WordPress Speed Optimization with Terrorists, Bombs and Death</h2>\n<p>That title came out grimmer than I expected. Heh. <em>Anyways.</em></p>\n<p>2015 was the year when I first thought about a speed optimization service for WordPress-based websites. Then I thought that I would better use my energy on the upcoming general elections in June. I worked for an NGO called &#8220;Vote and Beyond&#8221; to <a href=\"https://en.wikipedia.org/wiki/Vote_and_Beyond\">ensure transparency in observering of ballot count in the elections</a>.</p>\n<p>2015 was also the year with a whole lot of terrorist attacks. PKK, a terrorist organization <em>pretending</em> to defend Kurds&#8217; rights (while giving a bad name for all Kurds countrywide) and ISIS (you know them) were the most active terrorist organizations in 2015. They killed more than 250 people and injured more than 1000 in a series of shootings and bombings throughout the year.</p>\n<p>Worst year ever, right? <em>Not even close.</em> Let me quickly summarize the hell we&#8217;ve been through:</p>\n<ol>\n<li>ISIS killed 116 people in 5 different attacks.</li>\n<li>PKK killed 176 people in 15 different attacks.</li>\n<li>TAK, PKK&#8217;s even uglier cousin, killed 43 people in 4 different attacks.</li>\n<li>FETO killed 248 people across the country in their coup d&#8217;état attempt on July 15.</li>\n</ol>\n<p>583 people killed in terrorist attacks in 2016. <em>So, just a few more than all those lovely celebrities.</em></p>\n<p>What&#8217;s that FETO sticking out among the others, attempting a coup? That&#8217;s <strong>FE</strong>thullahist <strong>T</strong>errorist <strong>O</strong>rganization: The organization of Fethullah Gülen, an Islamic cult leader comfortably residing in Pennsylvania, plotting to take over the government for (I kid you not) over 40 years. Even I had made peace with the President because of the much needed &#8220;purges&#8221; to scrape his crypto-disciples in the government organizations. FETO is one of the enemies that can let you make peace with the ones against your values.</p>\n<p>(By the way: While celebrating that we got rid off that horror show of 2016, ISIS killed 39 more people with an AK-47 in a New Year party on January 1, in the middle of the night.)</p>\n<p>Still waiting for the part where I founded Optimocha, right? Sorry it took a bit long.</p>\n<p>April 2016 was the month I registered my company by paying for the usual fees to register a sole proprietorship, accountant fees, rent for an office (because by law, you can&#8217;t register a company without an office), some paperwork. All my funds vanished, leaving me with nothing to spend on marketing.</p>\n<p>PayPal halted operations in Turkey on June, because of conflicts with the government. 2CheckOut followed. I was going to use 2CO, so I was left with no payment gateway provider. Along with the terrorist attacks, I decided to spend Ramadan (the holy month for Muslims, passed on June 2016) sleeping, lying and moping around with depression.</p>\n<p>At the beginning of July, I was ready to work again, amped up for success! Except the coup attempt happened. Bombs and sonic booms in my city. Back to depression.</p>\n<p>By October, I was almost ready to go live with <a href=\"https://optimocha.com/\">the website</a>. I didn&#8217;t. I forced myself to finish it in November, before Black Friday. <em>I did!</em> People responded to my emails, said they&#8217;ll publish my deal on their blogs. People who saw the deal also responded and purchased my services. Yay.</p>\n<h2>Conclusion</h2>\n<p>Blogging is hard. Blogging with the most powerful man in your country trying to lock you up is the hardest.</p>\n<p>Solopreneurship is hard. Solopreneurship with several, highly active terrorist organizations killing people next to you is the hardest.</p>\n<p>Yet, <em>and I&#8217;m sure this is going to sound cheesy</em>, I have hope. This is the price we have to pay in order to get rid of the scum in the world. Turkey isn&#8217;t the worst country in the world suffering from terror&#8211;we&#8217;re just a country stuck between Europe, Russia, the Middle East and Africa. (Talk about a rock and a hard place&#8230;) We will survive this, and this too will pass.</p>\n<p>Turkey may be viewed as &#8220;yet another Middle Eastern country&#8221;, but it was founded almost a hundred years ago with the heritage of the Ottoman Empire, but also with a Western, secular mindset. <em>Even today</em>, you can&#8217;t find a sensible person talking trash about Mustafa Kemal Atatürk, who declined the Ottoman monarchy to set the foundation of a democratic republic in a time of dictatorships across Europe and Asia. Emphasis on the words &#8220;even today&#8221;, because the principles of his <em>vision</em> of the Republic of Turkey is in danger, a very large portion of the country has the confidence and equipment to defend those principles.</p>\n<p>Again: We will survive this, and this too will pass. You have my word.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Blogging, Solopreneurship, & Terrorism\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Blogging%2C%20Solopreneurship%2C%20%26%20Terrorism&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fblogging-solopreneurship-terrorism%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Blogging, Solopreneurship, & Terrorism\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fblogging-solopreneurship-terrorism%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fblogging-solopreneurship-terrorism%2F&title=Blogging%2C+Solopreneurship%2C+%26%23038%3B+Terrorism\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Blogging, Solopreneurship, & Terrorism\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/blogging-solopreneurship-terrorism/&media=https://heropress.com/wp-content/uploads/2017/01/011117-150x150.jpg&description=Blogging, Solopreneurship, & Terrorism\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Blogging, Solopreneurship, & Terrorism\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/blogging-solopreneurship-terrorism/\" title=\"Blogging, Solopreneurship, & Terrorism\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/blogging-solopreneurship-terrorism/\">Blogging, Solopreneurship, &#038; Terrorism</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 12:00:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Barış Ünver\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Dev Blog: WordPress 4.7.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6519:\"<p>WordPress 4.7 has been <a href=\"https://wordpress.org/download/counter/\">downloaded over 10 million times</a> since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7 and earlier are affected by eight security issues:</p>\n<ol>\n<li>Remote code execution (RCE) in PHPMailer &#8211; <em>No specific issue appears to affect WordPress</em> or any of the major plugins we investigated but, out of an abundance of caution, we updated PHPMailer in this release. This issue was fixed in PHPMailer thanks to <a href=\"https://legalhackers.com/\">Dawid Golunski</a> and <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a>.</li>\n<li>The REST API exposed user data for all users who had authored a post of a public post type. WordPress 4.7.1 limits this to only post types which have specified that they should be shown within the REST API. Reported by <a href=\"https://poststatus.com/\">Krogsgard</a> and <a href=\"https://ithemes.com/\">Chris Jean</a>.</li>\n<li>Cross-site scripting (XSS) via the plugin name or version header on <code>update-core.php</code>. Reported by <a href=\"https://dominikschilling.de/\">Dominik Schilling</a> of the WordPress Security Team.</li>\n<li>Cross-site request forgery (CSRF) bypass via uploading a Flash file. Reported by <a href=\"https://twitter.com/Abdulahhusam\">Abdullah Hussam</a>.</li>\n<li>Cross-site scripting (XSS) via theme name fallback. Reported by <a href=\"https://pentest.blog/\">Mehmet Ince</a>.</li>\n<li>Post via email checks <code>mail.example.com</code> if default settings aren&#8217;t changed. Reported by John Blackbourn of the WordPress Security Team.</li>\n<li>A cross-site request forgery (CSRF) was discovered in the accessibility mode of widget editing. Reported by <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronnie Skansing</a>.</li>\n<li>Weak cryptographic security for multisite activation key. Reported by <a href=\"https://itsjack.cc/\">Jack</a>.</li>\n</ol>\n<p>Thank you to the reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.7.1 fixes 62 bugs from 4.7. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.7.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.1.</p>\n<p>Thanks to everyone who contributed to 4.7.1: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chandrapatel/\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/christian1012/\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dreamon11/\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hristo-sg/\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/monikarao/\">monikarao</a>, <a href=\"https://profiles.wordpress.org/natereist/\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikschavan/\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nullvariable/\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/sirbrillig/\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sanketparmar/\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sfpt/\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom/\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/sstoqnov/\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/timph/\">timph</a>, <a href=\"https://profiles.wordpress.org/voldemortensen/\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 03:53:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Matt: Rebirth and Yellow Arrows\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://ma.tt/2017/01/rebirth-and-yellow-arrows/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2464:\"<p>My friend <a href=\"https://www.amazon.com/Rebirth-Fable-Forgiveness-Following-Heart/dp/0316312282/\">Kamal Ravikant has a new book out, Rebirth, which I highly recommend</a>. I had the good fortune to read it a few months ago and the story of the Camino de Santiago touched and inspired me.</p>\n<p>Because of the impact of the book, I ended up adopting a few New Year&#8217;s intentions long before January 1st &#8212; things to ruminate on and keep in mind as the year wound down. The outlook of the world seemed uncertain, and I&#8217;m learning to navigate the world without my father.</p>\n<p><img /></p>\n<h3>Yellow Arrows</h3>\n<p>The Camino de Santiago is a pilgrimage path in Spain that people have walked since the 9th century AD. The 500 mile path winds through mountains, fields, and sometimes cities, and many pilgrims take a month or more on it. In some ways it is similar to <a href=\"http://walkkumano.com/\">the Kumano Kodo walk I did with Dan and Craig last year</a>.</p>\n<p>There are places where the path isn&#8217;t exactly clear, either because the trail isn&#8217;t strong, there&#8217;s been growth, or you might be in a crowded urban area like a city. Over the years pilgrims and people who live on the trail have marked it with yellow arrows pointing the way. If someone gets lost or confused, it&#8217;s an opportunity for an additional sign to bring them back on track.</p>\n<p>When you know the path, is it clear where someone else walking it should go next? It&#8217;s an interesting concept that applies across life. In your relationships, does your friend, loved one, or partner know what to expect, and where you&#8217;re headed together? Even in WordPress I feel like there are too many places where we bring someone to a fork in the road and there is no clear indication which way they should take.</p>\n<p>Give some thought to the yellow arrows in your life, and I&#8217;ll write more about the other two things I&#8217;ve been thinking about tomorrow. Also don&#8217;t forget <a href=\"https://www.amazon.com/Rebirth-Fable-Forgiveness-Following-Heart/dp/0316312282/\">to pick up a copy of Kamal&#8217;s book</a>. I loved it and I think it will be one I&#8217;m recommending to many friends.</p>\n<p><a href=\"https://www.amazon.com/Rebirth-Fable-Forgiveness-Following-Heart/dp/0316312282/\"><img /></a></p>\n<p>(Image from <a href=\"http://caminotravelcenter.com/who-was-elias-valina-follow-the-yellow-arrow/\">Camino Travel Center</a>.)</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 03:48:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Year in WP Creates a Personalized Review of WordPress Contributions in 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64884\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/year-in-wp-creates-a-personalized-review-of-wordpress-contributions-in-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4911:\"<p><a href=\"https://yearinwp.com/\">Year In WP </a>is a new site by <span class=\"DMUpdateName-name DMConversation-name u-textTruncate\"><a href=\"http://jespervanengelen.com/\">Jesper van Engelen</a> that creates a personalized review of a user&#8217;s contributions to WordPress in 2016. Entering the WordPress.org username of a plugin or theme author or a WordPress core contributor into the field generates a list of statistics that includes:</span></p>\n<ul>\n<li>Profile information</li>\n<li>Number of times their plugins and themes were downloaded</li>\n<li>Most downloaded plugins and themes</li>\n<li>Average number of downloads per week</li>\n<li>Plugin and theme review rating average</li>\n<li>Percentage of five-star ratings</li>\n<li>A selection of five-star reviews</li>\n<li>Number of commits, changes, and comments to WordPress core</li>\n<li>Number of WordPress releases contributed to</li>\n</ul>\n<p>Engelen got the idea to create the site in 2014 after Spotify launched its &#8216;<a href=\"https://news.spotify.com/us/2014/12/03/2014-a-year-in-music/\">Year in Music</a>&#8216; that highlighted trends based on what 50 million users listened too.</p>\n<p>&#8220;I’d been active in the WordPress plugin market for about four years at that point, and I figured it would be really cool to get some year-over-year insight into your WordPress plugins,&#8221; Engelen said.</p>\n<p>&#8220;Having become a partner at Admin Columns (a freemium WordPress plugin) in 2014, I found out that I really liked analyzing statistics of downloads, sales and other data, and that, properly grouped and reported, they could have a pretty big influence on decision-making from a business perspective.&#8221;</p>\n<p>Engelen started the site by experimenting with fetching data from WordPress.org through its API that would show the change in the number of downloads to a user&#8217;s plugins.</p>\n<p>&#8220;That is basically what lead to the &#8216;Your most popular plugins&#8217; overview page,&#8221; Engelen said. &#8220;Spending some free hours each week on working on the project, more and more ideas of data to include popped up.&#8221;</p>\n<p><img /></p>\n<p>The site displays a lot of data, but it doesn&#8217;t include everything. Engelen would like to eventually display sections for contributions to WordPress translations, plugins, themes, core, design, etc.</p>\n<h2>The Technical Details</h2>\n<p>The data displayed on Year in WordPress is gathered using the <a href=\"https://codex.wordpress.org/WordPress.org_API\">WordPress.org API</a>, subversion, and web scraping. Engelen would have used the WordPress REST API but it was not available at the time, &#8220;Fetching the reviews and support topics yielded quite a bit of annoyance, as they’re done by scraping,&#8221; he said.</p>\n<p>He uses a Python framework to fetch relevant data in parallel. The data is stored in an SQL database, which is accessed by a front-end tool. The front-end of the site features a design that was reused from <a href=\"https://www.admincolumns.com/\">AdminColumns.com</a>.</p>\n<p>&#8220;jQuery, combined with Chart.js and Fullpage.js power the interactive portion of Year in WordPress. I’ve also written some simple sentiment analysis code for filtering out the most popular reviews to show for each plugin/theme developer,&#8221; Engelen said.</p>\n<h2>Fun Facts about Year in WordPress</h2>\n<p>Engelen provided the Tavern with these fun facts related to Year in WordPress:</p>\n<ul>\n<li>There’s a Year in Review for about 100,000 users on WordPress.org — or all users who have contributed to a plugin or theme, created a review or a support ticket, or contributed to WordPress core.</li>\n<li>The full database takes about 500MB of space.</li>\n<li>There were 364,763,308 plugin/theme downloads in 2015, and 434,865,745 in 2016. That’s 19.2% growth!</li>\n<li>2016 was the first year where the number of new core Trac tickets shrunk (4,044 in 2014; 4,392 in 2015; 4,028 in 2016)</li>\n<li>73% of all plugins received zero reviews in 2016</li>\n</ul>\n<h2>Year in WordPress 2017 Is Not Guaranteed</h2>\n<p>Engelen is not making any promises for continued development in 2017 as it&#8217;s contingent on his free time. However, the main thing he would like to change is to include a wider spectrum of data.</p>\n<p>&#8220;When I pitched the idea of Year in WordPress to a core committer and showed the beta version, he said &#8216;there&#8217;s so much more than core itself&#8217; and that stuck with me,&#8221; he said.</p>\n<p>&#8220;The perfect &#8216;Year in WordPress&#8217; would feature cool statistics about all types of contributions people make to WordPress — whether it’s creating plugins and themes, writing code for core, translating or testing. Furthermore, I’m really looking forward to making use of all of the REST API’s that I can use this time around.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Jan 2017 22:11:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: Say What Plugin Passes 10K Active Installs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64778\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/say-what-plugin-passes-10k-active-installs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5220:\"<p>WordPress core doesn&#8217;t make it easy to edit text strings, but a little plugin called <a href=\"https://wordpress.org/plugins/say-what/\" target=\"_blank\">Say What?</a> has been quietly gaining a solid user base by providing this functionality. It allows users to edit text strings without editing WordPress core or plugin code. Lee Willis released Say What in 2013, but the plugin had a significant jump in users in 2016, doubling the number of active installs from 5,000 to 10,000 sites.</p>\n<p>Willis, who is the author of <a href=\"https://profiles.wordpress.org/leewillis77/#content-plugins\" target=\"_blank\">22 plugins</a> hosted on WordPress.org and many more commercial extensions, created Say What while working as a Drupal developer.</p>\n<p>&#8220;One of our must-install Drupal modules was called String Overrides, which inspired Say What?&#8221; he said. &#8220;At the agency I was working at we used it regularly on virtually every site build to override plugin, theme, and core strings in a &#8216;non-hacky&#8217; way. Given that, I knew that the problem was there to be solved on WordPress, and that something that worked well would be useful to people.&#8221;</p>\n<p>Say What adds a new screen for editing text under Tools > Text changes for configuring string replacements. Users enter the current string, text domain, and replacement text.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/say-what-text-edits.png?ssl=1\"><img /></a></p>\n<p>This plugin is a good option for those who are not comfortable sifting through PHP files and adding a filter to change the text. If you just have a handful of strings to replace, it&#8217;s more convenient than using a translation tool like POEDIT to edit the language files. All of the text changes are listed together in the Say What admin panel, so they can be easily changed at any time without editing any files.</p>\n<p>Willis said users don&#8217;t often experience conflicts with themes and plugins, as there is so little frontend functionality included in the plugin.</p>\n<p>&#8220;The main areas of support tend to be around locating particular strings, or issues where broken custom code is breaking the filters that Say What uses,&#8221; Willis said. After speaking with friends at a WordCamp in March 2015, he decided to create a commercial version to address this issue and a number of other feature requests.</p>\n<p>&#8220;The free version was out for about two years before I launched the <a href=\"https://plugins.leewillis.co.uk/downloads/say-what-pro/\" target=\"_blank\">Pro version</a>,&#8221; Willis said. &#8220;The only issue people tended to have with the free version was around finding the information they needed for the &#8216;original string,&#8217; so I decided to build out the String Discovery feature as the first feature of the Pro version. This lets users search for the string using autocomplete functionality, making it much easier to set up replacements without delving through theme or plugin code.&#8221;</p>\n<p>Say What increased in popularity in 2016 and has maintained a 4.6-star rating on WordPress.org. It is becoming more frequently recommended by support teams of other plugins when customers ask about how to change text strings.</p>\n<p>&#8220;It&#8217;s great to know that it&#8217;s being used to help people build more future-proof sites without resorting to hacking plugin or core code just to change strings,&#8221; Willis said. &#8220;Even for people familiar with plugin and theme code, the String Discovery feature makes it a lot easier and quicker to set up replacements. It&#8217;s had a few new features over the last year, including support for multi-line, and single/plural style replacements.&#8221;</p>\n<p>Willis said his Pro version proved to be fairly popular during 2016 and became one of his highest selling plugins. He recently added support for multilingual sites, the most often requested feature, allowing users to set up different replacements for different languages.</p>\n<p>Willis does not have an extensive roadmap for the plugin, as he prefers to keep it uncomplicated and free of clutter. &#8220;I&#8217;m a big believer in plugins that do one thing, and do it well,&#8221; he said.</p>\n<p>Say What is another successful instance of a developer solving one of his own problems and striking upon a successful commercial product. Willis said he didn&#8217;t fully anticipate how popular the plugin would become.</p>\n<p>&#8220;As with most of my plugins it was also built to solve a problem that I personally was having at the time,&#8221; he said. &#8220;That said, I&#8217;m always (pleasantly) surprised when something does get popular.&#8221;</p>\n<p>After testing <a href=\"https://wordpress.org/plugins/say-what/\" target=\"_blank\">Say What</a> I found that Willis&#8217; implementation is the simplest way for non-technical users to make a few simple string changes without the risk of breaking their websites. He is also very responsive on the support forums. The success of the Pro version is a good indication that Willis will be able to continue support and maintenance on the free plugin for the foreseeable future.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Jan 2017 21:26:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: How Laravel Forge Can Help You Run WordPress in the Cloud\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64940\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/how-laravel-forge-can-help-you-run-wordpress-in-the-cloud\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7837:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2015/05/petersuhm.jpeg?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2015/05/petersuhm.jpeg?resize=150%2C150&ssl=1\" alt=\"petersuhm\" class=\"alignright size-thumbnail wp-image-43613\" /></a>This opinion piece was contributed by guest author <a href=\"https://twitter.com/petersuhm\" target=\"_blank\">Peter Suhm</a>. Peter is a web developer from the Land of the Danes. He is the creator of <a href=\"https://wppusher.com/\" target=\"_blank\">WP Pusher</a> and a huge travel addict, bringing his work along with him as he goes.<br />\n&nbsp;</p>\n<hr />\n<p><a href=\"http://forge.laravel.com/\" target=\"_blank\">Laravel Forge</a> is a server and application provisioning tool that was originally built to serve the Laravel PHP crowd. Recently, it has been made available to WordPress developers too, with the introduction of 1-click installs of WordPress on Digital Ocean, Linode and AWS cloud servers. In this post, I&#8217;ll give you a brief introduction to Laravel Forge and show you how you can use it to manage all of your WordPress installations in the cloud.</p>\n<h3>Laravel Forge is good news for WordPress developers</h3>\n<p>Because so many WordPress developers are used to managed hosting, the thought of running their own servers seem quite intimidating. That&#8217;s a shame with so many great cloud server companies offering virtual servers for very low costs. Unless your traffic is very heavy, a small ($5 to $10 per month) server can run quite a few WordPress websites. Laravel Forge takes care of provisioning your servers and can even setup your database and install WordPress for you. This makes cloud hosting much more available to WordPress developers at a low cost (Laravel Forge is $15 per month for unlimited servers), compared to many of the existing options.</p>\n<p>Here are a few reasons why I think Laravel Forge is great for WordPress hosting:</p>\n<ul>\n<li>Your servers are configured in a secure way by default, with SSH authentication, firewalls, automatic security updates and free SSL certificates from Let&#8217;s Encrypt</li>\n<li>Your servers are going to be really fast with PHP 7</li>\n<li>You can run a lot of WordPress installs on 1 single server *</li>\n<li>You can scale your servers if you need more horse power *</li>\n</ul>\n<p><em>* Goes for the cloud in general</em></p>\n<h3>Creating a new server</h3>\n<p>Here is how the &#8220;Create Server&#8221; screen looks in Forge:</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/create-server-e1483980109591.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/create-server-e1483980109591.png?resize=1025%2C416&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64946\" /></a></p>\n<p>If you use Digital Ocean, Forge can also create your servers. If you use another provider like Linode or AWS, Forge can only do the provisioning part.</p>\n<p>For Digital Ocean servers, here are the options you can configure:</p>\n<ul>\n<li>Which credentials to use, if you are managing multiple Digital Ocean accounts</li>\n<li>The server name</li>\n<li>The server size</li>\n<li>The server region</li>\n<li>The PHP version</li>\n<li>The default database name</li>\n</ul>\n<p>You can then choose to:</p>\n<ul>\n<li>Configure the server as a load balancer (if you have really heavy traffic and is running WordPress across multiple servers)</li>\n<li>Install <a href=\"https://mariadb.org/\" target=\"_blank\">MariaDB</a> instead of MySQL, which is a drop-in, faster replacement</li>\n<li>Enable weekly backups on Digital Ocean</li>\n</ul>\n<p>When Laravel Forge is done with the provisioning, your server is ready to go.</p>\n<h3>Setting up a database</h3>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/set-up-database-e1483980726266.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/set-up-database-e1483980726266.png?resize=1025%2C484&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64949\" /></a></p>\n<p>Once your server has been created, setting up a database for your WordPress installation is very easy. You can create the user at the same time you&#8217;re creating the database, or you can create the user afterwards.</p>\n<h3>Installing WordPress</h3>\n<p>Before you install WordPress, you need to create a new &#8220;site&#8221; on your server. You can just stick with the defaults:</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/new-site-e1483981223250.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/new-site-e1483981223250.png?resize=1025%2C453&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64951\" /></a></p>\n<p>For the &#8220;Root Domain&#8221;, you need to add the domain name of the site you are setting up. Remember that you need to add a DNS record for your domain that points to the IP address of your newly created server. If you are just testing, you can always add a record in your computer&#8217;s <code>hosts</code> file with a test domain that points to your server. Something like this:</p>\n<p><code># /etc/hosts</code></p>\n<p><code># Replace xx.xx.xx.xx with your server\'s IP address<br />\nxx.xx.xx.xx wordpress-forge.test</code></p>\n<p>Once you click the &#8220;Add Site&#8221; button, you will see a spinning wheel while Forge is setting up your site&#8217;s nginx configuration.</p>\n<p>When the installation is done, you need to click the &#8220;Manage&#8221; icon next to your site in order to install WordPress. The first screen you will be presented with gives you the option to install an &#8220;App&#8221; on your site. Click the &#8220;WordPress&#8221; button, select your database and user from the previous step and relax while Laravel Forge completes the installation. Fun fact: Laravel Forge is actually using WP-CLI to install WordPress on your server.</p>\n<p>When the installation has completed, visit your site in a browser and you&#8217;ll be met with something familiar:</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/wp-install-e1483984375432.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/wp-install-e1483984375432.png?resize=1025%2C625&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64962\" /></a></p>\n<h3>Setting up a free SSL certificate</h3>\n<p>Finally, you should set up SSL for your WordPress site. It&#8217;s more secure and Google likes it!</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/ssl-setup.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/ssl-setup.png?resize=1025%2C288&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64963\" /></a></p>\n<p>Head over on the &#8220;SSL&#8221; tab and click the &#8220;LetsEncrypt (Beta)&#8221; button. Click the &#8220;Obtain Certificate&#8221; button and wait while Forge creates and installs the certificate. Once the certificate is installed, click the &#8220;Activate&#8221; icon and voila! Your site is now all set up and secured with SSL.</p>\n<p>That&#8217;s how easy it is to setup WordPress on a cloud server with Laravel Forge. I hope to see a lot of more products and tools like this that can help us building better, faster, and more secure WordPress websites. In fact, Laravel Forge was the original inspiration for my own product <a href=\"https://wppusher.com/\" target=\"_blank\">WP Pusher</a>. I wanted to create a similar experience, but for WordPress plugins and themes instead.</p>\n<h3>Note on backups and security</h3>\n<p><em>Please note that even though Laravel Forge makes for a great starting point, ultimately you are the one in charge of the security of your servers. You should always try to educate yourself about security and have a backup strategy for your data.</em></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Jan 2017 18:44:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Post Status: Contributing to Twenty Seventeen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=31886\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://poststatus.com/contributing-to-twenty-seventeen-theme/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11882:\"<p><em><strong>Editor&#8217;s Note</strong>: This is a guest post by <a href=\"https://poststatus.com/profiles/sami-keijonen/\">Sami Keijonen</a>. Sami is a developer, the owner of the <a href=\"https://foxland.fi/\">Foxland theme and plugin shop</a>, and hails from Finland.</em></p>\n<p>Every year since 2010, WordPress has shipped with a new default theme, breaking the cycle of Kubrick being the primary default theme for years before that.</p>\n<p>In 2010, the default theme was called Twenty Ten. In 2011, the default theme was called Twenty Eleven. You get the idea.</p>\n<p>While every default theme has been unique in its own way, <a href=\"https://wordpress.org/themes/twentyseventeen/\">Twenty Seventeen</a> was particularly compelling in a way we haven’t seen in a default theme since Twenty Fourteen.</p>\n<p><a href=\"https://wordpress.org/themes/twentyfourteen/\">Twenty Fourteen</a> was the first theme that really made people think WordPress could be used for more than “just a blog” on a mass scale. It is a magazine theme.</p>\n<p>Twenty Seventeen &#8212; <a href=\"https://poststatus.com/wordpress-4-7-released/\">released with WordPress 4.7</a> &#8212; is the first theme that really made people think WordPress could be used for more than “just publishing content” on a mass scale. It is a business theme.</p>\n<p><img /></p>\n<p>Prior to WordPress 4.7, I contributed by helping out in the support forums and building <a href=\"https://foxland.fi/downloads/category/themes/\">accessible themes</a>. But I had never contributed to core before.</p>\n<p>When I saw the <a href=\"https://make.wordpress.org/core/2016/09/09/say-hello-to-twenty-seventeen-%25F0%259F%2591%258B%25F0%259F%258F%25BD/\">previews</a>, I knew I wanted to contribute, and began to follow development on GitHub to see if there was anything that I could lend my talents to and eventually make my first core contributions.</p>\n<p>When I saw Morten Rand-Hendriksen <a href=\"https://github.com/WordPress/twentyseventeen/issues/60\">open an issue</a> about replacing icon fonts with SVG icons, I knew I had found the perfect “in” to start contributing to core.</p>\n<h3>Contributing SVG icons system to Twenty Seventeen</h3>\n<p><img /></p>\n<p>I had already <a href=\"https://foxland.fi/switch-away-icon-fonts-svg/\">switched from icon fonts to SVG icons</a> in my public themes, so this was something I immediately felt confident in contributing to core.</p>\n<p>Development started in <a href=\"https://github.com/WordPress/twentyseventeen/\">GitHub</a>, where fellow contributors would create issues and submit pull requests.</p>\n<p>Then, everything moved to <a href=\"https://core.trac.wordpress.org/browser/trunk\">WordPress SVN</a>, where new patches were submitted.</p>\n<p>I’ll summarize what I learned in the process.</p>\n<h3>What I learned about contributing</h3>\n<p>I regret not keeping a diary. Not necessarily to keep track of what I contributed, since that’s all documented in the open.</p>\n<p>But rather things like my emotional state. My feelings ranged from despair to overwhelming joy throughout my contribution experience.</p>\n<p>I learned new things about code and collaborating with others in GitHub and SVN. Again, something not necessarily documented in patches and the like.</p>\n<h4>Git workflow</h4>\n<p>I’m not good with Git, and still don’t fully understand how rebasing works. I messed up my commits a couple of times. Not a big deal, but I got different error messages no matter which workflow I tried. I realized that I need to know more about Git, and be more patient.</p>\n<p>Eventually I understood enough to get my contributions through the door, but I’m still confused about <a href=\"https://github.com/edx/edx-platform/wiki/How-to-Rebase-a-Pull-Request\">how to rebase a pull request</a>.</p>\n<h4>Follow the development through to the end, and beyond</h4>\n<p>I started out by replacing only the social link icon fonts to SVG icons. Soon, I realized that a step-by-step process was not going to work because of new related commits coming in all the time that potentially conflicted with my code.</p>\n<p>It was better to replace all icon fonts, not just the social ones, with SVGs, and then work from there. I was also keeping track of style changes in RTL languages and IE8.</p>\n<p>At this point, the work was just getting started.</p>\n<p>Once you start contributing, you shouldn&#8217;t just disappear with no explanation. If you’re running low on time or have other obligations, it’s totally understandable, but be sure to politely inform others you can’t continue anymore, so they can pick up where you left off.</p>\n<p>As the <a href=\"https://geto2.com/\">o2</a> slogan states: &#8220;Communication is oxygen.&#8221;</p>\n<h4>Coding standards and automated tests</h4>\n<p>After several commits and iterations, <a>my first pull request was accepted</a>.</p>\n<p>As you can see in my first commits, I didn’t pass the WordPress coding standards. I needed to be more precise and follow the coding standards to the tee. With enough practice, I’m sure it’s possible to write standards-compliant code “naturally” but I was looking for a way to automate the code checks.</p>\n<p>I tried to get Atom to evaluate my code on the fly, but I just couldn’t get it to work. Like my Git experience, I got different error messages no matter what I tried.</p>\n<p>Eventually, I was able to use <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards\">PHPCS</a> via the command line, and fixed any issues discovered manually. But it would’ve been nice to have those checks automated.</p>\n<h4>Working with batches in SVN</h4>\n<p>Once the development moved to SVN, I began to get a little worried. As I described earlier, not too long ago, I was struggling just to use Git. However, thanks to the following tutorials I quickly got up to speed.</p>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/handbook/tutorials/installing-wordpress-locally/from-svn/\">Installing via SVN</a></li>\n<li><a href=\"https://make.wordpress.org/core/handbook/tutorials/installing-a-vcs/%23installing-tortoisesvn\">Installing TortoiseSVN</a> (I use Windows)</li>\n<li><a href=\"https://make.wordpress.org/core/handbook/tutorials/trac/submitting-a-patch/\">Submitting a Patch</a></li>\n<li><a href=\"https://make.wordpress.org/core/handbook/tutorials/working-with-patches/%23creating-a-patch-with-tortoisesvn\">Creating a Patch with TortoiseSVN</a></li>\n</ul>\n<p>Turns out, it wasn’t much to be worried about. Although I didn’t quite understand the concept of branches and tags in my local environments, and jumping between them like I know how to do with Git.</p>\n<p>Anyway, I eventually got <a href=\"https://core.trac.wordpress.org/changeset/39072\">my first props</a> with the help of others.</p>\n<h3>Technical overview of the SVG icons system</h3>\n<p>I adapted this contribution from the code and concepts first presented by others.</p>\n<ol>\n<li><a href=\"https://webdevstudios.com/\">WebDevStudios</a> has their own starter theme called <a href=\"https://github.com/WebDevStudios/wd_s\">wd_s</a>. I really like how they set up SVG icons and we fine-tuned them in Twenty Seventeen. Perhaps they will integrate those improvements back into their own project. Again, open source rocks.</li>\n<li><a href=\"http://themehybrid.com/\">Justin Tadlock</a> invented the <a href=\"http://justintadlock.com/archives/2013/08/14/social-nav-menus-part-2\">social links menu</a> concept. I just took that concept and applied it to SVG icons rather than icon fonts.</li>\n</ol>\n<p>All the main SVG-related functions can be found in the <a href=\"https://core.trac.wordpress.org/browser/trunk/src/wp-content/themes/twentyseventeen/inc/icon-functions.php\">inc/icon-functions.php file</a>. It’s well-documented in the code, but here’s a summary:</p>\n<ul>\n<li>Include the SVG sprite file via the <code>wp_footer</code> hook.</li>\n<li><code>twentyseventeen_get_svg()</code> function returns the SVG icon markup. In most cases, the SVG icon is injected in template files or via hooks and filters. In some cases, the SVG icon is injected via JavaScript.</li>\n<li>Default markup looks like this: <code>&lt;svg class=\"icon icon-name\" aria-hidden=\"true\" role=\"img\"&gt; &lt;use href=\"#icon-name\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:href=\"#icon-name\"&gt;&lt;/use&gt; &lt;/svg&gt;</code>.</li>\n<li>Note that we could use the absolute path to the SVG file in the <code>href</code> attribute of the use element. In that case:\n<ul>\n<li>there is no need to inject icons via the <code>wp_footer</code> hook.</li>\n<li>The <a href=\"https://github.com/Keyamoon/svgxuse\">svgxuse</a> JS polyfill must be used, because Internet Explorer doesn’t support external files referenced in the <code>&lt;use&gt;</code> element.</li>\n<li>This method helps caching the SVG sprite file.</li>\n</ul>\n</li>\n<li>By default, all icons are decorative, but I insisted we show how to use non-decorative icons in an accessible way. Check the examples in the aforementioned <code>twentyseventeen_get_svg()</code> function.</li>\n<li>We replace the default icon for supported social media links by using the <code>walker_nav_menu_start_el</code> filter.</li>\n</ul>\n<h3>Open source rocks</h3>\n<p>WordPress default themes are one of the best themes out there and they set an example how to use new WordPress features. The reason for this is simple.</p>\n<ul>\n<li>Default themes gets lots of love and attention.</li>\n<li>Many talented people contribute to default themes. <a href=\"https://davidakennedy.com/2016/12/07/dear-twenty-seventeen-contributors/\">Twenty Seventeen had over 100 contributors</a> and we thank you all!</li>\n<li>Default themes are tested before release in many platforms and browsers. And default themes are used on so many sites that any remaining bugs will be found after the release.</li>\n</ul>\n<p>Building default themes really is a community driven project. I&#8217;d like to say extra thanks for couple of people.</p>\n<h4>Special thank you</h4>\n<p>Any web project needs good leadership, design, and code. Those were all covered in Twenty Seventeen.</p>\n<ul>\n<li><a href=\"https://twitter.com/DavidAKennedy\">David A. Kennedy</a> was leading the project and kept everything rolling. He had a really friendly touch and he was open to ideas. At the same time he wasn&#8217;t afraid to make decisions; for example, a flexbox layout was rejected for this theme.</li>\n<li><a href=\"https://twitter.com/melchoyce\">Mel Choyce</a> created the modern, business looking design. She wrote a great article <a href=\"https://choycedesign.com/2016/12/07/behind-the-scenes-of-twenty-seventeen/\">with her behind the scenes take</a>.</li>\n<li><a href=\"https://twitter.com/laurelfulford\">Laurel Fulford</a> was the primary coding lead. She seem to have a solution for every new feature and brought Mel&#8217;s design to life with detailed code.</li>\n</ul>\n<p>Last but not least, remember <a href=\"http://mor10.com/\">Morten Rand-Hendriksen</a>, the one that opened the SVG icon issue that caught my eye?</p>\n<p>He was pretty happy with the end result.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/brad_frost\">@brad_frost</a> the SVG icon system solution by <a href=\"https://twitter.com/samikeijonen\">@samikeijonen</a> embedded in the new Twenty Seventeen theme in <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a> is pure genius</p>\n<p>&mdash; MortenRandHendriksen (@mor10) <a href=\"https://twitter.com/mor10/status/805808154520883200\">December 5, 2016</a></p></blockquote>\n<p></p>\n<p>Who knows if I would’ve contributed if it wasn’t for him posting that. Remember, reporting issues and bugs is contributing too, and can inspire first-time contributors like me to stop sitting on the sidelines and finally get started with core contributions.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Jan 2017 22:42:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sami Keijonen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: Let’s Encrypt Passes 20 Million Active Certificates in 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64815\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/lets-encrypt-passes-20-million-active-certificates-in-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5050:\"<p>Let&#8217;s Encrypt has just closed out its first full year as a certificate authority with more than <a href=\"https://letsencrypt.org/2017/01/06/le-2016-in-review.html\" target=\"_blank\">20 million active certificates</a>. The free and open certificate authority focuses on lowering the complexity of setting up TLS encryption by making the process more automated. It came <a href=\"https://wptavern.com/lets-encrypt-is-now-out-of-beta\" target=\"_blank\">out of beta</a> in April 2016 and the number of certificates issued per day has grown steadily since then.</p>\n<p>&#8220;At the start of 2016, Let’s Encrypt certificates had been available to the public for less than a month and we were supporting approximately 240,000 active (unexpired) certificates,&#8221; said Josh Aas, Executive Director of the non-profit Internet Security Research Group (ISRG). &#8220;Now we’re frequently issuing that many new certificates in a single day while supporting more than 20,000,000 active certificates in total. We’ve issued more than a million certificates in a single day a few times recently.&#8221;</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/lets-encrypt-2016.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/lets-encrypt-2016.png?resize=1025%2C503&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64920\" /></a></p>\n<p>Let&#8217;s Encrypt operates as a 501(c)(3) nonprofit and has received more than three dozen corporate <a href=\"https://letsencrypt.org/sponsors/\" target=\"_blank\">sponsorships</a> and grants, but funds for the coming year have fallen short. In November, Let&#8217;s Encrypt launched a <a href=\"https://www.generosity.com/community-fundraising/make-a-more-secure-web-with-let-s-encrypt\" target=\"_blank\">crowdfunding campaign</a> to cover the cost of one month of operating expenses. So far, the campaign has raised more than $100K towards its $200K fundraising goal.</p>\n<h3>Let&#8217;s Encrypt is Growing Fastest with Smaller, Previously-Unencrypted Sites</h3>\n<p>Let&#8217;s Encrypt is used with some larger organizations, such as WordPress.com, OVH, Shopify, Akamai, and Dreamhost, but the vast majority of users are smaller entities that were not previously encrypted. According to the Electronic Frontier Foundation (EFF), a founding sponsor of the certificate authority, most of Let&#8217;s Encrypt&#8217;s growth has not come from taking customers away from competitors:</p>\n<blockquote><p>\nOne of the ways Let&#8217;s Encrypt has been helping to secure the web is by making it easy and affordable for sites that have never had certs before to turn on secure HTTPS connections, and for software systems to start enabling HTTPS automatically and by default. Our free certificates may be more likely to be left unused than expensive certificates, and less expert webmasters may accidentally duplicate certificates—but that’s part of making HTTPS integration available to more webmasters across a range of resource and skill levels. Statistics suggest that most of our growth has come not at the expense of other CAs, but from giving previously unencrypted sites their first-ever certificates.</p></blockquote>\n<p>EFF analyzed various sources of usage statistics and estimates that <a href=\"https://www.eff.org/deeplinks/2016/10/lets-encrypt-largest-certificate-authority-web\" target=\"_blank\">Let&#8217;s Encrypt is now the largest certificate authority on the web</a>. Its rapid adoption has spurred impressive progress towards getting the entire web encrypted. Let&#8217;s Encrypt tracks progress by measuring the percentage of page loads using HTTPS, as seen by browsers.</p>\n<p>&#8220;According to Firefox Telemetry, the Web has gone from approximately 39% of page loads using HTTPS each day to just about 49% during the past year,&#8221; Aas said in Let&#8217;s Encrypt&#8217;s <a href=\"https://letsencrypt.org/2017/01/06/le-2016-in-review.html\" target=\"_blank\">2016 in Review</a> report. &#8220;We’re incredibly close to a Web that is more encrypted than not.&#8221;</p>\n<p>The proliferation of Let&#8217;s Encrypt <a href=\"https://letsencrypt.org/docs/client-options/\" target=\"_blank\">client options</a> in 2016 puts the certificate authority in an even better position to continue driving web encryption in 2017. Aas attributes last year&#8217;s progress to many organizations advocating for HTTPS and working to get their sites encrypted. His team has grown from four full-time employees to nine, and he anticipates that 2017 will be a year of even greater growth.</p>\n<p>&#8220;Much of the infrastructure and many of the plans necessary for a 100% encrypted Web came into being or solidified in 2016,&#8221; Aas said. &#8220;More and more hosting providers and CDNs are supporting HTTPS with one click or by default, often without additional fees. It has never been easier for people and organizations running their own sites to find the tools, services, and information they need to move to HTTPS.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Jan 2017 21:42:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: How Do You Educate People New to WordPress?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64890\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/how-do-you-educate-people-new-to-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5213:\"<p>When a friend of mine asked for suggestions on what he should use to create a new site, I suggested WordPress. It is well supported, has an amazing community, and a ton of free themes and plugins to choose from. After getting WordPress installed on a new webhosting account, I left him be to see what issues he would run into and how he would configure the site.</p>\n<p>After noticing the site was loading slowly three weeks later, I obtained admin access to try to determine what the problem was. The first thing I did was check which plugins he installed. One of the plugins added the ability to embed YouTube videos on the site using shortcodes. My friend was unaware that WordPress has <a href=\"https://codex.wordpress.org/Embeds\">oEmbed support</a> which allows users to easily embed videos by pasting the URL into the editor.</p>\n<p>He also installed a couple of other plugins that mimicked core functionality. He was unaware that WordPress does most of the things he wants without the need for plugins.</p>\n<h2>Page Builder Shenanigans</h2>\n<p>After activating a theme that was compatible with the <a href=\"https://wordpress.org/plugins/sportspress/\">SportsPress</a> plugin, he installed the <a href=\"http://www.getmotopress.com/plugins/content-editor/\">MotoPress Content Editor</a>. MotoPress Content Editor is a front-end page builder that enables users to visually construct pages. The front page of the site was a long vertical column filled with information that mimicked blog posts.</p>\n<p>Because he didn&#8217;t understand how WordPress works, he forgot to configure the site to display the latest posts instead of using a front page. What he ended up doing is recreating the blog post layout on the static front page using the MotoPress Content Editor. He also added a lot of page builder elements such as YouTube videos to the page which was a contributing factor to the site&#8217;s poor loading times.</p>\n<p>Page builders are a tool that can make building sites and pages more convenient, but in the wrong hands, they can help users <a href=\"https://wptavern.com/wordpress-visual-page-and-website-builders-make-it-easy-to-create-ugly-sites\">ruin their sites</a>. I replaced the video elements with a text widget that displays the latest video from a YouTube channel. Since he was mimicking the blog post layout on a static page, I configured the site to display the latest blog posts first.</p>\n<p>Once I fixed these issues, I removed the page builder and explained to my friend why it was unnecessary. He was recreating WordPress functionality and doing unnecessary work without realizing it.</p>\n<p>This experience makes me wonder how many other newer WordPress users end up in a similar situation. They don&#8217;t know what WordPress is capable of out-of-the-box and they end up installing a myriad of plugins with descriptions that sound similar to the features they want. I spent about a week undoing all of the work my friend did in three. Had I not stepped in, the site would likely not scale and its performance would decrease further.</p>\n<h2>Getting New Users Started on the Right Track</h2>\n<p>In early 2015, a community initiative dubbed <a href=\"https://make.wordpress.org/core/2015/02/05/4-2-community-initiative-nux-working-group/\">NUX Working Group</a> was created to brainstorm ideas on how to improve the new user experiences throughout the WordPress admin. While the group initially had a head of steam, it lost a lot of momentum last year. I&#8217;d like to see it re-emerge and work in concert with the <a href=\"https://wptavern.com/matt-mullenweg-announces-tech-and-design-leads-for-new-focus-based-development-cycle\">focus-based approach</a> to developing WordPress this year.</p>\n<p>How can WordPress explain to new users what its capable of without drowning them in technical information? Is it feasible to create something that caters to the majority without explaining every feature in detail? <a href=\"https://codex.wordpress.org/Version_3.3\">Admin Pointers</a> were introduced in WordPress 3.3 and while they&#8217;re typically used to introduce new features in a release, they don&#8217;t act as a guided tour to what WordPress can do.</p>\n<p>Education is likely a key component to improving the new user experience. WordPress.com has a <a href=\"https://learn.wordpress.com/get-started/\">12-step beginner&#8217;s guide</a> that walks people through the process of configuring and customizing their sites. For self-hosted WordPress users, there&#8217;s a <a href=\"https://codex.wordpress.org/New_To_WordPress_-_Where_to_Start\">New to WordPress &#8211; Where to Start guide</a> that covers what WordPress is, choosing a host, and considerations to keep in mind. However, much of the information is technical in nature.</p>\n<p>If you&#8217;re a consultant or coach who works with people new to WordPress, how do you handle the educational part of your projects? What are the most common roadblocks that they encounter? Do you have a custom-made getting started guide or do you forward them to a site with video tutorials like <a href=\"https://wordpress.tv/\">WordPress.TV</a> or <a href=\"https://www.wp101.com/\">WP101</a>?</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jan 2017 19:19:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: Incubator WordCamp Denpasar a Success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64903\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com/incubator-wordcamp-denpasar-a-success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4625:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/taylor-lovett.jpg?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/taylor-lovett.jpg?resize=150%2C150&ssl=1\" alt=\"\" class=\"alignright size-thumbnail wp-image-64907\" /></a>This post was contributed by guest author Taylor Lovett. Lovett is based in the Washington DC area, is the Director of Web Engineering at <a href=\"https://10up.com\" target=\"_blank\">10up</a>, creator of ElasticPress, and general open source enthusiast.<br />\n&nbsp;</p>\n<hr />\n<p>In February 2016, the <a href=\"http://wordpressfoundation.org/\" target=\"_blank\">WordPress Foundation</a> announced the <a href=\"https://wordpress.org/news/2016/02/experiment-wordcamp-incubator/\" target=\"_blank\">WordCamp incubator program</a>, focused on spreading WordPress and open source values to remote areas of the world through extra hands-on support to first time WordCamps. WordCamp Denpasar, which took place in Bali’s capital city, is the first of three camps to be supported as a part of the program — other WordCamps include Harare and Medellín. As Director of Web Engineering at <a href=\"https://10up.com\" target=\"_blank\">10up</a>, I was sent to attend and speak at the inaugural event. Our company values open source projects and the WordPress community, so we’re proud to support emerging communities by attending events like this.</p>\n<p>The incubator program supports WordCamps by providing them with an experienced organizer. In Denpasar’s case, Rocio Valdivia, a Community Wrangler for Automattic, was the WordCamp Incubator sponsored organizer. According to Ivan Kristianto, the lead organizer for WordCamp Denpasar, “Rocio was a hands-on consultant provided by the WordPress Foundation to help incubate the camp. She helped [us] in budgeting, managing the organizers, submission timelines, and more”.</p>\n<p>WordCamp Denpasar attracted 180 attendees, twice the initial goal. Many attendees came from other parts of Indonesia to attend the Camp, which bubbled with an aura of excitement as Indonesia has not had a WordCamp in over three years. The venue, the <a href=\"http://www.sofitel.com/gb/hotel-5551-the-royal-beach-seminyak-bali-mgallery-collection/index.shtml\" target=\"_blank\">Royal Beach Seminyak Hotel</a>, was of ample size and served the crowd well. There was a single session track, mixed with user, business, and developer topics. Lunch included a nice buffet featuring local Balinese cuisine. Overall, the WordCamp attendance, venue, and amenities were quite impressive.</p>\n<p>The speaker lineup was diverse, with speakers from Indonesia, Australia, Europe, Japan, and the United States. Attendees were extremely enthusiastic throughout the sessions and actively engaged in questions. I was last to speak, presenting on <a href=\"https://10up.com/blog/2016/twenty-sixteen-react-nodeifywp/\" target=\"_blank\">NodeifyWP and Twenty Sixteen React</a>. WordCamp Denpasar was the debut presentation of our new isomorphic JavaScript framework. The crowd was extremely excited to hear my presentation and attendees were grateful 10up choose Bali as a first occasion to show the framework. After my talk, I received more questions than could fit in the allotted time slot.</p>\n<p>In the weeks after the Camp, I talked with Rocio about the overall success of the event and Incubator program as a whole. Rocio believed the WordCamp went extremely well. She cited some key events that followed the inaugural camp:</p>\n<ol>\n<li>The local Indonesian meetup group has grown to more than 50 new members across different groups.</li>\n<li>The existing WP Meetup Bekasi group in Indonesia has applied to join the Meetup chapter program.</li>\n<li>The non-active WP Meetup of Jakarta has now two members interested in re-activating the group and have applied to join the chapter program. They are also interested in organizing WordCamp Jakarta 2017.</li>\n<li>The WordPress Foundation has received an application for organizing WordCamp Ubud in 2017 (one hour from Denpasar) which is in pre-planning now.</li>\n<li>A WP Indonesia Slack channel is being created to connect the whole community in the country.</li>\n</ol>\n<p>Clearly, WordCamp Denpasar has had a positive effect on the Indonesian WordPress community. As more areas of the world getting involved contributing to and using WordPress, the project’s internationalization and diversity improves. If Denpasar is any indication, expanding the incubator program to more areas of the world will have long-lasting benefits within the entire WordPress community.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jan 2017 18:59:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: Matt Mullenweg Announces Tech and Design Leads for New Focus-Based Development Cycle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/matt-mullenweg-announces-tech-and-design-leads-for-new-focus-based-development-cycle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7237:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/sharpened-pencil.jpg?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/sharpened-pencil.jpg?resize=960%2C542&ssl=1\" alt=\"\" class=\"size-full wp-image-64886\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/JLXDNN5BNE\">Angelina Litvin</a>\n<p>WordPress core development is kicking off in 2017 with the new focus-based development process that Matt Mullenweg announced during the <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\" target=\"_blank\">2016 State of the Word</a>. The new approach to releases shifts WordPress from the familiar time-based release cycle to one that is more project-based. The idea is that design and user testing will lead the way and upcoming releases will ship when significant user-facing improvements are ready.</p>\n<p>Mullenweg, who will serve as the overall product lead for 2017, <a href=\"https://make.wordpress.org/core/2017/01/04/focus-tech-and-design-leads/\" target=\"_blank\">announced</a> tech and design leads for each of the three focus areas: the REST API, the editor, and the customizer.</p>\n<p>&#8220;For the REST API we’re going to work on getting first party wp-admin usage of the new endpoints, and hopefully replace all of the core places where we still use admin-ajax,&#8221; Mullenweg said. The REST API team nominated Ryan McCue and K.Adam White to take the lead on the objectives Mullenweg outlined, as well as infrastructure and endpoint performance, security, and improvements to authentication options and documentation.</p>\n<p>&#8220;The editor will endeavor to create a new page and post building experience that makes writing rich posts effortless, and has &#8216;blocks&#8217; to make it easy what today might take shortcodes, custom HTML, or &#8216;mystery meat&#8217; embed discovery,&#8221; Mullenweg said. Automattic employees Matias Ventura and Joen Asmussen will be taking point on the editor.</p>\n<p>The <a href=\"https://wordpress.org/plugins/shortcode-ui/\" target=\"_blank\">Shortcake UI</a> feature plugin is one attempt at giving the existing shortcodes feature a more user-friendly interface, but contributors are also exploring other ideas for simplifying the experience of adding rich content to posts. Ella Van Dorpe recently posted an idea for <a href=\"https://make.wordpress.org/core/2016/12/24/idea-uniform-resource-identifiers-as-an-alternative-to-shortcodes/\" target=\"_blank\">using uniform resource identifiers as an alternative to shortcodes</a> in certain use cases. This would work similar to <a href=\"https://codex.wordpress.org/Embeds\" target=\"_blank\">WordPress&#8217; implementation of oEmbed</a> where data is stored elsewhere and embedded in a post using a URL.</p>\n<p>Mullenweg&#8217;s proposed direction for the customizer team is to &#8220;help out the editor at first, then shift to bring those fundamental building blocks into something that could allow customization &#8216;outside of the box&#8217; of post_content, including sidebars and possibly even an entire theme.&#8221; Weston Ruter and Mel Choyce will be taking the lead on the customizer focus.</p>\n<p>Ruter and contributors have been working on a project called <a href=\"https://github.com/xwp/wp-js-widgets\" target=\"_blank\">JS Widgets</a> that uses the Customize API to power the next generation of JavaScript-widgets in core. It opens the door for managing widgets via the REST API and ties in nicely with all three focus areas.</p>\n<p>A preliminary discussion on upcoming Customizer priorities cropped up in the comments. Nick Halsey, co-maintainer of the customize component, <a href=\"https://make.wordpress.org/core/2017/01/04/focus-tech-and-design-leads/#comment-31891\" target=\"_blank\">responded</a> to the proposal of having the customizer help out the editor at first. He believes the best approach is to create the new editor within the Customize API, giving it live previews from the start.</p>\n<p>&#8220;Improving the editor within an &#8216;admin&#8217; interface that lacks live preview doesn’t address the fundamental problems with the current content editing experience and creates something that still has to be entirely rebuilt and reimagined within a live preview context eventually,&#8221; Halsey said. &#8220;If the editor is built on the Customize API first, rather than rethinking the editor and then bringing it into the live preview API, the customize and editor contributors would be able to join forces to focus on improving the content editing experience much more effectively.&#8221;</p>\n<p>It will be interesting to see what direction Mullenweg and the leads decide to take in the foundational task of architecting the new editing experience. Mullenweg made it clear in the State of the Word address that he would like to see Calypso or a similar interface replace wp-admin in the future. However, Calypso was not built using the Customize API, WordPress&#8217; own single page application admin interface that plugins and themes already widely support.</p>\n<p>After WordCamp US, I asked Mullenweg about his intentions for Calypso in relationship to WordPress core. He said the application was &#8220;designed to be in core someday,&#8221; which is one reason they selected the same license and made it open source.</p>\n<p>&#8220;My real hope is that it is something that is ready for core someday &#8211; both Calypso the interface and the concept.&#8221; Mullenweg said. &#8220;That&#8217;s why I said Calypso or something like it. There&#8217;s obviously a lot of WordPress.com stuff in Calypso that will never be in core. If we think of a wp-admin replacement, it would be replacing wp-admin with the parts that Calypso does that are the same thing, kind of more of the my sites section of it. But I do believe the future of a great wp-admin experience is JavaScript &#8211; probably React, talking to APIs, super fast, and maybe even working offline.&#8221;</p>\n<p>Automattic is actively recruiting popular plugin authors to make their plugins Calypso-aware. Demonstrating the application&#8217;s interoperability with the WordPress plugin ecosystem is a must before Calypso can be considered a promising replacement for the WordPress admin. In the meantime, the foundation for a new page and post building experience is being laid with consideration for how the customizer can improve the editor.</p>\n<p>Mullenweg responded to comments on the post indicating that feature plugins or other improvements to WordPress outside of the three focus areas would need to continue on as plugins for the time being. However, performance improvements may be included in minor releases.</p>\n<p>&#8220;What goes in a minor release will broaden a bit, which I know is something we have to approach carefully, but performance is very important and improvements will be something I will consider for being in a minor release,&#8221; Mullenweg said. Contributors are currently working on <a href=\"https://make.wordpress.org/core/tag/4-7-1/\" target=\"_blank\">WordPress 4.7.1</a>, which is planned for release on Tuesday, January 10.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jan 2017 00:00:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"WPTavern: Micro.blog Surpasses Kickstarter Funding Goal, Set to Launch New Social Network for Independent Microblogs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64805\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"https://wptavern.com/micro-blog-surpasses-kickstarter-funding-goal-set-to-launch-new-social-network-for-independent-microblogs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6754:\"<p>Developer <a href=\"http://www.manton.org/\" target=\"_blank\">Manton Reece</a> is on a mission to take back short form content for the open web by providing better tools for independent microblogging. Most short form content today is posted through centralized social networking sites like Facebook, Twitter, and Instagram, where posts are mixed with promoted content and users have no control of their timelines. There&#8217;s no guarantee that these social networks will be around forever, as many before them have disappeared, eclipsed by new ways to connect online.</p>\n<p>Reece set out to create <a href=\"http://micro.blog/\" target=\"_blank\">Micro.blog</a>, a timeline and publishing platform for the open web, as an alternative social network that encourages more independent writing. He <a href=\"https://www.kickstarter.com/projects/manton/indie-microblogging-owning-your-short-form-writing\" target=\"_blank\">launched a Kickstarter campaign</a> to fund the platform along with his work on a book called Indie Microblogging. The project&#8217;s $10K goal was fully funded on the first day and has passed $22,000 on the second day of the campaign.</p>\n<p>Micro.blog has a timeline experience similar to Twitter with replies and favorites, but the main difference is that it is based on RSS, pulling posts from independent sites. Those who don&#8217;t have their own websites will be able to opt for a hosted microblog and map a custom domain. Users with hosted microblogs can post via a web interface that includes a Markdown editor or use the service&#8217;s iPhone app.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/micro-blog-1.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/micro-blog-1.png?resize=1025%2C590&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64853\" /></a></p>\n<h3>Micro.blog Will Integrate with WordPress</h3>\n<p>Reece, who self-hosts <a href=\"http://manton.org/\" target=\"_blank\">his own blog</a> on WordPress, will be launching Micro.blog with full integration for WordPress users, making it easy to cross post between the two platforms. I asked him about the workflow for publishing from WordPress and he said his Indie Microblogging book will contain a section specifically on WordPress.</p>\n<p>&#8220;After you&#8217;ve told Micro.blog about your WordPress RSS feed, you can continue to post to your blog as you normally would, although I&#8217;ll have some tips for taking the best advantage of it,&#8221; Reece said. &#8220;There&#8217;s also a native iPhone app for Micro.blog that supports direct posting to WordPress. I&#8217;ve found that it really improves the user experience to have a single app with a timeline experience, replies, favorites, as well as easy posting directly to your own site. But there&#8217;s no requirement to use any specific app.&#8221;</p>\n<p>Reece said he plans to implement a very strict, reverse-chronological timeline for content that users are following. He also does not plan to introduce any algorithms or advertising. Basic accounts will be free and the plan is to sustain the platform with revenue from a paid plan that includes extra features like microblog hosting.</p>\n<p>&#8220;One thing that is very important to me is not letting someone you don&#8217;t follow interrupt your timeline with harassment or other replies that aren&#8217;t appropriate,&#8221; Reece said. &#8220;I&#8217;m working on some features around this that I hope will help avoid similar issues that Twitter has faced in its community, for example. So if there are any custom algorithms or curation it will be around trying to deal with abuse before it happens.&#8221;</p>\n<p>The Micro.blog platform is currently built using Ruby, Sinatra, Ember.js, MySQL, and Redis. Reece said he is in the process of rewriting some of the app with a more traditional Ruby on Rails setup.</p>\n<p>&#8220;Ember didn&#8217;t end up being a great fit for the design,&#8221; Reece said. &#8220;There is also a portion of the microblog publishing engine built on Jekyll, so that themes and data files can be more portable.&#8221;</p>\n<p>Micro.blog isn&#8217;t entirely distributed where users host their own &#8220;pods&#8221; like Diaspora, but Reece said he is open to making it more decentralized in the future.</p>\n<p>&#8220;It&#8217;s a good goal to eventually move to something even more distributed, but it introduces a lot of complexity, which has prevented most of those kind of solutions from taking off,&#8221; Reece said. &#8220;I hope that Micro.blog is a step in the right direction, encouraging people to write more on their own site even for short microblog posts, instead of just Twitter and Facebook, with more open formats and APIs. It&#8217;s more achievable if we can build off of tools like WordPress instead of starting over.&#8221;</p>\n<p>Reece said he thinks WordPress.com (Automattic) is one of only a couple web publishing companies he believes could last 100 years. &#8220;Only 2 companies keep coming to mind: WordPress.com and GitHub,&#8221; he said in a <a href=\"http://mirror.manton.org/2015/09/complete-mirror-of-this-blog.html\" target=\"_blank\">post about mirroring his blog to GitHub</a>. &#8220;I believe both will last for decades, maybe even 100 years, and both embrace the open web in a way that most other centralized web sites do not.&#8221;</p>\n<p>During his 14 years of blogging and 10 years of using Twitter, Reece became an advocate for the open web. He said he used to be excited about Twitter and built apps for the platform but grew disillusioned at their approach to locking down the API.</p>\n<p>&#8220;We&#8217;ve been so focused on writing on Twitter and Facebook that we&#8217;ve gotten away from more independent publishing that makes blogs and the open web great,&#8221; Reece said. &#8220;I think microblogging has a place on the open web, and that posting to a blog and reading posts from friends can have just as great a user experience as using a traditional social network. I&#8217;ve already heard from many people who have been inspired recently to blog again, which is really the main goal of Micro.blog.&#8221;</p>\n<p>The <a href=\"https://www.kickstarter.com/projects/manton/indie-microblogging-owning-your-short-form-writing/community\" target=\"_blank\">Micro.blog Kickstarter campaign</a> will end in 27 days. Reece said he was surprised the project was funded so quickly. He plans to work hard over the next month to roll out Micro.blog to everyone.</p>\n<p>&#8220;I can&#8217;t wait to see how users use the service, how the book can help WordPress users expand their existing blogs, and what developers want to build on the APIs going forward,&#8221; Reece said.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Jan 2017 23:14:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"HeroPress: We Are The Same\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1556\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://heropress.com/essays/we-are-the-same/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9064:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/01/010417-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: To every woman... we are the same. I am you and you are me.\" /><p><em>Topher asked me to write an article for HeroPress as we sat together in an alcove in the Philly Convention Center. I was in a vulnerable space. My lightning talk at WordCamp US had concluded, and I was settling into the experience of being at another WordCamp. I thought about the life experiences that brought me to my second presentation a year later, and I started to cry. Below is why.</em></p>\n<p>One of my earliest memories is attending my mother&#8217;s graduate school graduation ceremony. It was a huge achievement. I wore a pink frilly dress with afro puffs to her graduation ceremony. I am sure I was gripping someone&#8217;s leg and hiding behind them. Behind my mother, my aunt or maybe my father. I was painfully awkward and shy. Which didn&#8217;t make any sense because my family was constantly telling me, &#8216;Be quiet&#8217;. That could have been their anthem for me. Children were meant to be seen, not heard.</p>\n<blockquote><p>I think of that young Sierra Leonean American girl I was, I think back to that day, and wonder what became of her.</p></blockquote>\n<p>She grew taller, much taller, transitioned from pink dresses to a pink bedroom, and, some say, is poised. But she is still painfully awkward. You wouldn&#8217;t know it, but you can catch her at times sitting quietly at an event achingly wishing she were alone and didn’t have to perform.</p>\n<p>I project confidence because I was drafted into an oratory competition in middle school. Something about my voice caught the attention of my middle school teacher Mrs. McNeil. She entered me into one. I don&#8217;t recall what I read or the outcome. I only remember my mom driving me to my competition and her, my sister and I pulling up to a very crowded parking lot. Everything gets fuzzy after we arrived.</p>\n<p>In high school, I didn&#8217;t need to be drafted into public speaking. I had strong ideals and opinions, and when it came to debate competitions I didn&#8217;t need to fit in and be cool. All I had to do was win. I debated as a Junior Statesmen, entered the Essex County Mock Trial competition, and the High School Moot Court Tournament at Princeton University. During 10th or 11th grade I got commendations for my role as a mother whose son died due to someone&#8217;s negligence at school. I argued with the other team’s attorneys. I was distraught. I channeled my inner mother. The judge gave our Mock Trial team extra points because I made the case believable. In 11th grade my partner and I came second place in the Moot Court competition at Princeton.</p>\n<p>I live in Maplewood, New Jersey. It is a town that actively engages its children. Our administration and teachers educate us to be competitive academically and in our extracurricular activities, and to actively seek out opportunities for service.</p>\n<blockquote><p>Teachers tell us we can be great &#8211; and expectations are that we will be great.</p></blockquote>\n<p>It is ingrained in us that to whom much is given much is expected. I do the best I can to embody what is expected of me.</p>\n<p>Truthfully, as an African girl, it was wonderful to be educated like this. At home my parents, aunts and uncles expect nothing less. Outside of home and my classes and clubs, I received mixed messages about who I was and what I could achieve. I was one of a handful of Africans in a diverse community. I didn&#8217;t look African or sound African I was told growing up. And I was surprised as a child of how differently I was treated by many of the same color other than my best friend and her family in elementary school. It was fascinating. On one occasion at school I achingly experienced different treatment. A college counselor lost interest in helping me with financial aid when it came up in conversation that I was African. After that conversation she was too busy to meet with me. I went to the head of guidance instead who was fabulous.</p>\n<blockquote><p>Occasions like this make me acutely proud of where my family comes from and the sacrifices my parents made 30 plus years ago when they immigrated here.</p></blockquote>\n<p>I see in them that resilience is a must and that success is accessible through motivation, hard work, focus, education and self-improvement.</p>\n<p>As a child, I hurt at the barriers some put up when I told them I am African. And I still do. At times, we are misunderstood and misrepresented. And it doesn&#8217;t make me any less proud of my Sierra Leonean heritage.</p>\n<p>Three weeks ago, I had dinner with someone I met years ago. I mentioned something related to my heritage. She stopped for a second. She said she was surprised to hear I am African. Her enthusiasm towards me immediately drained. I wasn&#8217;t shocked. I pushed away the feeling of disappointment I feel in these occasions. I acknowledged the difference internally and it didn&#8217;t stop me from enjoying her company. It&#8217;s a situation I&#8217;ve found myself in many, many times.</p>\n<p>I was told I could be great as a child growing up in Maplewood. I let this propel me forward through each obstacle in my way, and I let this make me stand tall as I take on each daunting task before me. I took this with me to every college class and graduate class I have taken even when overpowered by feelings of inadequacy. I have been to events at places where very few people will ever have the chance to go. There are organizations I have worked for that have a competitive selection process. There are certificates I have earned that make me wonder how I gathered the strength to make it through. And there are presentations like the ones I gave at WordCamp US in 2015 and 2016 where I fought through feelings of inadequacy to stand on stage and speak before hundreds of people in the tech industry.</p>\n<blockquote><p>At these times, I think of the little Sierra Leonean American girl in the pink frilly dress with afro puffs, and wonder how she could achieve each one of these accomplishments.</p></blockquote>\n<p>I wonder how she became so warmly embraced by the WordPress community, invited to plan WordCamp NYC at the United Nations in 2016, and invited to be a co-organizer of Meetups in NYC. It reflects how inclusive our community is.</p>\n<p>I think of my gender, my color, and my heritage.</p>\n<p>To every woman &#8211; we are the same. And, even if we glance at each other and look away, I am you and you are me. We can’t let anyone convince us otherwise.</p>\n<blockquote><p>I think of the African girl on the continent who doesn’t have the choices and resources I have. I cry for her, and I cry for me.</p></blockquote>\n<p>I cry because I may never meet her, never look deeply into her eyes, never tell her that she will be great, give her the resources she needs to fully realize her dreams and give her the space to be embraced by the WordPress community. Make no mistake in this digital age that this little girl is aware of what she doesn’t have, and that she needs us to propel her forward.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: We Are The Same\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=We%20Are%20The%20Same&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwe-are-the-same%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: We Are The Same\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fwe-are-the-same%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwe-are-the-same%2F&title=We+Are+The+Same\" rel=\"nofollow\" target=\"_blank\" title=\"Share: We Are The Same\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/we-are-the-same/&media=https://heropress.com/wp-content/uploads/2017/01/010417-150x150.jpg&description=We Are The Same\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: We Are The Same\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/we-are-the-same/\" title=\"We Are The Same\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/we-are-the-same/\">We Are The Same</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Jan 2017 12:00:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Winstina Hughes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: W3Techs Ranks WordPress as the Fastest Growing CMS of 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64826\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/w3techs-ranks-wordpress-as-the-fastest-growing-cms-of-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3019:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg?resize=960%2C521&ssl=1\" alt=\"\" class=\"size-full wp-image-54799\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/3ZHG0XOIT6\">Luis Llerena</a>\n<p>W3Techs published its <a href=\"https://w3techs.com/blog/entry/web_technologies_of_the_year_2016\" target=\"_blank\">Web Technologies of 2016</a> report today, compiling technologies that saw the largest increase in usage last year. The survey pulls data from the top 10 million sites (according to Alexa rankings) and compares the number of sites for each technology by measuring the difference from January 1, 2016 to January 1, 2017.</p>\n<p>W3Techs ranks WordPress as the fastest growing content management system with 58.5% market share. Shopify and Squarespace demonstrated the second and third largest increases in usage. Squarespace is a newcomer to the top three. In <a href=\"https://w3techs.com/blog/entry/web_technologies_of_the_year_2015\" target=\"_blank\">2015</a> the second and third place winners were Drupal and Shopify. WordPress has dominated the top spot every year since 2010.</p>\n<p>CMS usage on the whole saw a 3.3% increase. Of the top 15 CMS&#8217;s only six demonstrated growth, including the aforementioned top three, as well as Joomla, Drupal, and Bitrix, which showed nominal 0.1% increases in market share by the end of 2016. Blogger is on the decline, and the remaining CMS&#8217;s showed no increase or decrease.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/cms-usage-2016.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/cms-usage-2016.png?resize=1025%2C444&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64832\" /></a></p>\n<p>PHP regained its top ranking among server-side programming languages as the fastest growing in 2016, a title which it temporarily lost to Java in 2015. W3Techs estimates PHP to be used by 82.4% of all websites for which it can detect a server-side programming language.</p>\n<p>Another interesting result of the survey is that &#8220;WordPress Jetpack,&#8221; the stats module in Jetpack, ranks third among the fastest growing traffic analysis tools, trailing Google Analytics and Yandex.Metrika. Jetpack Stats has been on a slow upward trend, rising from 1.6% in 2011 to 4.5% in 2017. The top fastest growing players in this category have repeated several years in a row.</p>\n<p>It&#8217;s important to note that many Jetpack stats users also use Google Analytics, but these numbers also give a rough idea of Jetpack usage increase, since it is one of the most popular modules in the plugin. According to W3Techs, <a href=\"https://w3techs.com/technologies/details/ta-wordpressstats/all/all\" target=\"_blank\">Jetpack Stats</a> is used by 6.9% of sites for which it can detect a traffic analysis tool, which it estimates as 4.5% of all websites.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Jan 2017 23:03:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: WP-CLI Gets Official WordPress.org Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64789\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/wp-cli-gets-official-wordpress-org-support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5086:\"<p>The WP-CLI open source project will be coming under the WordPress.org umbrella in 2017. After recent talks with Daniel Bachhuber, WP-CLI&#8217;s official maintainer, Matt Mullenweg <a href=\"https://make.wordpress.org/core/2016/12/28/supporting-the-future-of-wp-cli/\" target=\"_blank\">announced WordPress&#8217; support for the project</a>, calling it &#8220;one of the highest impact developments for WP in many years.&#8221; The wp-cli.org website will soon be migrated to WordPress.org and a <a href=\"https://make.wordpress.org/cli/\" target=\"_blank\">CLI Make site</a> with its own P2 is now available to contributors.</p>\n<p>&#8220;As we head into 2017, I wanted to make sure that its future is certain for everyone who builds on it, and that the major contributors to the project, chiefly Daniel Bachhuber, are able to work on it even more in the coming year,&#8221; Mullenweg said. Now that the project is part of WordPress.org, Mullenweg said he will be leading a coalition of companies to &#8220;solidify their financial support&#8221; of <a href=\"http://wp-cli.org/blog/the-big-question.html\" target=\"_blank\">the existing fundraising effort</a> that Bachhuber launched in mid-December 2016.</p>\n<p>The logistics of the new funding model haven&#8217;t yet been completely ironed out, but Bachhuber says <a href=\"https://runcommand.io/\" target=\"_blank\">runcommand</a> will not be shutting down.</p>\n<p>&#8220;Runcommand&#8217;s sole focus will be to hire people to work on WP-CLI,&#8221; he said. &#8220;This hybrid approach better ensures WP-CLI&#8217;s long-term future (e.g. the project is under the wing of the WordPress project), while also being a creative way for paying for dedicated resources to it.&#8221;</p>\n<p>Bachhuber explored different funding models for WP CLI throughout 2016 without much success. When discussions about making it an official WordPress core project first began, he was leaning towards keeping WP-CLI operating as an independent project. The new hybrid approach gives companies the opportunity to financially support an official WordPress project via runcommand, where Bachhuber hopes to hire additional maintainers on a part-time basis.</p>\n<p>&#8220;I&#8217;ve thought a lot about funding open source over the last year,&#8221; Bachhuber said. &#8220;In the context of WP-CLI, I came to the conclusion that I didn&#8217;t have confidence in WP-CLI being a completely independent project + financially sustainable business.&#8221;</p>\n<p>Bachhuber said he feels &#8220;reasonably confident&#8221; about the future of the project after recent developments and hopes to have funding for a few part-time maintainers.</p>\n<p>&#8220;I think part-time is key because each of us needs to be working / solving problems in the real-world, and then taking those solutions back to the project,&#8221; Bachhuber said. Although many open source projects operate without paying people for contributions, he believes there is an important distinction between maintainers and contributors.</p>\n<p>&#8220;Contributors act in a voluntary manner (e.g. contributing code when they have a couple hours free),&#8221; Bachhuber said. &#8220;Maintainers take responsibility for the project, showing up every day, and doing most of the unglamorous work. I think maintainership is an important aspect of a healthy open source project. Everyone has an example of an open source project they use that&#8217;s no longer maintained and how painful it is to be dependent on it.&#8221;</p>\n<p>Responses to the news of WP-CLI gaining official WordPress.org support were overwhelmingly positive, as the tool is critical to the WordPress developer community. The decision to have WP-CLI operate under WordPress.org&#8217;s umbrella makes it better positioned to drive the financial support needed to sustain the ongoing burden of maintainership.</p>\n<p>Bachhuber said the current fundraising effort, which is <a href=\"https://wptavern.com/wp-cli-project-launches-patron-support-model-to-fund-ongoing-development\" target=\"_blank\">based on a patron support model</a>, is approximately 1/5 of the way to his funding goal. He is still waiting to hear from a number of large players but the funding drive will remain open indefinitely for now. Bachhuber said they will re-evaluate once they reach the goal.</p>\n<p>&#8220;I consider this the best possible outcome of my efforts trying to identify sustainability for the project over the last year,&#8221; Bachhuber said in the <a href=\"https://make.wordpress.org/cli/2017/01/03/lets-do-this/\" target=\"_blank\">first post</a> on the Make WordPress CLI site. &#8220;The decision to make WP-CLI an official WordPress project also means there’s a clear path forward for me to invest more of my own time into the <a href=\"http://wp-cli.org/docs/roadmap/\" target=\"_blank\">WP-CLI roadmap</a>. Concurrent with the transition process over the next couple of months, I want to move forward the conversation of how we realize a future where WP-CLI is the fastest way to do anything with WordPress.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Jan 2017 06:50:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"HeroPress: Help a HeroPress friend\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=1553\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://heropress.com/help-heropress-friend/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2334:\"<p>Hey folks, HeroPress contributor Michael Beil is fighting for his life right now. Michael&#8217;s a personal friend, and a tremendous person. There&#8217;s an <a href=\"https://www.plumfund.com/financial-hardship/michael-john-beil\">online donation form</a> to help with medical bills and life in general. If you can, please help out.</p>\n<p><a href=\"https://heropress.com/essays/life-without-limits/\">You can read Michael&#8217;s HeroPress essay here</a>.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Help a HeroPress friend\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Help%20a%20HeroPress%20friend&via=heropress&url=https%3A%2F%2Fheropress.com%2Fhelp-heropress-friend%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Help a HeroPress friend\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fhelp-heropress-friend%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fhelp-heropress-friend%2F&title=Help+a+HeroPress+friend\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Help a HeroPress friend\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/help-heropress-friend/&media=http://heropress.com/wp-content/plugins/rtsocial/images/default-pinterest.png&description=Help a HeroPress friend\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Help a HeroPress friend\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/help-heropress-friend/\" title=\"Help a HeroPress friend\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/help-heropress-friend/\">Help a HeroPress friend</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 31 Dec 2016 01:20:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: WPWeekly Episode 258 – 2016 Year in Review Part 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=64794&preview=true&preview_id=64794\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/wpweekly-episode-258-2016-year-in-review-part-1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1078:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I recap the news and headlines of the first half of 2016. Part two will be recorded on January 4th, 2017, where we&#8217;ll look back at the headlines during the second half of 2016, give our predictions for 2017, and share what we&#8217;re looking forward to in the new year.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, January 4th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #258:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Dec 2016 21:45:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Post Status: What we want from WordPress in 2017, live from Post Status Publish\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=31717\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://poststatus.com/post-status-draft-live-at-publish/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1751:\"<p>After Post Status Publish&#8217;s main talks concluded, Joe Hoyle and I recorded the podcast during the reception. It was a laid back format where we discuss the future of WordPress, including our own wishlist features, and then we spent the majority of the hour taking questions from the audience.</p>\n<p>We recorded this prior to the announcement of the <a href=\"https://poststatus.com/matt-mullenweg-state-word-2016/\">new development schedule</a> and changes to major releases, but most of our conversation remains relevant, as many of our wishlist items are within the three release focus areas that have been chosen.</p>\n<p>You can listen to just the audio, also on our podcast, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher.</p>\n<!--[if lt IE 9]><script>document.createElement(\'audio\');</script><![endif]-->\n<a href=\"https://audio.simplecast.com/56018.mp3\">https://audio.simplecast.com/56018.mp3</a>\n<p><a href=\"https://audio.simplecast.com/56018.mp3\">Direct Download</a></p>\n<p>Or just watch the <a href=\"https://youtu.be/Xoteb83jmD8\">video on YouTube</a>, or below for the full experience. And don&#8217;t forget to subscribe to <a href=\"https://www.youtube.com/c/PostStatus\">my new channel on YouTube</a>.</p>\n<p></p>\n<p>The rest of the videos from <a href=\"https://poststatus.com/publish\">Publish</a> are available to Post Status members.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Dec 2016 15:21:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"HeroPress: Over The Atlantic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1545\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://heropress.com/essays/over-the-atlantic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6054:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/12/122816-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I\'ve come to realise the WordPress community doesn\'t tolerate bad actors.\" /><p>I’m on a plane. They’ve just served lunch and I realise I’m stuck. There isn’t enough room to slip out for a bathroom break without tipping my meal and the trolley blocks the aisle.</p>\n<p>I cough and notice I’m tense, what’s going on? I enjoy flying, why should today be any different? Is it that I might be sick? Maybe it’s shovelling clothes off of the dining table into an open suitcase and rushing for a taxi at 6am? Or responding to a client at 11pm then playing Rimworld till 2am knowing I’d be up at 5? Maybe it’s Mr Robot? Anyone who’s seen that show knows it isn’t exactly happy.</p>\n<p>I open my watch up and try the new breathe app. I’ve installed watch apps before but never found much use from them, but this came with the update from Apple this morning so I’ll give it a go. It holds me steady but I’m still tense.</p>\n<p>I put on some music and try to eat some food. Maybe that’s the problem? I get anxious sometimes about food, it can get me in trouble. During speaker submissions for WordCamp Europe Sophia I wrote a mini rant about sandwiches and labeling. Siobhan thought it was funny, but I should know better. It was that year I saw a talk on depression.</p>\n<p>I’ve seen several people speak about it, but right now I’m anxious, and I’m typing. After WCEU 2016 I promised Topher I’d write an article for him, and I’ve been occupied. The last month or so, I’ve been working and not taking care of myself. I’m not sure if I&#8217;m actually sick or if this is burn out. I’ve noticed aches in my hands, it worries me.</p>\n<p>I think about what writing this will do. My WP Tavern article ranks higher than me on Facebook search.</p>\n<blockquote><p>There’s nothing like an article on anxiety popping up when a date searches your name. I don’t want to be known as the mental health guy.</p></blockquote>\n<p>But a promise is a promise. When I last did this people were supportive. They said nice things, they talked about their own feelings and gave talks. Nobody sent their pity.</p>\n<p>The food tray’s gone now, I’m not sure how I feel but I know there’s 2 Automatticians in front of me and 2 to the side. We land in Vancouver in 6 hours for the grand meet up, and I know I’ll get a big hug from several people. They’re genuine nice people, and I’ve come to realise the WordPress community doesn’t tolerate bad actors. We share what we think is important, what people need to hear.</p>\n<p>I’ve got one more episode of Mr Robot, I’ll think about those I see at WordCamps and close this app. It isn’t long before I can talk in person.</p>\n<hr />\n<p>I’m home! Despite a total lack of scrambled eggs on toast in not one, not two, but three major international airports, I’ve finally returned home. My friends dragged me jet lagged to a play entitled “The pacifists answer to the war on cancer” where a jolly sequinned cancer cell sings a song moments after a woman screams in agony. I got to sing happy birthday to my family with a room of Automatticians, climb a mountain, it was fun!</p>\n<p>I think about what I’ve written, and wish I’d been more positive.</p>\n<blockquote><p>Life can be scary but I’m surrounded by people who want to help.</p></blockquote>\n<p>Sometimes that’s family, or friends, but user groups and events help too. These people have the same problems and worries I do, and deal with them in many ways.</p>\n<p>Importantly, they’re willing to talk about their problems in front of hundreds of people, and share their solutions. I feel it’s something that isn’t mentioned often enough. Burnout and stress is rampant in our industry, and I’m glad people are stepping up to the challenge.</p>\n<p>I’m a lead organiser for a WordCamp Manchester now. That means I can’t speak at my own conference, but I’m hoping to get a good talk or two. Maybe things aren’t so terrible? Maybe next time I’ll get a window seat.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Over The Atlantic\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Over%20The%20Atlantic&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fover-the-atlantic%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Over The Atlantic\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fover-the-atlantic%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fover-the-atlantic%2F&title=Over+The+Atlantic\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Over The Atlantic\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/over-the-atlantic/&media=https://heropress.com/wp-content/uploads/2016/12/122816-150x150.jpg&description=Over The Atlantic\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Over The Atlantic\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/over-the-atlantic/\" title=\"Over The Atlantic\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/over-the-atlantic/\">Over The Atlantic</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Dec 2016 12:00:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Tom Nowell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Matt: Christmas Music: Leslie Odom Jr.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47002\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://ma.tt/2016/12/christmas-music-leslie-odom-jr/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:629:\"<p>I love Christmas music, and <a href=\"https://ma.tt/2013/12/christmas-jazz-music/\">most years</a> I like to recommend a Christmas music album that is a bit more jazz or has something interesting about it. This year I want to point you to Leslie Odom Jr., aka Aaron Burr in the hit musical Hamilton, who is a gifted vocalist. <cite>Hat tip: Rose Kuo.</cite> Check out &#8220;My Favorite Things.&#8221; Embedded on Spotify below, also on <a href=\"https://itunes.apple.com/us/album/simply-christmas/id1170245823\">iTunes</a> and <a href=\"https://www.amazon.com/Simply-Christmas-Leslie-Odom-Jr/dp/B01L22Y87K\">Amazon</a>.</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 Dec 2016 18:18:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WPTavern: BuddyPress 2.7.4 Patches Security Vulnerability That Could Allow Arbitrary File Deletion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=64736&preview=true&preview_id=64736\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wptavern.com/buddypress-2-7-4-patches-security-vulnerability-that-could-allow-arbitrary-file-deletion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1223:\"<p>The BuddyPress development team has <a href=\"https://buddypress.org/2016/12/buddypress-2-7-4-security-release/\">released BuddyPress 2.7.4</a> to address a security vulnerability that affects all versions back to 2.0.</p>\n<p>According to John James Jacoby, lead developer of BuddyPress, &#8220;This version patches a vulnerability to the BuddyPress core attachments API that could allow arbitrary file deletion on certain installation configurations.&#8221;</p>\n<p>The vulnerability was responsibly disclosed by Sam Pizzey through the <a href=\"https://hackerone.com/automattic\">HackerOne bounty program</a>. Although Automattic primarily uses the service for its own products, they accept reports for open source projects such as WordPress and BuddyPress.</p>\n<p>Boone Gorges and Paul Gibbs collaborated on a fix for all affected versions of BuddyPress while Stephen Edgar and Dion helped package the release. Those who use BuddyPress are highly encouraged to update as soon as possible to protect against this vulnerability. If you encounter any issues or need help, please create a post on the project&#8217;s<a href=\"https://buddypress.org/support/\"> support forums.</a></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Dec 2016 19:59:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"BuddyPress: BuddyPress 2.7.4 – Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=262326\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://buddypress.org/2016/12/buddypress-2-7-4-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1235:\"<p>BuddyPress 2.7.4 is now available, and is a security release &amp; recommended upgrade for all BuddyPress installations. We&#8217;ve also ported the code changes in 2.7.4 to all branches back 2.0, and are pushing updates out for all installations where we are able to do so.</p>\n<p>These releases include a fix to the BuddyPress core attachments API that could allow arbitrary file deletion on certain installation configurations.</p>\n<p>This bug was responsibly disclosed to the WordPress security team (and the BuddyPress team) through the WordPress HackerOne Bounty Program by Sam Pizzey (mopman).</p>\n<p>Both Boone &amp; Paul worked together to fix this for all versions of BuddyPress that are currently in active use, and Stephen &amp; Dion helped package and push these releases out.</p>\n<p>Please update to these latest versions of BuddyPress today in your WordPress Dashboard, or by <a href=\"https://wordpress.org/plugins/buddypress/\">downloading from the wordpress.org plugin repository</a>.</p>\n<p>Questions or comments? Check out the <a href=\"https://codex.buddypress.org/releases/version-2-7-4/\">2.7.4 changelog</a>, or stop by our <a href=\"https://buddypress.org/support/\">support forums</a> or  Trac.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Dec 2016 02:25:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPTavern: WordPress.org Launches Homepage Redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64708\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wptavern.com/wordpress-org-launches-homepage-redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2790:\"<p><a href=\"https://wordpress.org/\" target=\"_blank\">WordPress.org</a> made its new <a href=\"https://wptavern.com/the-wordpress-org-homepage-is-getting-a-redesign\" target=\"_blank\">homepage redesign</a> live today. The meta team worked quickly to put the new design in place in time for the holidays.</p>\n<p>&#8220;While this is only the first iteration, the plan is to continue design and development to create something truly amazing,&#8221; Mark Uraine said in the <a href=\"https://make.wordpress.org/meta/2016/12/22/new-homepage-is-launched/\" target=\"_blank\">announcement</a>. &#8220;This is the first step toward that goal.&#8221;</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordpress-homepage-new-design-e1482443742169.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordpress-homepage-new-design-e1482443742169.png?resize=1025%2C854&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64722\" /></a></p>\n<p>The header and footer have been kept from the previous design. According to meta team member Samuel Wood, matching them to the new design is beyond the scope of this first iteration.</p>\n<p>&#8220;The header and footer are global pieces,&#8221; Wood said. &#8220;Redesigning them, in any way, will have to be part of a much larger effort in redesigning, well, everything. The entire site would need adjustments to adjust them.&#8221;</p>\n<p>Uraine <a href=\"https://make.wordpress.org/meta/2016/12/12/new-homepage-redesign/#comment-8739\" target=\"_blank\">said</a> in a previous post that there are iterations underway for a new, more minimal header that better aligns with the new homepage style.</p>\n<p>Feedback on the <a href=\"https://make.wordpress.org/meta/2016/12/12/new-homepage-redesign/\" target=\"_blank\">initial draft</a> included notes on the copy, particularly the &#8220;Meet WordPress&#8221; headline. One person commented on it not being inclusive of people who have already met WordPress and are returning. Also, a few found the tagline to be too narrow: <em>WordPress is open source software you can use to create a beautiful website, blog, or app.</em> Some suggested the inclusion of other use cases, such as store, forum, and membership site. These ideas have not been incorporated but they were recognized by the design team in the comments on the initial draft.</p>\n<p>The homepage redesign went from sketches to prototype to live on WordPress.org in a matter of a couple weeks. Feedback has been overwhelmingly positive so far, and most see it as a huge improvement. The new design should receive a great deal more exposure now that it&#8217;s live, which will hopefully bring in more varied perspectives towards making it extraordinary in future iterations.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Dec 2016 23:13:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: New .org Homepage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46996\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://ma.tt/2016/12/new-org-homepage/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:410:\"<p>For the first time in&#8230; many years, <a href=\"https://wordpress.org/\">WordPress.org has a new home page</a>. What&#8217;s on the page today actually isn&#8217;t that important, even though it&#8217;s better in many ways, the key is that it&#8217;s changing again, the stone has <a href=\"https://make.wordpress.org/meta/2016/12/22/new-homepage-is-launched/\">been unstuck</a> and can now keep rolling.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Dec 2016 22:10:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: WPWeekly Episode 257 – My Side Project, WordPress 4.7, and the News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=64711&preview=true&preview_id=64711\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wptavern.com/wpweekly-episode-257-my-side-project-wordpress-4-7-and-the-news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3589:\"<p>In this episode of WordPress Weekly, <a href=\"http://www.marcuscouch.com/\">Marcus Couch</a> and I discuss the news of the week including, WooCommerce&#8217;s 42% market share, the redesign concept of WordPress.org, and two plugin acquisitions. I also share details of a side project I&#8217;m working on that involves BuddyPress. Last but not least, we briefly discuss <a href=\"https://twitter.com/kingjeff2\">Jeff King&#8217;s</a> impact on GoDaddy as he&#8217;s leaving the company at the end of this year.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/wordpress-4-7-introduces-twenty-seventeen-default-theme-and-wp-rest-api-content-endpoints\">WordPress 4.7 Introduces Twenty Seventeen Default Theme and WP REST API Content Endpoints</a><br />\n<a href=\"https://wptavern.com/the-wordpress-org-homepage-is-getting-a-redesign\">The WordPress.org Homepage is Getting a Redesign</a><br />\n<a href=\"https://wptavern.com/woocommerce-powers-42-of-all-online-stores\">WooCommerce Powers 42% of All Online Stores</a><br />\n<a href=\"https://wptavern.com/podcast-motor-acquires-seriously-simple-podcasting-plugin\">Podcast Motor Acquires Seriously Simple Podcasting Plugin</a><br />\n<a href=\"https://wptavern.com/updraftplus-acquires-wp-optimize-will-be-integrated-into-updraftcentral\">UpdraftPlus Acquires WP-Optimize, Will Be Integrated Into UpdraftCentral</a><br />\n<a href=\"https://wptavern.com/wordpress-com-launches-vr-content-coming-soon-to-jetpack\">WordPress.com Launches VR Content, Coming Soon to Jetpack</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/wp-youtube-live/\">WP YouTube Live</a> displays a YouTube live video from a specified channel via shortcode. There are several shortcode options available that allow you to autoplay and change the video&#8217;s dimensions. There&#8217;s also an option to not display a video if there isn&#8217;t a live video taking place.</p>\n<p><a href=\"https://wordpress.org/plugins/woo-floating-cart-lite/\">Woo Floating Cart Lite</a> is an interactive floating cart for WooCommerce that slides into view when a user decides to buy an item. Products, quantities, and prices are updated instantly via AJAX. It&#8217;s similar to many of the professional carts you may have seen at the big retail stores where the cart is in view at all times.</p>\n<p><a href=\"https://wordpress.org/plugins/import-facebook-events/\">Import Facebook Events</a> allows you to import events from Facebook into <a href=\"https://wordpress.org/plugins/the-events-calendar/\">The Events Calendar</a> and <a href=\"https://wordpress.org/plugins/events-manager/\">Events Manager</a> plugins. If you are like me and use The Events Manager as your events plugin of choice, this plugin is a no-brainer as an extra add-on. As an add-on plugin this plugin needs The Events Calendar or Events Manager Installed and activated.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, December 28th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #257:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Dec 2016 21:20:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Nadia Eghbal Publishes Guide to Financial Support for Open Source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64676\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wptavern.com/nadia-eghbal-publishes-guide-to-financial-support-for-open-source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4614:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/lemonade-stand.jpg?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/lemonade-stand.jpg?resize=1024%2C577&ssl=1\" alt=\"\" class=\"size-full wp-image-64693\" /></a>photo credit: rachaelvoorhees <a href=\"http://www.flickr.com/photos/17237319@N00/2521106411\">A Young Entrepreneur on a Hot Day at Portland State</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">(license)</a>\n<p>If you want to make a living in the world of open source software, <a href=\"http://nadiaeghbal.com/\" target=\"_blank\">Nadia Eghbal</a> has created a <a href=\"https://github.com/nayafia/lemonade-stand#consulting--services\" target=\"_blank\">guide</a> that explores various models for funding your work. Eghbal, who has written extensively on <a href=\"http://nadiaeghbal.com/oss\" target=\"_blank\">sustainability and open source</a>, recently authored <a href=\"https://wptavern.com/ford-foundation-publishes-non-technical-white-paper-on-open-source-software-and-the-challenges-of-sustaining-digital-infrastructure\" target=\"_blank\">a white paper published by the Ford Foundation</a> called “Roads and Bridges: The Unseen Labor Behind Our Digital Infrastructure.” The whitepaper was written to help consumers and companies understand the challenges of sustaining open source software.</p>\n<p>Eghbal published &#8220;A handy guide to financial support for open source&#8221; on GitHub so that others with experience can contribute to the reference. The repository is called &#8220;<a href=\"https://github.com/nayafia/lemonade-stand\" target=\"_blank\">lemonade stand</a>,&#8221; a term that references a common summertime business venture where children cut their teeth in entrepreneurship. The lemonade stand is often used as a symbol of capitalism, a new arena that many developers will need to embrace if they want to provide a sustainable future for their open source work.</p>\n<p>Eghbal&#8217;s guide currently includes 16 different categories of funding, starting with the smallest (donations, bounties, crowdfunding) to the largest (foundations, consortiums, and venture capital). The funding categories explore pros, cons, and relevent case studies where the particular model has been explored.</p>\n<p>&#8220;The purpose of this guide is to provide an exhaustive list of all the ways you can get paid, so that you can figure out what works best for you,&#8221; Eghbal said. It has already received additions from 12 contributors, including Daniel Bachhuber, who is currently <a href=\"https://wptavern.com/wp-cli-project-launches-patron-support-model-to-fund-ongoing-development\" target=\"_blank\">exploring a patron support model to fund his work on WP-CLI</a>.</p>\n<p>With a few notable exceptions like Red Hat and Linux, open source projects suffer from a severe lack of funding, a problem which Eghbal calls &#8220;<a href=\"https://medium.com/@nayafia/how-i-stumbled-upon-the-internet-s-biggest-blind-spot-b9aa23618c58#.6efp8nk2c\" target=\"_blank\">the internet&#8217;s biggest blind spot</a>.&#8221; She notes that the problem of funding digital infrastructure is relatively new but is accelerating as more people are using open source software but ignoring the developer tools everyone relies on.</p>\n<p>WP-CLI is a prime example in the WordPress community. Developers who use it are more inclined to send sporadic donations than become personally invested in maintaining the code base, which has led Bachhuber to test different funding models throughout 2016. There have been <a href=\"https://twitter.com/dd32/status/807435845724577792\" target=\"_blank\">discussions</a> about making it an official WordPress core project with the goal of widening the contributor base and ensuring its longterm future. However, Bachhuber <a href=\"https://twitter.com/danielbachhuber/status/806563582968115201\" target=\"_blank\">said</a> he &#8220;strongly believes WP-CLI should be an independent project.&#8221;</p>\n<p>Eghbal&#8217;s funding <a href=\"https://github.com/nayafia/lemonade-stand\" target=\"_blank\">guide</a> is an important document for open source software maintainers who are struggling to fund their efforts and looking for more options beyond sticking a simple download button on the project&#8217;s website. If you&#8217;re looking for more discussion on this topic, Eghbal co-produces a podcast called <a href=\"https://changelog.com/rfc/archive\" target=\"_blank\">Request for Commits</a> that explores open source&#8217;s complicated relationship with money and various sustainability models.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Dec 2016 20:00:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Wallace: A Free WordPress Theme Built on the WP REST API and Angular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64652\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wptavern.com/wallace-a-free-wordpress-theme-built-on-the-wp-rest-api-and-angular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4819:\"<p><a href=\"https://twitter.com/Bradley_Kirby\" target=\"_blank\">Bradley Kirby</a> released version 1.0 of his <a href=\"https://wallacetheme.com/\" target=\"_blank\">Wallace WordPress theme</a> today. The theme is built using the WP REST API and <a href=\"https://angular.io/\" target=\"_blank\">Angular 2</a>. Kirby has been working on Wallace for the past two years and has rewritten it several times in order to keep pace with changes in the REST API and Angular.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/wallace-theme.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/wallace-theme.png?resize=1025%2C925&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64661\" /></a></p>\n<p>If you view the <a href=\"https://demo.wallacetheme.com/\" target=\"_blank\">Wallace demo</a>, you&#8217;ll notice that the theme is super fast because the interface is rendered on the client side with JavaScript.</p>\n<p>&#8220;It really opens a whole new world of possibility for WordPress themes,&#8221; Kirby said. &#8220;For this release I&#8217;ve primarily focused on smooth page transitions. That&#8217;s just not possible with the traditional server-rendered themes. But I think there&#8217;s a lot of really cool customization techniques that the API allows for, too. That&#8217;s what I&#8217;m hoping to explore next.&#8221;</p>\n<p>Although React has emerged as <a href=\"https://wptavern.com/state-of-javascript-survey-results-published-react-emerges-as-clear-winner-in-front-end-frameworks\" target=\"_blank\">the most popular JavaScript framework for front-end development</a> in 2016, Kirby said he chose Angular mostly because he learned it first.</p>\n<p>&#8220;I really like the prescriptive nature of Angular,&#8221; Kirby said. &#8220;There&#8217;s a &#8216;right&#8217; way to do things that you&#8217;ll find in example projects and all the functionality comes with the framework itself. With React you have to use a collection of third-party libraries with various maintainers. With Angular, it&#8217;s all Google, and all one repository. I think React is a perfectly fine framework, and they actually share a lot of concepts.&#8221;</p>\n<p>Wallace currently only supports posts, but Kirby plans to implement more core WordPress features, including pages, comments, searching, and category filtering. He said those features shouldn&#8217;t be too difficult to implement now that the frame is there.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/wallace-posts.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/wallace-posts.png?resize=500%2C494&ssl=1\" alt=\"\" class=\"aligncenter size-large wp-image-64669\" /></a></p>\n<p>&#8220;From a programming perspective, this was way more difficult to create than a PHP-rendered theme, because you get so much &#8216;for free&#8217; with the PHP theming API that you don&#8217;t get when you&#8217;re just making raw requests to the REST API,&#8221; Kirby said. The primary advantage of theming with the API is more instantaneous interactions with the content, but creating API-driven themes is not yet as easy as the old way of theming.</p>\n<p>Kirby said he is actively exploring the idea of submitting Wallace to WordPress.org, but the Theme Review Team does not permit the use of Twig templates.</p>\n<p>&#8220;I&#8217;ve brought it up with the team that approves themes, and they didn&#8217;t like that I was using the Twig templating library on the PHP side,&#8221; Kirby said. &#8220;So I&#8217;d have to maintain two versions of the theme if I were to submit it to the directory.&#8221; Kirby hasn&#8217;t ruled it out yet and said he will probably revisit the idea next year.</p>\n<p>&#8220;Twig templates mirror Angular templates really nicely,&#8221; Kirby said. &#8220;It cuts down on the maintenance burden quite a bit, because I have to exactly mirror the templates on the server side and the client side. That would be more difficult if I had to construct PHP echo strings, the typical WordPress template way.&#8221;</p>\n<p>Wallace is integrated with the Customizer and will disable its JavaScript when it detects the Customizer is open, reverting back to a &#8220;normal&#8221; theme. Currently the only option users can customize is the site icon and site title. Wallace does not yet offer support for setting a static front page.</p>\n<p>The next items on Wallace&#8217;s roadmap are adding more core features into the theme. Kirby said he is also exploring the idea of creating a commercial magazine theme in the future.</p>\n<p>&#8220;I think the real killer use case for this way of developing themes is e-commerce, but I want to get a good solid magazine style premium theme done before I tackle that,&#8221; Kirby said.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Dec 2016 22:43:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: How to Make BuddyPress User Registration Invite-Only\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64644\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/how-to-make-buddypress-user-registration-invite-only\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3486:\"<p>One of the first things I recommend users do after installing WordPress is to either close user registration or install a plugin that protects the site against spam registrations. A friend of mine recently started a new WordPress site that has BuddyPress installed.</p>\n<p>After two weeks, I chipped in to help him out and discovered more than 300 registered spam accounts. To make matters worse, these accounts were able to create new groups in BuddyPress and each one contained spam content. The first thing I did was close user registration then I began the boring process of removing the accounts.</p>\n<p>We ran into an issue where legitimate users needed to create accounts while user registration was closed. After asking <a href=\"https://twitter.com/jeffr0/status/810664097868107777\">for suggestions</a> on Twitter and performing a few Google searches, I discovered the <a href=\"https://wordpress.org/plugins/invite-anyone/\">Invite Anyone</a> plugin by <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>. Invite Anyone allows registered members to invite people to register to the site via email while registration is closed.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/InviteAnyoneSettings.png?ssl=1\"><img class=\"size-full wp-image-64646\" src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/InviteAnyoneSettings.png?resize=859%2C836&ssl=1\" alt=\"Invite Anyone Settings\" /></a>Invite Anyone Settings\n<p>Using variables provided by the plugin, you can customize the email invitation subject line, the invitation message, and the text at the end of the email. I used the default values which happened to suit my needs. You can also give registered users the ability to customize the invitation subject line or message body and limit the number of emails members can send at one time. In my case, the most important setting to enable was allowing email invitations to be accepted even when site registration is disabled.</p>\n<p>There are other configuration settings as well such as controlling who can send emails and limiting group invitations. Invite Only also has <a href=\"https://www.cloudsponge.com/signup/invite-anyone/\">built-in support for CloudSponge</a>, a service where users can invite anyone from their address books without leaving your site. Stats are built-in as well but during testing I couldn&#8217;t get the Stats tab to load. The Stats tab loads the General Settings page instead.</p>\n<p>Here&#8217;s what Invite Anyone looks like from a user&#8217;s BuddyPress profile page. In addition to inviting someone to the site, users can also invite them to a BuddyPress group as well.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/InviteAnyoneFrontEnd.png?ssl=1\"><img class=\"size-full wp-image-64647\" src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/InviteAnyoneFrontEnd.png?resize=885%2C658&ssl=1\" alt=\"What Invite Anyone Looks Like on the Frontend\" /></a>What Invite Anyone Looks Like on the Frontend\n<p>I&#8217;m using this plugin on a site running WordPress 4.7 and it&#8217;s functioning as expected. So far, we&#8217;ve invited three people and all of them were able to successfully register an account despite user registration being disabled. If you use BuddyPress and need a free solution that implements a user invitation system, I recommend <a href=\"https://wordpress.org/plugins/invite-anyone/\">Invite Anyone</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Dec 2016 19:33:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"HeroPress: The WordPress Mantra Is Mine Too\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1537\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://heropress.com/essays/wordpress-mantra-mine/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8731:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/12/122116-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: The simple fact that I improve someone\'s life through my work means the world to me.\" /><h3>Transparency makes the world go round</h3>\n<p>I like being honest, so please allow me to provide a context for this story. First of all, I&#8217;m a pretty introvert kind of guy, and I often need to be thrown in the cold water to start learning how to swim. This was exactly what happened with my teammate, Oana, when she asked me if I&#8217;d be tempted to give HeroPress a go. Of course I would, and so it started the beginning of this story. The next lines are the result of a friendly dialogue between us. Enjoy the ride, dear fellows.</p>\n<p>Here&#8217;s Andrei, a passionate web dev who truly admires the WordPress world. I&#8217;m a full-time backend at Pixelgrade, a design studio where we create WordPress themes that solve real and painful digital problems. Yes, we don&#8217;t just play around with eye-candy pixels, we strive to show up with trustworthy solutions that make people&#8217;s lives easier and more pleasant.</p>\n<p>I&#8217;ve experienced an intense professional rollercoaster till I got here. I still remember the first time I met with the WordPress fascinating world. It was during my first job interview. The employer (today a good friend of mine) told me that I would need to play around with Joomla, something I loved at that time. You can laugh, it&#8217;s okay. I do the same.</p>\n<p>However, the interview was full of tricks since I needed to do something totally different: create a homepage into WordPress. This way, the team could have seen how fast I&#8217;m able to learn new stuff. Pretty good trap since everyone working in the digital playground needs to be open-minded and capable of improving their skills and knowledge.</p>\n<p>That was the very first contact with WordPress, and I was surprised to see its potential. Not only it was easy-to-learn and get along with thanks to an in-depth documentation, but it also had an active community eager to help. Fast forward and the story had a happy ending: I got the job.</p>\n<blockquote><p>Becoming better is kind of a mantra for the true WordPress people</p></blockquote>\n<p>Starting from there and since today I still appreciate WordPress from top to toe. I have a bunch of reasons why I feel this world fits my values and principles. First of all, I enjoy all the PHP talking around WordPress. I find it interesting and challenging at the same time, and every time I have the chance to get involved, I accept it without hesitations. Another great aspect is directly related to my day-to-day job at Pixelgrade. The backend universe where I can improve an amount of cool things keeps my motivation up and kicking. On top of that, I resonate with JavaScript in various ways, backend and frontend too, and from time-to-time I write down my thoughts on my personal blog. I&#8217;m always happy to share ideas and provide feedback that helps. In the end, this is all about when you think of WordPress as an ecosystem, right?</p>\n<p>Talking about this core mission, I must confess that WordPress can be felt like a lifestyle into a room with glass walls. Everyone sees what you do, how you do it, and why you keep doing it. Nobody can take your work for granted, but can easily be inspired by it and even improving it. Becoming better is kind of a mantra for the true WordPress people, and that&#8217;s why they jump in and start spreading solutions about how things can achieve a superior level. With other words, it&#8217;s like sailing with a bunch of amazing people eager to enjoy the same outstanding experience.</p>\n<p>On the other hand, there are some coders that still think that WordPress is not that sexy and challenging in the end. They&#8217;re definitely not in the same boat, but I think it&#8217;s fair from our side to help them change their mind. And not because we chose to work in this playground, mostly because this platform changed a lot in the last years.</p>\n<blockquote><p>The simple fact that I improve someone&#8217;s life through my work means the world to me.</p></blockquote>\n<p>Here are my thoughts for all those programming lovers that would like to try WordPress, but need an extra boost.</p>\n<h3>A wide range of features</h3>\n<p>Articles, menus, widgets, users, live previews, e-commerce, e-learning, listings and so on. You can administrate them, make them better, simply play around as you wish. It might sound naive, but in reality these different areas are constantly bringing all kind of challenges on the table.</p>\n<h3>Legacy code</h3>\n<p>WordPress still strives to support the PHP 5.2.4 version, which was dropped five years ago but 7.5% from today&#8217;s websites still use it. But hey, WordPress is all about keeping users on board, happy and loyal, not skipping the battle. In the end, it does say something about the whole philosophy of the people behind the scenes.</p>\n<h3>Colleges got it wrong</h3>\n<p>There was a time where people studying Object Oriented Programming didn&#8217;t take WordPress seriously since it&#8217;s based on functional programming and that handy and approachable isn&#8217;t something that helps you progress. Well, things changed, people changed, now functional programming is turning back as the coolest thing to do nowadays, and WordPress is trying to get the best from both paradigms.</p>\n<h3>WordPress makes me proud</h3>\n<p>I mean it. It&#8217;s not just shiny words thrown into the digital garden. I&#8217;m a proud WordPress backend dev who deeply feels that impact matters, and building things for an open-source community matters even more. I&#8217;m also happy with the diverse work I do at Pixelgrade: one day can be Customify or the WP Body Class plugin, the next one can be improving Listable, a WordPress theme used by thousands of users spread all over the world. In between could be the passionate discussions regarding the core of WordPress, some advice tailored on other authors or the amazing WordCamp Europe. Whatever it is, I am grateful that I found my place where creativity, freedom, and braveness are in the first place.</p>\n<p>Call it as you wish, but the simple fact that I improve someone&#8217;s life through my work means the world to me. It gives me a sense of fulfillment, the necessary energy to keep improving, and the never-ending joy that I did something useful. And hey, there&#8217;s just another beginning since Pixelgrade has reshaped its digital presence through an outstanding website and more consistent brand story. So bring it on, fellows!</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: The WordPress Mantra Is Mine Too\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=The%20WordPress%20Mantra%20Is%20Mine%20Too&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwordpress-mantra-mine%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: The WordPress Mantra Is Mine Too\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fwordpress-mantra-mine%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwordpress-mantra-mine%2F&title=The+WordPress+Mantra+Is+Mine+Too\" rel=\"nofollow\" target=\"_blank\" title=\"Share: The WordPress Mantra Is Mine Too\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/wordpress-mantra-mine/&media=https://heropress.com/wp-content/uploads/2016/12/122116-150x150.jpg&description=The WordPress Mantra Is Mine Too\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: The WordPress Mantra Is Mine Too\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/wordpress-mantra-mine/\" title=\"The WordPress Mantra Is Mine Too\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/wordpress-mantra-mine/\">The WordPress Mantra Is Mine Too</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Dec 2016 12:00:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Andrei Lupu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WPTavern: The WordPress.org Homepage is Getting a Redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64587\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wptavern.com/the-wordpress-org-homepage-is-getting-a-redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3549:\"<p>A WordPress.org homepage redesign is now in the works with a strong focus on marketing to new users. As the face of the open source project, the site is long overdue for some design attention. Mark Uraine, a designer at Automattic, <a href=\"https://make.wordpress.org/meta/2016/12/12/new-homepage-redesign/\" target=\"_blank\">posted</a> on the Make/Meta blog about how quickly the project is coming together:</p>\n<p>&#8220;During the Contributor Day at WordCamp US, the Marketing Team sat down with a project in mind — the homepage of wordpress.org,&#8221; Uraine said. &#8220;Since the new design style is making an appearance in various places across the site, there was a desire to reboot the homepage as well.&#8221;</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordpress-homepage.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordpress-homepage.png?resize=203%2C500&ssl=1\" alt=\"\" class=\"alignleft size-large wp-image-64631\" /></a>Uraine posted the group&#8217;s original sketches as well as a screenshot of the initial draft on desktop and mobile. The screenshot doesn&#8217;t include the site&#8217;s header and footer, which will be added when the design is implemented. The team has also created a <a href=\"http://codepen.io/mapk/full/MbGpvR/\" target=\"_blank\">Codepen Prototype</a>, which demonstrates the fixed background featuring high profile WordPress sites that visitors see as they scroll.</p>\n<p>&#8220;Keep in mind that this is only version 1.0 and we’re planning on launching and iterating quickly,&#8221; Uraine said when asking for feedback from the community. &#8220;Otto has offered his help to get this implemented. After a few technical revisions, I’ll be passing it over to him for implementation and providing support where I can.&#8221;</p>\n<p>The redesign focuses on social proof (market share and showcase examples) as well as WordPress&#8217; features and extensibility:</p>\n<p><em>&#8220;Extend WordPress with over 45,000 plugins to help your website meet your needs. Add an online store, galleries, mailing lists, forums, analytics, and much more.&#8221;</em></p>\n<p>Since Uraine posted the design draft, commenters have been weighing in with revisions to the site copy, which hasn&#8217;t yet been finalized. A few contributors have also suggested including A/B testing, although no specific metrics have been determined. The redesign is moving fast, so make sure to jump in on the <a href=\"https://make.wordpress.org/meta/2016/12/12/new-homepage-redesign/\" target=\"_blank\">Make/Meta post</a> if you have feedback on the draft.</p>\n<p>WordPress is getting more strategic about its marketing in 2017. Matt Mullenweg announced during the <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\" target=\"_blank\">2016 State of the Word</a> that he is bringing a new product-based leadership to core development and is assembling a <a href=\"https://wptavern.com/matt-mullenweg-proposes-wordpress-growth-council\" target=\"_blank\">Growth Council</a> to coordinate strategy with organizations invested in WordPress&#8217; growth.</p>\n<p>&#8220;I think in the past WordPress got by on a lot of marketing happenstance,&#8221; Mullenweg said. &#8220;We can become a lot more sophisticated with our messaging and presentation on WordPress.org to bring people in and tell the story about what makes WordPress different.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Dec 2016 20:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: How to Change the Default Members Landing Tab in BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64592\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/how-to-change-the-default-members-landing-tab-in-buddypress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2880:\"<p>For the past two weeks, I&#8217;ve been helping a friend build his site. The site uses WordPress and BuddyPress and is the first opportunity I&#8217;ve had to use BuddyPress for a project. The site is dedicated to a Hockey League league that&#8217;s specific to a video game. The league has a number of players and teams.</p>\n<p>By default, when a visitor browses a BuddyPress member&#8217;s profile, the activity tab is displayed. Since a player&#8217;s team is displayed on a user&#8217;s profile, I wanted the profile tab to be the first thing users see. According to the <a href=\"https://codex.buddypress.org/getting-started/guides/change-members-profile-landing-tab/\">BuddyPress Codex</a>, it&#8217;s possible to change the default landing tab by adding a line of code to either a bp-custom.php file or to wp-config.php. The code is as follows:</p>\n<p><code>/**<br />\n* Change BuddyPress default Members landing tab.<br />\n*/<br />\ndefine(\'BP_DEFAULT_COMPONENT\', \'profile\' );</code></p>\n<p>As I didn&#8217;t want to create and upload another php file, I inserted the code into wp-config.php. At the time of writing this article, the help document on the BuddyPress Codex did not specify where in the wp-config file the code should be placed. After adding the code to the bottom of the wp-config file, I noticed it didn&#8217;t work.</p>\n<p>The trick is to add it to a place that runs before BuddyPress is fully loaded. I moved the code so that is was after the define(&#8216;DB_COLLATE&#8217;, &#8221;); line in wp-config. This allowed the code to run without any issues.</p>\n<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/BPAddedCodetoWPConfig.png?ssl=1\"><img class=\"size-full wp-image-64616\" src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/BPAddedCodetoWPConfig.png?resize=645%2C203&ssl=1\" alt=\"Code Added to the Proper Place in the wpconfig File\" /></a>Code Added to the Proper Place in the wp-config File\n<p>With the code in place, whenever someone clicks on a player&#8217;s name that&#8217;s mentioned in a post, the first thing they see is their profile and the team they&#8217;re assigned too.</p>\n<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/ProfilePageLoadsFirst.png?ssl=1\"><img class=\"size-full wp-image-64617\" src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/ProfilePageLoadsFirst.png?resize=645%2C370&ssl=1\" alt=\"Profile Page Loads First in BuddyPress\" /></a>Profile Page Loads First in BuddyPress\n<p>This is a small change in how BuddyPress works but for an implementor like me, it was a bit of a hassle. The largest obstacle in achieving what I wanted were the directions that don&#8217;t specify where in the config file the code should be placed. I&#8217;ve since edited the Codex article to prevent others from experiencing the same trouble.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Dec 2016 03:30:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: WPWeekly Episode 256 – Interview With Tony Perez, CEO and Co-Founder of Sucuri\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=64479&preview=true&preview_id=64479\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/wpweekly-episode-256-interview-with-tony-perez-ceo-and-co-founder-of-sucuri\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2577:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"https://perezbox.com/\">Tony Perez</a>, co-founder and CEO of <a href=\"https://sucuri.net/\">Sucuri</a>. It&#8217;s easy to tell from this episode that Perez is extremely passionate about web security.</p>\n<p>We discussed a wide range of topics related to security including, trends involving WordPress, <a href=\"https://blog.sucuri.net/2016/10/security-confusion-fud-factor.html\">the FUD factor</a>, messaging surrounding HTTPS, and what <a href=\"https://blog.sucuri.net/2016/10/accounting-for-defense-in-depth-in-website-security.html\">Defense in Depth</a> really means. We also discussed the three basic elements of security, <a href=\"https://perezbox.com/2015/10/website-security-is-not-an-absolute/\">people, process, and technology</a>.</p>\n<p>Perez spoke relatively quickly and at times, the conversation was technical. I recommend listening to the show at least twice in order to digest everything.</p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/product-review/\">Product Review</a> comes with common features that you may need for a review focused site. This includes editor reviews, user reviews, segmented rating, pros and cons, affiliate button and a lot more.</p>\n<p><a href=\"https://wordpress.org/plugins/messenger-bot-for-woocommerce/\">Messengerbot for WooCommerce</a> provides the ability to send your customers messages via Facebook Messenger. It supports Order Receipts, Order status changes, and Customer Order notes.</p>\n<p><a href=\"https://wordpress.org/plugins/email-tracker/\">Email Tracker</a> is a plugin that notifies you if the emails sent by WordPress using the wp_mail function have been read or not. It displays statistics like how many times an email has been read with the date and time.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, December 21st 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #256:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Dec 2016 01:33:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: WordCamp Bangkok 2017 Adds English Track, Debuts New Wapuu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64566\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/wordcamp-bangkok-2017-adds-english-track-debuts-new-wapuu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1978:\"<p>Tickets for WordCamp Bangkok 2017 <a href=\"https://2017.bangkok.wordcamp.org/tickets-are-ready/\" target=\"_blank\">went on sale</a> over the weekend and there are 235 remaining. The event will be held on February 18, 2017, at CP Tower on Silom Road. This is the third WordCamp to take place in the Bangkok area but organizers are including an English Track for the first time at this year&#8217;s event. The Thai and English tracks will run side-by-side and will include WordPress topics for users of all levels.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/wordcamp-bangkok-wapuu-e1482185243432.jpg?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordcamp-bangkok-wapuu-e1482185243432-300x274.jpg?resize=300%2C274&ssl=1\" alt=\"\" class=\"alignright size-medium wp-image-64601\" /></a>Yesterday organizers <a href=\"https://2017.bangkok.wordcamp.org/wapuu-thailand/\" target=\"_blank\">unveiled the new Thailand Wapuu</a>, featuring traditional Thai garb and a banana stalk. Bananas leaves and stems, in addition to the fruit itself, make up an important part of Thai life with both ceremonial and practical uses.</p>\n<p>The calls for <a href=\"https://2017.bangkok.wordcamp.org/call-for-speakers/\" target=\"_blank\">speakers</a> and <a href=\"https://2017.bangkok.wordcamp.org/call-for-sponsors/\" target=\"_blank\">sponsors</a> are open and higher level sponsorships are already sold out. Speaker applications will be accepted through January 5, 2017.</p>\n<p>Previous WordCamps in the region were held in 2008 and 2009. During the past eight years the Thai WordPress community has grown and the <a href=\"https://www.facebook.com/groups/wpalliance/\" target=\"_blank\">Thai WordPress Alliance group</a> on Facebook now has more than 9,800 members. WordCamp Bangkok 2017 has a maximum capacity of 300 attendees. If you plan to go, make sure to purchase your ticket early before the event sells out.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Dec 2016 00:43:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: WooCommerce Powers 42% of All Online Stores\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64550\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/woocommerce-powers-42-of-all-online-stores\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5576:\"<p>Last week Automattic<a href=\"https://automattic.com/year-in-review-2016/\" target=\"_blank\"> published</a> its annual &#8220;Year in Review&#8221; stats, including WooCommerce stats for the first time since the company <a href=\"https://wptavern.com/automattic-acquires-woocommerce\" target=\"_blank\">acquired Woo</a> in 2015. As of December, there are 1,594,894 active stores using WooCommerce and roughly 1/3 of those (530,000) are new in 2016.</p>\n<p>One of the most exciting areas of growth is WooCommerce&#8217;s global market share. Although both the Year in Review post and the <a href=\"https://woocommerce.com/\" target=\"_blank\">WooCommerce website</a> have the software at 39%, <a href=\"http://trends.builtwith.com/shop\" target=\"_blank\">Builtwith stats</a> show WooCommerce powers 42% of all online stores. This is a huge leap from 30% a year and a half ago, when it was acquired.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/woocommerce-market-share.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/woocommerce-market-share.png?resize=1025%2C613&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64553\" /></a></p>\n<p>WooCommerce market share is even higher in emerging markets like <a href=\"https://trends.builtwith.com/shop/country/India\" target=\"_blank\">India</a> (55% among stores using the .IN extension) and <a href=\"https://trends.builtwith.com/shop/country/Mexico\" target=\"_blank\">Mexico</a> (56% among stores using the .MX extension).</p>\n<h3>WooCommerce in 2017: Evolving Storefront for Independent Stores</h3>\n<p>In May 2016, <a href=\"https://wptavern.com/automattic-introduces-woocommerce-connect-hosted-components-for-e-commerce\" target=\"_blank\">WooCommerce introduced WC Connect</a>, its new Automattic-hosted SaaS architecture built on the WP REST API that makes it easier for users to add and configure store features. Real-time USPS shipping rates for US-based stores is the first of many planned hosted components. <a href=\"https://wptavern.com/woocommerce-2-6-introduces-shipping-zones-and-a-new-design-for-account-pages\" target=\"_blank\">Version 2.6</a> introduced the new Shipping Zones feature and an updated design for account pages. In 2016, WooCommerce also <a href=\"https://wptavern.com/woocommerce-releases-square-integration-to-sync-online-and-offline-purchases-and-inventory\" target=\"_blank\">released its Square integration</a> to sync online and offline purchases and inventory.</p>\n<p>The plan for 2017, according to the Year in Review summary, is to continue making setup and scaling easier. At WordCamp US I asked Matt Mullenweg, CEO of Automattic, what he looks for in a buying experience and how he hopes to bring that to WooCommerce.</p>\n<p>&#8220;When I buy from an independent store online, I&#8217;m looking for it to be as friction-free as possible,&#8221; Mullenweg said. &#8220;I don&#8217;t want a lot of steps. I don&#8217;t want it to force me to register if I don&#8217;t want to. I don&#8217;t want the form to error out in weird ways &#8211; anything that breaks my trust. When I visit a website to buy something, how a site looks can increase or decrease my trust.&#8221;</p>\n<p>WooCommerce&#8217;s official <a href=\"https://woocommerce.com/storefront/\" target=\"_blank\">Storefront theme</a>, which is active on more than 80,000 stores, plays an important part in shaping the buying experience for millions of customers. Mullenweg said Storefront has a lot of potential for improvement.</p>\n<p>&#8220;With the Storefront theme there&#8217;s actually a lot we can do there to make it look like a really cool store out of the box, much like the default themes in WordPress,&#8221; Mullenweg said. &#8220;Part of the reason we change them every year is what was cool in 2012 is not cool in 2017. Fashions change, trends change. I think Woo should evolve Storefront in the same way. There&#8217;s kind of a look for independent stores right now. They&#8217;ve got a certain vibe. Let&#8217;s make it easy to do that vibe, so that you don&#8217;t have to be on Etsy or Amazon or one of the e-commerce monoliths to keep people coming to you and supporting your product.&#8221;</p>\n<p>Mullenweg said there are features in the power packs and add-ons that could be good candidates for building into Storefront. The theme <a href=\"https://wptavern.com/woothemes-launches-storefront-a-free-wordpress-theme-with-woocommerce-integration\" target=\"_blank\">launched in 2014</a> and since that time has made mostly gradual improvements. The last major design improvements were released last May in <a href=\"https://github.com/woocommerce/storefront/blob/master/changelog.md#20160506---200\" target=\"_blank\">version 2.0</a>, but many store owners opt for a child theme if they want more extensive design changes to Storefront.</p>\n<p>If WooCommerce market share continues to grow at the same rate, it could easily pass 50% of all online stores in 2017. With <a href=\"https://woocommerce.com/meetups/\" target=\"_blank\">53 meetups</a> scattered across the globe &#8211; from Tokyo to Mumbai to Vancouver, the plugin is embracing the community factor that has made WordPress a success.</p>\n<p>&#8220;I think both Jetpack and WooCommerce individually could each be bigger than WordPress.com,&#8221; Mullenweg said. &#8220;They&#8217;re both smaller than WordPress.com right now but I think each on their own could be several times larger. There are multi-billion dollar opportunities in both, so that&#8217;s what we&#8217;re working on.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Dec 2016 19:26:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Podcast Motor Acquires Seriously Simple Podcasting Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64535\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/podcast-motor-acquires-seriously-simple-podcasting-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2420:\"<p><a href=\"http://seriouslysimplepodcasting.com/\">Seriously Simple Podcasting</a>, created by <a href=\"https://hughlashbrooke.com/\">Hugh Lashbrooke</a> in 2012, has been acquired by <a href=\"http://www.podcastmotor.com/\">Podcast Motor</a>. The <a href=\"https://wordpress.org/plugins/seriously-simple-podcasting/\">plugin</a> is actively installed on nearly 20K sites and out of 104 reviews, has an average rating of 4.9 stars.</p>\n<p>Lashbrooke no longer has the time to dedicate to the project, &#8220;I am in fact selling the plugin (along with all of its add-ons) as I just no longer have the time or bandwidth available to support it in the way that I know it deserves,&#8221; Lashbrooke said. Lashbrooke created the plugin to <a href=\"https://hughlashbrooke.com/2015/11/25/democratising-podcasting/\">democratize podcasting</a> and says it was never meant to be a full-time project.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/SSPSettingsPage.png?ssl=1\"><img class=\"size-full wp-image-64542\" src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/SSPSettingsPage.png?resize=1025%2C541&ssl=1\" alt=\"Seriously Simply Podcasting Settings Page\" /></a>Seriously Simply Podcasting Settings Page\n<p>Podcast Motor provides editing and production services to podcasters. Craig Hewitt, founder of Podcast Motor, acquired the plugin because of its established brand, ease of use, and it allows his company to serve a wider audience.</p>\n<p>Seriously Simple Podcasting will remain a free plugin and Hewitt will continue to support it through WordPress.org. He also plans to add free features to increase the plugin&#8217;s value, &#8220;This will include things like bulk importing of episodes/feeds from other providers, RSS feed validation, and some enhanced front end styling of the on-page podcast display,&#8221; he said.</p>\n<p>Hewitt is ready to breath new life into the project and is seeking feedback from users on what features they&#8217;d like to see added, &#8220;Our long-term goal is to enhance the functionality of the product so that it meets more needs of more podcasters down the road,&#8221; he said.</p>\n<p>Instead of abandoning the plugin or putting it up for adoption, Lashbrooke has found it a new home with a developer eager to improve on his work. If you use Seriously Simple Podcasting, what features do you want to see added?</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Dec 2016 23:07:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WP-CLI Project Launches Patron Support Model to Fund Ongoing Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64512\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/wp-cli-project-launches-patron-support-model-to-fund-ongoing-development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5912:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/wp-cli.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/wp-cli.png?resize=1025%2C411&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-55961\" /></a></p>\n<p>WP-CLI contributors have been <a href=\"https://wptavern.com/wp-cli-contributors-work-towards-a-more-sustainable-future-for-the-project\" target=\"_blank\">working towards a more sustainable future for the project</a> throughout 2016. Daniel Bachhuber, the project&#8217;s official maintainer, has launched an experiment to fund ongoing maintenance and new development, asking potential patrons, &#8220;<a href=\"http://wp-cli.org/blog/the-big-question.html\" target=\"_blank\">How much is WP-CLI worth to you?</a>&#8221; Options for contributions range from $100/yr &#8211; $7500/yr.</p>\n<p>This particular funding experiment is not asking for one-time contributions but rather follows a subscriber model where patrons will be billed annually. Bachhuber said he has a number in mind in order to consider the funding a success but he is not going to share it.</p>\n<p>&#8220;I want to see if this is a viable approach for funding a for-profit business,&#8221; Bacchuber said. He plans to fully refund subscribers if the campaign doesn&#8217;t reach its goal.</p>\n<p>Last year Bachhuber <a href=\"https://wptavern.com/a-more-restful-wp-cli-kickstarter-campaign-is-now-187-funded\" target=\"_blank\">raised $32,822</a> in a highly successful Kickstarter campaign from 107 backers, which funded development during the first part of 2016. After the campaign he started a business called <a href=\"https://runcommand.io/\" target=\"_blank\">runcommand</a> that offered enterprise support and custom development for hosts and agencies. This was an attempt to help subsidize his time spent on WP-CLI, but it didn&#8217;t work out the way he planned:</p>\n<blockquote><p>The business is doing alright, not great but not horrible. What I’ve come to realize, though, is that my time is zero-sum. I’m incentivized to spend time on runcommand, when I’d rather spend it on WP-CLI.</p>\n<p>Ultimately, the challenge I’m running into is opportunity cost. I’d love to be able to invest more into WP-CLI, but doing so comes at the cost of other business pursuits. Because WP-CLI is such a large project, the several hours I volunteer each week are basically enough to fight entropy — not make headway on larger initiatives.</p></blockquote>\n<p>Bachhuber said he hopes this patron-esque model will scale so he can hire a few people to work on WP-CLI, helping reduce his bus factor and creating a stronger contributor base.</p>\n<p>&#8220;The project itself is at a point where it needs dedicated attention from maintainers, not occasional changes from contributors,&#8221; Bachhuber said in response to commenters on the post.</p>\n<p>&#8220;I will, however, echo other comments here in regards to the wish for a public roadmap, more transparency, marketing efforts, and more in regards to the business being built upon WP-CLI,&#8221; subscriber Pippin Williamson said. &#8220;I have chosen to make my subscription payment as a donation to the project, not as a purchase/ of the product / service because, at this time at least, there&#8217;s not really anything I get out of it beyond continued development of the project.&#8221;</p>\n<p>Williamson said the new <a href=\"https://runcommand.io/wp/doctor/\" target=\"_blank\">wp doctor</a> and <a href=\"https://runcommand.io/wp/profile/\" target=\"_blank\">wp profile</a> commands would not be of much use to him or his team. He also suggested that Bachhuber sell a professional subscription that offers a library of additional commands for popular plugins, such as WooCommerce, Easy Digital Downloads, WP Migrate DB Pro, and Gravity Forms.</p>\n<p>&#8220;What I&#8217;ve come to appreciate is that WP-CLI will be far more successful in the long-term by building all of these in the open, instead of a more traditional model of making some selection of them paid-access,&#8221; Bachhuber said.</p>\n<p>Subscriptions will help fund the ongoing maintenance of WP-CLI, the creation of new commands, and improvements to the website and package index.</p>\n<p>For a project that is geared almost exclusively towards developers, there&#8217;s a surprisingly low number of contributors to its development. The brunt of it falls to Bachhuber as the official maintainer. His campaign puts the impetus on subscribers to help improve the tools they use every day through monetary contribution.</p>\n<p>Hopefully, funding the organization will also precipitate a culture shift resulting in more developers who are motivated to get their hands dirty and become personally invested in the code base. Funding one person&#8217;s time is not the most effective way to keep a project afloat and may not do much to reduce the bus factor on the project unless Bachhuber can hire or inspire more maintainers.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">This year, I\'ve spent 308 hours on <a href=\"https://twitter.com/wpcli\">@wpcli</a> (140 paid, 168 volunteer). Next year could be double or could be zero <a href=\"https://t.co/nujVBQZ3Bs\">https://t.co/nujVBQZ3Bs</a></p>\n<p>&mdash; Daniel Bachhuber (@danielbachhuber) <a href=\"https://twitter.com/danielbachhuber/status/809056634337042432\">December 14, 2016</a></p></blockquote>\n<p></p>\n<p>By choosing to wrestle with the challenges of funding open source software in a transparent way, Bachhuber is paving the way for other project maintainers to learn from his experiments and pursue similarly unorthodox funding options. So far WP-CLI has received 17 subscribers. If it reaches 50, Bachhuber plans to create a members-only forum. The <a href=\"http://wp-cli.org/blog/the-big-question.html\" target=\"_blank\">funding experiment</a> closes on December 28th.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Dec 2016 23:05:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Matt: A Poetition\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46988\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2016/12/a-poetition/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:239:\"<p>Joseph O&#8217;Neill has <a href=\"http://www.newyorker.com/magazine/2016/12/12/pardon-edward-snowden\">an amazing and funny poetry-related short story Pardon Edward Snowden in the New Yorker which pokes fun at itself quite a bit</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Dec 2016 20:11:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:36:\"http://feeds.feedburner.com/wp-pipes\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:8:\"wp-pipes\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:10:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"etag\";s:27:\"7ImWsrFiFUbtUVPagjYtSKb4URI\";s:13:\"last-modified\";s:29:\"Wed, 18 Jan 2017 10:21:01 GMT\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"date\";s:29:\"Wed, 18 Jan 2017 10:32:43 GMT\";s:7:\"expires\";s:29:\"Wed, 18 Jan 2017 10:32:43 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";}}s:5:\"build\";s:14:\"20160819135320\";}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134598", "_transient_timeout_feed_mod_99b272eaef9eaa265f30d77863073f26", "1484746363", "no");
INSERT INTO `wp_jzkb_options` VALUES("134599", "_transient_feed_mod_99b272eaef9eaa265f30d77863073f26", "1484735563", "no");
INSERT INTO `wp_jzkb_options` VALUES("134600", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1484746363", "no");
INSERT INTO `wp_jzkb_options` VALUES("134601", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jan 2017 10:11:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"363@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"51888@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"Secure your website with the most comprehensive WordPress security plugin. Firewall, malware scan, blocking, live traffic, login security &#38; more.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Extends and enhances TinyMCE, the WordPress Visual Editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using the Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"UpdraftPlus WordPress Backup Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2646@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Clef Two-Factor Authentication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wpclef/#post-47509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2012 01:25:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"47509@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical login experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Dave Ross\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Increase your traffic, view your stats, speed up your site, and protect yourself from hackers with Jetpack.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"6743@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"9542@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"One of the most downloaded WordPress plugins (over 30 million downloads since 2007). Use All in One SEO Pack to optimize your site for Search Engines.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"12073@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Search Engine (SEO) &#38; Performance Optimization (WPO) via caching. Integrated caching: CDN, Minify, Page, Object, Fragment, Database support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2572@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Google Analytics by MonsterInsights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"Connect Google Analytics with WordPress by adding your Google Analytics tracking code. Get the stats that matter.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Syed Balkhi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"NextGEN Gallery - WordPress Gallery Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 16 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5790@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26907@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly. Provides tool t\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26607@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"28395@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"31973@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"Take the guesswork out of WordPress security. iThemes Security offers 30+ ways to lock down WordPress in an easy-to-use WordPress security plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"iThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"SiteOrigin Widgets Bundle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/so-widgets-bundle/#post-67824\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 May 2014 14:27:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"67824@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"A collection of all widgets, neatly bundled into a single plugin. It&#039;s also a framework to code your own widgets on top of.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 18 Jan 2017 10:32:43 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:7:\"expires\";s:29:\"Wed, 18 Jan 2017 10:46:55 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Wed, 18 Jan 2017 10:11:55 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20160819135320\";}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134602", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1484746363", "no");
INSERT INTO `wp_jzkb_options` VALUES("134603", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1484735563", "no");
INSERT INTO `wp_jzkb_options` VALUES("134604", "_transient_timeout_plugin_slugs", "1484822368", "no");
INSERT INTO `wp_jzkb_options` VALUES("134605", "_transient_plugin_slugs", "a:15:{i:0;s:19:\"akismet/akismet.php\";i:1;s:24:\"buddypress/bp-loader.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:67:\"favicon-by-realfavicongenerator/favicon-by-realfavicongenerator.php\";i:5;s:25:\"formidable/formidable.php\";i:6;s:9:\"hello.php\";i:7;s:19:\"jetpack/jetpack.php\";i:8;s:47:\"mojo-marketplace-wp-plugin/mojo-marketplace.php\";i:9;s:47:\"participants-database/participants-database.php\";i:10;s:21:\"pixcodes/pixcodes.php\";i:11;s:41:\"wordpress-importer/wordpress-importer.php\";i:12;s:33:\"wpum-recaptcha/wpum-recaptcha.php\";i:13;s:49:\"wpum-user-verification/wpum-user-verification.php\";i:14;s:35:\"wp-user-manager/wp-user-manager.php\";}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134606", "_transient_timeout_dash_5f25301ca0145abac6dfc3a0899dc43b", "1484778763", "no");
INSERT INTO `wp_jzkb_options` VALUES("134607", "_transient_dash_5f25301ca0145abac6dfc3a0899dc43b", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\'>WordPress 4.7.1 Security and Maintenance Release</a> <span class=\"rss-date\">January 11, 2017</span><div class=\"rssSummary\">WordPress 4.7 has been downloaded over 10 million times since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7 and earlier are affected by eight security issues: [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/how-to-add-users-to-buddypress-groups-in-bulk\'>WPTavern: How to Add Users to BuddyPress Groups in Bulk</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/siteground-auto-issues-lets-encrypt-certificates-for-new-domains\'>WPTavern: SiteGround Auto-Issues Let’s Encrypt Certificates for New Domains</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/postmatic-basic-rebrands-as-replyable-moves-two-way-email-commenting-to-saas-product\'>WPTavern: Postmatic Basic Rebrands as Replyable, Moves Two-Way Email Commenting to SaaS Product</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\"dashboard-news-plugin\"><span>Popular Plugin:</span> Google Analytics Dashboard for WP&nbsp;<a href=\"plugin-install.php?tab=plugin-information&amp;plugin=google-analytics-dashboard-for-wp&amp;_wpnonce=ca7dac7ccd&amp;TB_iframe=true&amp;width=600&amp;height=800\" class=\"thickbox open-plugin-details-modal\" aria-label=\"Install Google Analytics Dashboard for WP\">(Install)</a></li></ul></div>", "no");
INSERT INTO `wp_jzkb_options` VALUES("134608", "can_compress_scripts", "1", "no");
INSERT INTO `wp_jzkb_options` VALUES("134609", "jetpack_nonce_1484735564_KeFCQjzxA1", "1484735565", "no");
INSERT INTO `wp_jzkb_options` VALUES("134610", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1484746374", "no");
INSERT INTO `wp_jzkb_options` VALUES("134611", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"6143\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3767\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3761\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"3288\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2870\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"2575\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2241\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"2162\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:4:\"2152\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"2125\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"2099\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"2056\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1991\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1954\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1784\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1678\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1657\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1479\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1398\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1305\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1301\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:4:\"1164\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:4:\"1140\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:4:\"1081\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:4:\"1034\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:4:\"1031\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"986\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"979\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"978\";}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";s:3:\"948\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"937\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"918\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"870\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"867\";}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";s:3:\"864\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"833\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"798\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"791\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"790\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"773\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"766\";}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";s:3:\"759\";}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";s:3:\"757\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"754\";}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"CSS\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";s:3:\"750\";}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";s:3:\"747\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"738\";}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";s:3:\"736\";}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";s:3:\"733\";}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";s:3:\"724\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"712\";}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";s:3:\"660\";}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";s:3:\"657\";}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";s:3:\"652\";}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";s:3:\"642\";}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";s:3:\"640\";}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";s:3:\"629\";}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";s:3:\"624\";}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";s:3:\"620\";}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";s:3:\"617\";}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";s:3:\"603\";}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";s:3:\"596\";}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";s:3:\"592\";}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";s:3:\"592\";}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";s:3:\"589\";}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";s:3:\"579\";}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";s:3:\"562\";}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";s:3:\"562\";}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";s:3:\"557\";}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";s:3:\"550\";}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";s:3:\"547\";}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";s:3:\"543\";}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";s:3:\"536\";}s:4:\"shop\";a:3:{s:4:\"name\";s:4:\"shop\";s:4:\"slug\";s:4:\"shop\";s:5:\"count\";s:3:\"527\";}s:7:\"picture\";a:3:{s:4:\"name\";s:7:\"picture\";s:4:\"slug\";s:7:\"picture\";s:5:\"count\";s:3:\"524\";}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";s:3:\"519\";}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";s:3:\"515\";}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";s:3:\"510\";}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";s:3:\"491\";}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";s:3:\"472\";}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";s:3:\"470\";}s:8:\"pictures\";a:3:{s:4:\"name\";s:8:\"pictures\";s:4:\"slug\";s:8:\"pictures\";s:5:\"count\";s:3:\"468\";}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";s:3:\"468\";}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";s:3:\"467\";}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";s:3:\"455\";}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";s:3:\"454\";}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";s:3:\"445\";}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";s:3:\"444\";}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";s:3:\"438\";}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";s:3:\"436\";}s:8:\"lightbox\";a:3:{s:4:\"name\";s:8:\"lightbox\";s:4:\"slug\";s:8:\"lightbox\";s:5:\"count\";s:3:\"432\";}s:9:\"thumbnail\";a:3:{s:4:\"name\";s:9:\"thumbnail\";s:4:\"slug\";s:9:\"thumbnail\";s:5:\"count\";s:3:\"429\";}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";s:3:\"429\";}s:6:\"upload\";a:3:{s:4:\"name\";s:6:\"upload\";s:4:\"slug\";s:6:\"upload\";s:5:\"count\";s:3:\"427\";}s:7:\"sharing\";a:3:{s:4:\"name\";s:7:\"sharing\";s:4:\"slug\";s:7:\"sharing\";s:5:\"count\";s:3:\"425\";}s:6:\"paypal\";a:3:{s:4:\"name\";s:6:\"paypal\";s:4:\"slug\";s:6:\"paypal\";s:5:\"count\";s:3:\"425\";}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"News\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";s:3:\"422\";}s:8:\"linkedin\";a:3:{s:4:\"name\";s:8:\"linkedin\";s:4:\"slug\";s:8:\"linkedin\";s:5:\"count\";s:3:\"421\";}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";s:3:\"420\";}s:5:\"flash\";a:3:{s:4:\"name\";s:5:\"flash\";s:4:\"slug\";s:5:\"flash\";s:5:\"count\";s:3:\"420\";}}", "no");
INSERT INTO `wp_jzkb_options` VALUES("134650", "_transient_timeout_jetpack_sync_callables_await", "1484736261", "no");
INSERT INTO `wp_jzkb_options` VALUES("134651", "_transient_jetpack_sync_callables_await", "1484736201.4314", "no");
INSERT INTO `wp_jzkb_options` VALUES("134647", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-01-18 10:42:17\";s:7:\"Version\";s:6:\"1.1.26\";s:9:\"VersionWP\";s:5:\"4.7.1\";s:9:\"VersionDB\";s:6:\"5.6.32\";s:10:\"VersionPHP\";s:6:\"5.4.43\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20170118_dgtalmind\";s:4:\"Hash\";s:29:\"587f46893c8fd7603170118104217\";s:8:\"NameHash\";s:48:\"20170118_dgtalmind_587f46893c8fd7603170118104217\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:44:\"/home1/dgtalmin/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://www.dgtal-mind.com/wp-snapshots/\";s:8:\"ScanFile\";s:58:\"20170118_dgtalmind_587f46893c8fd7603170118104217_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:27:\"/home1/dgtalmin/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-01-18 10:42:17\";s:7:\"Version\";s:6:\"1.1.26\";s:9:\"VersionWP\";s:5:\"4.7.1\";s:9:\"VersionDB\";s:6:\"5.6.32\";s:10:\"VersionPHP\";s:6:\"5.4.43\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20170118_dgtalmind\";s:4:\"Hash\";s:29:\"587f46893c8fd7603170118104217\";s:8:\"NameHash\";s:48:\"20170118_dgtalmind_587f46893c8fd7603170118104217\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:44:\"/home1/dgtalmin/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://www.dgtal-mind.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:52;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}", "yes");
INSERT INTO `wp_jzkb_options` VALUES("134635", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1484735952;s:7:\"checked\";a:15:{s:19:\"akismet/akismet.php\";s:3:\"3.2\";s:24:\"buddypress/bp-loader.php\";s:5:\"2.7.4\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:3:\"4.6\";s:25:\"duplicator/duplicator.php\";s:6:\"1.1.26\";s:67:\"favicon-by-realfavicongenerator/favicon-by-realfavicongenerator.php\";s:5:\"1.3.9\";s:25:\"formidable/formidable.php\";s:7:\"2.02.13\";s:9:\"hello.php\";s:3:\"1.6\";s:19:\"jetpack/jetpack.php\";s:3:\"4.5\";s:47:\"mojo-marketplace-wp-plugin/mojo-marketplace.php\";s:5:\"1.0.1\";s:47:\"participants-database/participants-database.php\";s:7:\"1.7.1.4\";s:21:\"pixcodes/pixcodes.php\";s:5:\"2.3.3\";s:41:\"wordpress-importer/wordpress-importer.php\";s:5:\"0.6.3\";s:33:\"wpum-recaptcha/wpum-recaptcha.php\";s:5:\"1.1.0\";s:49:\"wpum-user-verification/wpum-user-verification.php\";s:5:\"1.0.2\";s:35:\"wp-user-manager/wp-user-manager.php\";s:5:\"1.4.2\";}s:8:\"response\";a:2:{s:47:\"participants-database/participants-database.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:5:\"27645\";s:4:\"slug\";s:21:\"participants-database\";s:6:\"plugin\";s:47:\"participants-database/participants-database.php\";s:11:\"new_version\";s:7:\"1.7.1.5\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/participants-database/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/participants-database.1.7.1.5.zip\";s:14:\"upgrade_notice\";s:65:\"Version 1.7.1.5 is a bugfix upgrade; essential to all PHP 7 users\";s:6:\"tested\";s:5:\"4.7.1\";s:13:\"compatibility\";O:8:\"stdClass\":1:{s:6:\"scalar\";O:8:\"stdClass\":1:{s:6:\"scalar\";b:0;}}}s:47:\"mojo-marketplace-wp-plugin/mojo-marketplace.php\";O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"1.1.0\";s:4:\"date\";s:10:\"2016-12-02\";s:7:\"package\";s:97:\"https://www.mojomarketplace.com/mojo-plugin-assets/updater/release/mojo-marketplace-wp-plugin.zip\";s:3:\"url\";s:59:\"https://www.mojomarketplace.com/mojo-plugin-assets/updater/\";s:4:\"slug\";s:26:\"mojo-marketplace-wp-plugin\";s:11:\"new_version\";s:5:\"1.1.0\";s:6:\"plugin\";s:47:\"mojo-marketplace-wp-plugin/mojo-marketplace.php\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:12:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"3.2\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.3.2.zip\";}s:24:\"buddypress/bp-loader.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"7756\";s:4:\"slug\";s:10:\"buddypress\";s:6:\"plugin\";s:24:\"buddypress/bp-loader.php\";s:11:\"new_version\";s:5:\"2.7.4\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/buddypress/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/buddypress.2.7.4.zip\";s:14:\"upgrade_notice\";s:57:\"See: https://codex.buddypress.org/releases/version-2-7-4/\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"790\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:3:\"4.6\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.6.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.1.26\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.1.26.zip\";}s:67:\"favicon-by-realfavicongenerator/favicon-by-realfavicongenerator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"50074\";s:4:\"slug\";s:31:\"favicon-by-realfavicongenerator\";s:6:\"plugin\";s:67:\"favicon-by-realfavicongenerator/favicon-by-realfavicongenerator.php\";s:11:\"new_version\";s:5:\"1.3.9\";s:3:\"url\";s:62:\"https://wordpress.org/plugins/favicon-by-realfavicongenerator/\";s:7:\"package\";s:74:\"https://downloads.wordpress.org/plugin/favicon-by-realfavicongenerator.zip\";}s:25:\"formidable/formidable.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"11762\";s:4:\"slug\";s:10:\"formidable\";s:6:\"plugin\";s:25:\"formidable/formidable.php\";s:11:\"new_version\";s:7:\"2.02.13\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/formidable/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/formidable.2.02.13.zip\";}s:9:\"hello.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"3564\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";}s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:3:\"4.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.4.5.zip\";}s:21:\"pixcodes/pixcodes.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"57897\";s:4:\"slug\";s:8:\"pixcodes\";s:6:\"plugin\";s:21:\"pixcodes/pixcodes.php\";s:11:\"new_version\";s:5:\"2.3.3\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/pixcodes/\";s:7:\"package\";s:51:\"https://downloads.wordpress.org/plugin/pixcodes.zip\";}s:41:\"wordpress-importer/wordpress-importer.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"14975\";s:4:\"slug\";s:18:\"wordpress-importer\";s:6:\"plugin\";s:41:\"wordpress-importer/wordpress-importer.php\";s:11:\"new_version\";s:5:\"0.6.3\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wordpress-importer/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/wordpress-importer.0.6.3.zip\";}s:33:\"wpum-recaptcha/wpum-recaptcha.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"62082\";s:4:\"slug\";s:14:\"wpum-recaptcha\";s:6:\"plugin\";s:33:\"wpum-recaptcha/wpum-recaptcha.php\";s:11:\"new_version\";s:5:\"1.1.0\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/wpum-recaptcha/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/wpum-recaptcha.zip\";}s:35:\"wp-user-manager/wp-user-manager.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"61430\";s:4:\"slug\";s:15:\"wp-user-manager\";s:6:\"plugin\";s:35:\"wp-user-manager/wp-user-manager.php\";s:11:\"new_version\";s:5:\"1.4.2\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/wp-user-manager/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/wp-user-manager.1.4.2.zip\";}}}", "no");

/* INSERT TABLE DATA: wp_jzkb_participants_database */
INSERT INTO `wp_jzkb_participants_database` VALUES("5", "VDY6G", "Toyin", "Okunjolu", "7 Aegean Gardens", "Salford", "Manchester", "United Kingdom", "M7 2JH", "07735539062", "toyinokunjolu@gmail.com", "Yes", NULL, NULL, NULL, "no", "2016-09-13 15:21:48", "2016-09-13 15:21:48", NULL);
INSERT INTO `wp_jzkb_participants_database` VALUES("4", "TYLIU", "Femi", "Kolade", "28 Carville Crescent", "Brentford", "Middlesex", "UK", "TW8 9RD", "07551186728", "femi_kolade@yahoo.co.uk", "Yes", NULL, NULL, NULL, "no", "2016-09-13 08:22:38", "2016-09-13 08:22:38", NULL);

/* INSERT TABLE DATA: wp_jzkb_participants_database_fields */
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("1", "0", "first_name", "First Name", NULL, "main", NULL, "text-line", NULL, "yes", "1", "2", "1", "1", "0", "1", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("2", "1", "last_name", "Last Name", NULL, "main", NULL, "text-line", NULL, "yes", "2", "3", "1", "1", "0", "1", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("3", "2", "address", "Address", "", "main", "", "text-line", "", "no", "0", "0", "0", "1", "0", "1", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("4", "3", "city", "City", "", "main", "", "text-line", "", "no", "3", "0", "1", "1", "1", "1", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("5", "4", "state", "County", "", "main", "", "text-line", "", "no", "4", "0", "1", "1", "1", "1", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("6", "5", "country", "Country", "", "main", "", "text-line", "", "no", "0", "0", "1", "1", "1", "1", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("7", "6", "zip", "Post Code", "", "main", "", "text-line", "", "no", "0", "0", "1", "1", "1", "1", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("8", "7", "phone", "Phone", "", "main", "Your primary contact number", "text-line", "", "no", "0", "0", "0", "1", "0", "1", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("9", "8", "email", "Email", NULL, "main", NULL, "text-line", NULL, "#^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,4}$#i", "0", "4", "0", "1", "0", "1", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("10", "9", "mailing_list", "Mailing List", "Yes", "main", "do you want to receive our newsletter and occasional announcements?", "checkbox", "a:2:{i:0;s:3:\"Yes\";i:1;s:2:\"No\";}", "no", "0", "0", "1", "1", "0", "1", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("11", "10", "photo", "Photo", NULL, "personal", "Upload a photo of yourself. 300 pixels maximum width or height.", "image-upload", NULL, "no", "0", "0", "0", "0", "0", "0", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("12", "11", "website", "Website, Blog or Social Media Link", NULL, "personal", "Put the URL in the left box and the link text that will be shown on the right", "link", NULL, "no", "0", "0", "0", "0", "0", "0", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("13", "12", "interests", "Interests or Hobbies", NULL, "personal", NULL, "multi-select-other", "a:7:{s:6:\"Sports\";s:6:\"sports\";s:11:\"Photography\";s:11:\"photography\";s:10:\"Art/Crafts\";s:6:\"crafts\";s:8:\"Outdoors\";s:8:\"outdoors\";s:4:\"Yoga\";s:4:\"yoga\";s:5:\"Music\";s:5:\"music\";s:7:\"Cuisine\";s:7:\"cuisine\";}", "no", "0", "0", "0", "0", "0", "0", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("14", "13", "approved", "Approved", "no", "admin", NULL, "checkbox", "a:2:{i:0;s:3:\"yes\";i:1;s:2:\"no\";}", "no", "0", "0", "1", "0", "0", "0", "0");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("15", "14", "id", "Record ID", NULL, "internal", NULL, "text-line", NULL, "no", "0", "0", "0", "1", "0", "1", "1");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("16", "15", "private_id", "Private ID", "RPNE2", "internal", NULL, "text", NULL, "no", "0", "90", "0", "0", "0", "1", "1");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("17", "16", "date_recorded", "Date Recorded", NULL, "internal", NULL, "timestamp", NULL, "no", "0", "100", "1", "0", "0", "0", "1");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("18", "17", "date_updated", "Date Updated", NULL, "internal", NULL, "timestamp", NULL, "no", "0", "0", "1", "0", "0", "0", "1");
INSERT INTO `wp_jzkb_participants_database_fields` VALUES("19", "18", "last_accessed", "Last Accessed", NULL, "internal", NULL, "timestamp", NULL, "no", "0", "0", "1", "0", "0", "0", "1");

/* INSERT TABLE DATA: wp_jzkb_participants_database_groups */
INSERT INTO `wp_jzkb_participants_database_groups` VALUES("1", "1", "1", "0", "Participant Info", "main", NULL);
INSERT INTO `wp_jzkb_participants_database_groups` VALUES("2", "2", "1", "0", "Personal Info", "personal", NULL);
INSERT INTO `wp_jzkb_participants_database_groups` VALUES("3", "3", "0", "0", "Administrative Info", "admin", NULL);
INSERT INTO `wp_jzkb_participants_database_groups` VALUES("4", "4", "0", "0", "Record Info", "internal", NULL);

/* INSERT TABLE DATA: wp_jzkb_postmeta */
INSERT INTO `wp_jzkb_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("84", "25", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:5000;s:6:\"height\";i:3337;s:4:\"file\";s:25:\"2016/02/1x1_consult-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"1x1_consult-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"1x1_consult-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"1x1_consult-1-768x513.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:513;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"1x1_consult-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:16:\".shock - Fotolia\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("83", "25", "_wp_attached_file", "2016/02/1x1_consult-1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("9", "9", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:200;s:6:\"height\";i:78;s:4:\"file\";s:27:\"2016/02/logo_DGtal-Mind.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"logo_DGtal-Mind-150x78.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:78;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("8", "9", "_wp_attached_file", "2016/02/logo_DGtal-Mind.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("18", "12", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("19", "12", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("20", "12", "pikart_project_gallery", "3409");
INSERT INTO `wp_jzkb_postmeta` VALUES("21", "12", "pikart_project_title", "1 to 1 UX Consultancy");
INSERT INTO `wp_jzkb_postmeta` VALUES("22", "12", "pikart_project_subtitle", "UX Clinics");
INSERT INTO `wp_jzkb_postmeta` VALUES("23", "12", "_edit_lock", "1458756661:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("38", "15", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("39", "15", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("40", "15", "pikart_project_gallery", "28");
INSERT INTO `wp_jzkb_postmeta` VALUES("41", "15", "pikart_project_title", "Experience Design");
INSERT INTO `wp_jzkb_postmeta` VALUES("42", "15", "pikart_project_subtitle", "Conceptual interface modelling");
INSERT INTO `wp_jzkb_postmeta` VALUES("43", "15", "_edit_lock", "1458759167:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("44", "16", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("45", "16", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("46", "16", "pikart_project_gallery", "33");
INSERT INTO `wp_jzkb_postmeta` VALUES("47", "16", "pikart_project_title", "Usability Research");
INSERT INTO `wp_jzkb_postmeta` VALUES("48", "16", "pikart_project_subtitle", "Who your users are");
INSERT INTO `wp_jzkb_postmeta` VALUES("49", "16", "_edit_lock", "1458757585:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("50", "17", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("51", "17", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("52", "17", "pikart_project_gallery", "34");
INSERT INTO `wp_jzkb_postmeta` VALUES("53", "17", "pikart_project_title", "Usability Testing");
INSERT INTO `wp_jzkb_postmeta` VALUES("54", "17", "pikart_project_subtitle", "Users interaction");
INSERT INTO `wp_jzkb_postmeta` VALUES("55", "17", "_edit_lock", "1458759015:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("62", "19", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("63", "19", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("64", "19", "pikart_project_gallery", "3410");
INSERT INTO `wp_jzkb_postmeta` VALUES("65", "19", "pikart_project_title", "Prototyping");
INSERT INTO `wp_jzkb_postmeta` VALUES("66", "19", "pikart_project_subtitle", "Testing usage scenarios");
INSERT INTO `wp_jzkb_postmeta` VALUES("67", "19", "_edit_lock", "1458755685:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("74", "21", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("75", "21", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("76", "21", "pikart_project_gallery", "51");
INSERT INTO `wp_jzkb_postmeta` VALUES("77", "21", "pikart_project_title", "Digital Inclusion Training");
INSERT INTO `wp_jzkb_postmeta` VALUES("78", "21", "pikart_project_subtitle", "Digital exclusion solution");
INSERT INTO `wp_jzkb_postmeta` VALUES("79", "21", "_edit_lock", "1458756615:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("80", "22", "_wp_attached_file", "2016/02/worksp1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("81", "22", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1207;s:4:\"file\";s:19:\"2016/02/worksp1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"worksp1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"worksp1-300x189.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:189;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"worksp1-768x483.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:483;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"worksp1-1024x644.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:644;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("85", "26", "_wp_attached_file", "2016/02/contact.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("86", "26", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:489;s:4:\"file\";s:19:\"2016/02/contact.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"contact-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"contact-300x76.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:76;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"contact-768x196.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:196;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"contact-1024x261.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:261;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:37:\"© Markus Mainka (www.marek-photo.de)\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("134", "51", "_wp_attached_file", "2016/02/digital-inclusion-4.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("135", "51", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1100;s:4:\"file\";s:31:\"2016/02/digital-inclusion-4.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"digital-inclusion-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"digital-inclusion-4-300x172.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:172;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"digital-inclusion-4-768x440.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:440;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"digital-inclusion-4-1024x587.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:587;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:19:\"photopitu - Fotolia\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("89", "28", "_wp_attached_file", "2016/02/exp-design-1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("90", "28", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:24:\"2016/02/exp-design-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"exp-design-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"exp-design-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"exp-design-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"exp-design-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:43:\"Ryhor Bruyeu (Grisha Bruev / Grigory Bruev)\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("91", "29", "_wp_attached_file", "2016/02/exp-strategy-1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("92", "29", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:26:\"2016/02/exp-strategy-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"exp-strategy-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"exp-strategy-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"exp-strategy-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"exp-strategy-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:10:\"Gaj Rudolf\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("93", "30", "_wp_attached_file", "2016/02/prototype-1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("94", "30", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2016/02/prototype-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"prototype-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"prototype-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"prototype-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"prototype-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:25:\"GoneWithTheWind - Fotolia\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("95", "31", "_wp_attached_file", "2016/02/training-1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("96", "31", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:22:\"2016/02/training-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"training-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"training-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"training-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"training-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:26:\"Stephanie Zieber - Fotolia\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("97", "32", "_wp_attached_file", "2016/02/usa-exp-review-1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("98", "32", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:28:\"2016/02/usa-exp-review-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"usa-exp-review-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"usa-exp-review-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"usa-exp-review-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"usa-exp-review-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:10:\"Gaj Rudolf\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("99", "33", "_wp_attached_file", "2016/02/usa-research-1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("100", "33", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:26:\"2016/02/usa-research-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"usa-research-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"usa-research-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"usa-research-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"usa-research-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:16:\".shock - Fotolia\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("101", "34", "_wp_attached_file", "2016/02/usa-test-1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("102", "34", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:22:\"2016/02/usa-test-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"usa-test-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"usa-test-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"usa-test-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"usa-test-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:22:\"DragonImages - Fotolia\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("103", "35", "_wp_attached_file", "2016/02/usa-exp-1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("104", "35", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:21:\"2016/02/usa-exp-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"usa-exp-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"usa-exp-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"usa-exp-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"usa-exp-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:21:\"leungchopan - Fotolia\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("105", "36", "_wp_attached_file", "2016/02/worksp1-1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("106", "36", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:21:\"2016/02/worksp1-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"worksp1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"worksp1-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"worksp1-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"worksp1-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("232", "89", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("108", "21", "_jetpack_related_posts_cache", "a:1:{s:32:\"1bbe8f9ea9055501072fc56d198fee16\";a:2:{s:7:\"expires\";i:1484238219;s:7:\"payload\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("472", "156", "sharing_disabled", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("111", "19", "sharing_disabled", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("112", "19", "_jetpack_related_posts_cache", "a:1:{s:32:\"1bbe8f9ea9055501072fc56d198fee16\";a:2:{s:7:\"expires\";i:1484238223;s:7:\"payload\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("115", "17", "sharing_disabled", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("116", "17", "_jetpack_related_posts_cache", "a:1:{s:32:\"1bbe8f9ea9055501072fc56d198fee16\";a:2:{s:7:\"expires\";i:1484238229;s:7:\"payload\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("117", "16", "sharing_disabled", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("118", "16", "_jetpack_related_posts_cache", "a:1:{s:32:\"1bbe8f9ea9055501072fc56d198fee16\";a:2:{s:7:\"expires\";i:1484238235;s:7:\"payload\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("119", "15", "sharing_disabled", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("120", "15", "_jetpack_related_posts_cache", "a:1:{s:32:\"1bbe8f9ea9055501072fc56d198fee16\";a:2:{s:7:\"expires\";i:1482220938;s:7:\"payload\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("125", "12", "sharing_disabled", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("126", "12", "_jetpack_related_posts_cache", "a:1:{s:32:\"1bbe8f9ea9055501072fc56d198fee16\";a:2:{s:7:\"expires\";i:1483509654;s:7:\"payload\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("128", "48", "_wp_attached_file", "2016/02/prototype-2.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("129", "48", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2016/02/prototype-2.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"prototype-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"prototype-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"prototype-2-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"prototype-2-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:25:\"GoneWithTheWind - Fotolia\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("157", "59", "_wp_page_template", "templates/page-builder.php");
INSERT INTO `wp_jzkb_postmeta` VALUES("1286", "3411", "_wp_attached_file", "2016/02/training.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("1285", "19", "_thumbnail_id", "3410");
INSERT INTO `wp_jzkb_postmeta` VALUES("1292", "3413", "_wp_attached_file", "2016/02/u-research.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("1282", "12", "_thumbnail_id", "3409");
INSERT INTO `wp_jzkb_postmeta` VALUES("457", "155", "_wp_attached_file", "2016/02/worksp2.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("1339", "3449", "_wp_attached_file", "2015/08/p1-b.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("1338", "3444", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("1337", "3444", "_thumbnail_id", "3445");
INSERT INTO `wp_jzkb_postmeta` VALUES("154", "58", "_wp_attached_file", "2016/02/logo_1856457_print.png");
INSERT INTO `wp_jzkb_postmeta` VALUES("155", "58", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:402;s:4:\"file\";s:30:\"2016/02/logo_1856457_print.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"logo_1856457_print-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"logo_1856457_print-300x121.png\";s:5:\"width\";i:300;s:6:\"height\";i:121;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"logo_1856457_print-768x309.png\";s:5:\"width\";i:768;s:6:\"height\";i:309;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("156", "59", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("158", "59", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("159", "59", "pikart_page_builder_sections", "YTo0OntpOjU7YTo5OntzOjEyOiJjb250ZW50X3R5cGUiO3M6NzoiZGVmYXVsdCI7czoxNjoicHJvamVjdHNfZGlzcGxheSI7czo4OiJmdWxsZ3JpZCI7czoxMzoiZ21hcF9sYXRpdHVkZSI7czowOiIiO3M6MTQ6ImdtYXBfbG9uZ2l0dWRlIjtzOjA6IiI7czoxMToibmJfcHJvamVjdHMiO3M6MjoiMTIiO3M6ODoibmJfcG9zdHMiO3M6MToiOSI7czoxNDoicHJvamVjdHNfc3BlZWQiO3M6Mjoib24iO3M6MTE6InBvc3RzX3NwZWVkIjtzOjI6Im9uIjtzOjc6ImNvbnRlbnQiO3M6MjU1OiI8YSBocmVmPSJodHRwOi8vd3d3LmRndGFsLW1pbmQuY29tLz9hdHRhY2htZW50X2lkPTMzODgiIHJlbD0iYXR0YWNobWVudCB3cC1hdHQtMzM4OCI+PGltZyBjbGFzcz0iYWxpZ25jZW50ZXIgc2l6ZS1mdWxsIHdwLWltYWdlLTMzODgiIHNyYz0iaHR0cDovL3d3dy5kZ3RhbC1taW5kLmNvbS93cC1jb250ZW50L3VwbG9hZHMvMjAxNi8wMi9tZS1mdWxsLTMuanBnIiBhbHQ9Im1lLWZ1bGwtMyIgd2lkdGg9IjgzNCIgaGVpZ2h0PSIxMzE3IiAvPjwvYT4iO31pOjEwO2E6OTp7czoxMjoiY29udGVudF90eXBlIjtzOjc6ImRlZmF1bHQiO3M6MTY6InByb2plY3RzX2Rpc3BsYXkiO3M6ODoiZnVsbGdyaWQiO3M6MTM6ImdtYXBfbGF0aXR1ZGUiO3M6MDoiIjtzOjE0OiJnbWFwX2xvbmdpdHVkZSI7czowOiIiO3M6MTE6Im5iX3Byb2plY3RzIjtzOjI6IjEyIjtzOjg6Im5iX3Bvc3RzIjtzOjE6IjkiO3M6MTQ6InByb2plY3RzX3NwZWVkIjtzOjI6Im9uIjtzOjExOiJwb3N0c19zcGVlZCI7czoyOiJvbiI7czo3OiJjb250ZW50IjtzOjYwOiJbaGVhZGluZyB0aXRsZT0iS05PVyBBIEJJVCBNT1JFIiBzdWJ0aXRsZT0iQUJPVVQgV0hBVCBJIERPIl0iO31pOjExO2E6OTp7czoxMjoiY29udGVudF90eXBlIjtzOjg6InByb2plY3RzIjtzOjE2OiJwcm9qZWN0c19kaXNwbGF5IjtzOjg6ImZ1bGxncmlkIjtzOjEzOiJnbWFwX2xhdGl0dWRlIjtzOjA6IiI7czoxNDoiZ21hcF9sb25naXR1ZGUiO3M6MDoiIjtzOjExOiJuYl9wcm9qZWN0cyI7czoxOiI4IjtzOjg6Im5iX3Bvc3RzIjtzOjE6IjkiO3M6MTQ6InByb2plY3RzX3NwZWVkIjtzOjI6Im9uIjtzOjExOiJwb3N0c19zcGVlZCI7czoyOiJvbiI7czo3OiJjb250ZW50IjtzOjA6IiI7fWk6MTI7YTo5OntzOjEyOiJjb250ZW50X3R5cGUiO3M6NToicG9zdHMiO3M6MTY6InByb2plY3RzX2Rpc3BsYXkiO3M6ODoiZnVsbGdyaWQiO3M6MTM6ImdtYXBfbGF0aXR1ZGUiO3M6MDoiIjtzOjE0OiJnbWFwX2xvbmdpdHVkZSI7czowOiIiO3M6MTE6Im5iX3Byb2plY3RzIjtzOjI6IjEyIjtzOjg6Im5iX3Bvc3RzIjtzOjE6IjMiO3M6MTQ6InByb2plY3RzX3NwZWVkIjtzOjI6Im9uIjtzOjExOiJwb3N0c19zcGVlZCI7czoyOiJvbiI7czo3OiJjb250ZW50IjtzOjA6IiI7fX0=");
INSERT INTO `wp_jzkb_postmeta` VALUES("160", "59", "_edit_lock", "1457298524:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1340", "3449", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:171;s:6:\"height\";i:88;s:4:\"file\";s:16:\"2015/08/p1-b.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"p1-b-150x88.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("163", "62", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("164", "62", "_edit_lock", "1458763542:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("165", "62", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("166", "62", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("169", "65", "_wp_attached_file", "2016/02/IMG_1824-Edit.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("170", "65", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1400;s:6:\"height\";i:933;s:4:\"file\";s:25:\"2016/02/IMG_1824-Edit.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"IMG_1824-Edit-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"IMG_1824-Edit-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"IMG_1824-Edit-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"IMG_1824-Edit-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1454440531\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"85\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("1316", "183", "_jetpack_related_posts_cache", "a:1:{s:32:\"1bbe8f9ea9055501072fc56d198fee16\";a:2:{s:7:\"expires\";i:1482247977;s:7:\"payload\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("1317", "231", "_edit_lock", "1459213227:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1322", "231", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1323", "3441", "_menu_item_type", "post_type");
INSERT INTO `wp_jzkb_postmeta` VALUES("1324", "3441", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_jzkb_postmeta` VALUES("1325", "3441", "_menu_item_object_id", "231");
INSERT INTO `wp_jzkb_postmeta` VALUES("1326", "3441", "_menu_item_object", "page");
INSERT INTO `wp_jzkb_postmeta` VALUES("1327", "3441", "_menu_item_target", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("1328", "3441", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("1329", "3441", "_menu_item_xfn", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("1330", "3441", "_menu_item_url", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("1332", "3441", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("177", "68", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("178", "68", "_edit_lock", "1469297609:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("179", "68", "_wp_page_template", "templates/page-builder.php");
INSERT INTO `wp_jzkb_postmeta` VALUES("180", "68", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("181", "68", "pikart_page_builder_sections", "YTozOntpOjU7YTo5OntzOjEyOiJjb250ZW50X3R5cGUiO3M6NzoiZGVmYXVsdCI7czoxNjoicHJvamVjdHNfZGlzcGxheSI7czo4OiJmdWxsZ3JpZCI7czoxMzoiZ21hcF9sYXRpdHVkZSI7czowOiIiO3M6MTQ6ImdtYXBfbG9uZ2l0dWRlIjtzOjA6IiI7czoxMToibmJfcHJvamVjdHMiO3M6MjoiMTIiO3M6ODoibmJfcG9zdHMiO3M6MToiOSI7czoxNDoicHJvamVjdHNfc3BlZWQiO3M6Mjoib24iO3M6MTE6InBvc3RzX3NwZWVkIjtzOjI6Im9uIjtzOjc6ImNvbnRlbnQiO3M6MTU4OiI8aW1nIGNsYXNzPSJhbGlnbm5vbmUgd3AtaW1hZ2UtMjYgc2l6ZS1mdWxsIiBzcmM9Imh0dHA6Ly93d3cuZGd0YWwtbWluZC5jb20vd3AtY29udGVudC91cGxvYWRzLzIwMTYvMDIvY29udGFjdC5qcGciIGFsdD0iY29udGFjdCIgd2lkdGg9IjE5MjAiIGhlaWdodD0iNDg5IiAvPiI7fWk6NjthOjk6e3M6MTI6ImNvbnRlbnRfdHlwZSI7czo3OiJkZWZhdWx0IjtzOjE2OiJwcm9qZWN0c19kaXNwbGF5IjtzOjg6ImZ1bGxncmlkIjtzOjEzOiJnbWFwX2xhdGl0dWRlIjtzOjA6IiI7czoxNDoiZ21hcF9sb25naXR1ZGUiO3M6MDoiIjtzOjExOiJuYl9wcm9qZWN0cyI7czoyOiIxMiI7czo4OiJuYl9wb3N0cyI7czoxOiI5IjtzOjE0OiJwcm9qZWN0c19zcGVlZCI7czoyOiJvbiI7czoxMToicG9zdHNfc3BlZWQiO3M6Mjoib24iO3M6NzoiY29udGVudCI7czoxODE0OiI8c3Ryb25nPkRHdGFsLU1pbmQ8L3N0cm9uZz4gPHN0cm9uZz5MaW1pdGVkPC9zdHJvbmc+IGlzIG15IHRyYWRlIG5hbWUgd2l0aCBVSyBjb21wYW55IHJlZ2lzdHJhdGlvbiBudW1iZXIgPHN0cm9uZz45ODU3NzE3PC9zdHJvbmc+Lg0KDQpJIGFtIGFsc28gPHN0cm9uZz5WQVQ8L3N0cm9uZz4gcmVnaXN0ZXJlZCAoTnVtYmVyOiA8c3Ryb25nPjIyOSAzMzYzIDA0PC9zdHJvbmc+KS4NCg0KJm5ic3A7DQo8aDI+UXVpdGUgZWFzeSB0byBmaW5kIHVzPC9oMj4NCjxoNj5XaGVuIHlvdSBuZWVkPC9oNj4NCltociBzdHlsZT0iZG90dGVkIl0NCg0KW3JvdyBjb2xzX25yPSI0Il0NCg0KW2NvbCBzaXplPSIxIl0NCg0KW2ljb24gc2l6ZT0ibWVkaXVtIiBuYW1lPSJtYXAtbWFya2VyIiBjbGFzcz0iaWNvbi1ib3JkZXIiXQ0KDQpbL2NvbF0NCg0KW2NvbCBzaXplPSI1Il0NCg0KPHN0cm9uZz5BZGRyZXNzOjwvc3Ryb25nPg0KMjggQ2FydmlsbGUgQ3Jlc2NlbnQsIEJyZW50Zm9yZCwgVFc4IDlSRA0KDQpbL2NvbF0NCg0KW2NvbCBzaXplPSIxIl0NCg0KW2ljb24gc2l6ZT0ibWVkaXVtIiBuYW1lPSJlbnZlbG9wZS1vIiBjbGFzcz0iaWNvbi1ib3JkZXIiXQ0KDQpbL2NvbF0NCg0KW2NvbCBzaXplPSI1Il0NCg0KPHN0cm9uZz5FbWFpbDo8L3N0cm9uZz4NCjxzcGFuIHN0eWxlPSJjb2xvcjogIzEyYTVmNCI+PGEgc3R5bGU9ImNvbG9yOiAjMTJhNWY0IiBocmVmPSJtYWlsdG86aGVsbG9AZGd0YWwtbWluZC5jb20iIHRhcmdldD0iX2JsYW5rIj5oZWxsb0BkZ3RhbC1taW5kLmNvbTwvYT48L3NwYW4+DQoNClsvY29sXQ0KDQpbL3Jvd10NCg0KW3JvdyBjb2xzX25yPSI0Il0NCg0KW2NvbCBzaXplPSIxIl0NCg0KW2ljb24gc2l6ZT0ibWVkaXVtIiBuYW1lPSJwaG9uZSIgY2xhc3M9Imljb24tYm9yZGVyIl0NCg0KWy9jb2xdDQoNCltjb2wgc2l6ZT0iNSJdDQo8c3Ryb25nPlBob25lOjwvc3Ryb25nPg0KKzQ0ICgwKSAyMDMgMzAyIDIzOTcNCg0KWy9jb2xdDQoNCltjb2wgc2l6ZT0iMSJdDQoNCltpY29uIHNpemU9Im1lZGl1bSIgbmFtZT0ibW9iaWxlIiBjbGFzcz0iaWNvbi1ib3JkZXIiXQ0KDQpbL2NvbF0NCg0KW2NvbCBzaXplPSI1Il0NCg0KPHN0cm9uZz5Nb2JpbGU6PC9zdHJvbmc+DQorNDQgKDApIDc1NSAxMTggNjcyOA0KDQpbL2NvbF0NCg0KWy9yb3ddDQoNCltyb3cgY29sc19ucj0iMiJdDQoNCltjb2wgc2l6ZT0iMSJdDQoNCltpY29uIHNpemU9Im1lZGl1bSIgbmFtZT0iZS1zaGFyZSIgY2xhc3M9Imljb24tYm9yZGVyIl0NCg0KWy9jb2xdDQoNCltjb2wgc2l6ZT0iMTEiXQ0KDQo8c3Ryb25nPlNvY2lhbCBNZWRpYTo8L3N0cm9uZz4NCjxzcGFuIHN0eWxlPSJjb2xvcjogIzEyYTVmNCI+PGEgc3R5bGU9ImNvbG9yOiAjMTJhNWY0IiBocmVmPSJodHRwczovL3d3dy5mYWNlYm9vay5jb20vREd0YWxNaW5kLyIgdGFyZ2V0PSJfYmxhbmsiPmZhY2Vib29rPC9hPiwgPGEgc3R5bGU9ImNvbG9yOiAjMTJhNWY0IiBocmVmPSJodHRwczovL3R3aXR0ZXIuY29tL0FudGhveV9Lb2xhZGUiIHRhcmdldD0iX2JsYW5rIj50d2l0dGVyPC9hPiwgPGEgc3R5bGU9ImNvbG9yOiAjMTJhNWY0IiBocmVmPSJodHRwczovL3VrLmxpbmtlZGluLmNvbS9pbi9hbnRob255a29sYWRlIiB0YXJnZXQ9Il9ibGFuayI+bGlua2VkaW48L2E+PC9zcGFuPg0KDQpbL2NvbF0NCg0KWy9yb3ddDQoNCiZuYnNwOw0KPGgyPlRlbGwgdXMgeW91ciBzdG9yeTwvaDI+DQo8aDY+V2UgYXJlIGN1cmlvdXM8L2g2Pg0KW2hyIHN0eWxlPSJkb3R0ZWQiXQ0KDQpbY29udGFjdC1mb3JtLTcgaWQ9IjE0NDkiIHRpdGxlPSJDb250YWN0IEZvcm0iXSI7fWk6NzthOjk6e3M6MTI6ImNvbnRlbnRfdHlwZSI7czoxMToiY29udGFjdF9tYXAiO3M6MTY6InByb2plY3RzX2Rpc3BsYXkiO3M6ODoiZnVsbGdyaWQiO3M6MTM6ImdtYXBfbGF0aXR1ZGUiO3M6OToiNTEuNDkyODU0IjtzOjE0OiJnbWFwX2xvbmdpdHVkZSI7czo5OiItMC4yOTgxMzgiO3M6MTE6Im5iX3Byb2plY3RzIjtzOjI6IjEyIjtzOjg6Im5iX3Bvc3RzIjtzOjE6IjkiO3M6MTQ6InByb2plY3RzX3NwZWVkIjtzOjI6Im9uIjtzOjExOiJwb3N0c19zcGVlZCI7czoyOiJvbiI7czo3OiJjb250ZW50IjtzOjA6IiI7fX0=");
INSERT INTO `wp_jzkb_postmeta` VALUES("182", "68", "_thumbnail_id", "26");
INSERT INTO `wp_jzkb_postmeta` VALUES("192", "74", "_menu_item_type", "post_type");
INSERT INTO `wp_jzkb_postmeta` VALUES("193", "74", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_jzkb_postmeta` VALUES("194", "74", "_menu_item_object_id", "62");
INSERT INTO `wp_jzkb_postmeta` VALUES("195", "74", "_menu_item_object", "page");
INSERT INTO `wp_jzkb_postmeta` VALUES("196", "74", "_menu_item_target", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("197", "74", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("198", "74", "_menu_item_xfn", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("199", "74", "_menu_item_url", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("211", "74", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("201", "75", "_menu_item_type", "post_type");
INSERT INTO `wp_jzkb_postmeta` VALUES("202", "75", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_jzkb_postmeta` VALUES("203", "75", "_menu_item_object_id", "68");
INSERT INTO `wp_jzkb_postmeta` VALUES("204", "75", "_menu_item_object", "page");
INSERT INTO `wp_jzkb_postmeta` VALUES("205", "75", "_menu_item_target", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("206", "75", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("207", "75", "_menu_item_xfn", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("208", "75", "_menu_item_url", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("212", "75", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("214", "78", "_wp_attached_file", "2016/02/me1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("215", "78", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:436;s:6:\"height\";i:687;s:4:\"file\";s:15:\"2016/02/me1.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"me1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"me1-190x300.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("1065", "65", "_wp_attachment_image_alt", "Anthony Kolade");
INSERT INTO `wp_jzkb_postmeta` VALUES("1336", "3445", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1366;s:6:\"height\";i:702;s:4:\"file\";s:14:\"2016/03/p1.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"p1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"p1-300x154.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:154;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("1335", "3445", "_wp_attached_file", "2016/03/p1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("1334", "3444", "_edit_lock", "1459189006:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1333", "3444", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("233", "89", "_edit_lock", "1457122251:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("234", "89", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("235", "89", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("236", "91", "_menu_item_type", "post_type");
INSERT INTO `wp_jzkb_postmeta` VALUES("237", "91", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_jzkb_postmeta` VALUES("238", "91", "_menu_item_object_id", "89");
INSERT INTO `wp_jzkb_postmeta` VALUES("239", "91", "_menu_item_object", "page");
INSERT INTO `wp_jzkb_postmeta` VALUES("240", "91", "_menu_item_target", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("241", "91", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("242", "91", "_menu_item_xfn", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("243", "91", "_menu_item_url", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("245", "91", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("246", "92", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("247", "92", "_form", "<p class=\'comment-form-comment\'>[textarea textarea-499 placeholder \"Your comment\"]</p>\n\n<p class=\'blog-form-input comment-form-author\'>[text text-238 placeholder \"Name\"]</p>\n\n<p class=\'blog-form-input comment-form-email\'>[email email-682 placeholder \"Email\"]</p>\n\n<p class=\'blog-form-input comment-form-url\'>[url url-505 placeholder \"Website\"]</p>\n\n<p class=\'form-submit\'>[submit \"Send your message\"]</p>");
INSERT INTO `wp_jzkb_postmeta` VALUES("248", "92", "_mail", "a:8:{s:7:\"subject\";s:24:\"My Site \"[your-subject]\"\";s:6:\"sender\";s:34:\"[your-name] <hello@dgtal-mind.com>\";s:4:\"body\";s:170:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on My Site (http://www.dgtal-mind.com)\";s:9:\"recipient\";s:20:\"hello@dgtal-mind.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_jzkb_postmeta` VALUES("249", "92", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:24:\"My Site \"[your-subject]\"\";s:6:\"sender\";s:34:\"My Site <wordpress@dgtal-mind.com>\";s:4:\"body\";s:112:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on My Site (http://www.dgtal-mind.com)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:25:\"Reply-To: you@example.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_jzkb_postmeta` VALUES("250", "92", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";s:12:\"invalid_date\";s:29:\"The date format is incorrect.\";s:14:\"date_too_early\";s:44:\"The date is before the earliest one allowed.\";s:13:\"date_too_late\";s:41:\"The date is after the latest one allowed.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";s:14:\"invalid_number\";s:29:\"The number format is invalid.\";s:16:\"number_too_small\";s:47:\"The number is smaller than the minimum allowed.\";s:16:\"number_too_large\";s:46:\"The number is larger than the maximum allowed.\";s:23:\"quiz_answer_not_correct\";s:36:\"The answer to the quiz is incorrect.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:13:\"invalid_email\";s:38:\"The e-mail address entered is invalid.\";s:11:\"invalid_url\";s:19:\"The URL is invalid.\";s:11:\"invalid_tel\";s:32:\"The telephone number is invalid.\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("251", "92", "_additional_settings", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("252", "92", "_locale", "en_US");
INSERT INTO `wp_jzkb_postmeta` VALUES("253", "68", "_g_feedback_shortcode", "[contact-field label=\'Comment\' type=\'textarea\' required=\'1\'/][contact-field label=\'Name\' type=\'name\' required=\'1\'/][contact-field label=\'Email\' type=\'email\' required=\'1\'/][contact-field label=\'Website\' type=\'url\'/]");
INSERT INTO `wp_jzkb_postmeta` VALUES("254", "93", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("255", "93", "_feedback_extra_fields", "a:0:{}");
INSERT INTO `wp_jzkb_postmeta` VALUES("257", "93", "_feedback_email", "a:2:{s:2:\"to\";a:1:{i:0;s:22:\"anthony@dgtal-mind.com\";}s:7:\"message\";s:338:\"<b>Name:</b> Femi Kolade<br /><br /><b>Email:</b> femi_kolade@yahoo.co.uk<br /><br /><b>Website:</b> http://www.dgtalmind.com<br /><br /><b>Comment:</b> Testing<br /><br />Time: February 25, 2016 at 2:05 pm<br />IP Address: 2.103.215.155<br />Contact Form URL: http://www.dgtal-mind.com/?page_id=68<br />Sent by a verified \"My Site\" user.\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("258", "1", "_edit_lock", "1457089823:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("259", "1", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("263", "1", "_jetpack_related_posts_cache", "a:1:{s:32:\"8f6677c9d6b0f903e98ad32ec61f8deb\";a:2:{s:7:\"expires\";i:1483622122;s:7:\"payload\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("262", "1", "pikart_audio_link", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("264", "1", "_thumbnail_id", "22");
INSERT INTO `wp_jzkb_postmeta` VALUES("268", "95", "_edit_lock", "1467195317:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("267", "95", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("269", "95", "_thumbnail_id", "22");
INSERT INTO `wp_jzkb_postmeta` VALUES("270", "95", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("271", "95", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("272", "97", "_menu_item_type", "post_type");
INSERT INTO `wp_jzkb_postmeta` VALUES("273", "97", "_menu_item_menu_item_parent", "91");
INSERT INTO `wp_jzkb_postmeta` VALUES("274", "97", "_menu_item_object_id", "95");
INSERT INTO `wp_jzkb_postmeta` VALUES("275", "97", "_menu_item_object", "page");
INSERT INTO `wp_jzkb_postmeta` VALUES("276", "97", "_menu_item_target", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("277", "97", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("278", "97", "_menu_item_xfn", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("279", "97", "_menu_item_url", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("281", "97", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("282", "98", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("283", "98", "_edit_lock", "1467195295:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("284", "98", "_thumbnail_id", "25");
INSERT INTO `wp_jzkb_postmeta` VALUES("285", "98", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("286", "98", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("297", "104", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("298", "104", "_edit_lock", "1456417395:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("299", "104", "_thumbnail_id", "29");
INSERT INTO `wp_jzkb_postmeta` VALUES("300", "104", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("301", "104", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1268", "190", "_edit_lock", "1457360999:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1267", "404", "_edit_lock", "1459168995:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1390", "3488", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("1265", "2650", "sharing_disabled", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1389", "3488", "_menu_item_target", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("312", "108", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("313", "108", "_edit_lock", "1456417604:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("314", "108", "_thumbnail_id", "32");
INSERT INTO `wp_jzkb_postmeta` VALUES("315", "108", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("316", "108", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1388", "3488", "_menu_item_object", "page");
INSERT INTO `wp_jzkb_postmeta` VALUES("1387", "3488", "_menu_item_object_id", "115");
INSERT INTO `wp_jzkb_postmeta` VALUES("1386", "3488", "_menu_item_menu_item_parent", "91");
INSERT INTO `wp_jzkb_postmeta` VALUES("327", "111", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("328", "111", "_edit_lock", "1467194736:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("329", "111", "_thumbnail_id", "28");
INSERT INTO `wp_jzkb_postmeta` VALUES("330", "111", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("331", "111", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1394", "3488", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1392", "3488", "_menu_item_url", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("1391", "3488", "_menu_item_xfn", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("342", "115", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("343", "115", "_edit_lock", "1469300283:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("344", "115", "_thumbnail_id", "33");
INSERT INTO `wp_jzkb_postmeta` VALUES("345", "115", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("346", "115", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1385", "3488", "_menu_item_type", "post_type");
INSERT INTO `wp_jzkb_postmeta` VALUES("357", "118", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("358", "118", "_edit_lock", "1456418365:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("359", "118", "_thumbnail_id", "34");
INSERT INTO `wp_jzkb_postmeta` VALUES("360", "118", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("361", "118", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("372", "122", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("373", "122", "_edit_lock", "1456418621:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("374", "122", "_thumbnail_id", "35");
INSERT INTO `wp_jzkb_postmeta` VALUES("375", "122", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("376", "122", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("387", "125", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("388", "125", "_edit_lock", "1456418924:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("389", "125", "_thumbnail_id", "48");
INSERT INTO `wp_jzkb_postmeta` VALUES("390", "125", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("391", "125", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("402", "128", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("403", "128", "_edit_lock", "1456502118:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("404", "128", "_thumbnail_id", "31");
INSERT INTO `wp_jzkb_postmeta` VALUES("405", "128", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("406", "128", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("417", "131", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("418", "131", "_edit_lock", "1456501763:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("419", "131", "_thumbnail_id", "51");
INSERT INTO `wp_jzkb_postmeta` VALUES("420", "131", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("421", "131", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("422", "133", "_menu_item_type", "post_type");
INSERT INTO `wp_jzkb_postmeta` VALUES("423", "133", "_menu_item_menu_item_parent", "91");
INSERT INTO `wp_jzkb_postmeta` VALUES("424", "133", "_menu_item_object_id", "131");
INSERT INTO `wp_jzkb_postmeta` VALUES("425", "133", "_menu_item_object", "page");
INSERT INTO `wp_jzkb_postmeta` VALUES("426", "133", "_menu_item_target", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("427", "133", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("428", "133", "_menu_item_xfn", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("429", "133", "_menu_item_url", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("431", "133", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("432", "142", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("433", "142", "_edit_lock", "1456578367:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("434", "143", "_wp_attached_file", "2016/02/web-design.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("435", "143", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:22:\"2016/02/web-design.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"web-design-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"web-design-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"web-design-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"web-design-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:22:\"PHOTOMORPHIC PTE. LTD.\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("436", "142", "_thumbnail_id", "143");
INSERT INTO `wp_jzkb_postmeta` VALUES("437", "142", "_wp_page_template", "default");
INSERT INTO `wp_jzkb_postmeta` VALUES("438", "142", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("439", "147", "_menu_item_type", "post_type");
INSERT INTO `wp_jzkb_postmeta` VALUES("440", "147", "_menu_item_menu_item_parent", "91");
INSERT INTO `wp_jzkb_postmeta` VALUES("441", "147", "_menu_item_object_id", "142");
INSERT INTO `wp_jzkb_postmeta` VALUES("442", "147", "_menu_item_object", "page");
INSERT INTO `wp_jzkb_postmeta` VALUES("443", "147", "_menu_item_target", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("444", "147", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("445", "147", "_menu_item_xfn", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("446", "147", "_menu_item_url", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("448", "147", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("449", "148", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("450", "148", "_edit_lock", "1458758278:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("451", "143", "_wp_old_slug", "web-design");
INSERT INTO `wp_jzkb_postmeta` VALUES("452", "148", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("453", "148", "pikart_project_gallery", "143");
INSERT INTO `wp_jzkb_postmeta` VALUES("454", "148", "pikart_project_title", "Web design and development");
INSERT INTO `wp_jzkb_postmeta` VALUES("455", "148", "pikart_project_subtitle", "rigorous design driven methodology");
INSERT INTO `wp_jzkb_postmeta` VALUES("456", "148", "_jetpack_related_posts_cache", "a:1:{s:32:\"1bbe8f9ea9055501072fc56d198fee16\";a:2:{s:7:\"expires\";i:1484238213;s:7:\"payload\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("458", "155", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:19:\"2016/02/worksp2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"worksp2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"worksp2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("462", "156", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("463", "156", "_edit_lock", "1458757900:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1295", "3414", "_wp_attached_file", "2016/02/workshop.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("465", "156", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("466", "156", "pikart_project_gallery", "3408");
INSERT INTO `wp_jzkb_postmeta` VALUES("467", "156", "pikart_project_title", "UX Workshops");
INSERT INTO `wp_jzkb_postmeta` VALUES("468", "156", "pikart_project_subtitle", "Usability Experience workshops");
INSERT INTO `wp_jzkb_postmeta` VALUES("469", "156", "_jetpack_related_posts_cache", "a:1:{s:32:\"1bbe8f9ea9055501072fc56d198fee16\";a:2:{s:7:\"expires\";i:1484238208;s:7:\"payload\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("1298", "3415", "_wp_attached_file", "2016/02/web-design-1.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("473", "148", "sharing_disabled", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("475", "21", "sharing_disabled", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("476", "68", "sharing_disabled", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("477", "160", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("478", "160", "_feedback_extra_fields", "a:0:{}");
INSERT INTO `wp_jzkb_postmeta` VALUES("480", "160", "_feedback_email", "a:2:{s:2:\"to\";a:1:{i:0;s:22:\"anthony@dgtal-mind.com\";}s:7:\"message\";s:432:\"<b>Comment:</b> Hello,<br />\r\n<br />\r\nThis is my story.<br />\r\n<br />\r\nRegards,<br />\r\n<br />\r\nAyo Mitide<br /><br /><b>Name:</b> Ayo Mitide<br /><br /><b>Email:</b> ayomitide@gmail.com<br /><br /><b>Website:</b> http://www.dgtalmind.com<br /><br />Time: February 27, 2016 at 6:38 pm<br />IP Address: 2.103.215.155<br />Contact Form URL: http://www.dgtal-mind.com/?page_id=68<br />Sent by a verified \"...designing experience!\" user.\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("481", "161", "_wp_attached_file", "2016/02/logo-icon.png");
INSERT INTO `wp_jzkb_postmeta` VALUES("482", "161", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:313;s:6:\"height\";i:386;s:4:\"file\";s:21:\"2016/02/logo-icon.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"logo-icon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"logo-icon-243x300.png\";s:5:\"width\";i:243;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("483", "62", "sharing_disabled", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("484", "173", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("485", "173", "_edit_lock", "1456605781:1");
INSERT INTO `wp_jzkb_postmeta` VALUES("488", "59", "sharing_disabled", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("1055", "190", "_jetpack_related_posts_cache", "a:1:{s:32:\"1bbe8f9ea9055501072fc56d198fee16\";a:2:{s:7:\"expires\";i:1484382320;s:7:\"payload\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("493", "1626", "_wp_attached_file", "2015/08/056.png");
INSERT INTO `wp_jzkb_postmeta` VALUES("494", "1626", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:260;s:6:\"height\";i:260;s:4:\"file\";s:15:\"2015/08/056.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"056-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("495", "2185", "_wp_attached_file", "2015/09/055.png");
INSERT INTO `wp_jzkb_postmeta` VALUES("496", "2185", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:143;s:4:\"file\";s:15:\"2015/09/055.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"055-150x143.png\";s:5:\"width\";i:150;s:6:\"height\";i:143;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"055-300x84.png\";s:5:\"width\";i:300;s:6:\"height\";i:84;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("497", "2564", "_wp_attached_file", "2015/08/01.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("498", "2564", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1080;s:4:\"file\";s:14:\"2015/08/01.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"01-250x300.jpg\";s:5:\"width\";i:250;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("499", "2564", "_wp_attachment_image_alt", "Beautiful Sea Rocks");
INSERT INTO `wp_jzkb_postmeta` VALUES("500", "2565", "_wp_attached_file", "2015/08/02.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("501", "2565", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1080;s:4:\"file\";s:14:\"2015/08/02.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"02-250x300.jpg\";s:5:\"width\";i:250;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("502", "2565", "_wp_attachment_image_alt", "Mornings in London");
INSERT INTO `wp_jzkb_postmeta` VALUES("503", "2566", "_wp_attached_file", "2015/08/03.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("504", "2566", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1080;s:4:\"file\";s:14:\"2015/08/03.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"03-250x300.jpg\";s:5:\"width\";i:250;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("505", "2566", "_wp_attachment_image_alt", "Lost in space");
INSERT INTO `wp_jzkb_postmeta` VALUES("506", "2567", "_wp_attached_file", "2015/08/04.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("507", "2567", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1080;s:4:\"file\";s:14:\"2015/08/04.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"04-250x300.jpg\";s:5:\"width\";i:250;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("508", "2568", "_wp_attached_file", "2015/08/11.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("509", "2568", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:14:\"2015/08/11.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"11-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("510", "2568", "_wp_attachment_image_alt", "Winter Landscape");
INSERT INTO `wp_jzkb_postmeta` VALUES("511", "2568", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("512", "2569", "_wp_attached_file", "2015/08/12.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("513", "2569", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:14:\"2015/08/12.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"12-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("514", "2569", "_wp_attachment_image_alt", "Holiday Memories");
INSERT INTO `wp_jzkb_postmeta` VALUES("515", "2569", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("516", "2570", "_wp_attached_file", "2015/08/13.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("517", "2570", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:14:\"2015/08/13.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"13-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("518", "2570", "_wp_attachment_image_alt", "Greece, Mon amour!");
INSERT INTO `wp_jzkb_postmeta` VALUES("519", "2570", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("520", "2571", "_wp_attached_file", "2015/08/14.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("521", "2571", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:14:\"2015/08/14.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"14-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("522", "2571", "_wp_attachment_image_alt", "Going to heaven");
INSERT INTO `wp_jzkb_postmeta` VALUES("523", "2571", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("524", "2572", "_wp_attached_file", "2015/08/15.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("525", "2572", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:14:\"2015/08/15.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"15-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"15-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("526", "2572", "_wp_attachment_image_alt", "Angry Sea");
INSERT INTO `wp_jzkb_postmeta` VALUES("527", "2572", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("528", "2573", "_wp_attached_file", "2015/08/16.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("529", "2573", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:14:\"2015/08/16.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"16-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"16-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("530", "2573", "_wp_attachment_image_alt", "Cardboard level");
INSERT INTO `wp_jzkb_postmeta` VALUES("531", "2573", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("532", "2574", "_wp_attached_file", "2015/08/17.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("533", "2574", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:14:\"2015/08/17.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"17-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"17-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("534", "2574", "_wp_attachment_image_alt", "Rendez-vous de Printemps!");
INSERT INTO `wp_jzkb_postmeta` VALUES("535", "2575", "_wp_attached_file", "2015/08/18.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("536", "2575", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:14:\"2015/08/18.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"18-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"18-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("537", "2575", "_wp_attachment_image_alt", "Mountain Extremes");
INSERT INTO `wp_jzkb_postmeta` VALUES("538", "2576", "_wp_attached_file", "2015/08/19.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("539", "2576", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:14:\"2015/08/19.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"19-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"19-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("540", "2576", "_wp_attachment_image_alt", "Undiscovered Minimalism");
INSERT INTO `wp_jzkb_postmeta` VALUES("541", "2577", "_wp_attached_file", "2015/08/20.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("542", "2577", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:14:\"2015/08/20.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"20-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"20-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("543", "2577", "_wp_attachment_image_alt", "Amber Bottle");
INSERT INTO `wp_jzkb_postmeta` VALUES("544", "2578", "_wp_attached_file", "2015/08/21.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("545", "2578", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1354;s:4:\"file\";s:14:\"2015/08/21.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"21-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"21-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:15:\"21-851x1280.jpg\";s:5:\"width\";i:851;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("546", "2579", "_wp_attached_file", "2015/08/22.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("547", "2579", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1354;s:4:\"file\";s:14:\"2015/08/22.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"22-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"22-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:15:\"22-851x1280.jpg\";s:5:\"width\";i:851;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("548", "2580", "_wp_attached_file", "2015/08/23.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("549", "2580", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1354;s:4:\"file\";s:14:\"2015/08/23.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"23-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"23-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:15:\"23-851x1280.jpg\";s:5:\"width\";i:851;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("550", "2581", "_wp_attached_file", "2015/08/24.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("551", "2581", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1354;s:4:\"file\";s:14:\"2015/08/24.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"24-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"24-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:15:\"24-851x1280.jpg\";s:5:\"width\";i:851;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_jzkb_postmeta` VALUES("552", "2581", "_wp_attachment_image_alt", "WILD");
INSERT INTO `wp_jzkb_postmeta` VALUES("553", "2581", "_edit_last", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("554", "2582", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("555", "2582", "_menu_item_type", "custom");
INSERT INTO `wp_jzkb_postmeta` VALUES("556", "2582", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_jzkb_postmeta` VALUES("557", "2582", "_menu_item_object_id", "2582");
INSERT INTO `wp_jzkb_postmeta` VALUES("558", "2582", "_menu_item_object", "custom");
INSERT INTO `wp_jzkb_postmeta` VALUES("559", "2582", "_menu_item_target", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("560", "2582", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("561", "2582", "_menu_item_xfn", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("562", "2582", "_menu_item_url", "https://www.facebook.com/DGtalMind");
INSERT INTO `wp_jzkb_postmeta` VALUES("563", "2583", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("564", "2583", "_menu_item_type", "custom");
INSERT INTO `wp_jzkb_postmeta` VALUES("565", "2583", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_jzkb_postmeta` VALUES("566", "2583", "_menu_item_object_id", "2583");
INSERT INTO `wp_jzkb_postmeta` VALUES("567", "2583", "_menu_item_object", "custom");
INSERT INTO `wp_jzkb_postmeta` VALUES("568", "2583", "_menu_item_target", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("569", "2583", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("570", "2583", "_menu_item_xfn", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("571", "2583", "_menu_item_url", "https://uk.linkedin.com/in/anthonykolade");
INSERT INTO `wp_jzkb_postmeta` VALUES("572", "2584", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("573", "2584", "_menu_item_type", "custom");
INSERT INTO `wp_jzkb_postmeta` VALUES("574", "2584", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_jzkb_postmeta` VALUES("575", "2584", "_menu_item_object_id", "2584");
INSERT INTO `wp_jzkb_postmeta` VALUES("576", "2584", "_menu_item_object", "custom");
INSERT INTO `wp_jzkb_postmeta` VALUES("577", "2584", "_menu_item_target", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("578", "2584", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("579", "2584", "_menu_item_xfn", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("580", "2584", "_menu_item_url", "https://twitter.com/Anthoy_Kolade");
INSERT INTO `wp_jzkb_postmeta` VALUES("581", "2585", "_wpas_done_all", "1");
INSERT INTO `wp_jzkb_postmeta` VALUES("582", "2585", "_menu_item_type", "custom");
INSERT INTO `wp_jzkb_postmeta` VALUES("583", "2585", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_jzkb_postmeta` VALUES("584", "2585", "_menu_item_object_id", "2585");
INSERT INTO `wp_jzkb_postmeta` VALUES("585", "2585", "_menu_item_object", "custom");
INSERT INTO `wp_jzkb_postmeta` VALUES("586", "2585", "_menu_item_target", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("587", "2585", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("588", "2585", "_menu_item_xfn", "");
INSERT INTO `wp_jzkb_postmeta` VALUES("589", "2585", "_menu_item_url", "#");
INSERT INTO `wp_jzkb_postmeta` VALUES("590", "2694", "_wp_attached_file", "2015/11/AutumnSunset.mp3");
INSERT INTO `wp_jzkb_postmeta` VALUES("591", "2694", "_wp_attachment_metadata", "a:21:{s:10:\"dataformat\";s:3:\"mp3\";s:8:\"channels\";i:2;s:11:\"sample_rate\";i:44100;s:7:\"bitrate\";i:128000;s:11:\"channelmode\";s:12:\"joint stereo\";s:12:\"bitrate_mode\";s:3:\"cbr\";s:8:\"lossless\";b:0;s:15:\"encoder_options\";s:6:\"CBR128\";s:17:\"compression_ratio\";d:0.090702947845804988;s:10:\"fileformat\";s:3:\"mp3\";s:8:\"filesize\";i:1545240;s:9:\"mime_type\";s:10:\"audio/mpeg\";s:6:\"length\";i:96;s:16:\"length_formatted\";s:4:\"1:36\";s:5:\"title\";s:13:\"AUTUMN SUNSET\";s:5:\"genre\";s:8:\"Acoustic\";s:6:\"artist\";s:15:\"AUDIONAUTIX.COM\";s:4:\"isrc\";s:15:\"QM-QFZ-13-00006\";s:5:\"album\";s:4:\"SLOW\";s:7:\"comment\";s:17:\"CALMING, RELAXING\";s:3:\"bpm\";s:4:\"1:36\";}");
INSERT INTO `wp_jzkb_postmeta` VALUES("592", "3237", "_wp_attached_file", "2015/12/25.jpg");
INSERT INTO `wp_jzkb_postmeta` VALUES("593", "3237", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:1280;s:4:\"file\";s:14:\"2015/12/25.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"25-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"25-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:16:\"25-1280x1280.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_t