<?php
use Arkfield\Misc\Service;

$related_projects = Service::project_dal()->get_related_projects( get_post(), 5 );

if ( ! empty( $related_projects ) ) : ?>
	<div class="related-posts-wrapper">
		<h5>
			<?php esc_html_e( 'Related projects:', 'arkfield' ); ?>
		</h5>
		<ul class="related-posts">
			<?php foreach ( $related_projects as $related_project ) : ?>
				<li>
					<a href="<?php echo esc_url( get_permalink( $related_project ) ); ?>"
					   title="<?php the_title_attribute( array( 'post' => $related_project ) ); ?>">
						<?php echo get_the_title( $related_project ); ?>
					</a>
				</li>
			<?php endforeach; ?>
		</ul>
	</div>
<?php endif; ?>
