<?php
/**
 * The template part for displaying a message that posts cannot be found
 */
?>

<header class="main__header main__header--noresults">
	<h1><?php esc_html_e( 'Nothing Found', 'arkfield' ); ?></h1>
	<?php get_search_form(); ?>
</header>

<div class="main__content main__content--noresults">
	<p>
		<?php if ( is_home() && current_user_can( 'publish_posts' ) ) :
			esc_html_e( 'Ready to publish your first post?', 'arkfield' ) ?>
			<a href="<?php echo esc_url( admin_url( 'post-new.php' ) ) ?>"><?php esc_html_e( 'Get started here', 'arkfield' ) ?></a>
			<?php
		elseif ( is_search() ) :
			esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.',
				'arkfield' );
		else :
			esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.',
				'arkfield' );
		endif; ?>
	</p>
	<a class="pikode pikode--btn btn btn--large btn--gamma"
	   href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Go to home page', 'arkfield' ); ?></a>
</div>

