<?php
namespace Arkfield\Misc;

if ( ! class_exists( __NAMESPACE__ . '\\Service_Container' ) ) {
	/**
	 * Class Service_Container
	 * @package Arkfield\Misc
	 */
	class Service_Container {
		/**
		 * @var Application_Service_Container
		 */
		private static $container;

		/**
		 * @param string $serviceName
		 *
		 * @return object
		 */
		public static function get_service( $serviceName ) {
			static::load_container();

			return static::$container->get( $serviceName );
		}

		protected static function load_container() {
			if ( null !== static::$container ) {
				return;
			}
			Service_Container_Generator::generate();
			static::$container = new Application_Service_Container();
		}
	}
}