<?php
namespace Arkfield\Misc;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Dumper\PhpDumper;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;

if ( ! class_exists( __NAMESPACE__ . '\\Service_Container_Generator' ) ) {
	/**
	 * Class Service_Container_Generator
	 * @package Arkfield\Misc
	 */
	class Service_Container_Generator {
		const SERVICES_DIR = '/includes/resources/';
		const SERVICES_FILE = 'services.xml';
		const CONTAINER_CACHE_FILE = '/includes/cache/class-application-service-container.php';

		public static function generate( $force = false ) {
			$container_cache_full_path = ARKFIELD_TEMPLATE_DIR . self::CONTAINER_CACHE_FILE;

			if ( $force || ! file_exists( $container_cache_full_path ) ) {
				$container_builder = new ContainerBuilder();
				$loader            = new XmlFileLoader(
					$container_builder,
					new FileLocator( ARKFIELD_TEMPLATE_DIR . self::SERVICES_DIR )
				);
				$loader->load( self::SERVICES_FILE );
				$container_builder->compile();

				$dumper = new PhpDumper( $container_builder );

				file_put_contents(
					$container_cache_full_path,
					$dumper->dump( array( 'namespace' => __NAMESPACE__, 'class' => 'Application_Service_Container' ) )
				);
			}
		}
	}
}