<?php
namespace Arkfield\Admin\ThemeCustomizer;

if ( ! class_exists( __NAMESPACE__ . '\\Theme_Options_Sanitizer' ) ) {
	/**
	 * Class Theme_Options_Sanitizer
	 * @package Arkfield\Admin\ThemeCustomizer
	 */
	class Theme_Options_Sanitizer {
		/**
		 * @param string $text
		 *
		 * @return string
		 */
		public function sanitize_select( $select ) {
			return $this->sanitize_text( $select );
		}

		/**
		 * @param string $text
		 *
		 * @return int
		 */
		public function sanitize_range( $range ) {
			return $this->sanitize_number( $range );
		}

		/**
		 * @param string $text
		 *
		 * @return int
		 */
		public function sanitize_number( $number ) {
			return 0 + $number;
		}

		/**
		 * @param string $text
		 *
		 * @return string
		 */
		public function sanitize_image( $image ) {
			return \esc_url_raw( $image );
		}


		/**
		 * @param string $text
		 *
		 * @return string
		 */
		public function sanitize_checkbox( $value ) {
			if ( $value ) {
				return 1;
			}

			return 0;
		}

		/**
		 * @param string $text
		 *
		 * @return string
		 */
		public function sanitize_text( $text ) {
			return \sanitize_text_field( $text );
		}

		/**
		 * @param string $color
		 *
		 * @return string
		 */
		public function sanitize_color( $color ) {
			return \sanitize_hex_color( $color );
		}

		/**
		 * @param string $text
		 *
		 * @return string
		 */
		public function sanitize_textarea( $text ) {
			return $this->sanitize_text( $text );
		}
	}
}