<?php
namespace Arkfield\Admin\MetaBoxes;

if ( ! class_exists( __NAMESPACE__ . '\\Meta_Box_DAL' ) ) {
	/**
	 * Class Meta_Box_DAL
	 * @package Arkfield\Admin\MetaBoxes
	 */
	class Meta_Box_DAL {

		/**
		 * @var Meta_Box_Sanitizer
		 */
		protected $meta_box_sanitizer;

		/**
		 * Meta_Box_DAL constructor.
		 *
		 * @param Meta_Box_Sanitizer $meta_box_sanitizer
		 */
		public function __construct( Meta_Box_Sanitizer $meta_box_sanitizer ) {
			$this->meta_box_sanitizer = $meta_box_sanitizer;
		}


		/**
		 * @param int   $post_id
		 * @param array $meta_box_config
		 */
		public function save_meta_box_data( $post_id, array $meta_box_config ) {
			if ( ! isset( $meta_box_config['nonce'] ) || ! isset( $meta_box_config['fields'] ) ) {
				return;
			}

			$nonce_value    = filter_input( INPUT_POST, $meta_box_config['nonce']['name'], FILTER_SANITIZE_STRING );
			$is_valid_nonce = $nonce_value && \wp_verify_nonce( $nonce_value, $meta_box_config['nonce']['action'] );

			if ( ! $is_valid_nonce || \wp_is_post_autosave( $post_id ) || ! \current_user_can( 'edit_post', $post_id ) ) {
				return;
			}

			foreach ( $meta_box_config['fields'] as $field_config ) {
				if ( isset( $field_config['persist'] ) && ! $field_config['persist'] ) {
					continue;
				}
				$value = $this->meta_box_sanitizer->sanitize(
					(string) filter_input( INPUT_POST, $field_config['id'], FILTER_UNSAFE_RAW ),
					$field_config['type']
				);

				\update_post_meta( $post_id, $field_config['id'], $value );
			}
		}

		/**
		 * @param int   $post_id
		 * @param array $field_config
		 *
		 * @return string
		 */
		public function get_field_value( $post_id, array $field_config ) {
			if ( isset( $field_config['value'] ) ) {
				return $field_config['value'];
			}

			return null === $post_id && isset( $field_config['default'] )
				? $field_config['default'] : \get_post_meta( $post_id, $field_config['id'], true );
		}
	}
}