<?php
use Arkfield\Misc\Service;

// WP_DEBUG && error_reporting( - 1 );

$wp_theme = wp_get_theme();

// ARKFIELD_THEME_VERSION constant is used as a version for the static files while enqueueing,
// when debugging is enabled we don't want the browser to cache the static files, that's why in this case we append
// a new suffix every time
define( 'ARKFIELD_THEME_VERSION', $wp_theme->get( 'Version' ) . ( WP_DEBUG ? '.' . uniqid() : '' ) );

define( 'PIKARTHOUSE_THEME_VENDOR', $wp_theme->get( 'Author' ) );

define( 'ARKFIELD_TEMPLATE_DIR_URI', get_template_directory_uri() );
define( 'ARKFIELD_TEMPLATE_DIR', get_template_directory() );
define( 'ARKFIELD_VENDOR_DIR', ARKFIELD_TEMPLATE_DIR . '/includes/vendor' );
define( 'ARKFIELD_THEME_ASSETS_URI', ARKFIELD_TEMPLATE_DIR_URI . '/assets' );
define( 'ARKFIELD_THEME_IMAGES_URI', ARKFIELD_THEME_ASSETS_URI . '/images' );
define( 'ARKFIELD_THEME_JS_URI', ARKFIELD_THEME_ASSETS_URI . '/js' );
define( 'ARKFIELD_THEME_CSS_URI', ARKFIELD_THEME_ASSETS_URI . '/css' );

require_once ARKFIELD_VENDOR_DIR . '/autoload.php';

Service::bootstrap()->run();
