<?php
/**
 * Class used to insert links in the head for preloading assets.
 *
 * @package Total WordPress Theme
 * @subpackage Framework
 * @version 5.0
 */

namespace TotalTheme;

defined( 'ABSPATH' ) || exit;

class Preload_Assets {

	/**
	 * Our single Preload_Assets instance.
	 */
	private static $instance;

	/**
	 * Disable instantiation.
	 */
	private function __construct() {
		// Private to disabled instantiation.
	}

	/**
	 * Disable the cloning of this class.
	 *
	 * @return void
	 */
	final public function __clone() {
		throw new Exception( 'You\'re doing things wrong.' );
	}

	/**
	 * Disable the wakeup of this class.
	 *
	 * @return void
	 */
	final public function __wakeup() {
		throw new Exception( 'You\'re doing things wrong.' );
	}

	/**
	 * Create or retrieve the instance of Preload_Assets.
	 *
	 * @return Preload_Assets
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new Preload_Assets;
			static::$instance->init_hooks();
		}

		return static::$instance;
	}

	/**
	 * Initialization hooks.
	 *
	 * @since 5.0
	 */
	public function init_hooks() {
		add_action( 'wp_head', array( $this, 'add_links' ) );
	}

	/**
	 * Add links to wp_head
	 *
	 * @since 5.0
	 */
	public function add_links() {

		$links = $this->get_links();

		if ( $links ) {

			foreach ( $links as $link => $atts ) {

				echo '<link rel="preload" href="' . esc_attr( esc_url( $atts['href'] ) ) . '" as="' . esc_attr( $atts['type'] ) . '">';

			}

		}

	}

	/**
	 * Return array of links.
	 *
	 * @since 5.0
	 */
	public function get_links() {

		$links = array();

		$sticky_logo = wpex_sticky_header_logo_img();

		if ( $sticky_logo ) {

			$links[] = array(
				'href' => $sticky_logo,
				'type' => 'image'
			);

		}

		$sticky_logo_retina = wpex_sticky_header_logo_img_retina();

		if ( $sticky_logo_retina ) {

			$links[] = array(
				'href' => $sticky_logo_retina,
				'type' => 'image'
			);

		}

		return (array) apply_filters( 'wpex_preload_links', $links );

	}

}
Preload_Assets::instance();