<?php
global $current_user, $wpdb, $wp_query;
$wpttarUserRole = $this->WPTTARGetCurrentUserCall();
$wpttarProjectResults = $this->WPTTARGetTableDataByID('', $this->WpttarProjectsTable, '');
wp_enqueue_style('wpttar-datepicker3-css');
?>
<!-- BEGIN PAGE HEADER-->
<!-- END PAGE HEADER-->
<div class="preloader">  <span class="preloader-custom-gif"></span></div>
<input type="hidden" id="current-role-member" value="<?php echo esc_attr($wpttarUserRole); ?>">
<div style="padding-left: 0px; padding-right:20px; padding-top:0px;" class="col-md-12">
    <h3 class="page-title"><?php _e('Projects', 'wpttar'); ?></h3>
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li><a href="?page=wpttar-projects"><i class="fa fa-home"></i><?php _e('Home', 'wpttar'); ?><i class="fa fa-angle-right"></i></a></li>
            <li><?php _e('Projects', 'wpttar'); ?></li>        
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <a class="btn green " href="?page=wpttar-add-project" data-toggle="modal"><i class="fa fa-plus"></i><?php _e('Add New Project', 'wpttar'); ?></a>
           
            
            <div class="portlet box blue calendar">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-list"></i>
                           <?php _e('Projects List', 'wpttar'); ?>
                    </div>
                    <div class="actions" style="margin-right: -6px;">
                     <input form="wpttar-project-reports" style="padding :7px 12px; height: 29px;" placeholder="<?php _e('From Date', 'wpttar'); ?> " data-date-format="dd-mm-yyyy" id="from-date" name="from-date" class="date-picker form-control input-inline">
                     <input form="wpttar-project-reports" style="padding :7px 12px; margin-right: 12px; height: 29px;" placeholder="<?php _e('To Date', 'wpttar'); ?>" data-date-format="dd-mm-yyyy" name="to-date" id="to-date" class="date-picker form-control input-inline">
                    
                     <a href="javascript:;"  onclick="WPTTARprojectsReport('Wpttar-pdf-reports','projects-list')"   class="demo-loading-btn btn btn-sm red">
                            <i class="fa fa-download" ></i><?php _e('PDF', 'Wpttar'); ?>
                        </a>
                        <a href="javascript:;"  onclick="WPTTARprojectsReport('Wpttar-excel-reports','projects-list')"  class="demo-loading-btn btn btn-sm yellow">
                            <i class="fa fa-download" ></i><?php _e('Excel', 'Wpttar'); ?>
                        </a>
                    </div>
                </div>
                <div class="portlet-body">
                     <form name="wpttar-project-reports" id="wpttar-project-reports" action="?page=wpttar-projects-reports" method="post">
                        <div class="col-md-12 col-sm-12 project-report-msg"></div>
                            <input type="hidden" name="wpttar-report-type" value="" id="wpttar-report-type" class="wpttar-report-type" />
                            <input type="hidden" name="wpttar-report-action" value="" id="wpttar-report-action" class="wpttar-report-action" />
                            <input type="hidden" name="wpttar-developer-id" value="" id="wpttar-developer-id" class="wpttar-developer-id" />
                       
                    </form>
                    <table class="table table-striped table-bordered table-hover" id="wpttarDataTable">
                        <thead>
                            <tr>
                                <th><?php _e('Project ID', 'wpttar'); ?></th>
                                <th class="text-center"><?php _e('Project Name', 'wpttar'); ?></th>
                                <th><?php _e('Added Date', 'wpttar'); ?></th>
                                <th><?php _e('Start Date', 'wpttar'); ?></th>
                                <th><?php _e('End Date', 'wpttar'); ?></th>
                                <th><?php _e('Total Time', 'wpttar'); ?></th>
                                <th><?php _e('Status', 'wpttar'); ?></th>
                                <th><?php _e('Action', 'wpttar'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $i = 1;
                            foreach ($wpttarProjectResults as $key => $wpttarProjectResult) {
                                
                                $wpttarProjectID = esc_sql($wpttarProjectResult->id);
                                $wpttarProjectDates = $this->WPTTARGetResultsByOrderByFieldName($this->WpttarProjectsLogTable,'projectID',$wpttarProjectID,'updateDate','ASC','getRow');
                                $wpttarProjectHours = $this->WPTTARGetResultsByID($wpttarProjectID, $this->WpttarProjectsLogTable, 'projectID');
                                $wpttarProjectEndDate = $this->WPTTARGetTableDataByID($wpttarProjectID, $this->WpttarProjectsTable, 'id');
                                $getTotalHour = $this->WPTTARGetProjectTime($wpttarProjectHours, 'totalHours');
                                ?>
                            <tr id="dataRow-<?php if (isset($wpttarProjectResult->id)) : echo esc_attr($wpttarProjectResult->id);
                                        endif; ?>">
                                    <td style="width: 8%;"><?php echo esc_html($i); ?></td>
                                    <td class="text-center"><a  href="?page=wpttar-project-view&projectID=<?php
                                        if (isset($wpttarProjectResult->id)) : echo esc_html($wpttarProjectResult->id);
                                        endif;
                                    ?>&graphType=DayWise"><?php
                                            if (isset($wpttarProjectResult->projectName)) : echo esc_html($wpttarProjectResult->projectName);
                                            endif;
                                            ?></a></td>
                                    <td style="width: 9%;"><?php
                                        if (isset($wpttarProjectResult->dateTime)) : echo esc_html(date('d-m-Y', strtotime($wpttarProjectResult->dateTime)));
                                        endif;
                                        ?></td>
                                    <td style="width: 8%;"><?php
                                        if (isset($wpttarProjectResult->dateTime)) : echo esc_html(date('d-m-Y', strtotime($wpttarProjectResult->dateTime)));
                                        endif;
                                        ?></td>
                                    <td style="width: 8%;"> <?php if (isset($wpttarProjectEndDate->projectStatus) && ($wpttarProjectEndDate->projectStatus == 'Open' || $wpttarProjectEndDate->projectStatus == 'Reopen' )) {
                                          _e('In Progress', 'wpttar'); }else{ echo esc_html(date('d-m-Y',strtotime($wpttarProjectEndDate->lastUpdate))); } ?></td>
                                    <td style="width: 14%;"><?php
                                        if (isset($getTotalHour['hour'])) : echo esc_html($getTotalHour['hour']);
                                        endif;
                                        ?>&nbsp;
                                        <?php
                                        if (isset($getTotalHour['minutes'])) : echo  esc_html($getTotalHour['minutes']);
                                        endif;
                                        ?></td>

                                    <td style="width: 7%;">
                                        <?php if (isset($wpttarProjectResult->projectStatus) && $wpttarProjectResult->projectStatus == 'Open') { ?>
                                            <span class="label label-sm label-warning"><?php _e('Open', 'wpttar'); ?></span>
                                        <?php } else if (isset($wpttarProjectResult->projectStatus) && $wpttarProjectResult->projectStatus == 'Close') { ?>
                                            <span class="label label-sm label-success"><?php _e('Close', 'wpttar'); ?></span>
                                        <?php } else if (isset($wpttarProjectResult->projectStatus) && $wpttarProjectResult->projectStatus == 'Reopen') { ?> 
                                            <span class="label label-sm label-danger"><?php _e('Reopen', 'wpttar'); ?></span>
                                        <?php } ?>
                                    </td>
                                    <td style="width: 7%;">
                                        <a class="blue color" href="?page=wpttar-add-project&projectID=<?php
                                        if (isset($wpttarProjectResult->id)) : echo esc_html($wpttarProjectResult->id);
                                        endif;
                                        ?>">
                                            <i class="fa fa-edit"></i>
                                        </a>
                                        <a class="red color" onclick="wpttarDeleteIDSet('<?php echo esc_js($wpttarProjectResult->id); ?>','<?php echo esc_js($wpttarProjectResult->projectName);?>')" class="js-open-modal">
                                            <i class="fa fa-trash"></i></a>
                                    </td>
                                </tr>
                                <?php
                                $i++;
                            }
                            ?>
                        </tbody>
                    </table>                   
                </div>
            </div>
        </div>
    </div>
</div>
<div id="project-model" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="alert alert-success display-hide" id="WPTTARCustomDelete_success"><i class='fa fa-check-square' aria-hidden='true'></i> <?php echo esc_html($wpttarMessagesUpdateDeparment); ?>
                <button class="close" data-close="alert"></button>
            </div>
            <div class="alert alert-danger display-hide" id="WPTTARCustomDelete_error">
                <button class="close" data-close="alert"></button>
            </div>
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"><?php _e('Projects Report', 'wpttar'); ?></h4>
            </div>
            <div class="modal-body" id="info"><?php _e('Please select date range.', 'wpttar'); ?></div>
            <div class="modal-footer">
               
                <button type="button" data-dismiss="modal" aria-hidden="true" class="btn default"><i class="fa fa-times"></i><?php _e('Cancel', 'wpttar'); ?></button>
            </div>
        </div>
    </div>
</div>


<div id="wpttar-project-delete" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="alert alert-success display-hide" id="wpttarDelete_success"><i class='fa fa-check-square' aria-hidden='true'></i>
                <button class="close" data-close="alert"></button>
            </div>
            <div class="alert alert-danger display-hide" id="wpttarDelete_error">
                <button class="close" data-close="alert"></button>
            </div>
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"><?php _e('Delete Project', 'wpttar'); ?></h4>
            </div>
            <div class="modal-body" id="info"><?php _e('Are you sure you went to delete ', 'wpttar'); ?><font id="getTitle"></font><?php _e(' project?', 'wpttar'); ?></div>
            <div class="modal-footer">
               
                <button type="button" class="btn red wpttar-project-delete"><i class="fa fa-times"></i><?php _e('Delete', 'wpttar'); ?></button>
                <button type="button" data-dismiss="modal" aria-hidden="true" class="btn default wpttar-project-close"><i class="fa fa-times"></i><?php _e('Cancel', 'wpttar'); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- END PAGE CONTENT-->
<?php if (isset($wpttarUserRole) && $wpttarUserRole != 'administrator') { } else { ?> 
<div class="user-timer-load-in-div"></div>
<?php } ?>