<?php
/**
 * Simple_Job_Board_CAPTCHA_Admin Class
 * 
 * The admin-specific functionality of the plugin.
 *
 * @link       http://presstigers.com/
 * @since      1.0.0
 *
 * @package    Simple_Job_Board_Captcha
 * @subpackage Simple_Job_Board_Captcha/admin
 * @author     PressTigers <support@presstigers.com>
 */
class Simple_Job_Board_CAPTCHA_Admin {

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string    $plugin_name       The name of this plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct($plugin_name, $version) {
        $this->plugin_name = $plugin_name;
        $this->version = $version;

        /**
         * The class responsible for including application form captcha's settings in reCAPTCHA section.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/class-simple-job-board-captcha-settings.php';

        // Action - After Activation - Redirect to reCAPTCHA Settings
        add_action('activated_plugin', array($this, 'activation_redirect'));
    }

    /**
     * Register the stylesheets for the admin area.
     *
     * @since    1.0.0
     */
    public function enqueue_styles() {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Simple_Job_Board_Captcha_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Simple_Job_Board_Captcha_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/simple-job-board-captcha-admin.css', array(), $this->version, 'all');
    }

    /**
     * Register the JavaScript for the admin area.
     *
     * @since    1.0.0
     */
    public function enqueue_scripts() {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Simple_Job_Board_Captcha_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Simple_Job_Board_Captcha_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/simple-job-board-captcha-admin.js', array('jquery'), $this->version, false);
    }

    /**
     * Action - After Activation - Redirect to reCAPTCHA Settings
     * 
     * @since   2.3.2
     */
    public function activation_redirect( $plugin ) {
        
        // Redirect to reCAPTCHA Settings
        if( $plugin == 'simple-job-board-captcha/simple-job-board-captcha.php' ) {
            exit(wp_redirect(admin_url('edit.php?post_type=jobpost&page=job-board-settings#settings-recaptcha')));
        }
    }

}