<?php
namespace BooklyStaffCabinet\Frontend\Modules\StaffSpecialDays;

use Bookly\Lib as BooklyLib;
use Bookly\Backend\Modules\Staff\Proxy;
use BooklyStaffCabinet\Lib;
use BooklyStaffCabinet\Frontend\Components as FrontendComponents;

/**
 * Class Page
 * @package BooklyStaffCabinet\Frontend\Modules\StaffSpecialDays
 */
class ShortCode extends BooklyLib\Base\Component
{
    /**
     * Init component.
     */
    public static function init()
    {
        // Register short code.
        add_shortcode( 'bookly-staff-special-days', array( __CLASS__, 'render' ) );

        // Assets.
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'linkStyles' ) );
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'linkScripts' ) );
    }

    /**
     * Link styles.
     */
    public static function linkStyles()
    {
        if (
            get_option( 'bookly_gen_link_assets_method' ) == 'enqueue' ||
            BooklyLib\Utils\Common::postsHaveShortCode( 'bookly-staff-special-days' )
        ) {
            $bookly_ver = BooklyLib\Plugin::getVersion();
            $bookly_url = plugins_url( '', BooklyLib\Plugin::getMainFile() );
            $cabinet    = plugins_url( '', Lib\Plugin::getMainFile() );

            wp_enqueue_style( 'bookly-bootstrap.min.css', $bookly_url . '/backend/resources/bootstrap/css/bootstrap.min.css', array(), $bookly_ver );
            wp_enqueue_style( 'bookly-staff-cabinet.css', $cabinet  . '/frontend/resources/css/staff-cabinet.css', array(), Lib\Plugin::getVersion() );

            Proxy\Shared::enqueueStaffProfileStyles();
        }
    }

    /**
     * Link scripts.
     */
    public static function linkScripts()
    {
        if (
            get_option( 'bookly_gen_link_assets_method' ) == 'enqueue' ||
            BooklyLib\Utils\Common::postsHaveShortCode( 'bookly-staff-special-days' )
        ) {
            $bookly_ver  = BooklyLib\Plugin::getVersion();
            $sp_days_ver = \BooklySpecialDays\Lib\Plugin::getVersion();
            $bookly_url  = plugins_url( '', BooklyLib\Plugin::getMainFile() );
            $sp_days_url = plugins_url( '', \BooklySpecialDays\Lib\Plugin::getMainFile() );
            $cabinet     = plugins_url( '', Lib\Plugin::getMainFile() );

            wp_enqueue_script( 'bookly-spin.min.js', $bookly_url . '/frontend/resources/js/spin.min.js',  array( 'jquery' ), $bookly_ver );
            wp_enqueue_script( 'bookly-ladda.min.js', $bookly_url . '/frontend/resources/js/ladda.min.js', array( 'bookly-spin.min.js' ), $bookly_ver );
            wp_enqueue_script( 'bookly-bootstrap.min.js', $bookly_url . '/backend/resources/bootstrap/js/bootstrap.min.js', array( 'jquery' ), $bookly_ver );
            wp_enqueue_script( 'bookly-moment.min.js', $bookly_url . '/backend/resources/js/moment.min.js', array(), $bookly_ver );
            wp_enqueue_script( 'bookly-daterangepicker.js', $bookly_url . '/backend/resources/js/daterangepicker.js', array( 'jquery', 'bookly-moment.min.js' ), $bookly_ver );
            wp_enqueue_script( 'bookly-range-tools.js', $bookly_url . '/backend/resources/js/range-tools.js', array(), $bookly_ver );
            wp_enqueue_script( 'bookly-special-days.js', $sp_days_url . '/backend/modules/staff/resources/js/special-days.js', array( 'bookly-range-tools.js' ), $sp_days_ver );
            wp_enqueue_script( 'bookly-staff-cabinet-native.js', $cabinet  . '/frontend/resources/js/staff-cabinet-native.js', array(), Lib\Plugin::getVersion() );
            wp_enqueue_script( 'bookly-staff-cabinet-special-days.js',$cabinet  . '/frontend/modules/staff_special_days/resources/js/staff-cabinet-special-days.js', array( 'bookly-special-days.js', 'bookly-daterangepicker.js', 'bookly-staff-cabinet-native.js' ), Lib\Plugin::getVersion() );

            Proxy\Shared::enqueueStaffProfileScripts();

            wp_localize_script( 'bookly-staff-cabinet-special-days.js', 'BooklySCSpecialDaysL10n', array(
                'datePicker'      => BooklyLib\Utils\DateTime::datePickerOptions(),
                'are_you_sure'    => __( 'Are you sure?', 'bookly' ),
                'start_time'      => '08:00:00',
                'end_time'        => '18:00:00',
                'saved'           => __( 'Settings saved.', 'bookly' ),
                'duplicate_error' => __( 'Duplicate dates are not permitted.', 'bookly' ),
                'past_date_error' => __( 'Date in the past.', 'bookly' ),
                'csrfToken'       => BooklyLib\Utils\Common::getCsrfToken(),
            ) );
        }
    }

    /**
     * Render Staff Special Days shortcode.
     *
     * @param array $attributes
     * @return string
     */
    public static function render( $attributes )
    {
        // Disable caching.
        BooklyLib\Utils\Common::noCache();

        if ( is_user_logged_in() && $staff = BooklyLib\Entities\Staff::query()->select( 'id, visibility' )->where( 'wp_user_id', get_current_user_id() )->fetchRow() ) {
            \BooklyPro\Backend\Components\License\Components::renderLicenseNotice( false );
            if ( $staff['visibility'] == 'archive' ) {
                return FrontendComponents\Notice\Permission::generateAccountDisabled();
            }
            return \BooklyPro\Lib\Config::graceExpired()
                ? null
                : self::renderTemplate( 'short_code', array( 'form_id' => uniqid( 'special-days-' ), 'staff_id' => $staff['id'], 'attributes' => $attributes ), false );
        }

        return FrontendComponents\Notice\Permission::generate();
    }
}