<?php
namespace BooklyStaffCabinet\Frontend\Modules\StaffSchedule;

use Bookly\Lib as BooklyLib;
use BooklyStaffCabinet\Lib;
use BooklyStaffCabinet\Frontend\Components as FrontendComponents;

/**
 * Class Page
 * @package BooklyStaffCabinet\Frontend\Modules\StaffSchedule
 */
class ShortCode extends BooklyLib\Base\Component
{
    /**
     * Init component.
     */
    public static function init()
    {
        // Register short code.
        add_shortcode( 'bookly-staff-schedule', array( __CLASS__, 'render' ) );

        // Assets.
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'linkStyles' ) );
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'linkScripts' ) );
    }

    /**
     * Link styles.
     */
    public static function linkStyles()
    {
        if (
            get_option( 'bookly_gen_link_assets_method' ) == 'enqueue' ||
            BooklyLib\Utils\Common::postsHaveShortCode( 'bookly-staff-schedule' )
        ) {
            $bookly_ver = BooklyLib\Plugin::getVersion();
            $bookly_url = plugins_url( '', BooklyLib\Plugin::getMainFile() );

            wp_enqueue_style( 'bookly-ladda.min.css', $bookly_url . '/frontend/resources/css/ladda.min.css', array(), $bookly_ver );
            wp_enqueue_style( 'bookly-bootstrap.min.css', $bookly_url . '/backend/resources/bootstrap/css/bootstrap.min.css', array(), $bookly_ver );
        }
    }

    /**
     * Link scripts.
     */
    public static function linkScripts()
    {
        if (
            get_option( 'bookly_gen_link_assets_method' ) == 'enqueue' ||
            BooklyLib\Utils\Common::postsHaveShortCode( 'bookly-staff-schedule' )
        ) {
            $bookly_ver = BooklyLib\Plugin::getVersion();
            $bookly_url = plugins_url( '', BooklyLib\Plugin::getMainFile() );
            $cabinet   = plugins_url( '', Lib\Plugin::getMainFile() );

            wp_enqueue_script( 'bookly-spin.min.js', $bookly_url . '/frontend/resources/js/spin.min.js', array(), $bookly_ver );
            wp_enqueue_script( 'bookly-ladda.min.js', $bookly_url . '/frontend/resources/js/ladda.min.js', array( 'bookly-spin.min.js' ), $bookly_ver );
            wp_enqueue_script( 'bookly-bootstrap.min.js', $bookly_url . '/backend/resources/bootstrap/js/bootstrap.min.js', array( 'jquery' ), $bookly_ver );
            wp_enqueue_script( 'bookly-range-tools.js', $bookly_url . '/backend/resources/js/range-tools.js', array( 'jquery' ), $bookly_ver );
            wp_enqueue_script( 'bookly-staff-schedule.js', $bookly_url . '/backend/components/dialogs/staff/edit/resources/js/staff-schedule.js', array( 'bookly-range-tools.js' ), $bookly_ver );
            wp_enqueue_script( 'bookly-staff-cabinet-native.js', $cabinet  . '/frontend/resources/js/staff-cabinet-native.js', array(), Lib\Plugin::getVersion() );
            wp_enqueue_script( 'bookly-staff-cabinet-schedule.js', $cabinet . '/frontend/modules/staff_schedule/resources/js/staff-cabinet-schedule.js', array( 'bookly-staff-schedule.js', 'bookly-staff-cabinet-native.js' ), Lib\Plugin::getVersion() );

            wp_localize_script( 'bookly-staff-cabinet-schedule.js', 'BooklySCScheduleL10n', array(
                'saved'      => __( 'Settings saved.', 'bookly' ),
                'areYouSure' => __( 'Are you sure?', 'bookly' ),
                'csrfToken'  => BooklyLib\Utils\Common::getCsrfToken(),
            ) );
        }
    }

    /**
     * Render Staff Schedule shortcode.
     *
     * @param array $attributes
     * @return string
     */
    public static function render( $attributes )
    {
        if ( is_user_logged_in() && $staff = BooklyLib\Entities\Staff::query()->select( 'id, visibility' )->where( 'wp_user_id', get_current_user_id() )->fetchRow() ) {
            \BooklyPro\Backend\Components\License\Components::renderLicenseNotice( false );
            if ( $staff['visibility'] == 'archive' ) {
                return FrontendComponents\Notice\Permission::generateAccountDisabled();
            }
            return \BooklyPro\Lib\Config::graceExpired()
                ? null
                : self::renderTemplate( 'short_code', array( 'form_id' => uniqid( 'schedule-' ), 'staff_id' => $staff['id'], 'attributes' => $attributes ), false );
        }

        return FrontendComponents\Notice\Permission::generate();
    }
}