<?php
namespace BooklyRecurringAppointments\Lib\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Lib\DataHolders\Booking\Item;
use Bookly\Lib\DataHolders\Booking\Order;
use Bookly\Lib\Notifications\Assets\Item\Codes;
use BooklyRecurringAppointments\Lib\Notifications\Booking;

/**
 * Class Local
 * @package BooklyRecurringAppointments\Lib
 */
class Local extends BooklyLib\Proxy\RecurringAppointments
{
    /**
     * @inheritdoc
     */
    public static function hideChildAppointments( $default, BooklyLib\CartItem $cart_item )
    {
        if (
            $cart_item->getSeriesUniqueId()
            && get_option( 'bookly_recurring_appointments_payment' ) === 'first'
            && ( ! $cart_item->getFirstInSeries() )
        ) {
            return true;
        }

        return $default;
    }

    /**
     * @inheritdoc
     */
    public static function cancelPayment( $payment_id )
    {
        /** @var BooklyLib\Entities\CustomerAppointment[] $ca_list */
        $ca_list = BooklyLib\Entities\CustomerAppointment::query( 'ca' )
            ->where( 'ca.payment_id', $payment_id )
            ->whereNot( 'ca.series_id', null )
            ->groupBy( 'ca.series_id' )
            ->find();

        foreach ( $ca_list as $ca ) {
            $ca->deleteCascade();
        }
    }

    /**
     * @param BooklyLib\Entities\Notification[] $notifications
     * @param Item  $item
     * @param Order $order
     * @param Codes $codes
     * @param array|bool $queue
     * @return bool|array
     */
    public static function sendSeries( $queue, array $notifications, Item $item, Order $order, Codes $codes )
    {
        Booking\Sender::sendSeries( $notifications, $item, $order, $codes, $queue );

        return $queue;
    }

}