<?php
namespace BooklyPro\Lib\Notifications\Cart;

use Bookly\Lib\DataHolders\Booking\Item;
use Bookly\Lib\DataHolders\Booking\Order;
use Bookly\Lib\Entities\CustomerAppointment;
use Bookly\Lib\Notifications\Assets\Item\Attachments;
use Bookly\Lib\Notifications\Base;
use BooklyPro\Lib\Notifications\Assets\Combined\Codes;

/**
 * Class Sender
 * @package BooklyPro\Lib\Notifications\Cart
 */
abstract class Sender extends Base\Sender
{
    /**
     * Send combined notifications to client.
     *
     * @param Order      $order
     * @param array|bool $queue
     */
    public static function sendCombined( Order $order, &$queue = false )
    {
        /** @var Item $item */
        $item = current( $order->getItems() );
        $ca   = $item->getCA();

        if ( ! in_array( $ca->getStatus(), array( CustomerAppointment::STATUS_CANCELLED, CustomerAppointment::STATUS_REJECTED ) ) ) {

            $just_сreated = $ca->isJustCreated()
                ?: (
                    // Maybe this is IPN request and combined notification should be sent for pending payment appointments created
                    $ca->getCreatedFrom() == 'frontend' &&
                    strtotime( $ca->getCreatedAt() ) - current_time( 'timestamp' ) >= - 120 // 2 minutes
                );

            if ( $just_сreated ) {
                $codes = new Codes( $order );
                $notifications = static::getNotifications( 'new_booking_combined' );

                $attachments = new Attachments( $codes );
                // Notify client.
                foreach ( $notifications['client'] as $notification ) {
                    static::sendToClient( $order->getCustomer(), $notification, $codes, $attachments, $queue );
                }
                if ( $queue === false ) {
                    $attachments->clear();
                }
            }
        }
    }
}