<?php
namespace BooklyFiles\Lib\ProxyProviders;

use BooklyFiles\Lib;
use Bookly\Lib as BooklyLib;

/**
 * Class Local
 * Provide local methods to be used in Bookly and other add-ons.
 *
 * @package BooklyFiles\Lib\ProxyProviders
 */
abstract class Local extends BooklyLib\Proxy\Files
{
    /******************************************************************************************************************
     * FRONTEND                                                                                                       *
     ******************************************************************************************************************/

    /**
     * @inheritdoc
     */
    public static function getAllIds()
    {
        $custom_fields = (array) BooklyLib\Proxy\CustomFields::getAll( array( 'text-field', 'textarea', 'text-content', 'checkboxes', 'radio-buttons', 'drop-down', 'captcha' ) );

        $ids = array();
        foreach ( $custom_fields as $custom_field ) {
            if ( $custom_field->type == 'file' ) {
                $ids[] = $custom_field->id;
            }
        }

        return $ids;
    }

    /**
     * @inheritdoc
     */
    public static function attachFiles( array $custom_fields, BooklyLib\Entities\CustomerAppointment $ca )
    {
        $custom_fields_with_file = self::getAllIds();

        // Need compare current files with new custom files
        $current_ca = BooklyLib\Entities\CustomerAppointment::query( 'ca' )
            ->select( 'ca.custom_fields' )
            ->where( 'id', $ca->getId() )
            ->fetchRow();
        $current_files = array();

        if ( $current_ca ) {
            foreach ( (array) json_decode( $current_ca['custom_fields'], true ) as $cf ) {
                $current_files[ $cf['id'] ] = $cf['value'];
            }
        }

        $customer_appointment_id = $ca->getId();
        foreach ( $custom_fields as $custom_field ) {
            if ( in_array( $custom_field['id'], $custom_fields_with_file ) ) {
                $file = new Lib\Entities\Files();
                if ( $custom_field['value'] && $file->loadBy( array( 'slug' => $custom_field['value'] ) ) ) {
                    $ca_file = new Lib\Entities\CustomerAppointmentFiles();
                    $ca_file->loadBy(
                        array(
                            'customer_appointment_id' => $customer_appointment_id,
                            'file_id'                 => $file->getId(),
                        ) );
                    if ( ! $ca_file->isLoaded() ) {
                        $ca_file
                            ->setCustomerAppointmentId( $customer_appointment_id )
                            ->setFileId( $file->getId() )
                            ->save();
                    }
                }

                // Removing unnecessary files
                // Compare old and new file slug
                if ( isset( $current_files[ $custom_field['id'] ] )
                    && $current_files[ $custom_field['id'] ] != ''
                    && $current_files[ $custom_field['id'] ] !== $custom_field['value']
                ) {
                    // Need detach old file.
                    $file = new Lib\Entities\Files();
                    if ( $file->loadBy( array( 'slug' => $current_files[ $custom_field['id'] ] ) ) ) {
                        $ca_file = new Lib\Entities\CustomerAppointmentFiles();
                        $ca_file->loadBy(
                            array(
                                'customer_appointment_id' => $customer_appointment_id,
                                'file_id'                 => $file->getId(),
                            ) );
                        $ca_file->deleteCascade();
                    }
                }
            }
        }
    }

    /**
     * @inheritdoc
     */
    public static function getFileNamesForCustomFields( array $custom_fields )
    {
        $names = array();
        $custom_fields_with_file = self::getAllIds();
        foreach ( $custom_fields as $field ) {
            if ( in_array( $field['id'], $custom_fields_with_file ) && isset( $field['value'] ) ) {
                $file = Lib\Entities\Files::query()
                    ->select( 'name' )
                    ->where( 'slug', $field['value'] )
                    ->fetchRow();
                $names[ $field['id'] ] = $file ? $file['name'] : $field['value'];
            }
        }

        return $names;
    }

    /******************************************************************************************************************
     * BACKEND                                                                                                        *
     ******************************************************************************************************************/

    /**
     * @inheritdoc
     */
    public static function setFileNamesForCustomFields( $data, array $custom_fields )
    {
        foreach ( $data as &$customer_custom_field ) {
            if ( array_key_exists( $customer_custom_field['id'], $custom_fields ) ) {
                $field = $custom_fields[ $customer_custom_field['id'] ];
                if ( $field->type == 'file' ) {
                    $file = Lib\Entities\Files::query( 'f' )
                        ->select( '`f`.`name`' )
                        ->where('slug', $customer_custom_field['value'] )
                        ->fetchRow();
                    if ( $file ) {
                        $customer_custom_field['value'] = $file['name'];
                    }
                }
            }
        }

        return $data;
    }

    /**
     * @inheritdoc
     */
    public static function getAll()
    {
        $custom_fields = (array) BooklyLib\Proxy\CustomFields::getAll( array( 'text-field', 'textarea', 'text-content', 'checkboxes', 'radio-buttons', 'drop-down', 'captcha' ) );

        return array_filter( $custom_fields, function ( $field ) {
            return $field->type == 'file';
        } );

    }

}